/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.ActivityManager;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import android.util.Printer;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.ConfigurationError;
import androidx.benchmark.ConfigurationErrorKt;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u000eH\u0002J\b\u0010+\u001a\u00020\u0006H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\"\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0011\u0010$\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001bR\u0011\u0010&\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0010\u00a8\u0006,"}, d2={"Landroidx/benchmark/DeviceInfo;", "", "()V", "ART_MAINLINE_MIN_VERSIONS_AFFECTING_METHOD_TRACING", "Lkotlin/ranges/LongRange;", "ART_MAINLINE_VERSION_UNDETECTED", "", "ART_MAINLINE_VERSION_UNDETECTED_ERROR", "MINIMUM_BATTERY_PERCENT", "", "artMainlineVersion", "getArtMainlineVersion", "()J", "deviceSummaryString", "", "getDeviceSummaryString", "()Ljava/lang/String;", "errors", "", "Landroidx/benchmark/ConfigurationError;", "getErrors", "()Ljava/util/List;", "initialBatteryPercent", "getInitialBatteryPercent", "()I", "isEmulator", "", "()Z", "isEngBuild", "isLowRamDevice", "isRooted", "isUserdebugBuild", "methodTracingAffectsMeasurements", "getMethodTracingAffectsMeasurements", "misconfiguredForTracing", "getMisconfiguredForTracing", "profileableEnforced", "getProfileableEnforced", "typeLabel", "getTypeLabel", "getMainlineAppInfo", "Landroid/content/pm/ApplicationInfo;", "packageName", "queryArtMainlineVersion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDeviceInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,269:1\n1#2:270\n12474#3,2:271\n*S KotlinDebug\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n*L\n69#1:271,2\n*E\n"})
public final class DeviceInfo {
    @NotNull
    public static final DeviceInfo INSTANCE;
    private static final boolean isEmulator;
    @NotNull
    private static final String typeLabel;
    private static final boolean isEngBuild;
    private static final boolean isUserdebugBuild;
    private static final boolean profileableEnforced;
    private static final boolean isRooted;
    public static final int MINIMUM_BATTERY_PERCENT = 25;
    private static final int initialBatteryPercent;
    @NotNull
    private static final String deviceSummaryString;
    @NotNull
    private static final List<ConfigurationError> errors;
    private static final boolean misconfiguredForTracing;
    private static final boolean isLowRamDevice;
    @NotNull
    private static final LongRange ART_MAINLINE_MIN_VERSIONS_AFFECTING_METHOD_TRACING;
    public static final long ART_MAINLINE_VERSION_UNDETECTED = -1L;
    public static final long ART_MAINLINE_VERSION_UNDETECTED_ERROR = -100L;
    private static final long artMainlineVersion;
    private static final boolean methodTracingAffectsMeasurements;

    private DeviceInfo() {
    }

    public final boolean isEmulator() {
        return isEmulator;
    }

    @NotNull
    public final String getTypeLabel() {
        return typeLabel;
    }

    public final boolean isEngBuild() {
        return isEngBuild;
    }

    public final boolean getProfileableEnforced() {
        return profileableEnforced;
    }

    public final boolean isRooted() {
        return isRooted;
    }

    public final int getInitialBatteryPercent() {
        return initialBatteryPercent;
    }

    @NotNull
    public final String getDeviceSummaryString() {
        return deviceSummaryString;
    }

    @NotNull
    public final List<ConfigurationError> getErrors() {
        return errors;
    }

    public final boolean getMisconfiguredForTracing() {
        return misconfiguredForTracing;
    }

    private final ApplicationInfo getMainlineAppInfo(String packageName) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = InstrumentationRegistry.getInstrumentation().getContext().getPackageManager().getApplicationInfo(packageName, 0x40000000);
        }
        catch (PackageManager.NameNotFoundException notFoundException) {
            applicationInfo = null;
        }
        return applicationInfo;
    }

    @RequiresApi(value=31)
    private final long queryArtMainlineVersion() {
        ApplicationInfo artMainlinePackage;
        ApplicationInfo applicationInfo = this.getMainlineAppInfo("com.google.android.art");
        if (applicationInfo == null && (applicationInfo = this.getMainlineAppInfo("com.android.art")) == null && (applicationInfo = this.getMainlineAppInfo("com.google.android.go.art")) == null) {
            applicationInfo = this.getMainlineAppInfo("com.android.go.art");
        }
        if ((artMainlinePackage = applicationInfo) == null) {
            Log.d((String)"Benchmark", (String)("No ART mainline module found on API " + Build.VERSION.SDK_INT));
            return Build.VERSION.SDK_INT >= 34 ? -100L : -1L;
        }
        Ref.LongRef versionCode = new Ref.LongRef();
        versionCode.element = -1L;
        Printer printer2 = new Printer(versionCode){
            final /* synthetic */ Ref.LongRef $versionCode;
            {
                this.$versionCode = $versionCode;
            }

            public void println(@Nullable String x) {
                if (x == null || this.$versionCode.element != -1L) {
                    return;
                }
                String prefix2 = " versionCode=";
                int offset = StringsKt.indexOf$default((CharSequence)x, (String)prefix2, (int)0, (boolean)false, (int)6, null);
                if (offset >= 0) {
                    String string = x.substring(offset + prefix2.length(), StringsKt.indexOf$default((CharSequence)x, (char)' ', (int)(offset + prefix2.length()), (boolean)false, (int)4, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String versionString = string;
                    this.$versionCode.element = Long.parseLong(versionString);
                }
            }
        };
        artMainlinePackage.dump(printer2, "");
        if (!(versionCode.element > 0L)) {
            boolean bl = false;
            String string = "Unable to parse ART version code";
            throw new IllegalStateException(string.toString());
        }
        return versionCode.element;
    }

    public final boolean isLowRamDevice() {
        return isLowRamDevice;
    }

    public final long getArtMainlineVersion() {
        return artMainlineVersion;
    }

    public final boolean getMethodTracingAffectsMeasurements() {
        return methodTracingAffectsMeasurements;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block9: {
            block10: {
                DeviceInfo.INSTANCE = new DeviceInfo();
                v0 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v0, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v1, (String)"unknown", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v2 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"FINGERPRINT");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v3 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"sdk_gphone64", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v5 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v5, (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v6 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v6, (CharSequence)"Android SDK built for", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v7 = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"MANUFACTURER");
                if (StringsKt.contains$default((CharSequence)v7, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v8 = Build.BRAND;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"BRAND");
                if (!StringsKt.startsWith$default((String)v8, (String)"generic", (boolean)false, (int)2, null)) break block10;
                v9 = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"DEVICE");
                if (StringsKt.startsWith$default((String)v9, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            }
            if (Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) lbl-1000:
            // 10 sources

            {
                v10 = true;
            } else {
                v10 = false;
            }
            DeviceInfo.isEmulator = v10;
            DeviceInfo.typeLabel = DeviceInfo.isEmulator != false ? "emulator" : "device";
            v11 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"FINGERPRINT");
            DeviceInfo.isEngBuild = StringsKt.contains$default((CharSequence)v11, (CharSequence)":eng/", (boolean)false, (int)2, null);
            v12 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"FINGERPRINT");
            DeviceInfo.isUserdebugBuild = StringsKt.contains$default((CharSequence)v12, (CharSequence)":userdebug/", (boolean)false, (int)2, null);
            DeviceInfo.profileableEnforced = DeviceInfo.isEngBuild == false && DeviceInfo.isUserdebugBuild == false;
            v13 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"FINGERPRINT");
            if (StringsKt.contains$default((CharSequence)v13, (CharSequence)":userdebug/", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var0 = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"};
            $this$any$iv = var0;
            $i$f$any = false;
            var3_8 = $this$any$iv.length;
            for (var2_6 = 0; var2_6 < var3_8; ++var2_6) {
                it = element$iv = $this$any$iv[var2_6];
                $i$a$-any-DeviceInfo$isRooted$1 = false;
                if (!new File(it).exists()) continue;
                v14 = true;
                break block9;
            }
            v14 = false;
        }
        if (v14) lbl-1000:
        // 2 sources

        {
            v15 = true;
        } else {
            v15 = false;
        }
        DeviceInfo.isRooted = v15;
        DeviceInfo.misconfiguredForTracing = new File("/sys/kernel/tracing/trace_marker").exists() == false && new File("/sys/kernel/debug/tracing/trace_marker").exists() == false;
        context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        v16 = context.registerReceiver(null, filter);
        if (v16 != null) {
            $this$_init__u24lambda_u242 = v16;
            $i$a$-run-DeviceInfo$1 = false;
            level = $this$_init__u24lambda_u242.getBooleanExtra("present", true) != false ? $this$_init__u24lambda_u242.getIntExtra("level", 100) : 100;
            scale = $this$_init__u24lambda_u242.getIntExtra("scale", 100);
            v17 = level * 100 / scale;
        } else {
            v17 = 100;
        }
        DeviceInfo.initialBatteryPercent = v17;
        v18 = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)v18, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        DeviceInfo.isLowRamDevice = ((ActivityManager)v18).isLowRamDevice();
        DeviceInfo.deviceSummaryString = "DeviceInfo(Brand=" + Build.BRAND + ", Model=" + Build.MODEL + ", SDK=" + Build.VERSION.SDK_INT + ", BuildFp=" + Build.FINGERPRINT + ')';
        var2_7 = new ConfigurationError[3];
        var2_7[0] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEngBuild, "ENG-BUILD", "Running on Eng Build", "Benchmark is running on device flashed with a '-eng' build. Eng builds\nof the platform drastically reduce performance to enable testing\nchanges quickly. For this reason they should not be used for\nbenchmarking. Use a '-user' or '-userdebug' system image.");
        var2_7[1] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEmulator, "EMULATOR", "Running on Emulator", "Benchmark is running on an emulator, which is not representative of\nreal user devices. Use a physical device to benchmark. Emulator\nbenchmark improvements might not carry over to a real user's\nexperience (or even regress real device performance).");
        var2_7[2] = ConfigurationErrorKt.conditionalError(DeviceInfo.initialBatteryPercent < 25, "LOW-BATTERY", "Device has low battery (" + DeviceInfo.initialBatteryPercent + ')', StringsKt.trimIndent((String)("\n                    When battery is low, devices will often reduce performance (e.g. disabling big\n                    cores) to save remaining battery. This occurs even when they are plugged in.\n                    Wait for your battery to charge to at least 25%.\n                    Currently at " + DeviceInfo.initialBatteryPercent + "%.\n                ")));
        DeviceInfo.errors = CollectionsKt.listOfNotNull((Object[])var2_7);
        DeviceInfo.ART_MAINLINE_MIN_VERSIONS_AFFECTING_METHOD_TRACING = RangesKt.until((long)340000000L, (int)341513000);
        DeviceInfo.artMainlineVersion = Build.VERSION.SDK_INT >= 31 ? DeviceInfo.INSTANCE.queryArtMainlineVersion() : (Build.VERSION.SDK_INT == 30 ? 1L : -1L);
        var0_1 = Build.VERSION.SDK_INT;
        if (26 <= var0_1 ? var0_1 < 31 : false) ** GOTO lbl-1000
        var0_2 = DeviceInfo.ART_MAINLINE_MIN_VERSIONS_AFFECTING_METHOD_TRACING;
        var1_5 = var0_2.getFirst();
        var3_9 = var0_2.getLast();
        var5_12 = DeviceInfo.artMainlineVersion;
        v19 = var1_5 <= var5_12 ? var5_12 <= var3_9 : false;
        if (v19) lbl-1000:
        // 2 sources

        {
            v20 = true;
        } else {
            v20 = false;
        }
        DeviceInfo.methodTracingAffectsMeasurements = v20;
    }
}

