/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Process;
import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.ThreadDescriptor;
import perfetto.protos.Trace;
import perfetto.protos.TracePacket;
import perfetto.protos.TrackDescriptor;
import perfetto.protos.TrackEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\nJ\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/InMemoryTracing;", "", "()V", "CLOCK_ID", "", "TRACK_EVENT_CATEGORIES", "", "", "TRUSTED_PACKET_SEQUENCE_ID", "UUID", "", "events", "", "Lperfetto/protos/TracePacket;", "getEvents", "()Ljava/util/List;", "beginSection", "", "label", "nanoTime", "clearEvents", "commitToTrace", "Lperfetto/protos/Trace;", "endSection", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class InMemoryTracing {
    @NotNull
    public static final InMemoryTracing INSTANCE = new InMemoryTracing();
    private static final int TRUSTED_PACKET_SEQUENCE_ID = 1234543210;
    private static final long UUID = 123456543210L;
    private static final int CLOCK_ID = 3;
    @NotNull
    private static final List<String> TRACK_EVENT_CATEGORIES = CollectionsKt.listOf((Object)"benchmark");
    @NotNull
    private static final List<TracePacket> events = new ArrayList();

    private InMemoryTracing() {
    }

    @NotNull
    public final List<TracePacket> getEvents() {
        return events;
    }

    public final void clearEvents() {
        events.clear();
    }

    @NotNull
    public final Trace commitToTrace(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        List capturedEvents = CollectionsKt.toList((Iterable)events);
        this.clearEvents();
        TrackDescriptor trackDescriptor = new TrackDescriptor(123456543210L, label, new ThreadDescriptor(Process.myPid(), Process.myTid(), null, 4, null), true, null, 16, null);
        return new Trace(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)new TracePacket(null, 3, null, trackDescriptor, null, null, null, null, null, true, null, null, 3573, null))), (Iterable)capturedEvents), null, 2, null);
    }

    public final void beginSection(@NotNull String label, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        TrackEvent.Type type = TrackEvent.Type.TYPE_SLICE_BEGIN;
        List<String> list = TRACK_EVENT_CATEGORIES;
        TrackEvent trackEvent = new TrackEvent(list, null, label, type, 123456543210L, null, 34, null);
        events.add(new TracePacket(nanoTime, 3, trackEvent, null, null, null, 1234543210, null, null, null, null, null, 4024, null));
    }

    public static /* synthetic */ void beginSection$default(InMemoryTracing inMemoryTracing, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.nanoTime();
        }
        inMemoryTracing.beginSection(string, l);
    }

    public final void endSection(long nanoTime) {
        TrackEvent trackEvent = new TrackEvent(null, null, null, TrackEvent.Type.TYPE_SLICE_END, 123456543210L, null, 39, null);
        events.add(new TracePacket(nanoTime, 3, trackEvent, null, null, null, 1234543210, null, null, null, null, null, 4024, null));
    }

    public static /* synthetic */ void endSection$default(InMemoryTracing inMemoryTracing, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = System.nanoTime();
        }
        inMemoryTracing.endSection(l);
    }
}

