/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.vmtrace;

import androidx.annotation.NonNull;
import java.util.Locale;

class MethodInfo {
    public final long id;
    public final String className;
    public final String methodName;
    public final String signature;
    public final String srcPath;
    public final int srcLineNumber;
    private String mFullName;
    private String mShortName;

    MethodInfo(long id2, @NonNull String className, @NonNull String methodName, @NonNull String signature, @NonNull String srcPath, int srcLineNumber) {
        this.id = id2;
        this.className = className;
        this.methodName = methodName;
        this.signature = signature;
        this.srcPath = srcPath;
        this.srcLineNumber = srcLineNumber;
    }

    @NonNull
    public String getFullName() {
        if (this.mFullName == null) {
            this.mFullName = String.format(Locale.US, "%s.%s: %s", this.className, this.methodName, this.signature);
        }
        return this.mFullName;
    }

    @NonNull
    public String getShortName() {
        if (this.mShortName == null) {
            this.mShortName = String.format(Locale.US, "%s.%s", this.getUnqualifiedClassName(), this.methodName);
        }
        return this.mShortName;
    }

    @NonNull
    private String getUnqualifiedClassName() {
        String cn = this.className;
        int i = cn.lastIndexOf(47);
        if (i > 0) {
            cn = cn.substring(i + 1);
        }
        return cn;
    }
}

