/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.IdeSummaryPair;
import androidx.benchmark.Insight;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Measurements;
import androidx.benchmark.MetricResult;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.TreeBuilder;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJm\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J7\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\n2\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\n0#\u00a2\u0006\u0002\b%J \u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020\u0018J\u0015\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b,J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006/"}, d2={"Landroidx/benchmark/InstrumentationResults;", "", "()V", "ideWarningPrefix", "", "runEndResultBundle", "Landroid/os/Bundle;", "getRunEndResultBundle", "()Landroid/os/Bundle;", "clearIdeWarningPrefix", "", "ideSummary", "Landroidx/benchmark/IdeSummaryPair;", "testName", "message", "measurements", "Landroidx/benchmark/Measurements;", "iterationTracePaths", "", "profilerResults", "Landroidx/benchmark/Profiler$ResultFile;", "insights", "Landroidx/benchmark/Insight;", "useTreeDisplayFormat", "", "ideSummary$benchmark_common_release", "ideSummaryBasicMicro", "benchmarkName", "nanos", "", "allocations", "ideSummaryBasicMicro$benchmark_common_release", "(Ljava/lang/String;DLjava/lang/Double;Ljava/util/List;)Ljava/lang/String;", "instrumentationReport", "block", "Lkotlin/Function1;", "Landroidx/benchmark/InstrumentationResultScope;", "Lkotlin/ExtensionFunctionType;", "reportAdditionalFileToCopy", "key", "absoluteFilePath", "reportOnRunEndOnly", "reportBundle", "bundle", "reportBundle$benchmark_common_release", "scheduleIdeWarningOnNextReport", "string", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nInstrumentationResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstrumentationResults.kt\nandroidx/benchmark/InstrumentationResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1855#2,2:420\n1549#2:422\n1620#2,3:423\n1549#2:427\n1620#2,3:428\n1549#2:431\n1620#2,3:432\n618#2,12:435\n661#2,11:447\n1559#2:458\n1590#2,4:459\n1549#2:463\n1620#2,3:464\n1559#2:467\n1590#2,4:468\n1549#2:472\n1620#2,3:473\n1549#2:476\n1620#2,3:477\n1#3:426\n*S KotlinDebug\n*F\n+ 1 InstrumentationResults.kt\nandroidx/benchmark/InstrumentationResults\n*L\n138#1:420,2\n168#1:422\n168#1:423,3\n186#1:427\n186#1:428,3\n192#1:431\n192#1:432,3\n202#1:435,12\n204#1:447,11\n288#1:458\n288#1:459,4\n294#1:463\n294#1:464,3\n323#1:467\n323#1:468,4\n234#1:472\n234#1:473,3\n243#1:476\n243#1:477,3\n*E\n"})
public final class InstrumentationResults {
    @NotNull
    public static final InstrumentationResults INSTANCE = new InstrumentationResults();
    @NotNull
    private static final Bundle runEndResultBundle = new Bundle();
    @NotNull
    private static String ideWarningPrefix = "";

    private InstrumentationResults() {
    }

    @NotNull
    public final Bundle getRunEndResultBundle() {
        return runEndResultBundle;
    }

    public final void instrumentationReport(@NotNull Function1<? super InstrumentationResultScope, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        InstrumentationResultScope scope = new InstrumentationResultScope(null, 1, null);
        block.invoke((Object)scope);
        this.reportBundle$benchmark_common_release(scope.getBundle());
    }

    @NotNull
    public final String ideSummaryBasicMicro$benchmark_common_release(@NotNull String benchmarkName, double nanos, @Nullable Double allocations, @NotNull List<Profiler.ResultFile> profilerResults) {
        String string;
        Object object;
        Locale locale;
        String string2;
        Intrinsics.checkNotNullParameter((Object)benchmarkName, (String)"benchmarkName");
        Intrinsics.checkNotNullParameter(profilerResults, (String)"profilerResults");
        String output = null;
        if (nanos >= 100.0) {
            string2 = "%,13d   ns";
            locale = Locale.US;
            object = new Object[]{(long)nanos};
            String string3 = String.format(locale, string2, Arrays.copyOf(object, ((Object[])object).length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string2 = "%,15.1f ns";
            locale = Locale.US;
            object = new Object[]{nanos};
            String string4 = String.format(locale, string2, Arrays.copyOf(object, ((Object[])object).length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        output = string;
        if (allocations != null) {
            StringBuilder stringBuilder = new StringBuilder().append(output);
            string2 = "    %8d allocs";
            locale = Locale.US;
            object = new Object[]{(int)allocations.doubleValue()};
            String string5 = String.format(locale, string2, (Object[])Arrays.copyOf(object, ((Object)object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            output = stringBuilder.append(string5).toString();
        }
        Iterable $this$forEach$iv = profilerResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Profiler.ResultFile it = (Profiler.ResultFile)element$iv;
            boolean bl = false;
            output = output + "    [" + it.getLabel() + "](file://" + it.getSanitizedOutputRelativePath() + ')';
        }
        output = output + "    " + benchmarkName;
        return output;
    }

    public final void clearIdeWarningPrefix() {
        System.out.println((Object)"clear ide warning");
        ideWarningPrefix = "";
    }

    /*
     * WARNING - void declaration
     */
    public final void scheduleIdeWarningOnNextReport(@NotNull String string) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        ideWarningPrefix = ((CharSequence)ideWarningPrefix).length() == 0 ? string : ideWarningPrefix + '\n' + string;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Log.w((String)"Benchmark", (String)it));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdeSummaryPair ideSummary$benchmark_common_release(@Nullable String testName, @Nullable String message, @Nullable Measurements measurements, @Nullable List<String> iterationTracePaths, @NotNull List<Profiler.ResultFile> profilerResults, @NotNull List<Insight> insights, boolean useTreeDisplayFormat) {
        List list;
        List v2lines;
        List list2;
        List v2traceLinks;
        Iterator warningPrefix22;
        List linkableIterTraces;
        List list3;
        MetricResult absolutePath;
        boolean bl;
        Object object;
        Object[] $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Object[] $this$map$iv;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(profilerResults, (String)"profilerResults");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        CharSequence charSequence2 = ideWarningPrefix;
        if (charSequence2.length() == 0) {
            boolean bl2 = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String warningMessage = (String)charSequence;
        ideWarningPrefix = "";
        List<String> v1metricLines = null;
        List<String> v2metricLines = null;
        List<String> list4 = iterationTracePaths;
        if (list4 != null) {
            $this$map$iv = (Object[])list4;
            $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                bl = false;
                object.add(StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor((String)((Object)absolutePath)), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null));
            }
            list3 = (List)destination$iv$iv;
        } else {
            list3 = linkableIterTraces = CollectionsKt.emptyList();
        }
        if (measurements != null) {
            if (!measurements.isNotEmpty()) {
                boolean $i$a$-require-InstrumentationResults$ideSummary$232 = false;
                String $i$a$-require-InstrumentationResults$ideSummary$232 = "Require non-empty list of metric results.";
                throw new IllegalArgumentException($i$a$-require-InstrumentationResults$ideSummary$232.toString());
            }
            $this$map$iv = measurements.getSingleMetrics();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                absolutePath = (MetricResult)item$iv$iv;
                object = destination$iv$iv;
                bl = false;
                object.add(it.getName());
            }
            Set setOfMetrics = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (iterationTracePaths == null && testName != null && message == null && measurements.getSampledMetrics().isEmpty() && (Intrinsics.areEqual((Object)setOfMetrics, (Object)SetsKt.setOf((Object[])($this$map$iv = new String[]{"timeNs", "allocationCount"}))) || Intrinsics.areEqual((Object)setOfMetrics, (Object)SetsKt.setOf((Object)"timeNs")))) {
                Object v3;
                double nanos;
                block40: {
                    boolean bl3;
                    Iterable $this$single$iv = measurements.getSingleMetrics();
                    boolean $i$f$single = false;
                    Object single$iv = null;
                    boolean bl4 = false;
                    for (Object element$iv : $this$single$iv) {
                        MetricResult it = (MetricResult)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"timeNs")) continue;
                        if (bl3) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        bl3 = true;
                    }
                    if (!bl3) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    nanos = ((MetricResult)single$iv).getMin();
                    Iterable $this$singleOrNull$iv = measurements.getSingleMetrics();
                    boolean bl6 = false;
                    Object single$iv2 = null;
                    boolean found$iv2 = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        MetricResult it = (MetricResult)element$iv;
                        boolean bl32 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"allocationCount")) continue;
                        if (found$iv2) {
                            v3 = null;
                            break block40;
                        }
                        single$iv2 = element$iv;
                        found$iv2 = true;
                    }
                    v3 = !found$iv2 ? null : single$iv2;
                }
                MetricResult metricResult = v3;
                Double allocs = metricResult != null ? Double.valueOf(metricResult.getMin()) : null;
                String warningPrefix22 = warningMessage == null ? "" : warningMessage + '\n';
                return new IdeSummaryPair(warningPrefix22 + this.ideSummaryBasicMicro$benchmark_common_release(testName, nanos, allocs, CollectionsKt.emptyList()), warningPrefix22 + this.ideSummaryBasicMicro$benchmark_common_release(testName, nanos, allocs, profilerResults));
            }
            List allMetrics = CollectionsKt.plus((Collection)measurements.getSingleMetrics(), (Iterable)measurements.getSampledMetrics());
            warningPrefix22 = ((Iterable)allMetrics).iterator();
            if (!warningPrefix22.hasNext()) {
                throw new NoSuchElementException();
            }
            MetricResult it42422 = (MetricResult)warningPrefix22.next();
            boolean bl7 = false;
            int it42422 = it42422.getName().length();
            while (warningPrefix22.hasNext()) {
                MetricResult metricResult = (MetricResult)warningPrefix22.next();
                boolean bl8 = false;
                int n = metricResult.getName().length();
                if (it42422 >= n) continue;
                it42422 = n;
            }
            int maxLabelLength = it42422;
            Iterator it42422 = ((Iterable)allMetrics).iterator();
            if (!it42422.hasNext()) {
                throw new NoSuchElementException();
            }
            MetricResult metricResult = (MetricResult)it42422.next();
            boolean bl2 = false;
            double found$iv2 = metricResult.getMax();
            while (it42422.hasNext()) {
                MetricResult it2 = (MetricResult)it42422.next();
                boolean string = false;
                double bl32 = it2.getMax();
                found$iv2 = Math.max(found$iv2, bl32);
            }
            int maxValueLength = InstrumentationResults.ideSummary$toDisplayString(found$iv2).length();
            v1metricLines = InstrumentationResults.ideSummary$metricLines(measurements, maxLabelLength, maxValueLength, (Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String>)((Function5)ideSummary.2.INSTANCE));
            v2metricLines = !((Collection)linkableIterTraces).isEmpty() ? InstrumentationResults.ideSummary$metricLines(measurements, maxLabelLength, maxValueLength, (Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String>)((Function5)new Function5<String, String, String, String, MetricResult, String>((List<String>)linkableIterTraces){
                final /* synthetic */ List<String> $linkableIterTraces;
                {
                    this.$linkableIterTraces = $linkableIterTraces;
                    super(5);
                }

                public final String invoke(String name, String min, String median, String max, MetricResult result) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)min, (String)"min");
                    Intrinsics.checkNotNullParameter((Object)median, (String)"median");
                    Intrinsics.checkNotNullParameter((Object)max, (String)"max");
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    return "  " + name + "   [min " + min + "](file://" + this.$linkableIterTraces.get(result.getMinIndex()) + "),   [median " + median + "](file://" + this.$linkableIterTraces.get(result.getMedianIndex()) + "),   [max " + max + "](file://" + this.$linkableIterTraces.get(result.getMaxIndex()) + ')';
                }
            })) : v1metricLines;
        } else {
            v1metricLines = CollectionsKt.emptyList();
            v2metricLines = CollectionsKt.emptyList();
        }
        if (!useTreeDisplayFormat) {
            void $this$mapTo$iv$iv2;
            Object[] $this$map$iv2;
            List list5;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            if (!((Collection)linkableIterTraces).isEmpty()) {
                void $this$mapIndexed$iv;
                Iterable maxLabelLength = linkableIterTraces;
                object = new StringBuilder().append("    Traces: Iteration ");
                boolean $i$f$mapIndexed = false;
                warningPrefix22 = $this$mapIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean bl9 = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                    void path;
                    void index;
                    int it2;
                    if ((it2 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv$iv2;
                    int bl32 = it2;
                    collection = destination$iv$iv2;
                    boolean bl10 = false;
                    collection.add(InstrumentationResults.ideSummary$markdownFileLink(String.valueOf((int)index), (String)path));
                }
                list5 = CollectionsKt.listOf((Object)((StringBuilder)object).append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)).toString());
            } else {
                list5 = CollectionsKt.emptyList();
            }
            Iterable $this$mapIndexed$iv = profilerResults;
            object = list5;
            boolean $i$f$map2 = false;
            $this$mapIndexedTo$iv$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean bl11 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Profiler.ResultFile item$iv$iv2 = (Profiler.ResultFile)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl12 = false;
                collection.add("    " + InstrumentationResults.ideSummary$markdownFileLink(it.getLabel(), it.getSanitizedOutputRelativePath()));
            }
            v2traceLinks = CollectionsKt.plus((Collection)object, (Iterable)((List)destination$iv$iv3));
            $this$map$iv2 = new String[]{warningMessage, testName, message};
            list2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])$this$map$iv2), (Iterable)v2metricLines), (Iterable)v2traceLinks), (Object)"");
        } else {
            List $this$ideSummary_u24lambda_u2415 = v2traceLinks = CollectionsKt.createListBuilder();
            boolean bl13 = false;
            if (warningMessage != null) {
                $this$ideSummary_u24lambda_u2415.add(warningMessage);
            }
            if (testName != null) {
                $this$ideSummary_u24lambda_u2415.add(testName);
            }
            if (message != null) {
                $this$ideSummary_u24lambda_u2415.add(message);
            }
            TreeBuilder tree = new TreeBuilder();
            if (!((Collection)v2metricLines).isEmpty()) {
                tree.append("Metrics", 0);
                for (String string : v2metricLines) {
                    tree.append(string, 1);
                }
            }
            if (!((Collection)insights).isEmpty()) {
                tree.append("App Startup Insights", 0);
                for (Insight insight : insights) {
                    String criterion = insight.component1();
                    String observed = insight.component2();
                    tree.append(criterion, 1);
                    tree.append(observed, 2);
                }
            }
            if (!((Collection)linkableIterTraces).isEmpty() || !((Collection)profilerResults).isEmpty()) {
                tree.append("Traces", 0);
                if (!((Collection)linkableIterTraces).isEmpty()) {
                    void $this$mapIndexedTo$iv$iv;
                    void $this$mapIndexed$iv;
                    Iterable destination$iv$iv3 = linkableIterTraces;
                    TreeBuilder treeBuilder = tree;
                    boolean bl14 = false;
                    void criterion = $this$mapIndexed$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void trace;
                        void ix;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv4;
                        boolean bl4 = false;
                        collection.add(InstrumentationResults.ideSummary$markdownFileLink(String.valueOf((int)ix), (String)trace));
                    }
                    treeBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)" ", (CharSequence)"Iteration ", null, (int)0, null, null, (int)60, null), 1);
                }
                for (Profiler.ResultFile resultFile : profilerResults) {
                    tree.append(InstrumentationResults.ideSummary$markdownFileLink(resultFile.getLabel(), resultFile.getSanitizedOutputRelativePath()), 1);
                }
            }
            $this$ideSummary_u24lambda_u2415.addAll((Collection)tree.build());
            $this$ideSummary_u24lambda_u2415.add("");
            list2 = v2lines = CollectionsKt.build((List)v2traceLinks);
        }
        if (!((Collection)insights).isEmpty()) {
            list = v2lines;
        } else {
            Object[] objectArray = new String[]{warningMessage, testName, message};
            list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)v1metricLines), (Object)"");
        }
        List v1lines = list;
        return new IdeSummaryPair(v1lines, v2lines);
    }

    public static /* synthetic */ IdeSummaryPair ideSummary$benchmark_common_release$default(InstrumentationResults instrumentationResults, String string, String string2, Measurements measurements, List list, List list2, List list3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            measurements = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return instrumentationResults.ideSummary$benchmark_common_release(string, string2, measurements, list, list2, list3, bl);
    }

    public final void reportAdditionalFileToCopy(@NotNull String key, @NotNull String absoluteFilePath, boolean reportOnRunEndOnly) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        if (!(!StringsKt.contains$default((CharSequence)key, (char)'=', (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Key must not contain '=', which breaks instrumentation result string parsing";
            throw new IllegalArgumentException(string.toString());
        }
        if (reportOnRunEndOnly) {
            new InstrumentationResultScope(runEndResultBundle).fileRecord(key, absoluteFilePath);
        } else {
            this.instrumentationReport((Function1<? super InstrumentationResultScope, Unit>)((Function1)new Function1<InstrumentationResultScope, Unit>(key, absoluteFilePath){
                final /* synthetic */ String $key;
                final /* synthetic */ String $absoluteFilePath;
                {
                    this.$key = $key;
                    this.$absoluteFilePath = $absoluteFilePath;
                    super(1);
                }

                public final void invoke(InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    $this$instrumentationReport.fileRecord(this.$key, this.$absoluteFilePath);
                }
            }));
        }
    }

    public static /* synthetic */ void reportAdditionalFileToCopy$default(InstrumentationResults instrumentationResults, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        instrumentationResults.reportAdditionalFileToCopy(string, string2, bl);
    }

    public final void reportBundle$benchmark_common_release(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        InstrumentationRegistry.getInstrumentation().sendStatus(2, bundle);
    }

    private static final String ideSummary$toDisplayString(double $this$ideSummary_u24toDisplayString) {
        String string = "%,.1f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{$this$ideSummary_u24toDisplayString};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final List<String> ideSummary$metricLines(Measurements $measurements, int maxLabelLength, int maxValueLength, Function5<? super String, ? super String, ? super String, ? super String, ? super MetricResult, String> singleTransform) {
        MetricResult it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $measurements.getSingleMetrics();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MetricResult metricResult = (MetricResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)singleTransform.invoke((Object)StringsKt.padEnd$default((String)it.getName(), (int)maxLabelLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMin()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMedian()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getMax()), (int)maxValueLength, (char)'\u0000', (int)2, null), (Object)it));
        }
        $this$map$iv = $measurements.getSampledMetrics();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (MetricResult)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String name = StringsKt.padEnd$default((String)it.getName(), (int)maxLabelLength, (char)'\u0000', (int)2, null);
            String p50 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP50()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p90 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP90()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p95 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP95()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            String p99 = StringsKt.padStart$default((String)InstrumentationResults.ideSummary$toDisplayString(it.getP99()), (int)maxValueLength, (char)'\u0000', (int)2, null);
            collection2.add("  " + name + "   P50  " + p50 + ",   P90  " + p90 + ",   P95  " + p95 + ",   P99  " + p99);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private static final String ideSummary$markdownFileLink(String label, String outputRelativePath) {
        return '[' + label + "](file://" + outputRelativePath + ')';
    }
}

