/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.util.Log;
import androidx.benchmark.AllocationCountCapture;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkState;
import androidx.benchmark.CpuEventCounter;
import androidx.benchmark.CpuEventCounterCapture;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.MicrobenchmarkPhase;
import androidx.benchmark.Profiler;
import androidx.benchmark.ThrottleDetector;
import androidx.benchmark.TimeCapture;
import androidx.benchmark.WarmupManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0003,-.BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\b\u0010*\u001a\u00020\u000eH\u0003J\u0006\u0010+\u001a\u00020\u000eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0018R\u000e\u0010)\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase;", "", "label", "", "measurementCount", "", "loopMode", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "metrics", "", "Landroidx/benchmark/MetricCapture;", "profiler", "Landroidx/benchmark/Profiler;", "gcBeforePhase", "", "thermalThrottleSleepsMax", "(Ljava/lang/String;ILandroidx/benchmark/MicrobenchmarkPhase$LoopMode;[Landroidx/benchmark/MetricCapture;Landroidx/benchmark/Profiler;ZI)V", "getGcBeforePhase", "()Z", "getLabel", "()Ljava/lang/String;", "getLoopMode", "()Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "getMeasurementCount", "()I", "getMetrics", "()[Landroidx/benchmark/MetricCapture;", "[Landroidx/benchmark/MetricCapture;", "metricsContainer", "Landroidx/benchmark/MetricsContainer;", "getMetricsContainer", "()Landroidx/benchmark/MetricsContainer;", "getProfiler", "()Landroidx/benchmark/Profiler;", "thermalThrottleSleepSeconds", "", "getThermalThrottleSleepSeconds", "()J", "setThermalThrottleSleepSeconds", "(J)V", "getThermalThrottleSleepsMax", "thermalThrottleSleepsRemaining", "sleepIfThermalThrottled", "tryEnd", "Companion", "Config", "LoopMode", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nMicrobenchmarkPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrobenchmarkPhase.kt\nandroidx/benchmark/MicrobenchmarkPhase\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,312:1\n186#2,6:313\n*S KotlinDebug\n*F\n+ 1 MicrobenchmarkPhase.kt\nandroidx/benchmark/MicrobenchmarkPhase\n*L\n53#1:313,6\n*E\n"})
public final class MicrobenchmarkPhase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    private final int measurementCount;
    @NotNull
    private final LoopMode loopMode;
    @NotNull
    private final MetricCapture[] metrics;
    @Nullable
    private final Profiler profiler;
    private final boolean gcBeforePhase;
    private final int thermalThrottleSleepsMax;
    @NotNull
    private final MetricsContainer metricsContainer;
    private int thermalThrottleSleepsRemaining;
    private long thermalThrottleSleepSeconds;
    private static final long THROTTLE_BACKOFF_S = Arguments.INSTANCE.getThermalThrottleSleepDurationSeconds$benchmark_common_release();
    @NotNull
    private static final Lazy<CpuEventCounter> cpuEventCounter$delegate = LazyKt.lazy((Function0)Companion.cpuEventCounter.2.INSTANCE);

    public MicrobenchmarkPhase(@NotNull String label, int measurementCount, @NotNull LoopMode loopMode, @NotNull MetricCapture[] metrics, @Nullable Profiler profiler, boolean gcBeforePhase, int thermalThrottleSleepsMax) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)loopMode, (String)"loopMode");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.label = label;
        this.measurementCount = measurementCount;
        this.loopMode = loopMode;
        this.metrics = metrics;
        this.profiler = profiler;
        this.gcBeforePhase = gcBeforePhase;
        this.thermalThrottleSleepsMax = thermalThrottleSleepsMax;
        this.metricsContainer = new MetricsContainer(this.metrics, this.measurementCount);
        this.thermalThrottleSleepsRemaining = this.thermalThrottleSleepsMax;
        if (this.loopMode.getWarmupManager() != null && !(Intrinsics.areEqual((Object)CollectionsKt.first(this.metricsContainer.getNames$benchmark_common_release()), (Object)"timeNs") && this.metricsContainer.getNames$benchmark_common_release().size() <= 2)) {
            boolean bl = false;
            String string = "If warmup is enabled, expect to only capture one or two metrics";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ MicrobenchmarkPhase(String string, int n, LoopMode loopMode, MetricCapture[] metricCaptureArray, Profiler profiler, boolean bl, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture(null, 1, null)};
            metricCaptureArray = metricCaptureArray2;
        }
        if ((n3 & 0x10) != 0) {
            profiler = null;
        }
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        this(string, n, loopMode, metricCaptureArray, profiler, bl, n2);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final int getMeasurementCount() {
        return this.measurementCount;
    }

    @NotNull
    public final LoopMode getLoopMode() {
        return this.loopMode;
    }

    @NotNull
    public final MetricCapture[] getMetrics() {
        return this.metrics;
    }

    @Nullable
    public final Profiler getProfiler() {
        return this.profiler;
    }

    public final boolean getGcBeforePhase() {
        return this.gcBeforePhase;
    }

    public final int getThermalThrottleSleepsMax() {
        return this.thermalThrottleSleepsMax;
    }

    @NotNull
    public final MetricsContainer getMetricsContainer() {
        return this.metricsContainer;
    }

    public final long getThermalThrottleSleepSeconds() {
        return this.thermalThrottleSleepSeconds;
    }

    public final void setThermalThrottleSleepSeconds(long l) {
        this.thermalThrottleSleepSeconds = l;
    }

    public final boolean tryEnd() {
        boolean bl;
        if (this.thermalThrottleSleepsRemaining > 0 && this.sleepIfThermalThrottled()) {
            int n = this.thermalThrottleSleepsRemaining;
            this.thermalThrottleSleepsRemaining = n + -1;
            bl = false;
        } else {
            if (this.thermalThrottleSleepsMax > 0 && this.thermalThrottleSleepsRemaining == 0) {
                ThrottleDetector.INSTANCE.resetThrottleBaseline();
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"BanThreadSleep"})
    private final boolean sleepIfThermalThrottled() {
        boolean bl;
        if (ThrottleDetector.INSTANCE.isDeviceThermalThrottled()) {
            Log.d((String)"Benchmark", (String)("THERMAL THROTTLE DETECTED, SLEEPING FOR " + THROTTLE_BACKOFF_S + " SECONDS"));
            long startTimeNs = System.nanoTime();
            String label$iv = "Sleep due to Thermal Throttle";
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, null, null, 14, null);
            try {
                boolean bl2 = false;
                Thread.sleep(TimeUnit.SECONDS.toMillis(THROTTLE_BACKOFF_S));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
            }
            long sleepTimeNs = System.nanoTime() - startTimeNs;
            this.thermalThrottleSleepSeconds += TimeUnit.NANOSECONDS.toSeconds(sleepTimeNs);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ5\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\fJ1\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$Companion;", "", "()V", "THROTTLE_BACKOFF_S", "", "cpuEventCounter", "Landroidx/benchmark/CpuEventCounter;", "getCpuEventCounter$benchmark_common_release", "()Landroidx/benchmark/CpuEventCounter;", "cpuEventCounter$delegate", "Lkotlin/Lazy;", "allocationMeasurementPhase", "Landroidx/benchmark/MicrobenchmarkPhase;", "loopMode", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "dryRunModePhase", "profiledTimingPhase", "profiler", "Landroidx/benchmark/Profiler;", "metrics", "", "Landroidx/benchmark/MetricCapture;", "loopModeOverride", "measurementCountOverride", "", "(Landroidx/benchmark/Profiler;[Landroidx/benchmark/MetricCapture;Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;Ljava/lang/Integer;)Landroidx/benchmark/MicrobenchmarkPhase;", "startupModePhase", "timingMeasurementPhase", "measurementCount", "simplifiedTimingOnlyMode", "", "(Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;IZ[Landroidx/benchmark/MetricCapture;)Landroidx/benchmark/MicrobenchmarkPhase;", "warmupPhase", "warmupManager", "Landroidx/benchmark/WarmupManager;", "collectCpuEventInstructions", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CpuEventCounter getCpuEventCounter$benchmark_common_release() {
            Lazy lazy = cpuEventCounter$delegate;
            return (CpuEventCounter)lazy.getValue();
        }

        @NotNull
        public final MicrobenchmarkPhase dryRunModePhase() {
            return new MicrobenchmarkPhase("Benchmark DryRun Timing", 1, new LoopMode.FixedIterations(1), null, null, false, 0, 120, null);
        }

        @NotNull
        public final MicrobenchmarkPhase startupModePhase() {
            return new MicrobenchmarkPhase("Benchmark Startup Timing (experimental)", 10, new LoopMode.FixedIterations(1), null, null, false, 0, 120, null);
        }

        @NotNull
        public final MicrobenchmarkPhase warmupPhase(@NotNull WarmupManager warmupManager, boolean collectCpuEventInstructions) {
            MetricCapture[] metricCaptureArray;
            Intrinsics.checkNotNullParameter((Object)warmupManager, (String)"warmupManager");
            LoopMode loopMode = new LoopMode.Warmup(warmupManager);
            if (collectCpuEventInstructions) {
                MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture(null, 1, null), new CpuEventCounterCapture(this.getCpuEventCounter$benchmark_common_release(), CollectionsKt.listOf((Object)((Object)CpuEventCounter.Event.Instructions)))};
                metricCaptureArray = metricCaptureArray2;
            } else {
                MetricCapture[] metricCaptureArray3 = new MetricCapture[]{new TimeCapture(null, 1, null)};
                metricCaptureArray = metricCaptureArray3;
            }
            return new MicrobenchmarkPhase("Benchmark Warmup", 1, loopMode, metricCaptureArray, null, true, 0, 80, null);
        }

        @NotNull
        public final MicrobenchmarkPhase timingMeasurementPhase(@NotNull LoopMode loopMode, int measurementCount, boolean simplifiedTimingOnlyMode, @NotNull MetricCapture[] metrics) {
            Intrinsics.checkNotNullParameter((Object)loopMode, (String)"loopMode");
            Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
            return new MicrobenchmarkPhase("Benchmark Time", measurementCount, loopMode, metrics, null, false, simplifiedTimingOnlyMode ? 0 : 2, 48, null);
        }

        @NotNull
        public final MicrobenchmarkPhase profiledTimingPhase(@NotNull Profiler profiler, @NotNull MetricCapture[] metrics, @Nullable LoopMode loopModeOverride, @Nullable Integer measurementCountOverride) {
            int measurementCount;
            Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
            Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
            Integer n = measurementCountOverride;
            int n2 = measurementCount = n != null ? n : (profiler.getRequiresSingleMeasurementIteration() ? 1 : 50);
            LoopMode loopMode = loopModeOverride;
            if (loopMode == null) {
                loopMode = profiler.getRequiresSingleMeasurementIteration() ? (LoopMode)new LoopMode.FixedIterations(1) : (LoopMode)new LoopMode.Duration(profiler.getRequiresExtraRuntime() ? BenchmarkState.Companion.getSAMPLED_PROFILER_DURATION_NS$benchmark_common_release() / (long)measurementCount : BenchmarkState.Companion.getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release());
            }
            LoopMode loopMode2 = loopMode;
            return new MicrobenchmarkPhase("Benchmark Profiled Time", measurementCount, loopMode2, metrics, profiler, false, 0, 96, null);
        }

        @NotNull
        public final MicrobenchmarkPhase allocationMeasurementPhase(@NotNull LoopMode loopMode) {
            Intrinsics.checkNotNullParameter((Object)loopMode, (String)"loopMode");
            MetricCapture[] metricCaptureArray = new MetricCapture[]{new AllocationCountCapture()};
            return new MicrobenchmarkPhase("Benchmark Allocations", 5, loopMode, metricCaptureArray, null, false, 0, 112, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$Config;", "", "dryRunMode", "", "startupMode", "simplifiedTimingOnlyMode", "profiler", "Landroidx/benchmark/Profiler;", "profilerPerfCompareMode", "warmupCount", "", "measurementCount", "metrics", "", "Landroidx/benchmark/MetricCapture;", "(ZZZLandroidx/benchmark/Profiler;ZLjava/lang/Integer;Ljava/lang/Integer;[Landroidx/benchmark/MetricCapture;)V", "getDryRunMode", "()Z", "getMeasurementCount", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMetrics", "()[Landroidx/benchmark/MetricCapture;", "[Landroidx/benchmark/MetricCapture;", "getProfiler", "()Landroidx/benchmark/Profiler;", "getProfilerPerfCompareMode", "getSimplifiedTimingOnlyMode", "getStartupMode", "getWarmupCount", "warmupManager", "Landroidx/benchmark/WarmupManager;", "getWarmupManager", "()Landroidx/benchmark/WarmupManager;", "generatePhases", "", "Landroidx/benchmark/MicrobenchmarkPhase;", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nMicrobenchmarkPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrobenchmarkPhase.kt\nandroidx/benchmark/MicrobenchmarkPhase$Config\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n12474#2,2:313\n1726#3,3:315\n*S KotlinDebug\n*F\n+ 1 MicrobenchmarkPhase.kt\nandroidx/benchmark/MicrobenchmarkPhase$Config\n*L\n260#1:313,2\n304#1:315,3\n*E\n"})
    public static final class Config {
        private final boolean dryRunMode;
        private final boolean startupMode;
        private final boolean simplifiedTimingOnlyMode;
        @Nullable
        private final Profiler profiler;
        private final boolean profilerPerfCompareMode;
        @Nullable
        private final Integer warmupCount;
        @Nullable
        private final Integer measurementCount;
        @NotNull
        private final MetricCapture[] metrics;
        @NotNull
        private final WarmupManager warmupManager;

        public Config(boolean dryRunMode, boolean startupMode, boolean simplifiedTimingOnlyMode, @Nullable Profiler profiler, boolean profilerPerfCompareMode, @Nullable Integer warmupCount, @Nullable Integer measurementCount, @NotNull MetricCapture[] metrics) {
            Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
            this.dryRunMode = dryRunMode;
            this.startupMode = startupMode;
            this.simplifiedTimingOnlyMode = simplifiedTimingOnlyMode;
            this.profiler = profiler;
            this.profilerPerfCompareMode = profilerPerfCompareMode;
            this.warmupCount = warmupCount;
            this.measurementCount = measurementCount;
            this.metrics = metrics;
            this.warmupManager = new WarmupManager(this.warmupCount);
            if (!(this.warmupCount == null || this.warmupCount > 0)) {
                boolean $i$a$-require-MicrobenchmarkPhase$Config$32 = false;
                String $i$a$-require-MicrobenchmarkPhase$Config$32 = "warmupCount (" + this.warmupCount + ") must null or positive";
                throw new IllegalArgumentException($i$a$-require-MicrobenchmarkPhase$Config$32.toString());
            }
            if (!(this.measurementCount == null || this.measurementCount > 0)) {
                boolean bl = false;
                String string = "measurementCount (" + this.measurementCount + ") must be null or positive";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final boolean getDryRunMode() {
            return this.dryRunMode;
        }

        public final boolean getStartupMode() {
            return this.startupMode;
        }

        public final boolean getSimplifiedTimingOnlyMode() {
            return this.simplifiedTimingOnlyMode;
        }

        @Nullable
        public final Profiler getProfiler() {
            return this.profiler;
        }

        public final boolean getProfilerPerfCompareMode() {
            return this.profilerPerfCompareMode;
        }

        @Nullable
        public final Integer getWarmupCount() {
            return this.warmupCount;
        }

        @Nullable
        public final Integer getMeasurementCount() {
            return this.measurementCount;
        }

        @NotNull
        public final MetricCapture[] getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final WarmupManager getWarmupManager() {
            return this.warmupManager;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MicrobenchmarkPhase> generatePhases() {
            List list;
            if (this.dryRunMode) {
                list = CollectionsKt.listOf((Object)Companion.dryRunModePhase());
            } else {
                List list2;
                List list3;
                if (this.startupMode) {
                    list3 = CollectionsKt.listOf((Object)Companion.startupModePhase());
                } else {
                    MicrobenchmarkPhase microbenchmarkPhase;
                    boolean bl;
                    int n;
                    MetricCapture[] $this$any$iv;
                    Companion companion;
                    WarmupManager warmupManager;
                    Object[] objectArray;
                    LoopMode loopMode;
                    Profiler profiler;
                    int timingMeasurementCount;
                    block14: {
                        Integer n2 = this.measurementCount;
                        timingMeasurementCount = n2 != null ? n2 : 50;
                        profiler = this.simplifiedTimingOnlyMode ? null : this.profiler;
                        loopMode = this.profilerPerfCompareMode ? (LoopMode)new LoopMode.FixedIterations(1) : (LoopMode)new LoopMode.Duration(BenchmarkState.Companion.getDEFAULT_MEASUREMENT_DURATION_NS$benchmark_common_release());
                        objectArray = new MicrobenchmarkPhase[4];
                        MetricCapture[] metricCaptureArray = this.metrics;
                        warmupManager = this.warmupManager;
                        companion = Companion;
                        int n3 = 0;
                        Object[] objectArray2 = objectArray;
                        boolean $i$f$any = false;
                        int n4 = $this$any$iv.length;
                        for (n = 0; n < n4; n += 1) {
                            void element$iv;
                            void it = element$iv = $this$any$iv[n];
                            boolean bl2 = false;
                            if (!(it instanceof CpuEventCounterCapture && !((Collection)it.getNames()).isEmpty())) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                    boolean bl3 = bl;
                    objectArray2[n3] = companion.warmupPhase(warmupManager, bl3);
                    $this$any$iv = Companion;
                    MetricCapture[] metricCaptureArray = this.metrics;
                    n = this.simplifiedTimingOnlyMode ? 1 : 0;
                    objectArray[1] = $this$any$iv.timingMeasurementPhase(loopMode, timingMeasurementCount, n != 0, metricCaptureArray);
                    if (this.simplifiedTimingOnlyMode || profiler == null) {
                        microbenchmarkPhase = null;
                    } else if (this.profilerPerfCompareMode) {
                        $this$any$iv = new MetricCapture[]{new TimeCapture("profilerTimeNs")};
                        microbenchmarkPhase = Companion.profiledTimingPhase(profiler, $this$any$iv, loopMode, timingMeasurementCount);
                    } else {
                        microbenchmarkPhase = Companion.profiledTimingPhase(profiler, new MetricCapture[0], null, null);
                    }
                    objectArray[2] = microbenchmarkPhase;
                    objectArray[3] = this.simplifiedTimingOnlyMode ? null : Companion.allocationMeasurementPhase(loopMode);
                    list3 = CollectionsKt.listOfNotNull((Object[])objectArray);
                }
                List it = list2 = list3;
                boolean bl = false;
                if (this.simplifiedTimingOnlyMode) {
                    boolean bl4;
                    block15: {
                        Iterable $this$all$iv = it;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                MicrobenchmarkPhase phase = (MicrobenchmarkPhase)element$iv;
                                boolean bl5 = false;
                                if (phase.getThermalThrottleSleepsMax() == 0) continue;
                                bl4 = false;
                                break block15;
                            }
                            bl4 = true;
                        }
                    }
                    if (!bl4) {
                        boolean bl6 = false;
                        String string = "Thermal throttle check banned within simplifiedTimingOnlyMode";
                        throw new IllegalStateException(string.toString());
                    }
                }
                list = list2;
            }
            return list;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0013\b\u0004\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "", "warmupManager", "Landroidx/benchmark/WarmupManager;", "(Landroidx/benchmark/WarmupManager;)V", "getWarmupManager", "()Landroidx/benchmark/WarmupManager;", "getIterations", "", "warmupEstimatedIterationTimeNs", "", "Companion", "Duration", "FixedIterations", "Warmup", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$Duration;", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$FixedIterations;", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$Warmup;", "benchmark-common_release"})
    public static abstract class LoopMode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final WarmupManager warmupManager;
        public static final int MAX_TEST_ITERATIONS = 1000000;
        public static final int MIN_TEST_ITERATIONS = 1;

        private LoopMode(WarmupManager warmupManager) {
            this.warmupManager = warmupManager;
        }

        public /* synthetic */ LoopMode(WarmupManager warmupManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                warmupManager = null;
            }
            this(warmupManager, null);
        }

        @Nullable
        public final WarmupManager getWarmupManager() {
            return this.warmupManager;
        }

        public abstract int getIterations(long var1);

        public /* synthetic */ LoopMode(WarmupManager warmupManager, DefaultConstructorMarker $constructor_marker) {
            this(warmupManager);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$Companion;", "", "()V", "MAX_TEST_ITERATIONS", "", "MIN_TEST_ITERATIONS", "benchmark-common_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$Duration;", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "targetRepeatDurationNs", "", "(J)V", "getIterations", "", "warmupEstimatedIterationTimeNs", "benchmark-common_release"})
        public static final class Duration
        extends LoopMode {
            private final long targetRepeatDurationNs;

            public Duration(long targetRepeatDurationNs) {
                super(null, 1, null);
                this.targetRepeatDurationNs = targetRepeatDurationNs;
            }

            @Override
            public int getIterations(long warmupEstimatedIterationTimeNs) {
                if (!(warmupEstimatedIterationTimeNs >= 0L)) {
                    boolean bl = false;
                    String string = "Cannot dynamically determine repeat duration, warmup has not run!";
                    throw new IllegalStateException(string.toString());
                }
                return RangesKt.coerceIn((int)((int)(this.targetRepeatDurationNs / RangesKt.coerceAtLeast((long)warmupEstimatedIterationTimeNs, (long)1L))), (int)1, (int)1000000);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$FixedIterations;", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "iterations", "", "(I)V", "getIterations", "warmupEstimatedIterationTimeNs", "", "benchmark-common_release"})
        public static final class FixedIterations
        extends LoopMode {
            private final int iterations;

            public FixedIterations(int iterations) {
                super(null, 1, null);
                this.iterations = iterations;
            }

            @Override
            public int getIterations(long warmupEstimatedIterationTimeNs) {
                return this.iterations;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Landroidx/benchmark/MicrobenchmarkPhase$LoopMode$Warmup;", "Landroidx/benchmark/MicrobenchmarkPhase$LoopMode;", "warmupManager", "Landroidx/benchmark/WarmupManager;", "(Landroidx/benchmark/WarmupManager;)V", "getIterations", "", "warmupEstimatedIterationTimeNs", "", "benchmark-common_release"})
        public static final class Warmup
        extends LoopMode {
            public Warmup(@NotNull WarmupManager warmupManager) {
                Intrinsics.checkNotNullParameter((Object)warmupManager, (String)"warmupManager");
                super(warmupManager, null);
            }

            @Override
            public int getIterations(long warmupEstimatedIterationTimeNs) {
                return 1;
            }
        }
    }
}

