/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.benchmark.ConnectedAllocation;
import androidx.benchmark.ConnectedSampling;
import androidx.benchmark.MethodTracing;
import androidx.benchmark.Outputs;
import androidx.benchmark.StackSamplingLegacy;
import androidx.benchmark.StackSamplingSimpleperf;
import androidx.benchmark.json.BenchmarkData;
import androidx.benchmark.perfetto.StackSamplingConfig;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0010\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0011H&J\b\u0010\u001b\u001a\u00020\u0014H&R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u0082\u0001\u0005\u001e\u001f !\"\u00a8\u0006#"}, d2={"Landroidx/benchmark/Profiler;", "", "()V", "requiresDebuggable", "", "getRequiresDebuggable", "()Z", "requiresExtraRuntime", "getRequiresExtraRuntime", "requiresLibraryOutputDir", "getRequiresLibraryOutputDir", "requiresSingleMeasurementIteration", "getRequiresSingleMeasurementIteration", "config", "Landroidx/benchmark/perfetto/StackSamplingConfig;", "packageNames", "", "", "config$benchmark_common_release", "embedInPerfettoTrace", "", "profilerTrace", "Ljava/io/File;", "perfettoTrace", "start", "Landroidx/benchmark/Profiler$ResultFile;", "traceUniqueName", "stop", "Companion", "ResultFile", "Landroidx/benchmark/ConnectedAllocation;", "Landroidx/benchmark/ConnectedSampling;", "Landroidx/benchmark/MethodTracing;", "Landroidx/benchmark/StackSamplingLegacy;", "Landroidx/benchmark/StackSamplingSimpleperf;", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class Profiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean requiresSingleMeasurementIteration;
    private final boolean requiresExtraRuntime;
    private final boolean requiresDebuggable;
    private final boolean requiresLibraryOutputDir;
    public static final long CONNECTED_PROFILING_SLEEP_MS = 20000L;

    private Profiler() {
        this.requiresLibraryOutputDir = true;
    }

    @Nullable
    public abstract ResultFile start(@NotNull String var1);

    public abstract void stop();

    @Nullable
    public StackSamplingConfig config$benchmark_common_release(@NotNull List<String> packageNames) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        return null;
    }

    public void embedInPerfettoTrace(@NotNull File profilerTrace, @NotNull File perfettoTrace) {
        Intrinsics.checkNotNullParameter((Object)profilerTrace, (String)"profilerTrace");
        Intrinsics.checkNotNullParameter((Object)perfettoTrace, (String)"perfettoTrace");
    }

    public boolean getRequiresSingleMeasurementIteration() {
        return this.requiresSingleMeasurementIteration;
    }

    public boolean getRequiresExtraRuntime() {
        return this.requiresExtraRuntime;
    }

    public boolean getRequiresDebuggable() {
        return this.requiresDebuggable;
    }

    public boolean getRequiresLibraryOutputDir() {
        return this.requiresLibraryOutputDir;
    }

    public /* synthetic */ Profiler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/benchmark/Profiler$Companion;", "", "()V", "CONNECTED_PROFILING_SLEEP_MS", "", "getByName", "Landroidx/benchmark/Profiler;", "name", "", "traceName", "traceUniqueName", "traceTypeLabel", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\nandroidx/benchmark/Profiler$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n468#2:366\n414#2:367\n1238#3,4:368\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\nandroidx/benchmark/Profiler$Companion\n*L\n155#1:366\n155#1:367\n155#1:368,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Profiler getByName(@NotNull String name) {
            void $this$mapKeysTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"MethodTracing", (Object)MethodTracing.INSTANCE), TuplesKt.to((Object)"StackSampling", (Object)(Build.VERSION.SDK_INT >= 29 ? (Profiler)StackSamplingSimpleperf.INSTANCE : (Profiler)StackSamplingLegacy.INSTANCE)), TuplesKt.to((Object)"ConnectedAllocation", (Object)ConnectedAllocation.INSTANCE), TuplesKt.to((Object)"ConnectedSampling", (Object)ConnectedSampling.INSTANCE), TuplesKt.to((Object)"MethodSampling", (Object)StackSamplingLegacy.INSTANCE), TuplesKt.to((Object)"MethodSamplingSimpleperf", (Object)StackSamplingSimpleperf.INSTANCE), TuplesKt.to((Object)"Method", (Object)MethodTracing.INSTANCE), TuplesKt.to((Object)"Sampled", (Object)StackSamplingLegacy.INSTANCE), TuplesKt.to((Object)"ConnectedSampled", (Object)ConnectedSampling.INSTANCE)};
            Map $this$mapKeys$iv = MapsKt.mapOf((Pair[])pairArray);
            boolean $i$f$mapKeys = false;
            Map map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                String string;
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)((String)it.getKey()).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = map2;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string, entry);
            }
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return (Profiler)destination$iv$iv.get(string);
        }

        @NotNull
        public final String traceName(@NotNull String traceUniqueName, @NotNull String traceTypeLabel) {
            Intrinsics.checkNotNullParameter((Object)traceUniqueName, (String)"traceUniqueName");
            Intrinsics.checkNotNullParameter((Object)traceTypeLabel, (String)"traceTypeLabel");
            return Outputs.INSTANCE.sanitizeFilename(traceUniqueName + '-' + traceTypeLabel + '-' + Outputs.dateToFileName$default(Outputs.INSTANCE, null, 1, null) + ".trace");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0003R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Landroidx/benchmark/Profiler$ResultFile;", "", "label", "", "type", "Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "outputRelativePath", "source", "Landroidx/benchmark/Profiler;", "convertBeforeSync", "Lkotlin/Function0;", "", "(Ljava/lang/String;Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;Ljava/lang/String;Landroidx/benchmark/Profiler;Lkotlin/jvm/functions/Function0;)V", "getConvertBeforeSync", "()Lkotlin/jvm/functions/Function0;", "getLabel", "()Ljava/lang/String;", "getOutputRelativePath", "sanitizedOutputRelativePath", "getSanitizedOutputRelativePath", "getSource", "()Landroidx/benchmark/Profiler;", "getType", "()Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "embedInPerfettoTrace", "perfettoTracePath", "Companion", "benchmark-common_release"})
    public static final class ResultFile {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String label;
        @NotNull
        private final BenchmarkData.TestResult.ProfilerOutput.Type type;
        @NotNull
        private final String outputRelativePath;
        @Nullable
        private final Profiler source;
        @Nullable
        private final Function0<Unit> convertBeforeSync;

        private ResultFile(String label, BenchmarkData.TestResult.ProfilerOutput.Type type, String outputRelativePath, Profiler source, Function0<Unit> convertBeforeSync2) {
            this.label = label;
            this.type = type;
            this.outputRelativePath = outputRelativePath;
            this.source = source;
            this.convertBeforeSync = convertBeforeSync2;
        }

        /* synthetic */ ResultFile(String string, BenchmarkData.TestResult.ProfilerOutput.Type type, String string2, Profiler profiler, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                function0 = null;
            }
            this(string, type, string2, profiler, (Function0<Unit>)function0);
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final BenchmarkData.TestResult.ProfilerOutput.Type getType() {
            return this.type;
        }

        @NotNull
        public final String getOutputRelativePath() {
            return this.outputRelativePath;
        }

        @Nullable
        public final Profiler getSource() {
            return this.source;
        }

        @Nullable
        public final Function0<Unit> getConvertBeforeSync() {
            return this.convertBeforeSync;
        }

        public final void embedInPerfettoTrace(@NotNull String perfettoTracePath) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)perfettoTracePath, (String)"perfettoTracePath");
                Profiler profiler = this.source;
                if (profiler == null) break block0;
                profiler.embedInPerfettoTrace(new File(Outputs.INSTANCE.getOutputDirectory(), this.outputRelativePath), new File(perfettoTracePath));
            }
        }

        @NotNull
        public final String getSanitizedOutputRelativePath() {
            return StringsKt.replace$default((String)StringsKt.replace$default((String)this.outputRelativePath, (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null);
        }

        public /* synthetic */ ResultFile(String label, BenchmarkData.TestResult.ProfilerOutput.Type type, String outputRelativePath, Profiler source, Function0 convertBeforeSync2, DefaultConstructorMarker $constructor_marker) {
            this(label, type, outputRelativePath, source, (Function0<Unit>)convertBeforeSync2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/Profiler$ResultFile$Companion;", "", "()V", "of", "Landroidx/benchmark/Profiler$ResultFile;", "label", "", "type", "Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "outputRelativePath", "source", "Landroidx/benchmark/Profiler;", "convertBeforeSync", "Lkotlin/Function0;", "", "ofMethodTrace", "absolutePath", "ofPerfettoTrace", "benchmark-common_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResultFile ofPerfettoTrace(@NotNull String label, @NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                String string = Outputs.INSTANCE.relativePathFor(absolutePath);
                BenchmarkData.TestResult.ProfilerOutput.Type type = BenchmarkData.TestResult.ProfilerOutput.Type.PerfettoTrace;
                return new ResultFile(label, type, string, null, null, 16, null);
            }

            @NotNull
            public final ResultFile ofMethodTrace(@NotNull String label, @NotNull String absolutePath) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
                String string = Outputs.INSTANCE.relativePathFor(absolutePath);
                BenchmarkData.TestResult.ProfilerOutput.Type type = BenchmarkData.TestResult.ProfilerOutput.Type.MethodTrace;
                return new ResultFile(label, type, string, null, null, 16, null);
            }

            @NotNull
            public final ResultFile of(@NotNull String label, @NotNull BenchmarkData.TestResult.ProfilerOutput.Type type, @NotNull String outputRelativePath, @NotNull Profiler source, @Nullable Function0<Unit> convertBeforeSync2) {
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)outputRelativePath, (String)"outputRelativePath");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new ResultFile(label, type, outputRelativePath, source, convertBeforeSync2, null);
            }

            public static /* synthetic */ ResultFile of$default(Companion companion, String string, BenchmarkData.TestResult.ProfilerOutput.Type type, String string2, Profiler profiler, Function0 function0, int n, Object object) {
                if ((n & 0x10) != 0) {
                    function0 = null;
                }
                return companion.of(string, type, string2, profiler, (Function0<Unit>)function0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

