/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.Context;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.Outputs;
import androidx.benchmark.ResultWriter;
import androidx.benchmark.json.BenchmarkData;
import androidx.test.platform.app.InstrumentationRegistry;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014J#\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0001\u00a2\u0006\u0002\b\u001bR8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/ResultWriter;", "", "()V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "Landroidx/benchmark/json/BenchmarkData;", "kotlin.jvm.PlatformType", "getAdapter$benchmark_common_release", "()Lcom/squareup/moshi/JsonAdapter;", "reports", "", "Landroidx/benchmark/json/BenchmarkData$TestResult;", "getReports$benchmark_common_release$annotations", "getReports$benchmark_common_release", "()Ljava/util/List;", "appendTestResult", "", "testResult", "getParams", "", "", "testName", "writeReport", "file", "Ljava/io/File;", "benchmarks", "", "writeReport$benchmark_common_release", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nResultWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResultWriter.kt\nandroidx/benchmark/ResultWriter\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,112:1\n80#2:113\n165#2:114\n81#2:115\n82#2:120\n52#3,4:116\n60#3,10:121\n56#3,18:131\n1855#4:149\n1856#4:156\n151#5,6:150\n*S KotlinDebug\n*F\n+ 1 ResultWriter.kt\nandroidx/benchmark/ResultWriter\n*L\n90#1:113\n90#1:114\n90#1:115\n90#1:120\n90#1:116,4\n90#1:121,10\n90#1:131,18\n100#1:149\n100#1:156\n101#1:150,6\n*E\n"})
public final class ResultWriter {
    @NotNull
    public static final ResultWriter INSTANCE = new ResultWriter();
    @NotNull
    private static final List<BenchmarkData.TestResult> reports = new ArrayList();
    private static final JsonAdapter<BenchmarkData> adapter = new Moshi.Builder().build().adapter(BenchmarkData.class).indent("    ");

    private ResultWriter() {
    }

    @NotNull
    public final List<BenchmarkData.TestResult> getReports$benchmark_common_release() {
        return reports;
    }

    @VisibleForTesting
    public static /* synthetic */ void getReports$benchmark_common_release$annotations() {
    }

    public final JsonAdapter<BenchmarkData> getAdapter$benchmark_common_release() {
        return adapter;
    }

    public final void appendTestResult(@NotNull BenchmarkData.TestResult testResult) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        reports.add(testResult);
        if (Arguments.INSTANCE.getOutputEnable$benchmark_common_release()) {
            Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
            Intrinsics.checkNotNull((Object)context);
            String packageName = context.getPackageName();
            Outputs.INSTANCE.writeFile(packageName + "-benchmarkData.json", true, (Function1<? super File, Unit>)((Function1)appendTestResult.1.INSTANCE));
        } else {
            Log.d((String)"Benchmark", (String)"androidx.benchmark.output.enable not set, not writing results json");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void writeReport$benchmark_common_release(@NotNull File file, @NotNull List<BenchmarkData.TestResult> benchmarks) {
        Unit unit;
        Throwable thrown$iv$iv;
        block18: {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(benchmarks, (String)"benchmarks");
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException exception) {
                    throw new IOException(StringsKt.trimIndent((String)("\n                            Failed to create file for benchmark report in:\n                            " + file + ".parent\n                            Make sure the instrumentation argument additionalTestOutputDir is set\n                            to a writable directory on device. If using a version of Android Gradle\n                            Plugin that doesn't support additionalTestOutputDir, ensure your app's\n                            manifest file enables legacy storage behavior by adding the\n                            application attribute: android:requestLegacyExternalStorage=\"true\"\n                        ")), exception);
                }
            }
            BenchmarkData benchmarkData = new BenchmarkData(new BenchmarkData.Context(), benchmarks);
            FileSystem fileSystem = FileSystem.SYSTEM;
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            Path file$iv = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$writeReport_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                adapter.toJson($this$writeReport_u24lambda_u240, (Object)benchmarkData);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block19: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block19;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    @NotNull
    public final Map<String, String> getParams(@NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        int parameterStrStart = StringsKt.indexOf$default((CharSequence)testName, (char)'[', (int)0, (boolean)false, (int)6, null);
        int parameterStrEnd = StringsKt.lastIndexOf$default((CharSequence)testName, (char)']', (int)0, (boolean)false, (int)6, null);
        HashMap params = new HashMap();
        if (parameterStrStart >= 0 && parameterStrEnd >= 0) {
            String string = testName.substring(parameterStrStart + 1, parameterStrEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String paramListString = string;
            String[] stringArray = new String[]{","};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)paramListString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String value;
                String key;
                int separatorIndex;
                String paramString;
                block3: {
                    int n;
                    paramString = (String)element$iv;
                    boolean bl = false;
                    CharSequence $this$indexOfFirst$iv = paramString;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (!(it == ':' || it == '=')) continue;
                        n = index$iv;
                        break block3;
                    }
                    n = separatorIndex = -1;
                }
                boolean bl = 1 <= separatorIndex ? separatorIndex < paramString.length() - 1 : false;
                if (!bl) continue;
                Intrinsics.checkNotNullExpressionValue((Object)paramString.substring(0, separatorIndex), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)paramString.substring(separatorIndex + 1), (String)"substring(...)");
                ((Map)params).put(key, value);
            }
        }
        return params;
    }
}

