/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Debug;
import androidx.benchmark.MetricCapture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/AllocationCountCapture;", "Landroidx/benchmark/MetricCapture;", "()V", "currentPausedStarted", "", "currentTotalPaused", "capturePaused", "", "captureResumed", "captureStart", "timeNs", "", "captureStop", "output", "", "offset", "benchmark-common_release"})
public final class AllocationCountCapture
extends MetricCapture {
    private int currentPausedStarted;
    private int currentTotalPaused;

    public AllocationCountCapture() {
        super(CollectionsKt.listOf((Object)"allocationCount"));
    }

    @Override
    public void captureStart(long timeNs) {
        this.currentTotalPaused = 0;
        Debug.startAllocCounting();
    }

    @Override
    public void captureStop(long timeNs, @NotNull long[] output, int offset) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Debug.stopAllocCounting();
        output[offset] = Debug.getGlobalAllocCount() - this.currentTotalPaused;
    }

    @Override
    public void capturePaused() {
        this.currentPausedStarted = Debug.getGlobalAllocCount();
    }

    @Override
    public void captureResumed() {
        this.currentTotalPaused += Debug.getGlobalAllocCount() - this.currentPausedStarted;
    }
}

