/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.MetricCapture;
import androidx.benchmark.MetricResult;
import androidx.benchmark.MetricsContainer;
import androidx.benchmark.TimeCapture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/benchmark/MetricsContainer;", "", "metrics", "", "Landroidx/benchmark/MetricCapture;", "repeatCount", "", "([Landroidx/benchmark/MetricCapture;I)V", "data", "", "", "getData$benchmark_common_release", "()Ljava/util/List;", "[Landroidx/benchmark/MetricCapture;", "names", "", "getNames$benchmark_common_release", "repeatTiming", "runNum", "captureFinished", "Landroidx/benchmark/MetricResult;", "maxIterations", "captureInit", "", "capturePaused", "captureResumed", "captureStart", "captureStop", "peekSingleRepeatTime", "", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nMetricsContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsContainer.kt\nandroidx/benchmark/MetricsContainer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n9972#2:179\n10394#2,5:180\n1#3:185\n1559#4:186\n1590#4,3:187\n1864#4,3:190\n1593#4:193\n1549#4:194\n1620#4,3:195\n1549#4:198\n1620#4,3:199\n1855#4,2:202\n*S KotlinDebug\n*F\n+ 1 MetricsContainer.kt\nandroidx/benchmark/MetricsContainer\n*L\n31#1:179\n31#1:180,5\n140#1:186\n140#1:187,3\n146#1:190,3\n140#1:193\n161#1:194\n161#1:195,3\n168#1:198\n168#1:199,3\n173#1:202,2\n*E\n"})
public final class MetricsContainer {
    @NotNull
    private final MetricCapture[] metrics;
    private final int repeatCount;
    @NotNull
    private final List<String> names;
    @NotNull
    private final List<long[]> data;
    @NotNull
    private final long[] repeatTiming;
    private int runNum;

    /*
     * WARNING - void declaration
     */
    public MetricsContainer(@NotNull MetricCapture[] metrics, int repeatCount) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        this.metrics = metrics;
        this.repeatCount = repeatCount;
        MetricCapture[] metricCaptureArray = this.metrics;
        MetricsContainer metricsContainer = this;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$flatMapTo = 0;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            Iterable list$iv$iv = it.getNames();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        metricsContainer.names = (List)destination$iv$iv;
        int n2 = this.repeatCount;
        metricsContainer = this;
        ArrayList<long[]> arrayList = new ArrayList<long[]>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            $i$f$flatMapTo = n4 = n3++;
            ArrayList<long[]> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new long[this.names.size()]);
        }
        metricsContainer.data = arrayList;
        this.repeatTiming = new long[this.repeatCount * 2];
    }

    public /* synthetic */ MetricsContainer(MetricCapture[] metricCaptureArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            MetricCapture[] metricCaptureArray2 = new MetricCapture[]{new TimeCapture(null, 1, null)};
            metricCaptureArray = metricCaptureArray2;
        }
        this(metricCaptureArray, n);
    }

    @NotNull
    public final List<String> getNames$benchmark_common_release() {
        return this.names;
    }

    @NotNull
    public final List<long[]> getData$benchmark_common_release() {
        return this.data;
    }

    public final long peekSingleRepeatTime() {
        if (!(this.repeatCount == 1)) {
            boolean bl = false;
            String string = "Observed repeat count " + this.repeatCount + ", expected 1";
            throw new IllegalStateException(string.toString());
        }
        return this.repeatTiming[1] - this.repeatTiming[0];
    }

    public final void captureInit() {
        this.runNum = 0;
    }

    public final void captureStart() {
        long timeNs;
        this.repeatTiming[this.runNum * 2] = timeNs = System.nanoTime();
        for (int i = ArraysKt.getLastIndex((Object[])this.metrics); -1 < i; --i) {
            this.metrics[i].captureStart(timeNs);
        }
    }

    public final void captureStop() {
        long timeNs = System.nanoTime();
        int offset = 0;
        int i = 0;
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (i <= n) {
            while (true) {
                this.metrics[i].captureStop(timeNs, this.data.get(this.runNum), offset);
                offset += this.metrics[i].getNames().size();
                if (i == n) break;
                ++i;
            }
        }
        this.repeatTiming[this.runNum * 2 + 1] = timeNs;
        ++this.runNum;
    }

    public final void capturePaused() {
        int i = 0;
        int n = ArraysKt.getLastIndex((Object[])this.metrics);
        if (i <= n) {
            while (true) {
                this.metrics[i].capturePaused();
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void captureResumed() {
        for (int i = ArraysKt.getLastIndex((Object[])this.metrics); -1 < i; --i) {
            this.metrics[i].captureResumed();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MetricResult> captureFinished(int maxIterations) {
        void $this$mapTo$iv$iv;
        Object $this$forEachIndexed$iv;
        Object object;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.names;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void name;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            object = destination$iv$iv;
            boolean bl = false;
            int n3 = this.repeatCount;
            ArrayList<Double> arrayList = new ArrayList<Double>(n3);
            int n4 = 0;
            while (n4 < n3) {
                void index;
                void it;
                int n5;
                int n6 = n5 = n4++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl2 = false;
                arrayList2.add((double)this.data.get((int)it)[index] / (double)maxIterations);
            }
            List metricData = arrayList;
            $this$forEachIndexed$iv = CollectionsKt.chunked((Iterable)metricData, (int)10);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                void chunk;
                int n7;
                Object item$iv = iterator.next();
                if ((n7 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int chunkNum = n7;
                boolean bl3 = false;
                StringBuilder stringBuilder = new StringBuilder().append((String)name);
                String string2 = "[%2d:%2d]: %s";
                Object[] objectArray = new Object[]{chunkNum * 10, (chunkNum + 1) * 10, CollectionsKt.joinToString$default((Iterable)((Iterable)chunk), (CharSequence)" ", null, null, (int)0, null, (Function1)captureFinished.results.1.1.1.INSTANCE, (int)30, null)};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                Log.d((String)"Benchmark", (String)stringBuilder.append(string3).toString());
            }
            object.add(new MetricResult((String)name, metricData, null, 4, null));
        }
        List results2 = (List)destination$iv$iv;
        Iterable $this$map$iv22 = this.names;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv22;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add("metric: " + (String)it);
        }
        List metricTraceLabels = (List)destination$iv$iv2;
        int i = 0;
        int $this$map$iv22 = ArraysKt.getLastIndex((long[])this.repeatTiming);
        int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)$this$map$iv22, (int)2);
        if (i <= n) {
            while (true) {
                Collection<Double> collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                Object item$iv$iv;
                int measurementIndex = i / 2;
                Iterable $i$f$mapTo2 = results2;
                List list = metricTraceLabels;
                long l = this.repeatTiming[i];
                String string = "measurement " + measurementIndex;
                object = InMemoryTracing.INSTANCE;
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    $this$forEachIndexed$iv = (MetricResult)item$iv$iv2;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    collection.add(((Number)it.getData().get(measurementIndex)).doubleValue());
                }
                collection = (List)destination$iv$iv3;
                ((InMemoryTracing)object).beginSection(string, l, list, (List<Double>)collection);
                InMemoryTracing.INSTANCE.endSection(this.repeatTiming[i + 1]);
                if (i == n) break;
                i += 2;
            }
        }
        Iterable $this$forEach$iv = metricTraceLabels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            InMemoryTracing.INSTANCE.counter(it, 0.0, ArraysKt.last((long[])this.repeatTiming));
        }
        return results2;
    }
}

