/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.CheckResult;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellImpl;
import androidx.benchmark.ShellScript;
import androidx.tracing.Trace;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002TUB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0019\u001a\u00020\u0010H\u0007J\u0014\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cJ\b\u0010\u001d\u001a\u00020\u0010H\u0007J\u0014\u0010\u001e\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0007J\u001c\u0010!\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010$\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00042\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J\u0015\u0010)\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0007J\u0012\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0015\u0010.\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010(\u001a\u00020\u0004J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001c2\u0006\u0010,\u001a\u00020\u0004H\u0007J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010,\u001a\u00020\u0004J\u000e\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004J\u000e\u00106\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0004J\u0016\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0004J\u0006\u00109\u001a\u00020&J\u0006\u0010:\u001a\u00020&J>\u0010;\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00042\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\u00062\u001a\b\u0002\u0010>\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001c\u0012\u0004\u0012\u00020\u00100?JD\u0010;\u001a\u00020\u00102\f\u0010@\u001a\b\u0012\u0004\u0012\u0002020\u001c2\b\b\u0002\u0010<\u001a\u00020\b2\b\b\u0002\u0010=\u001a\u00020\u00062\u001a\b\u0002\u0010>\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001c\u0012\u0004\u0012\u00020\u00100?J\u0014\u0010A\u001a\u00020\u00102\f\u0010@\u001a\b\u0012\u0004\u0012\u0002020\u001cJ\u0018\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u0004H\u0002J\u0010\u0010E\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010F\u001a\u00020&2\u0006\u0010G\u001a\u00020\u0004J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u0002020\u001c2\u0006\u0010I\u001a\u00020\u0004H\u0007J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010,\u001a\u00020\u0004H\u0007J\u0018\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0002J>\u0010M\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u00062\u0006\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020\b2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00100SH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Landroidx/benchmark/Shell;", "", "()V", "COMPILATION_PROFILE_UNKNOWN", "", "DEFAULT_KILL_POLL_MAX_COUNT", "", "DEFAULT_KILL_POLL_PERIOD_MS", "", "amBroadcast", "broadcastArguments", "(Ljava/lang/String;)Ljava/lang/Integer;", "catProcFileLong", "path", "(Ljava/lang/String;)Ljava/lang/Long;", "connectUiAutomation", "", "createRunnableExecutable", "name", "inputStream", "Ljava/io/InputStream;", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "stdin", "disableBackgroundDexOpt", "disablePackages", "appPackages", "", "enableBackgroundDexOpt", "enablePackages", "executeCommandCaptureStdoutOnly", "command", "executeScriptCaptureStdout", "executeScriptCaptureStdoutStderr", "Landroidx/benchmark/Shell$Output;", "executeScriptSilent", "fullProcessNameMatchesProcess", "", "fullProcessName", "processName", "getChecksum", "getChecksum$benchmark_common_release", "getCompilationMode", "packageName", "getFileSizeLsUnsafe", "getFileSizeUnsafe", "getFileSizeUnsafe$benchmark_common_release", "getPidsForProcess", "getRunningPidsAndProcessesForPackage", "Landroidx/benchmark/Shell$ProcessPid;", "getRunningProcessesForPackage", "getprop", "propertyName", "isPackageAlive", "isProcessAlive", "pid", "isSELinuxEnforced", "isSessionRooted", "killProcessesAndWait", "waitPollPeriodMs", "waitPollMaxCount", "processKiller", "Lkotlin/Function1;", "processes", "killTerm", "moveToTmpAndMakeExecutable", "src", "dst", "optionalCommand", "pathExists", "absoluteFilePath", "pgrepLF", "pattern", "pmPath", "psLineContainsProcess", "psOutputLine", "waitForFileFlush", "stableIterations", "maxInitialFlushWaitIterations", "maxStableFlushWaitIterations", "pollDurationMs", "triggerFileFlush", "Lkotlin/Function0;", "Output", "ProcessPid", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nandroidx/benchmark/Shell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Trace.kt\nandroidx/tracing/TraceKt\n+ 5 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,901:1\n1#2:902\n1#2:913\n1#2:926\n1#2:945\n1603#3,9:903\n1855#3:912\n1856#3:914\n1612#3:915\n1603#3,9:916\n1855#3:925\n1856#3:927\n1612#3:928\n1603#3,9:935\n1855#3:944\n1856#3:946\n1612#3:947\n1549#3:948\n1620#3,3:949\n766#3:952\n857#3,2:953\n1549#3:955\n1620#3,3:956\n766#3:959\n857#3,2:960\n1549#3:962\n1620#3,3:963\n766#3:966\n857#3,2:967\n1549#3:969\n1620#3,3:970\n1549#3:973\n1620#3,3:974\n766#3:977\n857#3,2:978\n1747#3,3:980\n1855#3,2:983\n1549#3:985\n1620#3,3:986\n766#3:989\n857#3,2:990\n27#4,6:929\n186#5,6:992\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nandroidx/benchmark/Shell\n*L\n360#1:913\n408#1:926\n482#1:945\n360#1:903,9\n360#1:912\n360#1:914\n360#1:915\n408#1:916,9\n408#1:925\n408#1:927\n408#1:928\n482#1:935,9\n482#1:944\n482#1:946\n482#1:947\n500#1:948\n500#1:949,3\n501#1:952\n501#1:953,2\n502#1:955\n502#1:956,3\n523#1:959\n523#1:960,2\n524#1:962\n524#1:963,3\n533#1:966\n533#1:967,2\n542#1:969\n542#1:970,3\n551#1:973\n551#1:974,3\n555#1:977\n555#1:978,2\n569#1:980,3\n579#1:983,2\n597#1:985\n597#1:986,3\n617#1:989\n617#1:990,2\n448#1:929,6\n621#1:992,6\n*E\n"})
public final class Shell {
    @NotNull
    public static final Shell INSTANCE = new Shell();
    @NotNull
    private static final String COMPILATION_PROFILE_UNKNOWN = "unknown";
    private static final long DEFAULT_KILL_POLL_PERIOD_MS = 50L;
    private static final int DEFAULT_KILL_POLL_MAX_COUNT = 100;

    private Shell() {
    }

    private final boolean psLineContainsProcess(String psOutputLine, String processName) {
        return StringsKt.endsWith$default((String)psOutputLine, (String)(' ' + processName), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)psOutputLine, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    private final boolean fullProcessNameMatchesProcess(String fullProcessName, String processName) {
        return Intrinsics.areEqual((Object)fullProcessName, (Object)processName) || StringsKt.endsWith$default((String)fullProcessName, (String)('/' + processName), (boolean)false, (int)2, null);
    }

    public final void connectUiAutomation() {
        if (Build.VERSION.SDK_INT >= 21) {
        }
    }

    @Nullable
    public final String optionalCommand(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        return Build.VERSION.SDK_INT >= 21 ? Shell.executeScriptCaptureStdoutStderr$default(this, command2, null, 2, null).getStdout() : null;
    }

    @Nullable
    public final Long catProcFileLong(@NotNull String path) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.optionalCommand("cat " + path);
        if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null) {
            Long l2;
            String $this$catProcFileLong_u24lambda_u240 = string;
            boolean bl = false;
            try {
                l2 = Long.parseLong($this$catProcFileLong_u24lambda_u240);
            }
            catch (NumberFormatException exception) {
                l2 = null;
            }
            l = l2;
        } else {
            l = null;
        }
        return l;
    }

    @NotNull
    public final String getChecksum$benchmark_common_release(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Build.VERSION.SDK_INT < 23) {
            String string = this.getFileSizeLsUnsafe(path);
            if (string == null) {
                string = "";
            }
            return string;
        }
        String sum = StringsKt.substringBefore$default((String)ShellImpl.INSTANCE.executeCommandUnsafe("md5sum " + path), (String)" ", null, (int)2, null);
        if (StringsKt.isBlank((CharSequence)sum)) {
            if (!ShellImpl.INSTANCE.isSessionRooted()) {
                String lsOutput = ShellImpl.INSTANCE.executeCommandUnsafe("ls -l " + path);
                throw new IllegalStateException("Checksum for " + path + " was blank. Adb session is not rooted, if root owns file, you may need to \"adb root\" and delete the file: " + lsOutput);
            }
            throw new IllegalStateException("Checksum for " + path + " was blank.");
        }
        return sum;
    }

    @SuppressLint(value={"BanThreadSleep"})
    public final void waitForFileFlush(@NotNull String path, int stableIterations, int maxInitialFlushWaitIterations, int maxStableFlushWaitIterations, long pollDurationMs, @NotNull Function0<Unit> triggerFileFlush) {
        int iteration;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(triggerFileFlush, (String)"triggerFileFlush");
        long lastKnownSize = this.getFileSizeUnsafe$benchmark_common_release(path);
        triggerFileFlush.invoke();
        long currentSize = this.getFileSizeUnsafe$benchmark_common_release(path);
        for (iteration = 0; iteration < maxInitialFlushWaitIterations && currentSize == lastKnownSize; ++iteration) {
            Thread.sleep(pollDurationMs);
            currentSize = this.getFileSizeUnsafe$benchmark_common_release(path);
        }
        lastKnownSize = 0L;
        int stable = 0;
        for (iteration = 0; iteration < maxStableFlushWaitIterations; ++iteration) {
            currentSize = this.getFileSizeUnsafe$benchmark_common_release(path);
            if (currentSize > 0L) {
                if (currentSize == lastKnownSize) {
                    if (++stable == stableIterations) {
                        break;
                    }
                } else {
                    stable = 0;
                    lastKnownSize = currentSize;
                }
            }
            Thread.sleep(pollDurationMs);
        }
    }

    public final long getFileSizeUnsafe$benchmark_common_release(@NotNull String path) {
        Long fileSize;
        Long l;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Build.VERSION.SDK_INT >= 23) {
            l = StringsKt.toLongOrNull((String)((Object)StringsKt.trim((CharSequence)ShellImpl.INSTANCE.executeCommandUnsafe("stat -c %s " + path))).toString());
        } else {
            String string = this.getFileSizeLsUnsafe(path);
            l = fileSize = string != null ? Long.valueOf(Long.parseLong(string)) : null;
        }
        if (!(fileSize != null)) {
            boolean bl = false;
            String string = "Unable to obtain file size for the file " + path;
            throw new IllegalArgumentException(string.toString());
        }
        return fileSize;
    }

    private final String getFileSizeLsUnsafe(String path) {
        String string;
        String result = ShellImpl.INSTANCE.executeCommandUnsafe("ls -l " + path);
        if (StringsKt.isBlank((CharSequence)result)) {
            string = null;
        } else {
            CharSequence charSequence = result;
            Regex regex = new Regex("\\s+");
            int n = 0;
            string = (String)regex.split(charSequence, n).get(3);
        }
        return string;
    }

    private final void moveToTmpAndMakeExecutable(String src, String dst) {
        ShellImpl.INSTANCE.executeCommandUnsafe("cp " + src + ' ' + dst);
        if (Build.VERSION.SDK_INT >= 23) {
            ShellImpl.INSTANCE.executeCommandUnsafe("chmod +x " + dst);
        } else {
            ShellImpl.INSTANCE.executeCommandUnsafe("chmod 777 " + dst);
        }
        String srcSum = this.getChecksum$benchmark_common_release(src);
        String dstSum = this.getChecksum$benchmark_common_release(dst);
        if (!Intrinsics.areEqual((Object)srcSum, (Object)dstSum)) {
            throw new IllegalStateException("Failed to verify copied executable " + dst + ", md5 sums " + srcSum + ", " + dstSum + " don't match. Check if root owns " + dst + " and if so, delete it with `adb root`-ed shell session.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String createRunnableExecutable(@NotNull String name, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        File writableExecutableFile = File.createTempFile("temporary_" + name, null, Outputs.INSTANCE.getDirUsableByAppAndShell());
        String runnableExecutablePath = "/data/local/tmp/" + name;
        try {
            Intrinsics.checkNotNull((Object)writableExecutableFile);
            Closeable closeable = new FileOutputStream(writableExecutableFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                writableExecutableFile.setReadable(true, false);
            }
            String string = writableExecutableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            this.moveToTmpAndMakeExecutable(string, runnableExecutablePath);
        }
        finally {
            writableExecutableFile.delete();
        }
        return runnableExecutablePath;
    }

    public final boolean isSessionRooted() {
        return ShellImpl.INSTANCE.isSessionRooted() || ShellImpl.INSTANCE.isSuAvailable();
    }

    @NotNull
    public final String getprop(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default(this, "getprop " + propertyName, null, 2, null))).toString();
    }

    public final void executeScriptSilent(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Output output = this.executeScriptCaptureStdoutStderr(script, stdin);
        if (!output.isBlank()) {
            boolean bl = false;
            String string = "Expected no stdout/stderr from " + script + ", saw " + output;
            throw new IllegalStateException(string.toString());
        }
    }

    public static /* synthetic */ void executeScriptSilent$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        shell.executeScriptSilent(string, string2);
    }

    @CheckResult
    @NotNull
    public final String executeScriptCaptureStdout(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Output output = this.executeScriptCaptureStdoutStderr(script, stdin);
        if (!StringsKt.isBlank((CharSequence)output.getStderr())) {
            boolean bl = false;
            String string = "Expected no stderr from " + script + ", saw " + output.getStderr();
            throw new IllegalStateException(string.toString());
        }
        return output.getStdout();
    }

    public static /* synthetic */ String executeScriptCaptureStdout$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptCaptureStdout(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @CheckResult
    @NotNull
    public final String getCompilationMode(@NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (Build.VERSION.SDK_INT <= 23) {
            return "speed";
        }
        String dump = ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default(this, "cmd package dump " + packageName, null, 2, null))).toString();
        int n = Build.VERSION.SDK_INT;
        boolean bl = 24 <= n ? n < 28 : false;
        if (bl) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            String string2;
            MatchGroup matchGroup;
            Object object;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("Dexopt state:.*status:[^\\[]+\\[([^\\]]+)\\]", RegexOption.DOT_MATCHES_ALL), (CharSequence)dump, (int)0, (int)2, null);
            String keyValues = matchResult != null && (object = matchResult.getGroups()) != null && (matchGroup = object.get(1)) != null && (string2 = matchGroup.getValue()) != null ? string2 : COMPILATION_PROFILE_UNKNOWN;
            object = new String[]{","};
            object = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)keyValues, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null), (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            string2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                String[] stringArray = new String[]{"="};
                List kv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if ((kv.size() != 2 ? null : TuplesKt.to(kv.get(0), kv.get(1))) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Map dexOptStatus = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            string = (String)dexOptStatus.get("compilation_filter");
            if (string == null) {
                string = COMPILATION_PROFILE_UNKNOWN;
            }
        } else {
            String string3;
            MatchGroup matchGroup;
            MatchGroupCollection matchGroupCollection;
            MatchResult matchResult = Regex.find$default((Regex)new Regex("Dexopt state:.*\\[status=([^\\]]+)\\]", RegexOption.DOT_MATCHES_ALL), (CharSequence)dump, (int)0, (int)2, null);
            string = matchResult != null && (matchGroupCollection = matchResult.getGroups()) != null && (matchGroup = matchGroupCollection.get(1)) != null && (string3 = matchGroup.getValue()) != null ? string3 : COMPILATION_PROFILE_UNKNOWN;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @CheckResult
    @NotNull
    public final List<String> pmPath(@NotNull String packageName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)Shell.executeScriptCaptureStdout$default(this, "pm path " + packageName, null, 2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String delimiter = "package:";
            int index = StringsKt.indexOf$default((CharSequence)it, (String)delimiter, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                String string2 = it.substring(index + delimiter.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckResult
    @NotNull
    public final Output executeScriptCaptureStdoutStderr(@NotNull String script, @Nullable String stdin) {
        Output output;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = StringsKt.take((String)("executeScript " + script), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            output = ShellImpl.INSTANCE.createShellScript(script, stdin).start().getOutputAndClose();
        }
        finally {
            Trace.endSection();
        }
        return output;
    }

    public static /* synthetic */ Output executeScriptCaptureStdoutStderr$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.executeScriptCaptureStdoutStderr(string, string2);
    }

    @CheckResult
    @NotNull
    public final String executeCommandCaptureStdoutOnly(@NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        return ShellImpl.INSTANCE.executeCommandUnsafe(command2);
    }

    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return ShellImpl.INSTANCE.createShellScript(script, stdin);
    }

    public static /* synthetic */ ShellScript createShellScript$default(Shell shell, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return shell.createShellScript(string, string2);
    }

    public final boolean isPackageAlive(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return !((Collection)this.getPidsForProcess(packageName)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getPidsForProcess(@NotNull String processName) {
        Iterable $this$filterTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapNotNullTo$iv$iv22;
            Iterable $this$mapNotNull$iv = this.pgrepLF(processName);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ProcessPid runningProcess = (ProcessPid)element$iv$iv;
                boolean bl2 = false;
                if ((INSTANCE.fullProcessNameMatchesProcess(runningProcess.getProcessName(), processName) ? Integer.valueOf(runningProcess.getPid()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        CharSequence $this$mapNotNull$iv = Shell.executeScriptCaptureStdout$default(this, "ps | grep " + processName, null, 2, null);
        Regex $i$f$mapNotNull = new Regex("\r?\n");
        int $this$mapNotNullTo$iv$iv22 = 0;
        Iterable $this$map$iv = $i$f$mapNotNull.split($this$mapNotNull$iv, $this$mapNotNullTo$iv$iv22);
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("\\s+");
            int n = 0;
            collection.add(Integer.parseInt((String)regex.split(charSequence, n).get(1)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=23)
    @NotNull
    public final List<ProcessPid> pgrepLF(@NotNull String pattern) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        CharSequence charSequence = ShellImpl.INSTANCE.executeCommandUnsafe("pgrep -l -f " + pattern);
        Regex regex = new Regex("\r?\n");
        int n = 0;
        Iterable $this$filter$iv = regex.split(charSequence, n);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List list = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String pidString = (String)list.get(0);
            String process = (String)list.get(1);
            collection.add(new ProcessPid(process, Integer.parseInt(pidString)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=23)
    @NotNull
    public final List<ProcessPid> getRunningPidsAndProcessesForPackage(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-Shell$getRunningPidsAndProcessesForPackage$22 = false;
            String $i$a$-require-Shell$getRunningPidsAndProcessesForPackage$22 = "Package " + packageName + " must not contain ':'";
            throw new IllegalArgumentException($i$a$-require-Shell$getRunningPidsAndProcessesForPackage$22.toString());
        }
        Iterable $this$filter$iv = this.pgrepLF(StringsKt.replace$default((String)packageName, (String)".", (String)"\\.", (boolean)false, (int)4, null));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProcessPid it = (ProcessPid)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getProcessName(), (Object)packageName) || StringsKt.startsWith$default((String)it.getProcessName(), (String)(packageName + ':'), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getRunningProcessesForPackage(@NotNull String packageName) {
        void $this$filterTo$iv$iv;
        String it2;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)":", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-Shell$getRunningProcessesForPackage$22 = false;
            String $i$a$-require-Shell$getRunningProcessesForPackage$22 = "Package " + packageName + " must not contain ':'";
            throw new IllegalArgumentException($i$a$-require-Shell$getRunningProcessesForPackage$22.toString());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapTo$iv$iv22;
            Iterable $this$map$iv = this.getRunningPidsAndProcessesForPackage(packageName);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                void it2;
                ProcessPid processPid = (ProcessPid)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getProcessName());
            }
            return (List)destination$iv$iv;
        }
        Object $this$map$iv = Shell.executeScriptCaptureStdout$default(this, "ps | grep " + packageName, null, 2, null);
        Regex $i$f$map = new Regex("\r?\n");
        int $this$mapTo$iv$iv22 = 0;
        $this$map$iv = $i$f$map.split((CharSequence)$this$map$iv, $this$mapTo$iv$iv22);
        boolean $i$f$map2 = false;
        Object $this$mapTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv22.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringAfterLast$default((String)it2, (String)" ", null, (int)2, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it2, (Object)packageName) || StringsKt.startsWith$default((String)it2, (String)(packageName + ':'), (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isProcessAlive(int pid, @NotNull String processName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            CharSequence charSequence = ShellImpl.INSTANCE.executeCommandUnsafe("ps " + pid);
            Regex regex = new Regex("\r?\n");
            int n = 0;
            Iterable $this$any$iv = regex.split(charSequence, n);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.psLineContainsProcess(it, processName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void killTerm(@NotNull List<ProcessPid> processes) {
        Intrinsics.checkNotNullParameter(processes, (String)"processes");
        Iterable $this$forEach$iv = processes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessPid it = (ProcessPid)element$iv;
            boolean bl = false;
            Output stopOutput = Shell.executeScriptCaptureStdoutStderr$default(INSTANCE, "kill -TERM " + it.getPid(), null, 2, null);
            Log.d((String)"Benchmark", (String)("kill -TERM command output - " + stopOutput));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void killProcessesAndWait(@NotNull String processName, long waitPollPeriodMs, int waitPollMaxCount, @NotNull Function1<? super List<ProcessPid>, Unit> processKiller) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter(processKiller, (String)"processKiller");
        Iterable $this$map$iv = this.getPidsForProcess(processName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pid;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProcessPid(processName, (int)pid));
        }
        List processes = (List)destination$iv$iv;
        this.killProcessesAndWait(processes, waitPollPeriodMs, waitPollMaxCount, processKiller);
    }

    public static /* synthetic */ void killProcessesAndWait$default(Shell shell, String string, long l, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 50L;
        }
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            function1 = (Function1)new Function1<List<? extends ProcessPid>, Unit>((Object)shell){

                public final void invoke(List<ProcessPid> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    ((Shell)this.receiver).killTerm(p0);
                }
            };
        }
        shell.killProcessesAndWait(string, l, n, (Function1<? super List<ProcessPid>, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void killProcessesAndWait(@NotNull List<ProcessPid> processes, long waitPollPeriodMs, int waitPollMaxCount, @NotNull Function1<? super List<ProcessPid>, Unit> processKiller) {
        Intrinsics.checkNotNullParameter(processes, (String)"processes");
        Intrinsics.checkNotNullParameter(processKiller, (String)"processKiller");
        Ref.ObjectRef runningProcesses = new Ref.ObjectRef();
        runningProcesses.element = CollectionsKt.toList((Iterable)processes);
        processKiller.invoke(runningProcesses.element);
        for (int i = 0; i < waitPollMaxCount; ++i) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            int it = i;
            boolean bl = false;
            Iterable iterable = (Iterable)runningProcesses.element;
            Ref.ObjectRef objectRef = runningProcesses;
            boolean $i$f$filter = false;
            void var13_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProcessPid it2 = (ProcessPid)element$iv$iv;
                boolean bl2 = false;
                if (!INSTANCE.isProcessAlive(it2.getPid(), it2.getProcessName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            objectRef.element = (List)destination$iv$iv;
            if (((List)runningProcesses.element).isEmpty()) {
                return;
            }
            String label$iv = "wait for " + runningProcesses.element + " to die";
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, null, null, 14, null);
            try {
                boolean bl3 = false;
                SystemClock.sleep((long)waitPollPeriodMs);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
            }
            Log.d((String)"Benchmark", (String)("Waiting " + waitPollPeriodMs + " ms for " + runningProcesses.element + " to die"));
        }
        throw new IllegalStateException("Failed to stop " + runningProcesses.element);
    }

    public static /* synthetic */ void killProcessesAndWait$default(Shell shell, List list, long l, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 50L;
        }
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            function1 = killProcessesAndWait.2.INSTANCE;
        }
        shell.killProcessesAndWait(list, l, n, (Function1<? super List<ProcessPid>, Unit>)function1);
    }

    public final boolean pathExists(@NotNull String absoluteFilePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteFilePath, (String)"absoluteFilePath");
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)ShellImpl.INSTANCE.executeCommandUnsafe("ls " + absoluteFilePath))).toString(), (Object)absoluteFilePath);
    }

    @Nullable
    public final Integer amBroadcast(@NotNull String broadcastArguments) {
        Intrinsics.checkNotNullParameter((Object)broadcastArguments, (String)"broadcastArguments");
        return StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)ShellImpl.INSTANCE.executeCommandUnsafe("am broadcast " + broadcastArguments), (String)"Broadcast completed: result=", null, (int)2, null))).toString());
    }

    public final void disablePackages(@NotNull List<String> appPackages) {
        Intrinsics.checkNotNullParameter(appPackages, (String)"appPackages");
        String command2 = CollectionsKt.joinToString$default((Iterable)appPackages, (CharSequence)"\n", null, null, (int)0, null, (Function1)disablePackages.command.1.INSTANCE, (int)30, null);
        Shell.executeScriptCaptureStdoutStderr$default(this, command2, null, 2, null);
    }

    public final void enablePackages(@NotNull List<String> appPackages) {
        Intrinsics.checkNotNullParameter(appPackages, (String)"appPackages");
        String command2 = CollectionsKt.joinToString$default((Iterable)appPackages, (CharSequence)"\n", null, null, (int)0, null, (Function1)enablePackages.command.1.INSTANCE, (int)30, null);
        Shell.executeScriptCaptureStdoutStderr$default(this, command2, null, 2, null);
    }

    @RequiresApi(value=24)
    public final void disableBackgroundDexOpt() {
        ShellImpl.INSTANCE.executeCommandUnsafe("cmd package bg-dexopt-job --cancel");
        ShellImpl.INSTANCE.executeCommandUnsafe("cmd package bg-dexopt-job --disable");
    }

    @RequiresApi(value=24)
    public final void enableBackgroundDexOpt() {
        ShellImpl.INSTANCE.executeCommandUnsafe("cmd package bg-dexopt-job --enable");
    }

    public final boolean isSELinuxEnforced() {
        boolean bl;
        switch (((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default(this, "getenforce", null, 2, null))).toString()) {
            case "Permissive": {
                bl = false;
                break;
            }
            case "Disabled": {
                bl = false;
                break;
            }
            case "Enforcing": {
                bl = true;
                break;
            }
            default: {
                String value;
                throw new IllegalStateException("unexpected result from getenforce: " + value);
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\rJ\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/Shell$Output;", "", "stdout", "", "stderr", "(Ljava/lang/String;Ljava/lang/String;)V", "getStderr", "()Ljava/lang/String;", "getStdout", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "isBlank", "toString", "benchmark-common_release"})
    public static final class Output {
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public Output(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            this.stdout = stdout;
            this.stderr = stderr;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        public final boolean isBlank() {
            return StringsKt.isBlank((CharSequence)this.stdout) && StringsKt.isBlank((CharSequence)this.stderr);
        }

        @NotNull
        public final String component1() {
            return this.stdout;
        }

        @NotNull
        public final String component2() {
            return this.stderr;
        }

        @NotNull
        public final Output copy(@NotNull String stdout, @NotNull String stderr) {
            Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
            Intrinsics.checkNotNullParameter((Object)stderr, (String)"stderr");
            return new Output(stdout, stderr);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.stdout;
            }
            if ((n & 2) != 0) {
                string2 = output.stderr;
            }
            return output.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Output(stdout=" + this.stdout + ", stderr=" + this.stderr + ')';
        }

        public int hashCode() {
            int result = this.stdout.hashCode();
            result = result * 31 + this.stderr.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)output.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)output.stderr);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/Shell$ProcessPid;", "", "processName", "", "pid", "", "(Ljava/lang/String;I)V", "getPid", "()I", "getProcessName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isAlive", "toString", "benchmark-common_release"})
    public static final class ProcessPid {
        @NotNull
        private final String processName;
        private final int pid;

        public ProcessPid(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            this.processName = processName;
            this.pid = pid;
        }

        @NotNull
        public final String getProcessName() {
            return this.processName;
        }

        public final int getPid() {
            return this.pid;
        }

        public final boolean isAlive() {
            return INSTANCE.isProcessAlive(this.pid, this.processName);
        }

        @NotNull
        public final String component1() {
            return this.processName;
        }

        public final int component2() {
            return this.pid;
        }

        @NotNull
        public final ProcessPid copy(@NotNull String processName, int pid) {
            Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
            return new ProcessPid(processName, pid);
        }

        public static /* synthetic */ ProcessPid copy$default(ProcessPid processPid, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = processPid.processName;
            }
            if ((n2 & 2) != 0) {
                n = processPid.pid;
            }
            return processPid.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ProcessPid(processName=" + this.processName + ", pid=" + this.pid + ')';
        }

        public int hashCode() {
            int result = this.processName.hashCode();
            result = result * 31 + Integer.hashCode(this.pid);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessPid)) {
                return false;
            }
            ProcessPid processPid = (ProcessPid)other;
            if (!Intrinsics.areEqual((Object)this.processName, (Object)processPid.processName)) {
                return false;
            }
            return this.pid == processPid.pid;
        }
    }
}

