/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.vmtrace;

import java.util.Locale;
import org.jspecify.annotations.NonNull;

class MethodInfo {
    public final long id;
    public final String className;
    public final String methodName;
    public final String signature;
    public final String srcPath;
    public final int srcLineNumber;
    private String mFullName;
    private String mShortName;

    MethodInfo(long id2, @NonNull String className, @NonNull String methodName, @NonNull String signature, @NonNull String srcPath, int srcLineNumber) {
        this.id = id2;
        this.className = className;
        this.methodName = methodName;
        this.signature = signature;
        this.srcPath = srcPath;
        this.srcLineNumber = srcLineNumber;
    }

    public @NonNull String getFullName() {
        if (this.mFullName == null) {
            this.mFullName = String.format(Locale.US, "%s.%s: %s", this.className, this.methodName, this.signature);
        }
        return this.mFullName;
    }

    public @NonNull String getShortName() {
        if (this.mShortName == null) {
            this.mShortName = String.format(Locale.US, "%s.%s", this.getUnqualifiedClassName(), this.methodName);
        }
        return this.mShortName;
    }

    private @NonNull String getUnqualifiedClassName() {
        String cn = this.className;
        int i = cn.lastIndexOf(47);
        if (i > 0) {
            cn = cn.substring(i + 1);
        }
        return cn;
    }
}

