/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.ActivityManager;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import android.util.Printer;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.ConfigurationError;
import androidx.benchmark.ConfigurationErrorKt;
import androidx.benchmark.DeviceInfo;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u000fH\u0002J\u001d\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\n2\b\u00104\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0011\u0010#\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR\u0011\u0010%\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u001d\u0010'\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b(\u0010\u0011R\u0011\u0010+\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001cR\u0011\u0010-\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0011\u00a8\u00067"}, d2={"Landroidx/benchmark/DeviceInfo;", "", "()V", "ART_MAINLINE_MIN_VERSION_CLASS_INIT_TRACING", "", "ART_MAINLINE_VERSIONS_AFFECTING_METHOD_TRACING", "Lkotlin/ranges/LongRange;", "ART_MAINLINE_VERSION_UNDETECTED", "ART_MAINLINE_VERSION_UNDETECTED_ERROR", "MINIMUM_BATTERY_PERCENT", "", "artMainlineVersion", "getArtMainlineVersion", "()J", "deviceSummaryString", "", "getDeviceSummaryString", "()Ljava/lang/String;", "errors", "", "Landroidx/benchmark/ConfigurationError;", "getErrors", "()Ljava/util/List;", "initialBatteryPercent", "getInitialBatteryPercent", "()I", "isEmulator", "", "()Z", "isEngBuild", "isLowRamDevice", "isRooted", "isUserdebugBuild", "methodTracingAffectsMeasurements", "getMethodTracingAffectsMeasurements", "misconfiguredForTracing", "getMisconfiguredForTracing", "profileableEnforced", "getProfileableEnforced", "supportsBaselineProfileCaptureError", "getSupportsBaselineProfileCaptureError", "supportsBaselineProfileCaptureError$delegate", "Lkotlin/Lazy;", "supportsCpuEventCounters", "getSupportsCpuEventCounters", "typeLabel", "getTypeLabel", "getMainlineAppInfo", "Landroid/content/pm/ApplicationInfo;", "packageName", "isClassInitTracingAvailable", "targetApiLevel", "targetArtMainlineVersion", "(ILjava/lang/Long;)Z", "queryArtMainlineVersion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDeviceInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,306:1\n1#2:307\n12474#3,2:308\n*S KotlinDebug\n*F\n+ 1 DeviceInfo.kt\nandroidx/benchmark/DeviceInfo\n*L\n70#1:308,2\n*E\n"})
public final class DeviceInfo {
    @NotNull
    public static final DeviceInfo INSTANCE;
    private static final boolean isEmulator;
    @NotNull
    private static final String typeLabel;
    private static final boolean isEngBuild;
    private static final boolean isUserdebugBuild;
    private static final boolean profileableEnforced;
    private static final boolean isRooted;
    @NotNull
    private static final Lazy supportsBaselineProfileCaptureError$delegate;
    public static final int MINIMUM_BATTERY_PERCENT = 25;
    private static final int initialBatteryPercent;
    @NotNull
    private static final String deviceSummaryString;
    @NotNull
    private static final List<ConfigurationError> errors;
    private static final boolean misconfiguredForTracing;
    private static final boolean isLowRamDevice;
    @NotNull
    private static final LongRange ART_MAINLINE_VERSIONS_AFFECTING_METHOD_TRACING;
    public static final long ART_MAINLINE_MIN_VERSION_CLASS_INIT_TRACING = 341511000L;
    public static final long ART_MAINLINE_VERSION_UNDETECTED = -1L;
    public static final long ART_MAINLINE_VERSION_UNDETECTED_ERROR = -100L;
    private static final long artMainlineVersion;
    private static final boolean methodTracingAffectsMeasurements;
    private static final boolean supportsCpuEventCounters;

    private DeviceInfo() {
    }

    public final boolean isEmulator() {
        return isEmulator;
    }

    @NotNull
    public final String getTypeLabel() {
        return typeLabel;
    }

    public final boolean isEngBuild() {
        return isEngBuild;
    }

    public final boolean getProfileableEnforced() {
        return profileableEnforced;
    }

    public final boolean isRooted() {
        return isRooted;
    }

    @Nullable
    public final String getSupportsBaselineProfileCaptureError() {
        Lazy lazy = supportsBaselineProfileCaptureError$delegate;
        return (String)lazy.getValue();
    }

    public final int getInitialBatteryPercent() {
        return initialBatteryPercent;
    }

    @NotNull
    public final String getDeviceSummaryString() {
        return deviceSummaryString;
    }

    @NotNull
    public final List<ConfigurationError> getErrors() {
        return errors;
    }

    public final boolean getMisconfiguredForTracing() {
        return misconfiguredForTracing;
    }

    private final ApplicationInfo getMainlineAppInfo(String packageName) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = InstrumentationRegistry.getInstrumentation().getContext().getPackageManager().getApplicationInfo(packageName, 0x40000000);
        }
        catch (PackageManager.NameNotFoundException notFoundException) {
            applicationInfo = null;
        }
        return applicationInfo;
    }

    @RequiresApi(value=31)
    private final long queryArtMainlineVersion() {
        ApplicationInfo artMainlinePackage;
        ApplicationInfo applicationInfo = this.getMainlineAppInfo("com.google.android.art");
        if (applicationInfo == null && (applicationInfo = this.getMainlineAppInfo("com.android.art")) == null && (applicationInfo = this.getMainlineAppInfo("com.google.android.go.art")) == null) {
            applicationInfo = this.getMainlineAppInfo("com.android.go.art");
        }
        if ((artMainlinePackage = applicationInfo) == null) {
            Log.d((String)"Benchmark", (String)("No ART mainline module found on API " + Build.VERSION.SDK_INT));
            return Build.VERSION.SDK_INT >= 34 ? -100L : -1L;
        }
        Ref.LongRef versionCode = new Ref.LongRef();
        versionCode.element = -1L;
        Printer printer2 = new Printer(versionCode){
            final /* synthetic */ Ref.LongRef $versionCode;
            {
                this.$versionCode = $versionCode;
            }

            public void println(String x) {
                if (x == null || this.$versionCode.element != -1L) {
                    return;
                }
                String prefix2 = " versionCode=";
                int offset = StringsKt.indexOf$default((CharSequence)x, (String)prefix2, (int)0, (boolean)false, (int)6, null);
                if (offset >= 0) {
                    String string = x.substring(offset + prefix2.length(), StringsKt.indexOf$default((CharSequence)x, (char)' ', (int)(offset + prefix2.length()), (boolean)false, (int)4, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String versionString = string;
                    this.$versionCode.element = Long.parseLong(versionString);
                }
            }
        };
        artMainlinePackage.dump(printer2, "");
        if (!(versionCode.element > 0L)) {
            boolean bl = false;
            String string = "Unable to parse ART version code";
            throw new IllegalStateException(string.toString());
        }
        return versionCode.element;
    }

    public final boolean isLowRamDevice() {
        return isLowRamDevice;
    }

    public final long getArtMainlineVersion() {
        return artMainlineVersion;
    }

    public final boolean getMethodTracingAffectsMeasurements() {
        return methodTracingAffectsMeasurements;
    }

    public final boolean isClassInitTracingAvailable(int targetApiLevel, @Nullable Long targetArtMainlineVersion) {
        return targetApiLevel >= 35 || targetApiLevel >= 31 && (targetArtMainlineVersion == null || targetArtMainlineVersion >= 341511000L);
    }

    public final boolean getSupportsCpuEventCounters() {
        return supportsCpuEventCounters;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            block12: {
                DeviceInfo.INSTANCE = new DeviceInfo();
                v0 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v0, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)v1, (String)"unknown", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v2 = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"FINGERPRINT");
                if (StringsKt.contains$default((CharSequence)v2, (CharSequence)"emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v3 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v3, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"MODEL");
                if (StringsKt.startsWith$default((String)v4, (String)"sdk_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v5 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v5, (CharSequence)"sdk_gphone64", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v6 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v6, (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v7 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)v7, (CharSequence)"Android SDK built for", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v8 = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"MANUFACTURER");
                if (StringsKt.contains$default((CharSequence)v8, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v9 = Build.BRAND;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"BRAND");
                if (!StringsKt.startsWith$default((String)v9, (String)"generic", (boolean)false, (int)2, null)) break block12;
                v10 = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"DEVICE");
                if (StringsKt.startsWith$default((String)v10, (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            }
            if (Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) lbl-1000:
            // 11 sources

            {
                v11 = true;
            } else {
                v11 = false;
            }
            DeviceInfo.isEmulator = v11;
            DeviceInfo.typeLabel = DeviceInfo.isEmulator != false ? "emulator" : "device";
            v12 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"FINGERPRINT");
            DeviceInfo.isEngBuild = StringsKt.contains$default((CharSequence)v12, (CharSequence)":eng/", (boolean)false, (int)2, null);
            v13 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"FINGERPRINT");
            DeviceInfo.isUserdebugBuild = StringsKt.contains$default((CharSequence)v13, (CharSequence)":userdebug/", (boolean)false, (int)2, null);
            DeviceInfo.profileableEnforced = DeviceInfo.isEngBuild == false && DeviceInfo.isUserdebugBuild == false;
            v14 = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"FINGERPRINT");
            if (StringsKt.contains$default((CharSequence)v14, (CharSequence)":userdebug/", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var0 = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"};
            $this$any$iv = var0;
            $i$f$any = false;
            var3_8 = $this$any$iv.length;
            for (var2_6 = 0; var2_6 < var3_8; ++var2_6) {
                it = element$iv = $this$any$iv[var2_6];
                $i$a$-any-DeviceInfo$isRooted$1 = false;
                if (!new File(it).exists()) continue;
                v15 = true;
                break block11;
            }
            v15 = false;
        }
        if (v15) lbl-1000:
        // 2 sources

        {
            v16 = true;
        } else {
            v16 = false;
        }
        DeviceInfo.isRooted = v16;
        DeviceInfo.supportsBaselineProfileCaptureError$delegate = LazyKt.lazy((Function0)supportsBaselineProfileCaptureError.2.INSTANCE);
        DeviceInfo.misconfiguredForTracing = new File("/sys/kernel/tracing/trace_marker").exists() == false && new File("/sys/kernel/debug/tracing/trace_marker").exists() == false;
        context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        v17 = context.registerReceiver(null, filter);
        if (v17 != null) {
            $this$_init__u24lambda_u242 = v17;
            $i$a$-run-DeviceInfo$1 = false;
            level = $this$_init__u24lambda_u242.getBooleanExtra("present", true) != false ? $this$_init__u24lambda_u242.getIntExtra("level", 100) : 100;
            scale = $this$_init__u24lambda_u242.getIntExtra("scale", 100);
            v18 = level * 100 / scale;
        } else {
            v18 = 100;
        }
        DeviceInfo.initialBatteryPercent = v18;
        v19 = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)v19, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        DeviceInfo.isLowRamDevice = ((ActivityManager)v19).isLowRamDevice();
        DeviceInfo.deviceSummaryString = "DeviceInfo(Brand=" + Build.BRAND + ", Model=" + Build.MODEL + ", SDK=" + Build.VERSION.SDK_INT + ", BuildFp=" + Build.FINGERPRINT + ')';
        var2_7 = new ConfigurationError[3];
        var2_7[0] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEngBuild, "ENG-BUILD", "Running on Eng Build", "Benchmark is running on device flashed with a '-eng' build. Eng builds\nof the platform drastically reduce performance to enable testing\nchanges quickly. For this reason they should not be used for\nbenchmarking. Use a '-user' or '-userdebug' system image.");
        var2_7[1] = ConfigurationErrorKt.conditionalError(DeviceInfo.isEmulator, "EMULATOR", "Running on Emulator", "Benchmark is running on an emulator, which is not representative of\nreal user devices. Use a physical device to benchmark. Emulator\nbenchmark improvements might not carry over to a real user's\nexperience (or even regress real device performance).");
        var2_7[2] = ConfigurationErrorKt.conditionalError(DeviceInfo.initialBatteryPercent < 25, "LOW-BATTERY", "Device has low battery (" + DeviceInfo.initialBatteryPercent + ')', StringsKt.trimIndent((String)("\n                    When battery is low, devices will often reduce performance (e.g. disabling big\n                    cores) to save remaining battery. This occurs even when they are plugged in.\n                    Wait for your battery to charge to at least 25%.\n                    Currently at " + DeviceInfo.initialBatteryPercent + "%.\n                ")));
        DeviceInfo.errors = CollectionsKt.listOfNotNull((Object[])var2_7);
        DeviceInfo.ART_MAINLINE_VERSIONS_AFFECTING_METHOD_TRACING = RangesKt.until((long)340000000L, (int)341513000);
        DeviceInfo.artMainlineVersion = Build.VERSION.SDK_INT >= 31 ? DeviceInfo.INSTANCE.queryArtMainlineVersion() : (Build.VERSION.SDK_INT == 30 ? 1L : -1L);
        var0_1 = Build.VERSION.SDK_INT;
        if (26 <= var0_1 ? var0_1 < 31 : false) ** GOTO lbl-1000
        var0_2 = DeviceInfo.ART_MAINLINE_VERSIONS_AFFECTING_METHOD_TRACING;
        var1_5 = var0_2.getFirst();
        var3_9 = var0_2.getLast();
        var5_12 = DeviceInfo.artMainlineVersion;
        v20 = var1_5 <= var5_12 ? var5_12 <= var3_9 : false;
        if (v20) lbl-1000:
        // 2 sources

        {
            v21 = true;
        } else {
            v21 = DeviceInfo.methodTracingAffectsMeasurements = false;
        }
        if (Build.VERSION.SDK_INT < 23) ** GOTO lbl-1000
        if (DeviceInfo.isRooted) lbl-1000:
        // 2 sources

        {
            v22 = true;
        } else {
            v22 = false;
        }
        DeviceInfo.supportsCpuEventCounters = v22;
    }
}

