/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Api29Kt;
import androidx.benchmark.Arguments;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.PackageInfo;
import androidx.benchmark.Profiler;
import androidx.benchmark.Shell;
import androidx.benchmark.StackSamplingSimpleperf;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0017\u0010\f\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0011\u0010\u000f\u001a\u00020\u0006*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/benchmark/Errors;", "", "()V", "MINIMUM_BATTERY_PERCENT", "", "PREFIX", "", "getPREFIX", "()Ljava/lang/String;", "UNSUPPRESSED_WARNING_MESSAGE", "throwIfError", "", "toDisplayString", "", "toDisplayString$benchmark_common_release", "trimMarginWrapNewlines", "trimMarginWrapNewlines$benchmark_common_release", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nErrors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Errors.kt\nandroidx/benchmark/Errors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n766#2:300\n857#2,2:301\n*S KotlinDebug\n*F\n+ 1 Errors.kt\nandroidx/benchmark/Errors\n*L\n255#1:300\n255#1:301,2\n*E\n"})
public final class Errors {
    @NotNull
    public static final Errors INSTANCE;
    @NotNull
    private static final String PREFIX;
    @Nullable
    private static final String UNSUPPRESSED_WARNING_MESSAGE;
    private static final int MINIMUM_BATTERY_PERCENT = 25;

    private Errors() {
    }

    @NotNull
    public final String trimMarginWrapNewlines$benchmark_common_release(@NotNull String $this$trimMarginWrapNewlines) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMarginWrapNewlines, (String)"<this>");
        return '\n' + StringsKt.trimMargin$default((String)$this$trimMarginWrapNewlines, null, (int)1, null) + " \n";
    }

    @NotNull
    public final String toDisplayString$benchmark_common_release(@NotNull Set<String> $this$toDisplayString) {
        Intrinsics.checkNotNullParameter($this$toDisplayString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)$this$toDisplayString)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String getPREFIX() {
        return PREFIX;
    }

    public final void throwIfError() {
        if (!Arguments.INSTANCE.getDryRunMode() && UNSUPPRESSED_WARNING_MESSAGE != null) {
            throw new AssertionError((Object)UNSUPPRESSED_WARNING_MESSAGE);
        }
        Arguments.INSTANCE.throwIfError();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$filterTo$iv$iv;
        int batteryPercent;
        int n;
        Bundle arguments;
        INSTANCE = new Errors();
        Context context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        ApplicationInfo appInfo = context.getApplicationInfo();
        String warningPrefix = "";
        String warningString = "";
        Profiler profiler = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        if (!(profiler != null ? profiler.getRequiresDebuggable() : false) && (appInfo.flags & 2) != 0) {
            warningPrefix = warningPrefix + "DEBUGGABLE_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Debuggable Benchmark\n                |    Benchmark is running with debuggable=true, which drastically reduces\n                |    runtime performance in order to support debugging features. Run\n                |    benchmarks with debuggable=false. Debuggable affects execution speed\n                |    in ways that mean benchmark improvements might not carry over to a\n                |    real user's experience (or even regress release performance).\n            ");
        }
        if (DeviceInfo.INSTANCE.isEmulator()) {
            warningPrefix = warningPrefix + "EMULATOR_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Emulator\n                |    Benchmark is running on an emulator, which is not representative of\n                |    real user devices. Use a physical device to benchmark. Emulator\n                |    benchmark improvements might not carry over to a real user's\n                |    experience (or even regress real device performance).\n            ");
        }
        String string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)":eng/", (boolean)false, (int)2, null)) {
            warningPrefix = warningPrefix + "ENG-BUILD_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Eng Build\n                |    Benchmark is running on device flashed with a '-eng' build. Eng builds\n                |    of the platform drastically reduce performance to enable testing\n                |    changes quickly. For this reason they should not be used for\n                |    benchmarking. Use a '-user' or '-userdebug' system image.\n            ");
        }
        if (Intrinsics.areEqual((Object)(arguments = InstrumentationRegistry.getArguments()).getString("coverage"), (Object)"true")) {
            warningPrefix = warningPrefix + "CODE-COVERAGE_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Code coverage enabled\n                |    Benchmark is running with code coverage enabled, which typically alters the dex\n                |    in a way that can affect performance. Ensure that code coverage is disabled by\n                |    setting testCoverageEnabled to false in the buildType your benchmarks run in.\n            ");
        }
        if (!DeviceInfo.INSTANCE.isEmulator() && DeviceInfo.INSTANCE.isRooted() && !CpuInfo.INSTANCE.getLocked()) {
            warningPrefix = warningPrefix + "UNLOCKED_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Unlocked CPU clocks\n                |    Benchmark appears to be running on a rooted device with unlocked CPU\n                |    clocks. Unlocked CPU clocks can lead to inconsistent results due to\n                |    dynamic frequency scaling, and thermal throttling. On a rooted device,\n                |    lock your device clocks to a stable frequency with `./gradlew lockClocks`\n            ");
        }
        if (!CpuInfo.INSTANCE.getLocked() && IsolationActivity.Companion.isSustainedPerformanceModeSupported$benchmark_common_release() && !IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release()) {
            warningPrefix = warningPrefix + "UNSUSTAINED-ACTIVITY-MISSING_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Cannot use SustainedPerformanceMode without IsolationActivity\n                |    Benchmark running on device that supports Window.setSustainedPerformanceMode,\n                |    but not launching IsolationActivity via the AndroidBenchmarkRunner. This\n                |    Activity is required to limit CPU clock max frequency, to prevent thermal\n                |    throttling. To fix this, add the following to your benchmark module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            ");
        } else if (IsolationActivity.Companion.getSingleton$benchmark_common_release().get() == null) {
            warningPrefix = warningPrefix + "ACTIVITY-MISSING_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Not using IsolationActivity via AndroidBenchmarkRunner\n                |    AndroidBenchmarkRunner should be used to isolate benchmarks from interference\n                |    from other visible apps. To fix this, add the following to your module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            ");
        }
        if (Intrinsics.areEqual((Object)Arguments.INSTANCE.getProfiler$benchmark_common_release(), (Object)StackSamplingSimpleperf.INSTANCE)) {
            if (Build.VERSION.SDK_INT < 28) {
                warningPrefix = warningPrefix + "SIMPLEPERF_";
                warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Cannot use Simpleperf on this device's API level (" + Build.VERSION.SDK_INT + ")\n                    |    Simpleperf prior to API 28 (P) requires AOT compilation, and isn't \n                    |    currently supported by the benchmark library.\n                ");
            } else if (Build.VERSION.SDK_INT == 28 && !DeviceInfo.INSTANCE.isRooted()) {
                warningPrefix = warningPrefix + "SIMPLEPERF_";
                warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Cannot use Simpleperf on this device's API level (" + Build.VERSION.SDK_INT + ")\n                    |    without root. Simpleperf on API 28 (P) can only be used on a rooted device,\n                    |    or when the APK is debuggable. Debuggable performance measurements should\n                    |    be avoided, due to measurement inaccuracy.\n                ");
            } else if (DeviceInfo.INSTANCE.getProfileableEnforced() && Build.VERSION.SDK_INT >= 29) {
                Intrinsics.checkNotNull((Object)context);
                if (!Api29Kt.isProfileableByShell(context)) {
                    warningPrefix = warningPrefix + "SIMPLEPERF_";
                    warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Apk must be profileable to use simpleperf.\n                    |    ensure you put <profileable android:shell=\"true\"/> within the\n                    |    <application ...> tag of your benchmark module\n                ");
                }
            }
        }
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, filter);
        if (intent != null) {
            Intent $this$_init__u24lambda_u240 = intent;
            boolean bl = false;
            int level = $this$_init__u24lambda_u240.getBooleanExtra("present", true) ? $this$_init__u24lambda_u240.getIntExtra("level", 100) : 100;
            int scale = $this$_init__u24lambda_u240.getIntExtra("scale", 100);
            n = level * 100 / scale;
        } else {
            n = batteryPercent = 100;
        }
        if (batteryPercent < 25) {
            warningPrefix = warningPrefix + "LOW-BATTERY_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Device has low battery (" + batteryPercent + "%)\n                |    When battery is low, devices will often reduce performance (e.g. disabling big\n                |    cores) to save remaining battery. This occurs even when they are plugged in.\n                |    Wait for your battery to charge to at least 25%.\n                |    Currently at " + batteryPercent + "%.\n            ");
        }
        String compilationMode2 = PackageInfo.INSTANCE.getCompilationMode();
        if (Arguments.INSTANCE.getRequireAot$benchmark_common_release() && !Intrinsics.areEqual((Object)compilationMode2, (Object)"speed")) {
            warningPrefix = warningPrefix + "NOT-AOT-COMPILED_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Benchmark running without full AOT compilation.\n                |    Benchmarks should be speed compiled to reduce noise. This is enabled by default\n                |    in the benchmark plugin. Observed compilation state = " + compilationMode2 + ".\n            ");
        }
        if (Arguments.INSTANCE.getRequireJitDisabledIfRooted$benchmark_common_release() && DeviceInfo.INSTANCE.isRooted() && !Intrinsics.areEqual((Object)Shell.INSTANCE.getprop("dalvik.vm.extra-opts"), (Object)"-Xusejit:false")) {
            warningPrefix = warningPrefix + "JIT-ENABLED_";
            warningString = warningString + INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Rooted device with JIT enabled.\n                |    Even in a speed-compiled, fully AOT'd benchmark, JIT can occur and reduce perf\n                |    consistency. Use the following script to disable JIT and restart the runtime:\n                |        ./benchmark/gradle-plugin/src/main/resources/scripts/disableJit.sh\n            ");
        }
        PREFIX = warningPrefix;
        if (((CharSequence)warningString).length() > 0) {
            InstrumentationResults.INSTANCE.scheduleIdeWarningOnNextReport(warningString);
        }
        char[] cArray = new char[]{'_'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)PREFIX, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            boolean bl3 = ((CharSequence)it).length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set warningSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set neverSuppressed = SetsKt.setOf((Object)"SIMPLEPERF");
        Set suppressedWarnings = SetsKt.minus(Arguments.INSTANCE.getSuppressedErrors(), (Iterable)neverSuppressed);
        Set unsuppressedWarningSet = SetsKt.minus((Set)warningSet, (Iterable)suppressedWarnings);
        UNSUPPRESSED_WARNING_MESSAGE = !((Collection)unsuppressedWarningSet).isEmpty() ? StringsKt.trimMargin$default((String)("\n                |ERRORS (not suppressed): " + INSTANCE.toDisplayString$benchmark_common_release(unsuppressedWarningSet) + "\n                |(Suppressed errors: " + INSTANCE.toDisplayString$benchmark_common_release(Arguments.INSTANCE.getSuppressedErrors()) + ")\n                |" + warningString + "\n                |While you can suppress these errors (turning them into warnings)\n                |PLEASE NOTE THAT EACH SUPPRESSED ERROR COMPROMISES ACCURACY\n                |\n                |// Sample suppression, in a benchmark module's build.gradle:\n                |android {\n                |    defaultConfig {\n                |        // Enable measuring on an emulator, or devices with low battery\n                |        testInstrumentationRunnerArguments[\"androidx.benchmark.suppressErrors\"] = \"EMULATOR,LOW-BATTERY\"\n                |    }\n                |}\n            "), null, (int)1, null) : null;
    }
}

