/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.CounterOutputStream;
import androidx.benchmark.RootState;
import androidx.benchmark.ShellFile;
import androidx.benchmark.ShellKt;
import androidx.benchmark.VirtualFile;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J'\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u001b0\u0014H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\r0\u0014H\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006!"}, d2={"Landroidx/benchmark/ShellFile;", "Landroidx/benchmark/VirtualFile;", "directory", "", "filename", "(Ljava/lang/String;Ljava/lang/String;)V", "absolutePath", "(Ljava/lang/String;)V", "getAbsolutePath", "()Ljava/lang/String;", "fileType", "getFileType", "checkErr", "", "errDescriptor", "Landroid/os/ParcelFileDescriptor;", "delete", "", "executeCommand", "block", "Lkotlin/Function1;", "exists", "mkdir", "size", "", "sync", "useInputStream", "T", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useOutputStream", "Ljava/io/OutputStream;", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFile.kt\nandroidx/benchmark/ShellFile\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,357:1\n27#2,6:358\n27#2,6:364\n27#2,6:370\n27#2,6:376\n*S KotlinDebug\n*F\n+ 1 VirtualFile.kt\nandroidx/benchmark/ShellFile\n*L\n212#1:358,6\n225#1:364,6\n234#1:370,6\n271#1:376,6\n*E\n"})
public final class ShellFile
extends VirtualFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String absolutePath;
    @NotNull
    private static final String TAG = "ShellFile";
    @NotNull
    private static final UiAutomation uiAutomation;
    @NotNull
    private static final Lazy<RootState> rootState$delegate;

    public ShellFile(@NotNull String absolutePath) {
        Intrinsics.checkNotNullParameter((Object)absolutePath, (String)"absolutePath");
        super(null);
        this.absolutePath = absolutePath;
    }

    @Override
    @NotNull
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    @NotNull
    public String getFileType() {
        return TAG;
    }

    public ShellFile(@NotNull String directory, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this((StringsKt.endsWith$default((String)directory, (String)"/", (boolean)false, (int)2, null) ? directory : directory + '/') + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T useInputStream(@NotNull Function1<? super InputStream, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.size();
        String cmd = ShellFile.Companion.getRootState().maybeRootify("cat " + this.getAbsolutePath());
        String label$iv = StringsKt.take((String)("ShellFile#useInputStream " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Object object2;
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor outDescriptor = ShellFile.uiAutomation.executeShellCommand(cmd);
            Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseInputStream(outDescriptor);
            Throwable throwable = null;
            try {
                object2 = block.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = object2;
        }
        finally {
            Trace.endSection();
        }
        Object value = object;
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(value=31)
    protected void useOutputStream(@NotNull Function1<? super OutputStream, Unit> block) {
        String label$iv;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String cmd = ShellFile.Companion.getRootState().maybeRootify("cp /dev/stdin " + this.getAbsolutePath());
        CounterOutputStream counterOs = null;
        if (Build.VERSION.SDK_INT >= 34) {
            label$iv = StringsKt.take((String)("ShellFile#useOutputStream " + cmd), (int)127);
            boolean $i$f$trace = false;
            try {
                Trace.beginSection((String)label$iv);
                boolean bl = false;
                ParcelFileDescriptor[] parcelFileDescriptorArray = ShellFile.uiAutomation.executeShellCommandRwe(cmd);
                Intrinsics.checkNotNull((Object)parcelFileDescriptorArray);
                ParcelFileDescriptor inDescriptor = parcelFileDescriptorArray[1];
                ParcelFileDescriptor errDescriptor = parcelFileDescriptorArray[2];
                Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseOutputStream(inDescriptor);
                Throwable throwable = null;
                try {
                    ParcelFileDescriptor.AutoCloseOutputStream it = (ParcelFileDescriptor.AutoCloseOutputStream)closeable;
                    boolean bl2 = false;
                    counterOs = new CounterOutputStream((OutputStream)it);
                    block.invoke((Object)counterOs);
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNull((Object)errDescriptor);
                this.checkErr(errDescriptor);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.endSection();
            }
        }
        label$iv = StringsKt.take((String)("ShellFile#useOutputStream " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ShellFile.uiAutomation.executeShellCommandRw(cmd);
            Intrinsics.checkNotNull((Object)parcelFileDescriptorArray);
            ParcelFileDescriptor inDescriptor = parcelFileDescriptorArray[1];
            Closeable closeable = (Closeable)new ParcelFileDescriptor.AutoCloseOutputStream(inDescriptor);
            Throwable throwable = null;
            try {
                ParcelFileDescriptor.AutoCloseOutputStream it = (ParcelFileDescriptor.AutoCloseOutputStream)closeable;
                boolean bl3 = false;
                counterOs = new CounterOutputStream((OutputStream)it);
                block.invoke((Object)counterOs);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Trace.endSection();
        }
        this.sync();
        long actualSize = this.size();
        long expectedSize = counterOs.getWrittenBytes();
        if (actualSize != expectedSize) {
            throw new IllegalStateException("Expected " + this.getAbsolutePath() + " size to be " + actualSize + " but was " + expectedSize);
        }
    }

    @Override
    public boolean delete() {
        String output2 = this.executeCommand((Function1<? super String, String>)((Function1)delete.output.1.INSTANCE));
        this.sync();
        if (StringsKt.isBlank((CharSequence)output2)) {
            return true;
        }
        Log.d((String)TAG, (String)("Error deleting `" + this.getAbsolutePath() + "`: " + output2));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String executeCommand(@NotNull Function1<? super String, String> block) {
        String string;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String cmd = ShellFile.Companion.getRootState().maybeRootify((String)block.invoke((Object)this.getAbsolutePath()));
        String label$iv = StringsKt.take((String)("ShellFile#executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor parcelFileDescriptor = ShellFile.uiAutomation.executeShellCommand(cmd);
            Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"executeShellCommand(...)");
            string = ShellKt.fullyReadInputStream(parcelFileDescriptor);
        }
        finally {
            Trace.endSection();
        }
        String output2 = string;
        return ((Object)StringsKt.trim((CharSequence)output2)).toString();
    }

    @Override
    public void mkdir() {
        this.executeCommand((Function1<? super String, String>)((Function1)mkdir.1.INSTANCE));
    }

    @Override
    public boolean exists() {
        return !((Collection)this.ls()).isEmpty();
    }

    private final void sync() {
        this.executeCommand((Function1<? super String, String>)((Function1)sync.1.INSTANCE));
    }

    private final long size() {
        long l;
        try {
            String[] stringArray = new String[]{" "};
            l = Long.parseLong((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.executeCommand((Function1<? super String, String>)((Function1)size.1.INSTANCE)), (String[])stringArray, (boolean)false, (int)0, (int)6, null)));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot check size of " + this.getAbsolutePath() + '.', e);
        }
        return l;
    }

    private final void checkErr(ParcelFileDescriptor errDescriptor) {
        InputStream inputStream = (InputStream)new ParcelFileDescriptor.AutoCloseInputStream(errDescriptor);
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        String err = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
        if (!StringsKt.isBlank((CharSequence)err)) {
            throw new IllegalStateException("Error writing in " + this.getAbsolutePath() + ": `" + err + '`');
        }
    }

    static {
        UiAutomation uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        Intrinsics.checkNotNullExpressionValue((Object)uiAutomation, (String)"getUiAutomation(...)");
        ShellFile.uiAutomation = uiAutomation;
        rootState$delegate = LazyKt.lazy((Function0)Companion.rootState.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/ShellFile$Companion;", "", "()V", "TAG", "", "rootState", "Landroidx/benchmark/RootState;", "getRootState", "()Landroidx/benchmark/RootState;", "rootState$delegate", "Lkotlin/Lazy;", "uiAutomation", "Landroid/app/UiAutomation;", "inTempDir", "Landroidx/benchmark/ShellFile;", "name", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        private final RootState getRootState() {
            Lazy lazy = rootState$delegate;
            return (RootState)lazy.getValue();
        }

        @NotNull
        public final ShellFile inTempDir(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ShellFile("/data/local/tmp/", name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

