/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.UiAutomation;
import android.os.Build;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.benchmark.ShellFile;
import androidx.benchmark.ShellKt;
import androidx.benchmark.ShellScript;
import androidx.benchmark.UserFile;
import androidx.benchmark.UserInfo;
import androidx.benchmark.VirtualFile;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.Trace;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0005\"\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/ShellImpl;", "", "()V", "isSessionRooted", "", "()Z", "setSessionRooted", "(Z)V", "isSuAvailable", "setSuAvailable", "uiAutomation", "Landroid/app/UiAutomation;", "kotlin.jvm.PlatformType", "createShellScript", "Landroidx/benchmark/ShellScript;", "script", "", "stdin", "executeCommandNonBlockingUnsafe", "Landroid/os/ParcelFileDescriptor;", "cmd", "executeCommandUnsafe", "benchmark-common_release"})
@SourceDebugExtension(value={"SMAP\nShell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellImpl\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,956:1\n27#2,6:957\n27#2,6:963\n27#2,3:969\n31#2,2:973\n1#3:972\n*S KotlinDebug\n*F\n+ 1 Shell.kt\nandroidx/benchmark/ShellImpl\n*L\n779#1:957,6\n784#1:963,6\n795#1:969,3\n795#1:973,2\n*E\n"})
final class ShellImpl {
    @NotNull
    public static final ShellImpl INSTANCE = new ShellImpl();
    private static final UiAutomation uiAutomation;
    private static boolean isSessionRooted;
    private static boolean isSuAvailable;

    private ShellImpl() {
    }

    public final boolean isSessionRooted() {
        return isSessionRooted;
    }

    public final void setSessionRooted(boolean bl) {
        isSessionRooted = bl;
    }

    public final boolean isSuAvailable() {
        return isSuAvailable;
    }

    public final void setSuAvailable(boolean bl) {
        isSuAvailable = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String executeCommandUnsafe(@NotNull String cmd) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            string = ShellKt.fullyReadInputStream(INSTANCE.executeCommandNonBlockingUnsafe(cmd));
        }
        finally {
            Trace.endSection();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ParcelFileDescriptor executeCommandNonBlockingUnsafe(@NotNull String cmd) {
        ParcelFileDescriptor parcelFileDescriptor;
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String label$iv = StringsKt.take((String)("executeCommandNonBlocking " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            ParcelFileDescriptor parcelFileDescriptor2 = ShellImpl.uiAutomation.executeShellCommand(!INSTANCE.isSessionRooted() && INSTANCE.isSuAvailable() ? "su root " + cmd : cmd);
            parcelFileDescriptor = parcelFileDescriptor2;
        }
        finally {
            Trace.endSection();
        }
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"trace(...)");
        return parcelFileDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ShellScript createShellScript(@NotNull String script, @Nullable String stdin) {
        ShellScript shellScript;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String label$iv = "createShellScript";
        boolean $i$f$trace = false;
        try {
            ShellScript shellScript2;
            Pair pair;
            VirtualFile virtualFile;
            VirtualFile virtualFile2;
            VirtualFile virtualFile3;
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            String scriptName = "temporaryScript_" + UInt.toString-impl((int)URandomKt.nextUInt((Random)((Random)Random.Default))) + ".sh";
            if (UserInfo.INSTANCE.isAdditionalUser()) {
                VirtualFile virtualFile4;
                virtualFile3 = ShellFile.Companion.inTempDir(scriptName);
                Object $this$createShellScript_u24lambda_u249_u24lambda_u243 = virtualFile3;
                boolean bl2 = false;
                ((VirtualFile)$this$createShellScript_u24lambda_u249_u24lambda_u243).writeText(script);
                VirtualFile virtualFile5 = virtualFile3;
                String string = stdin;
                if (string != null) {
                    void it;
                    $this$createShellScript_u24lambda_u249_u24lambda_u243 = string;
                    virtualFile2 = virtualFile5;
                    boolean bl3 = false;
                    VirtualFile $this$createShellScript_u24lambda_u249_u24lambda_u245_u24lambda_u244 = virtualFile = ShellFile.Companion.inTempDir(scriptName + "_stdin");
                    boolean bl4 = false;
                    $this$createShellScript_u24lambda_u249_u24lambda_u245_u24lambda_u244.writeText((String)it);
                    virtualFile4 = virtualFile;
                    virtualFile5 = virtualFile2;
                } else {
                    virtualFile4 = null;
                }
                VirtualFile virtualFile6 = virtualFile4;
                VirtualFile virtualFile7 = virtualFile5;
                pair = new Pair((Object)virtualFile7, virtualFile6);
            } else {
                VirtualFile virtualFile8;
                virtualFile3 = UserFile.Companion.inOutputsDir(scriptName);
                Object $this$createShellScript_u24lambda_u249_u24lambda_u246 = virtualFile3;
                boolean bl5 = false;
                ((VirtualFile)$this$createShellScript_u24lambda_u249_u24lambda_u246).writeText(script);
                VirtualFile virtualFile9 = virtualFile3;
                String string = stdin;
                if (string != null) {
                    void input;
                    $this$createShellScript_u24lambda_u249_u24lambda_u246 = string;
                    virtualFile2 = virtualFile9;
                    boolean bl6 = false;
                    VirtualFile $this$createShellScript_u24lambda_u249_u24lambda_u248_u24lambda_u247 = virtualFile = UserFile.Companion.inOutputsDir(scriptName + "_stdin");
                    boolean bl7 = false;
                    $this$createShellScript_u24lambda_u249_u24lambda_u248_u24lambda_u247.writeText((String)input);
                    virtualFile8 = virtualFile;
                    virtualFile9 = virtualFile2;
                } else {
                    virtualFile8 = null;
                }
                VirtualFile virtualFile10 = virtualFile8;
                VirtualFile virtualFile11 = virtualFile9;
                pair = new Pair((Object)virtualFile11, virtualFile10);
            }
            Pair pair2 = pair;
            VirtualFile scriptContentFile = (VirtualFile)pair2.component1();
            VirtualFile stdInFile = (VirtualFile)pair2.component2();
            String stderrPath = "/data/local/tmp/" + scriptName + "_stderr";
            try {
                shellScript2 = new ShellScript(stdInFile, scriptContentFile, stderrPath);
            }
            catch (Exception e) {
                throw new Exception("Can't create shell script", e);
            }
            shellScript = shellScript2;
        }
        finally {
            Trace.endSection();
        }
        return shellScript;
    }

    static {
        if (!(!Intrinsics.areEqual((Object)Looper.getMainLooper().getThread(), (Object)Thread.currentThread()))) {
            boolean bl = false;
            String string = "ShellImpl must not be initialized on the UI thread - UiAutomation must not be connected on the main thread!";
            throw new IllegalArgumentException(string.toString());
        }
        uiAutomation = InstrumentationRegistry.getInstrumentation().getUiAutomation();
        if (UserInfo.INSTANCE.getCurrentUserId() > 0) {
            int n = Build.VERSION.SDK_INT;
            boolean bl = 30 <= n ? n < 31 : false;
            if (bl) {
                throw new IllegalStateException("Benchmark and Baseline Profile generation are not currently supported on AAOS and multiuser environment when a secondary user is selected, on api 30");
            }
        }
        isSessionRooted = StringsKt.contains$default((CharSequence)INSTANCE.executeCommandUnsafe("id"), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
        isSuAvailable = StringsKt.contains$default((CharSequence)INSTANCE.createShellScript("su root id", null).start().getOutputAndClose().getStdout(), (CharSequence)"uid=0(root)", (boolean)false, (int)2, null);
    }
}

