/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RequiresApi;
import androidx.benchmark.Arguments;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.PropOverride;
import androidx.benchmark.Shell;
import androidx.benchmark.StackSamplingSimpleperf;
import androidx.benchmark.json.BenchmarkData;
import androidx.benchmark.perfetto.StackSamplingConfig;
import androidx.benchmark.simpleperf.ProfileSession;
import androidx.benchmark.simpleperf.RecordOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0010\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0017J\b\u0010\u0019\u001a\u00020\u0015H\u0017R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/StackSamplingSimpleperf;", "Landroidx/benchmark/Profiler;", "()V", "outputRelativePath", "", "requiresExtraRuntime", "", "getRequiresExtraRuntime", "()Z", "requiresLibraryOutputDir", "getRequiresLibraryOutputDir", "securityPerfHarden", "Landroidx/benchmark/PropOverride;", "session", "Landroidx/benchmark/simpleperf/ProfileSession;", "config", "Landroidx/benchmark/perfetto/StackSamplingConfig;", "packageNames", "", "config$benchmark_common_release", "convertBeforeSync", "", "start", "Landroidx/benchmark/Profiler$ResultFile;", "traceUniqueName", "stop", "benchmark-common_release"})
public final class StackSamplingSimpleperf
extends Profiler {
    @NotNull
    public static final StackSamplingSimpleperf INSTANCE = new StackSamplingSimpleperf();
    @RequiresApi(value=29)
    @Nullable
    private static ProfileSession session;
    @RequiresApi(value=29)
    @NotNull
    private static final PropOverride securityPerfHarden;
    @Nullable
    private static String outputRelativePath;
    private static final boolean requiresLibraryOutputDir;
    private static final boolean requiresExtraRuntime;

    private StackSamplingSimpleperf() {
        super(null);
    }

    @Override
    @RequiresApi(value=29)
    @NotNull
    public Profiler.ResultFile start(@NotNull String traceUniqueName) {
        Intrinsics.checkNotNullParameter((Object)traceUniqueName, (String)"traceUniqueName");
        ProfileSession profileSession = session;
        if (profileSession != null) {
            profileSession.stopRecording();
        }
        securityPerfHarden.forceValue();
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_event_max_sample_rate 10000", null, 2, null);
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_cpu_time_max_percent 25", null, 2, null);
        Shell.executeScriptSilent$default(Shell.INSTANCE, "setprop debug.perf_event_mlock_kb 32800", null, 2, null);
        outputRelativePath = Profiler.Companion.traceName(traceUniqueName, "stackSampling");
        Object object = new ProfileSession();
        ProfileSession it = object;
        boolean bl = false;
        Shell.executeScriptSilent$default(Shell.INSTANCE, it.findSimpleperf() + " api-prepare", null, 2, null);
        it.startRecording(new RecordOptions().setSampleFrequency(Arguments.INSTANCE.getProfilerSampleFrequency$benchmark_common_release()).recordDwarfCallGraph().setEvent("cpu-clock").traceOffCpu().setSampleCurrentThread().setOutputFilename("simpleperf.data"));
        session = object;
        object = Profiler.ResultFile.Companion;
        String string = outputRelativePath;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        BenchmarkData.TestResult.ProfilerOutput.Type type = BenchmarkData.TestResult.ProfilerOutput.Type.StackSamplingTrace;
        KFunction kFunction = (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((StackSamplingSimpleperf)this.receiver).convertBeforeSync();
            }
        };
        return ((Profiler.ResultFile.Companion)object).of("Stack Sampling Trace", type, string2, this, (Function0<Unit>)((Function0)kFunction));
    }

    @Override
    @RequiresApi(value=29)
    public void stop() {
        ProfileSession profileSession = session;
        Intrinsics.checkNotNull((Object)profileSession);
        profileSession.stopRecording();
        securityPerfHarden.resetIfOverridden();
    }

    @RequiresApi(value=29)
    public final void convertBeforeSync() {
        String string = outputRelativePath;
        Intrinsics.checkNotNull((Object)string);
        Outputs.writeFile$default(Outputs.INSTANCE, string, false, convertBeforeSync.1.INSTANCE, 2, null);
    }

    @Override
    @NotNull
    public StackSamplingConfig config$benchmark_common_release(@NotNull List<String> packageNames) {
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        return new StackSamplingConfig(packageNames, Arguments.INSTANCE.getProfilerSampleFrequency$benchmark_common_release(), Arguments.INSTANCE.getProfilerSampleDurationSeconds$benchmark_common_release());
    }

    @Override
    public boolean getRequiresLibraryOutputDir() {
        return requiresLibraryOutputDir;
    }

    @Override
    public boolean getRequiresExtraRuntime() {
        return requiresExtraRuntime;
    }

    public static final /* synthetic */ ProfileSession access$getSession$p() {
        return session;
    }

    public static final /* synthetic */ void access$setSession$p(ProfileSession profileSession) {
        session = profileSession;
    }

    static {
        securityPerfHarden = new PropOverride("security.perf_harden", "0");
        requiresExtraRuntime = true;
    }
}

