/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.VirtualFile;
import androidx.tracing.Trace;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J'\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00160\u0011H\u0014\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u00142\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00140\u0011H\u0014R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/UserFile;", "Landroidx/benchmark/VirtualFile;", "path", "", "(Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "fileType", "getFileType", "delete", "", "executeCommand", "block", "Lkotlin/Function1;", "exists", "mkdir", "", "useInputStream", "T", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useOutputStream", "Ljava/io/OutputStream;", "Companion", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFile.kt\nandroidx/benchmark/UserFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,357:1\n1#2:358\n27#3,6:359\n*S KotlinDebug\n*F\n+ 1 VirtualFile.kt\nandroidx/benchmark/UserFile\n*L\n167#1:359,6\n*E\n"})
public final class UserFile
extends VirtualFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;

    public UserFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(null);
        this.file = file;
    }

    public UserFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(new File(path));
    }

    @Override
    @NotNull
    public String getAbsolutePath() {
        String string = this.file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @Override
    @NotNull
    public String getFileType() {
        return "UserFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T useInputStream(@NotNull Function1<? super InputStream, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = new FileInputStream(this.file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            object = block.invoke((Object)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void useOutputStream(@NotNull Function1<? super OutputStream, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Closeable closeable = new FileOutputStream(this.file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            block.invoke((Object)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public boolean delete() {
        return FilesKt.deleteRecursively((File)this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected String executeCommand(@NotNull Function1<? super String, String> block) {
        String string;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String cmd = (String)block.invoke((Object)this.getAbsolutePath());
        String label$iv = StringsKt.take((String)("UserFile#executeCommand " + cmd), (int)127);
        boolean $i$f$trace = false;
        try {
            Trace.beginSection((String)label$iv);
            boolean bl = false;
            Closeable closeable = new DataInputStream(Runtime.getRuntime().exec(cmd).getInputStream());
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl2 = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        }
        finally {
            Trace.endSection();
        }
        return string;
    }

    @Override
    public void mkdir() {
        this.file.mkdirs();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/benchmark/UserFile$Companion;", "", "()V", "inOutputsDir", "Landroidx/benchmark/UserFile;", "name", "", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserFile inOutputsDir(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            File file = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), name);
            if (Outputs.INSTANCE.getForceFilesForShellAccessible()) {
                file.setReadable(true, false);
            }
            return new UserFile(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

