/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.json;

import android.os.Build;
import androidx.benchmark.Arguments;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.MemInfo;
import androidx.benchmark.MetricResult;
import androidx.benchmark.PackageInfo;
import androidx.benchmark.Profiler;
import androidx.benchmark.ResultWriter;
import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/json/BenchmarkData;", "", "context", "Landroidx/benchmark/json/BenchmarkData$Context;", "benchmarks", "", "Landroidx/benchmark/json/BenchmarkData$TestResult;", "(Landroidx/benchmark/json/BenchmarkData$Context;Ljava/util/List;)V", "getBenchmarks", "()Ljava/util/List;", "getContext", "()Landroidx/benchmark/json/BenchmarkData$Context;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Context", "TestResult", "benchmark-common_release"})
public final class BenchmarkData {
    @NotNull
    private final Context context;
    @NotNull
    private final List<TestResult> benchmarks;

    public BenchmarkData(@NotNull Context context, @NotNull List<TestResult> benchmarks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(benchmarks, (String)"benchmarks");
        this.context = context;
        this.benchmarks = benchmarks;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<TestResult> getBenchmarks() {
        return this.benchmarks;
    }

    @NotNull
    public final Context component1() {
        return this.context;
    }

    @NotNull
    public final List<TestResult> component2() {
        return this.benchmarks;
    }

    @NotNull
    public final BenchmarkData copy(@NotNull Context context, @NotNull List<TestResult> benchmarks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(benchmarks, (String)"benchmarks");
        return new BenchmarkData(context, benchmarks);
    }

    public static /* synthetic */ BenchmarkData copy$default(BenchmarkData benchmarkData, Context context, List list, int n, Object object) {
        if ((n & 1) != 0) {
            context = benchmarkData.context;
        }
        if ((n & 2) != 0) {
            list = benchmarkData.benchmarks;
        }
        return benchmarkData.copy(context, list);
    }

    @NotNull
    public String toString() {
        return "BenchmarkData(context=" + this.context + ", benchmarks=" + this.benchmarks + ')';
    }

    public int hashCode() {
        int result = this.context.hashCode();
        result = result * 31 + ((Object)this.benchmarks).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BenchmarkData)) {
            return false;
        }
        BenchmarkData benchmarkData = (BenchmarkData)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)benchmarkData.context)) {
            return false;
        }
        return Intrinsics.areEqual(this.benchmarks, benchmarkData.benchmarks);
    }

    @JsonClass(generateAdapter=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\"\b\u0087\b\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002Bc\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\u000fH\u00c6\u0003J\t\u0010-\u001a\u00020\u000fH\u00c6\u0003Jy\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012H\u00c6\u0001J\u0013\u0010/\u001a\u00020\b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0006H\u00d6\u0001J\t\u00102\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001d\u00a8\u00064"}, d2={"Landroidx/benchmark/json/BenchmarkData$Context;", "", "()V", "build", "Landroidx/benchmark/json/BenchmarkData$Context$Build;", "cpuCoreCount", "", "cpuLocked", "", "cpuMaxFreqHz", "", "memTotalBytes", "sustainedPerformanceModeEnabled", "artMainlineVersion", "osCodenameAbbreviated", "", "compilationMode", "payload", "", "(Landroidx/benchmark/json/BenchmarkData$Context$Build;IZJJZJLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getArtMainlineVersion", "()J", "getBuild", "()Landroidx/benchmark/json/BenchmarkData$Context$Build;", "getCompilationMode", "()Ljava/lang/String;", "getCpuCoreCount", "()I", "getCpuLocked", "()Z", "getCpuMaxFreqHz", "getMemTotalBytes", "getOsCodenameAbbreviated", "getPayload", "()Ljava/util/Map;", "getSustainedPerformanceModeEnabled", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Build", "benchmark-common_release"})
    public static final class Context {
        @NotNull
        private final Build build;
        private final int cpuCoreCount;
        private final boolean cpuLocked;
        private final long cpuMaxFreqHz;
        private final long memTotalBytes;
        private final boolean sustainedPerformanceModeEnabled;
        private final long artMainlineVersion;
        @NotNull
        private final String osCodenameAbbreviated;
        @NotNull
        private final String compilationMode;
        @NotNull
        private final Map<String, String> payload;

        public Context(@NotNull Build build, int cpuCoreCount, boolean cpuLocked, long cpuMaxFreqHz, long memTotalBytes, boolean sustainedPerformanceModeEnabled, long artMainlineVersion, @NotNull String osCodenameAbbreviated, @NotNull String compilationMode2, @NotNull Map<String, String> payload) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            Intrinsics.checkNotNullParameter((Object)osCodenameAbbreviated, (String)"osCodenameAbbreviated");
            Intrinsics.checkNotNullParameter((Object)compilationMode2, (String)"compilationMode");
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            this.build = build;
            this.cpuCoreCount = cpuCoreCount;
            this.cpuLocked = cpuLocked;
            this.cpuMaxFreqHz = cpuMaxFreqHz;
            this.memTotalBytes = memTotalBytes;
            this.sustainedPerformanceModeEnabled = sustainedPerformanceModeEnabled;
            this.artMainlineVersion = artMainlineVersion;
            this.osCodenameAbbreviated = osCodenameAbbreviated;
            this.compilationMode = compilationMode2;
            this.payload = payload;
        }

        public /* synthetic */ Context(Build build, int n, boolean bl, long l, long l2, boolean bl2, long l3, String string, String string2, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x200) != 0) {
                map = MapsKt.emptyMap();
            }
            this(build, n, bl, l, l2, bl2, l3, string, string2, map);
        }

        @NotNull
        public final Build getBuild() {
            return this.build;
        }

        public final int getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final boolean getCpuLocked() {
            return this.cpuLocked;
        }

        public final long getCpuMaxFreqHz() {
            return this.cpuMaxFreqHz;
        }

        public final long getMemTotalBytes() {
            return this.memTotalBytes;
        }

        public final boolean getSustainedPerformanceModeEnabled() {
            return this.sustainedPerformanceModeEnabled;
        }

        public final long getArtMainlineVersion() {
            return this.artMainlineVersion;
        }

        @NotNull
        public final String getOsCodenameAbbreviated() {
            return this.osCodenameAbbreviated;
        }

        @NotNull
        public final String getCompilationMode() {
            return this.compilationMode;
        }

        @NotNull
        public final Map<String, String> getPayload() {
            return this.payload;
        }

        public Context() {
            Build build = new Build();
            int n = CpuInfo.INSTANCE.getCoreDirs().size();
            boolean bl = CpuInfo.INSTANCE.getLocked();
            long l = CpuInfo.INSTANCE.getMaxFreqHz();
            long l2 = MemInfo.INSTANCE.getMemTotalBytes();
            boolean bl2 = IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release();
            long l3 = DeviceInfo.INSTANCE.getArtMainlineVersion();
            String string = !Intrinsics.areEqual((Object)Build.VERSION.CODENAME, (Object)"REL") ? Build.VERSION.CODENAME : android.os.Build.ID;
            Intrinsics.checkNotNull((Object)string);
            int n2 = 0;
            int n3 = 1;
            String string2 = string.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this(build, n, bl, l, l2, bl2, l3, string2, PackageInfo.INSTANCE.getCompilationMode(), Arguments.INSTANCE.getPayload());
        }

        @NotNull
        public final Build component1() {
            return this.build;
        }

        public final int component2() {
            return this.cpuCoreCount;
        }

        public final boolean component3() {
            return this.cpuLocked;
        }

        public final long component4() {
            return this.cpuMaxFreqHz;
        }

        public final long component5() {
            return this.memTotalBytes;
        }

        public final boolean component6() {
            return this.sustainedPerformanceModeEnabled;
        }

        public final long component7() {
            return this.artMainlineVersion;
        }

        @NotNull
        public final String component8() {
            return this.osCodenameAbbreviated;
        }

        @NotNull
        public final String component9() {
            return this.compilationMode;
        }

        @NotNull
        public final Map<String, String> component10() {
            return this.payload;
        }

        @NotNull
        public final Context copy(@NotNull Build build, int cpuCoreCount, boolean cpuLocked, long cpuMaxFreqHz, long memTotalBytes, boolean sustainedPerformanceModeEnabled, long artMainlineVersion, @NotNull String osCodenameAbbreviated, @NotNull String compilationMode2, @NotNull Map<String, String> payload) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            Intrinsics.checkNotNullParameter((Object)osCodenameAbbreviated, (String)"osCodenameAbbreviated");
            Intrinsics.checkNotNullParameter((Object)compilationMode2, (String)"compilationMode");
            Intrinsics.checkNotNullParameter(payload, (String)"payload");
            return new Context(build, cpuCoreCount, cpuLocked, cpuMaxFreqHz, memTotalBytes, sustainedPerformanceModeEnabled, artMainlineVersion, osCodenameAbbreviated, compilationMode2, payload);
        }

        public static /* synthetic */ Context copy$default(Context context, Build build, int n, boolean bl, long l, long l2, boolean bl2, long l3, String string, String string2, Map map, int n2, Object object) {
            if ((n2 & 1) != 0) {
                build = context.build;
            }
            if ((n2 & 2) != 0) {
                n = context.cpuCoreCount;
            }
            if ((n2 & 4) != 0) {
                bl = context.cpuLocked;
            }
            if ((n2 & 8) != 0) {
                l = context.cpuMaxFreqHz;
            }
            if ((n2 & 0x10) != 0) {
                l2 = context.memTotalBytes;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = context.sustainedPerformanceModeEnabled;
            }
            if ((n2 & 0x40) != 0) {
                l3 = context.artMainlineVersion;
            }
            if ((n2 & 0x80) != 0) {
                string = context.osCodenameAbbreviated;
            }
            if ((n2 & 0x100) != 0) {
                string2 = context.compilationMode;
            }
            if ((n2 & 0x200) != 0) {
                map = context.payload;
            }
            return context.copy(build, n, bl, l, l2, bl2, l3, string, string2, map);
        }

        @NotNull
        public String toString() {
            return "Context(build=" + this.build + ", cpuCoreCount=" + this.cpuCoreCount + ", cpuLocked=" + this.cpuLocked + ", cpuMaxFreqHz=" + this.cpuMaxFreqHz + ", memTotalBytes=" + this.memTotalBytes + ", sustainedPerformanceModeEnabled=" + this.sustainedPerformanceModeEnabled + ", artMainlineVersion=" + this.artMainlineVersion + ", osCodenameAbbreviated=" + this.osCodenameAbbreviated + ", compilationMode=" + this.compilationMode + ", payload=" + this.payload + ')';
        }

        public int hashCode() {
            int result = this.build.hashCode();
            result = result * 31 + Integer.hashCode(this.cpuCoreCount);
            result = result * 31 + Boolean.hashCode(this.cpuLocked);
            result = result * 31 + Long.hashCode(this.cpuMaxFreqHz);
            result = result * 31 + Long.hashCode(this.memTotalBytes);
            result = result * 31 + Boolean.hashCode(this.sustainedPerformanceModeEnabled);
            result = result * 31 + Long.hashCode(this.artMainlineVersion);
            result = result * 31 + this.osCodenameAbbreviated.hashCode();
            result = result * 31 + this.compilationMode.hashCode();
            result = result * 31 + ((Object)this.payload).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.build, (Object)context.build)) {
                return false;
            }
            if (this.cpuCoreCount != context.cpuCoreCount) {
                return false;
            }
            if (this.cpuLocked != context.cpuLocked) {
                return false;
            }
            if (this.cpuMaxFreqHz != context.cpuMaxFreqHz) {
                return false;
            }
            if (this.memTotalBytes != context.memTotalBytes) {
                return false;
            }
            if (this.sustainedPerformanceModeEnabled != context.sustainedPerformanceModeEnabled) {
                return false;
            }
            if (this.artMainlineVersion != context.artMainlineVersion) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.osCodenameAbbreviated, (Object)context.osCodenameAbbreviated)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.compilationMode, (Object)context.compilationMode)) {
                return false;
            }
            return Intrinsics.areEqual(this.payload, context.payload);
        }

        @JsonClass(generateAdapter=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JO\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Landroidx/benchmark/json/BenchmarkData$Context$Build;", "", "()V", "brand", "", "device", "fingerprint", "id", "model", "type", "version", "Landroidx/benchmark/json/BenchmarkData$Context$Build$Version;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroidx/benchmark/json/BenchmarkData$Context$Build$Version;)V", "getBrand", "()Ljava/lang/String;", "getDevice", "getFingerprint", "getId", "getModel", "getType", "getVersion", "()Landroidx/benchmark/json/BenchmarkData$Context$Build$Version;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Version", "benchmark-common_release"})
        public static final class Build {
            @NotNull
            private final String brand;
            @NotNull
            private final String device;
            @NotNull
            private final String fingerprint;
            @NotNull
            private final String id;
            @NotNull
            private final String model;
            @NotNull
            private final String type;
            @NotNull
            private final Version version;

            public Build(@NotNull String brand, @NotNull String device, @NotNull String fingerprint, @NotNull String id2, @NotNull String model, @NotNull String type, @NotNull Version version) {
                Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                this.brand = brand;
                this.device = device;
                this.fingerprint = fingerprint;
                this.id = id2;
                this.model = model;
                this.type = type;
                this.version = version;
            }

            @NotNull
            public final String getBrand() {
                return this.brand;
            }

            @NotNull
            public final String getDevice() {
                return this.device;
            }

            @NotNull
            public final String getFingerprint() {
                return this.fingerprint;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            @NotNull
            public final String getModel() {
                return this.model;
            }

            @NotNull
            public final String getType() {
                return this.type;
            }

            @NotNull
            public final Version getVersion() {
                return this.version;
            }

            public Build() {
                String string = android.os.Build.BRAND;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
                String string2 = android.os.Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
                String string3 = android.os.Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
                String string4 = android.os.Build.ID;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ID");
                String string5 = android.os.Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MODEL");
                String string6 = android.os.Build.TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"TYPE");
                String string7 = Build.VERSION.CODENAME;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"CODENAME");
                this(string, string2, string3, string4, string5, string6, new Version(string7, Build.VERSION.SDK_INT));
            }

            @NotNull
            public final String component1() {
                return this.brand;
            }

            @NotNull
            public final String component2() {
                return this.device;
            }

            @NotNull
            public final String component3() {
                return this.fingerprint;
            }

            @NotNull
            public final String component4() {
                return this.id;
            }

            @NotNull
            public final String component5() {
                return this.model;
            }

            @NotNull
            public final String component6() {
                return this.type;
            }

            @NotNull
            public final Version component7() {
                return this.version;
            }

            @NotNull
            public final Build copy(@NotNull String brand, @NotNull String device, @NotNull String fingerprint, @NotNull String id2, @NotNull String model, @NotNull String type, @NotNull Version version) {
                Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
                Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                return new Build(brand, device, fingerprint, id2, model, type, version);
            }

            public static /* synthetic */ Build copy$default(Build build, String string, String string2, String string3, String string4, String string5, String string6, Version version, int n, Object object) {
                if ((n & 1) != 0) {
                    string = build.brand;
                }
                if ((n & 2) != 0) {
                    string2 = build.device;
                }
                if ((n & 4) != 0) {
                    string3 = build.fingerprint;
                }
                if ((n & 8) != 0) {
                    string4 = build.id;
                }
                if ((n & 0x10) != 0) {
                    string5 = build.model;
                }
                if ((n & 0x20) != 0) {
                    string6 = build.type;
                }
                if ((n & 0x40) != 0) {
                    version = build.version;
                }
                return build.copy(string, string2, string3, string4, string5, string6, version);
            }

            @NotNull
            public String toString() {
                return "Build(brand=" + this.brand + ", device=" + this.device + ", fingerprint=" + this.fingerprint + ", id=" + this.id + ", model=" + this.model + ", type=" + this.type + ", version=" + this.version + ')';
            }

            public int hashCode() {
                int result = this.brand.hashCode();
                result = result * 31 + this.device.hashCode();
                result = result * 31 + this.fingerprint.hashCode();
                result = result * 31 + this.id.hashCode();
                result = result * 31 + this.model.hashCode();
                result = result * 31 + this.type.hashCode();
                result = result * 31 + this.version.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Build)) {
                    return false;
                }
                Build build = (Build)other;
                if (!Intrinsics.areEqual((Object)this.brand, (Object)build.brand)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.device, (Object)build.device)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.fingerprint, (Object)build.fingerprint)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.id, (Object)build.id)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.model, (Object)build.model)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.type, (Object)build.type)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.version, (Object)build.version);
            }

            @JsonClass(generateAdapter=true)
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/json/BenchmarkData$Context$Build$Version;", "", "codename", "", "sdk", "", "(Ljava/lang/String;I)V", "getCodename", "()Ljava/lang/String;", "getSdk", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "benchmark-common_release"})
            public static final class Version {
                @NotNull
                private final String codename;
                private final int sdk;

                public Version(@NotNull String codename, int sdk) {
                    Intrinsics.checkNotNullParameter((Object)codename, (String)"codename");
                    this.codename = codename;
                    this.sdk = sdk;
                }

                @NotNull
                public final String getCodename() {
                    return this.codename;
                }

                public final int getSdk() {
                    return this.sdk;
                }

                @NotNull
                public final String component1() {
                    return this.codename;
                }

                public final int component2() {
                    return this.sdk;
                }

                @NotNull
                public final Version copy(@NotNull String codename, int sdk) {
                    Intrinsics.checkNotNullParameter((Object)codename, (String)"codename");
                    return new Version(codename, sdk);
                }

                public static /* synthetic */ Version copy$default(Version version, String string, int n, int n2, Object object) {
                    if ((n2 & 1) != 0) {
                        string = version.codename;
                    }
                    if ((n2 & 2) != 0) {
                        n = version.sdk;
                    }
                    return version.copy(string, n);
                }

                @NotNull
                public String toString() {
                    return "Version(codename=" + this.codename + ", sdk=" + this.sdk + ')';
                }

                public int hashCode() {
                    int result = this.codename.hashCode();
                    result = result * 31 + Integer.hashCode(this.sdk);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Version)) {
                        return false;
                    }
                    Version version = (Version)other;
                    if (!Intrinsics.areEqual((Object)this.codename, (Object)version.codename)) {
                        return false;
                    }
                    return this.sdk == version.sdk;
                }
            }
        }
    }

    @JsonClass(generateAdapter=true)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\b\b\u0087\b\u0018\u00002\u00020\u0001:\u0004:;<=BU\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0012\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0016J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010*\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\bH\u00c6\u0003J\u0015\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u0015\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0012H\u00c6\u0003J\u0010\u00100\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\u0010\u00101\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010 J\u0010\u00102\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010$J\u00a4\u0001\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00122\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u00122\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u00122\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00108\u001a\u00020\u000bH\u00d6\u0001J\t\u00109\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0015\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b(\u0010 \u00a8\u0006>"}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult;", "", "name", "", "className", "totalRunTimeNs", "", "metrics", "", "Landroidx/benchmark/MetricResult;", "warmupIterations", "", "repeatIterations", "thermalThrottleSleepSeconds", "profilerOutputs", "Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput;", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/List;IIJLjava/util/List;)V", "params", "", "Landroidx/benchmark/json/BenchmarkData$TestResult$SingleMetricResult;", "sampledMetrics", "Landroidx/benchmark/json/BenchmarkData$TestResult$SampledMetricResult;", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;JLjava/util/Map;Ljava/util/Map;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/util/List;)V", "getClassName", "()Ljava/lang/String;", "getMetrics", "()Ljava/util/Map;", "getName", "getParams", "getProfilerOutputs", "()Ljava/util/List;", "getRepeatIterations", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSampledMetrics", "getThermalThrottleSleepSeconds", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getTotalRunTimeNs", "()J", "getWarmupIterations", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;JLjava/util/Map;Ljava/util/Map;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/util/List;)Landroidx/benchmark/json/BenchmarkData$TestResult;", "equals", "", "other", "hashCode", "toString", "MetricResult", "ProfilerOutput", "SampledMetricResult", "SingleMetricResult", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nBenchmarkData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BenchmarkData.kt\nandroidx/benchmark/json/BenchmarkData$TestResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1549#2:263\n1620#2,3:264\n766#2:267\n857#2,2:268\n1179#2,2:270\n1253#2,4:272\n766#2:276\n857#2,2:277\n1179#2,2:279\n1253#2,4:281\n*S KotlinDebug\n*F\n+ 1 BenchmarkData.kt\nandroidx/benchmark/json/BenchmarkData$TestResult\n*L\n145#1:263\n145#1:264,3\n169#1:267\n169#1:268,2\n172#1:270,2\n172#1:272,4\n175#1:276\n175#1:277,2\n178#1:279,2\n178#1:281,4\n*E\n"})
    public static final class TestResult {
        @NotNull
        private final String name;
        @NotNull
        private final Map<String, String> params;
        @NotNull
        private final String className;
        private final long totalRunTimeNs;
        @NotNull
        private final Map<String, SingleMetricResult> metrics;
        @NotNull
        private final Map<String, SampledMetricResult> sampledMetrics;
        @Nullable
        private final Integer warmupIterations;
        @Nullable
        private final Integer repeatIterations;
        @Nullable
        private final Long thermalThrottleSleepSeconds;
        @Nullable
        private final List<ProfilerOutput> profilerOutputs;

        /*
         * WARNING - void declaration
         */
        public TestResult(@NotNull String name, @NotNull Map<String, String> params, @NotNull String className, long totalRunTimeNs, @NotNull Map<String, SingleMetricResult> metrics, @NotNull Map<String, SampledMetricResult> sampledMetrics, @Nullable Integer warmupIterations, @Nullable Integer repeatIterations, @Nullable Long thermalThrottleSleepSeconds, @Nullable List<ProfilerOutput> profilerOutputs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            Intrinsics.checkNotNullParameter(sampledMetrics, (String)"sampledMetrics");
            this.name = name;
            this.params = params;
            this.className = className;
            this.totalRunTimeNs = totalRunTimeNs;
            this.metrics = metrics;
            this.sampledMetrics = sampledMetrics;
            this.warmupIterations = warmupIterations;
            this.repeatIterations = repeatIterations;
            this.thermalThrottleSleepSeconds = thermalThrottleSleepSeconds;
            this.profilerOutputs = profilerOutputs;
            List<ProfilerOutput> list = this.profilerOutputs;
            if (list != null) {
                void $this$mapTo$iv$iv;
                List<ProfilerOutput> profilerOutput = list;
                boolean bl = false;
                Iterable $this$map$iv = profilerOutput;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProfilerOutput profilerOutput2 = (ProfilerOutput)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getLabel());
                }
                List labels = (List)destination$iv$iv;
                if (!(CollectionsKt.toSet((Iterable)labels).size() == profilerOutput.size())) {
                    boolean bl3 = false;
                    String string = "Each profilerOutput must have a distinct label. Labels seen: " + CollectionsKt.joinToString$default((Iterable)labels, null, null, null, (int)0, null, null, (int)63, null);
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Map<String, String> getParams() {
            return this.params;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public final long getTotalRunTimeNs() {
            return this.totalRunTimeNs;
        }

        @NotNull
        public final Map<String, SingleMetricResult> getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final Map<String, SampledMetricResult> getSampledMetrics() {
            return this.sampledMetrics;
        }

        @Nullable
        public final Integer getWarmupIterations() {
            return this.warmupIterations;
        }

        @Nullable
        public final Integer getRepeatIterations() {
            return this.repeatIterations;
        }

        @Nullable
        public final Long getThermalThrottleSleepSeconds() {
            return this.thermalThrottleSleepSeconds;
        }

        @Nullable
        public final List<ProfilerOutput> getProfilerOutputs() {
            return this.profilerOutputs;
        }

        /*
         * WARNING - void declaration
         */
        public TestResult(@NotNull String name, @NotNull String className, long totalRunTimeNs, @NotNull List<androidx.benchmark.MetricResult> metrics, int warmupIterations, int repeatIterations, long thermalThrottleSleepSeconds, @Nullable List<ProfilerOutput> profilerOutputs) {
            void $this$filterTo$iv$iv;
            androidx.benchmark.MetricResult it;
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv;
            androidx.benchmark.MetricResult it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            Iterable iterable = metrics;
            long l = totalRunTimeNs;
            String string = className;
            Map<String, String> map = ResultWriter.INSTANCE.getParams(name);
            String string2 = name;
            TestResult testResult = this;
            boolean $i$f$filter = false;
            void var13_16 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (androidx.benchmark.MetricResult)element$iv$iv;
                boolean bl = false;
                if (!(it2.getIterationData() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map bl = destination$iv$iv2;
                it = (androidx.benchmark.MetricResult)element$iv$iv;
                boolean bl2 = false;
                it = TuplesKt.to((Object)it.getName(), (Object)new SingleMetricResult(it));
                bl.put(it.getFirst(), it.getSecond());
            }
            object = destination$iv$iv2;
            $this$associate$iv = metrics;
            $i$f$filter = false;
            Iterable capacity$iv22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (androidx.benchmark.MetricResult)element$iv$iv;
                boolean bl = false;
                if (!(it2.getIterationData() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object2 = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object2;
            $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                it = (androidx.benchmark.MetricResult)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)new SampledMetricResult(it));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            object2 = destination$iv$iv;
            testResult(string2, map, string, l, (Map<String, SingleMetricResult>)object, (Map<String, SampledMetricResult>)object2, warmupIterations, repeatIterations, thermalThrottleSleepSeconds, profilerOutputs);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.params;
        }

        @NotNull
        public final String component3() {
            return this.className;
        }

        public final long component4() {
            return this.totalRunTimeNs;
        }

        @NotNull
        public final Map<String, SingleMetricResult> component5() {
            return this.metrics;
        }

        @NotNull
        public final Map<String, SampledMetricResult> component6() {
            return this.sampledMetrics;
        }

        @Nullable
        public final Integer component7() {
            return this.warmupIterations;
        }

        @Nullable
        public final Integer component8() {
            return this.repeatIterations;
        }

        @Nullable
        public final Long component9() {
            return this.thermalThrottleSleepSeconds;
        }

        @Nullable
        public final List<ProfilerOutput> component10() {
            return this.profilerOutputs;
        }

        @NotNull
        public final TestResult copy(@NotNull String name, @NotNull Map<String, String> params, @NotNull String className, long totalRunTimeNs, @NotNull Map<String, SingleMetricResult> metrics, @NotNull Map<String, SampledMetricResult> sampledMetrics, @Nullable Integer warmupIterations, @Nullable Integer repeatIterations, @Nullable Long thermalThrottleSleepSeconds, @Nullable List<ProfilerOutput> profilerOutputs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            Intrinsics.checkNotNullParameter(sampledMetrics, (String)"sampledMetrics");
            return new TestResult(name, params, className, totalRunTimeNs, metrics, sampledMetrics, warmupIterations, repeatIterations, thermalThrottleSleepSeconds, profilerOutputs);
        }

        public static /* synthetic */ TestResult copy$default(TestResult testResult, String string, Map map, String string2, long l, Map map2, Map map3, Integer n, Integer n2, Long l2, List list, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = testResult.name;
            }
            if ((n3 & 2) != 0) {
                map = testResult.params;
            }
            if ((n3 & 4) != 0) {
                string2 = testResult.className;
            }
            if ((n3 & 8) != 0) {
                l = testResult.totalRunTimeNs;
            }
            if ((n3 & 0x10) != 0) {
                map2 = testResult.metrics;
            }
            if ((n3 & 0x20) != 0) {
                map3 = testResult.sampledMetrics;
            }
            if ((n3 & 0x40) != 0) {
                n = testResult.warmupIterations;
            }
            if ((n3 & 0x80) != 0) {
                n2 = testResult.repeatIterations;
            }
            if ((n3 & 0x100) != 0) {
                l2 = testResult.thermalThrottleSleepSeconds;
            }
            if ((n3 & 0x200) != 0) {
                list = testResult.profilerOutputs;
            }
            return testResult.copy(string, map, string2, l, map2, map3, n, n2, l2, list);
        }

        @NotNull
        public String toString() {
            return "TestResult(name=" + this.name + ", params=" + this.params + ", className=" + this.className + ", totalRunTimeNs=" + this.totalRunTimeNs + ", metrics=" + this.metrics + ", sampledMetrics=" + this.sampledMetrics + ", warmupIterations=" + this.warmupIterations + ", repeatIterations=" + this.repeatIterations + ", thermalThrottleSleepSeconds=" + this.thermalThrottleSleepSeconds + ", profilerOutputs=" + this.profilerOutputs + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.params).hashCode();
            result = result * 31 + this.className.hashCode();
            result = result * 31 + Long.hashCode(this.totalRunTimeNs);
            result = result * 31 + ((Object)this.metrics).hashCode();
            result = result * 31 + ((Object)this.sampledMetrics).hashCode();
            result = result * 31 + (this.warmupIterations == null ? 0 : ((Object)this.warmupIterations).hashCode());
            result = result * 31 + (this.repeatIterations == null ? 0 : ((Object)this.repeatIterations).hashCode());
            result = result * 31 + (this.thermalThrottleSleepSeconds == null ? 0 : ((Object)this.thermalThrottleSleepSeconds).hashCode());
            result = result * 31 + (this.profilerOutputs == null ? 0 : ((Object)this.profilerOutputs).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TestResult)) {
                return false;
            }
            TestResult testResult = (TestResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)testResult.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.params, testResult.params)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.className, (Object)testResult.className)) {
                return false;
            }
            if (this.totalRunTimeNs != testResult.totalRunTimeNs) {
                return false;
            }
            if (!Intrinsics.areEqual(this.metrics, testResult.metrics)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sampledMetrics, testResult.sampledMetrics)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.warmupIterations, (Object)testResult.warmupIterations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repeatIterations, (Object)testResult.repeatIterations)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.thermalThrottleSleepSeconds, (Object)testResult.thermalThrottleSleepSeconds)) {
                return false;
            }
            return Intrinsics.areEqual(this.profilerOutputs, testResult.profilerOutputs);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult$MetricResult;", "", "()V", "Landroidx/benchmark/json/BenchmarkData$TestResult$SampledMetricResult;", "Landroidx/benchmark/json/BenchmarkData$TestResult$SingleMetricResult;", "benchmark-common_release"})
        public static abstract class MetricResult {
            private MetricResult() {
            }

            public /* synthetic */ MetricResult(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @JsonClass(generateAdapter=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput;", "", "profilerResult", "Landroidx/benchmark/Profiler$ResultFile;", "(Landroidx/benchmark/Profiler$ResultFile;)V", "type", "Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "label", "", "filename", "(Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;Ljava/lang/String;Ljava/lang/String;)V", "getFilename", "()Ljava/lang/String;", "getLabel", "getType", "()Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Type", "benchmark-common_release"})
        public static final class ProfilerOutput {
            @NotNull
            private final Type type;
            @NotNull
            private final String label;
            @NotNull
            private final String filename;

            public ProfilerOutput(@NotNull Type type, @NotNull String label, @NotNull String filename) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                this.type = type;
                this.label = label;
                this.filename = filename;
            }

            @NotNull
            public final Type getType() {
                return this.type;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            @NotNull
            public final String getFilename() {
                return this.filename;
            }

            public ProfilerOutput(@NotNull Profiler.ResultFile profilerResult) {
                Intrinsics.checkNotNullParameter((Object)profilerResult, (String)"profilerResult");
                this(profilerResult.getType(), profilerResult.getLabel(), profilerResult.getOutputRelativePath());
            }

            @NotNull
            public final Type component1() {
                return this.type;
            }

            @NotNull
            public final String component2() {
                return this.label;
            }

            @NotNull
            public final String component3() {
                return this.filename;
            }

            @NotNull
            public final ProfilerOutput copy(@NotNull Type type, @NotNull String label, @NotNull String filename) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                return new ProfilerOutput(type, label, filename);
            }

            public static /* synthetic */ ProfilerOutput copy$default(ProfilerOutput profilerOutput, Type type, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    type = profilerOutput.type;
                }
                if ((n & 2) != 0) {
                    string = profilerOutput.label;
                }
                if ((n & 4) != 0) {
                    string2 = profilerOutput.filename;
                }
                return profilerOutput.copy(type, string, string2);
            }

            @NotNull
            public String toString() {
                return "ProfilerOutput(type=" + (Object)((Object)this.type) + ", label=" + this.label + ", filename=" + this.filename + ')';
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = result * 31 + this.label.hashCode();
                result = result * 31 + this.filename.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProfilerOutput)) {
                    return false;
                }
                ProfilerOutput profilerOutput = (ProfilerOutput)other;
                if (this.type != profilerOutput.type) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.label, (Object)profilerOutput.label)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.filename, (Object)profilerOutput.filename);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult$ProfilerOutput$Type;", "", "(Ljava/lang/String;I)V", "MethodTrace", "PerfettoTrace", "StackSamplingTrace", "benchmark-common_release"})
            public static final class Type
            extends Enum<Type> {
                public static final /* enum */ Type MethodTrace = new Type();
                public static final /* enum */ Type PerfettoTrace = new Type();
                public static final /* enum */ Type StackSamplingTrace = new Type();
                private static final /* synthetic */ Type[] $VALUES;
                private static final /* synthetic */ EnumEntries $ENTRIES;

                public static Type[] values() {
                    return (Type[])$VALUES.clone();
                }

                public static Type valueOf(String value) {
                    return Enum.valueOf(Type.class, value);
                }

                @NotNull
                public static EnumEntries<Type> getEntries() {
                    return $ENTRIES;
                }

                static {
                    $VALUES = typeArray = new Type[]{Type.MethodTrace, Type.PerfettoTrace, Type.StackSamplingTrace};
                    $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                }
            }
        }

        @JsonClass(generateAdapter=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u000bH\u00c6\u0003JG\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult$SampledMetricResult;", "Landroidx/benchmark/json/BenchmarkData$TestResult$MetricResult;", "metricResult", "Landroidx/benchmark/MetricResult;", "(Landroidx/benchmark/MetricResult;)V", "P50", "", "P90", "P95", "P99", "runs", "", "(DDDDLjava/util/List;)V", "getP50", "()D", "getP90", "getP95", "getP99", "getRuns", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "benchmark-common_release"})
        public static final class SampledMetricResult
        extends MetricResult {
            private final double P50;
            private final double P90;
            private final double P95;
            private final double P99;
            @NotNull
            private final List<List<Double>> runs;

            public SampledMetricResult(double P50, double P90, double P95, double P99, @NotNull List<? extends List<Double>> runs) {
                Intrinsics.checkNotNullParameter(runs, (String)"runs");
                super(null);
                this.P50 = P50;
                this.P90 = P90;
                this.P95 = P95;
                this.P99 = P99;
                this.runs = runs;
            }

            public final double getP50() {
                return this.P50;
            }

            public final double getP90() {
                return this.P90;
            }

            public final double getP95() {
                return this.P95;
            }

            public final double getP99() {
                return this.P99;
            }

            @NotNull
            public final List<List<Double>> getRuns() {
                return this.runs;
            }

            public SampledMetricResult(@NotNull androidx.benchmark.MetricResult metricResult) {
                Intrinsics.checkNotNullParameter((Object)metricResult, (String)"metricResult");
                double d = metricResult.getP50();
                double d2 = metricResult.getP90();
                double d3 = metricResult.getP95();
                double d4 = metricResult.getP99();
                List<List<Double>> list = metricResult.getIterationData();
                Intrinsics.checkNotNull(list);
                this(d, d2, d3, d4, list);
            }

            public final double component1() {
                return this.P50;
            }

            public final double component2() {
                return this.P90;
            }

            public final double component3() {
                return this.P95;
            }

            public final double component4() {
                return this.P99;
            }

            @NotNull
            public final List<List<Double>> component5() {
                return this.runs;
            }

            @NotNull
            public final SampledMetricResult copy(double P50, double P90, double P95, double P99, @NotNull List<? extends List<Double>> runs) {
                Intrinsics.checkNotNullParameter(runs, (String)"runs");
                return new SampledMetricResult(P50, P90, P95, P99, runs);
            }

            public static /* synthetic */ SampledMetricResult copy$default(SampledMetricResult sampledMetricResult, double d, double d2, double d3, double d4, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    d = sampledMetricResult.P50;
                }
                if ((n & 2) != 0) {
                    d2 = sampledMetricResult.P90;
                }
                if ((n & 4) != 0) {
                    d3 = sampledMetricResult.P95;
                }
                if ((n & 8) != 0) {
                    d4 = sampledMetricResult.P99;
                }
                if ((n & 0x10) != 0) {
                    list = sampledMetricResult.runs;
                }
                return sampledMetricResult.copy(d, d2, d3, d4, list);
            }

            @NotNull
            public String toString() {
                return "SampledMetricResult(P50=" + this.P50 + ", P90=" + this.P90 + ", P95=" + this.P95 + ", P99=" + this.P99 + ", runs=" + this.runs + ')';
            }

            public int hashCode() {
                int result = Double.hashCode(this.P50);
                result = result * 31 + Double.hashCode(this.P90);
                result = result * 31 + Double.hashCode(this.P95);
                result = result * 31 + Double.hashCode(this.P99);
                result = result * 31 + ((Object)this.runs).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SampledMetricResult)) {
                    return false;
                }
                SampledMetricResult sampledMetricResult = (SampledMetricResult)other;
                if (Double.compare(this.P50, sampledMetricResult.P50) != 0) {
                    return false;
                }
                if (Double.compare(this.P90, sampledMetricResult.P90) != 0) {
                    return false;
                }
                if (Double.compare(this.P95, sampledMetricResult.P95) != 0) {
                    return false;
                }
                if (Double.compare(this.P99, sampledMetricResult.P99) != 0) {
                    return false;
                }
                return Intrinsics.areEqual(this.runs, sampledMetricResult.runs);
            }
        }

        @JsonClass(generateAdapter=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/benchmark/json/BenchmarkData$TestResult$SingleMetricResult;", "Landroidx/benchmark/json/BenchmarkData$TestResult$MetricResult;", "metricResult", "Landroidx/benchmark/MetricResult;", "(Landroidx/benchmark/MetricResult;)V", "minimum", "", "maximum", "median", "coefficientOfVariation", "runs", "", "(DDDDLjava/util/List;)V", "getCoefficientOfVariation", "()D", "getMaximum", "getMedian", "getMinimum", "getRuns", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "benchmark-common_release"})
        public static final class SingleMetricResult
        extends MetricResult {
            private final double minimum;
            private final double maximum;
            private final double median;
            private final double coefficientOfVariation;
            @NotNull
            private final List<Double> runs;

            public SingleMetricResult(double minimum, double maximum, double median, double coefficientOfVariation, @NotNull List<Double> runs) {
                Intrinsics.checkNotNullParameter(runs, (String)"runs");
                super(null);
                this.minimum = minimum;
                this.maximum = maximum;
                this.median = median;
                this.coefficientOfVariation = coefficientOfVariation;
                this.runs = runs;
            }

            public final double getMinimum() {
                return this.minimum;
            }

            public final double getMaximum() {
                return this.maximum;
            }

            public final double getMedian() {
                return this.median;
            }

            public final double getCoefficientOfVariation() {
                return this.coefficientOfVariation;
            }

            @NotNull
            public final List<Double> getRuns() {
                return this.runs;
            }

            public SingleMetricResult(@NotNull androidx.benchmark.MetricResult metricResult) {
                Intrinsics.checkNotNullParameter((Object)metricResult, (String)"metricResult");
                this(metricResult.getMin(), metricResult.getMax(), metricResult.getMedian(), metricResult.getCoefficientOfVariation(), metricResult.getData());
            }

            public final double component1() {
                return this.minimum;
            }

            public final double component2() {
                return this.maximum;
            }

            public final double component3() {
                return this.median;
            }

            public final double component4() {
                return this.coefficientOfVariation;
            }

            @NotNull
            public final List<Double> component5() {
                return this.runs;
            }

            @NotNull
            public final SingleMetricResult copy(double minimum, double maximum, double median, double coefficientOfVariation, @NotNull List<Double> runs) {
                Intrinsics.checkNotNullParameter(runs, (String)"runs");
                return new SingleMetricResult(minimum, maximum, median, coefficientOfVariation, runs);
            }

            public static /* synthetic */ SingleMetricResult copy$default(SingleMetricResult singleMetricResult, double d, double d2, double d3, double d4, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    d = singleMetricResult.minimum;
                }
                if ((n & 2) != 0) {
                    d2 = singleMetricResult.maximum;
                }
                if ((n & 4) != 0) {
                    d3 = singleMetricResult.median;
                }
                if ((n & 8) != 0) {
                    d4 = singleMetricResult.coefficientOfVariation;
                }
                if ((n & 0x10) != 0) {
                    list = singleMetricResult.runs;
                }
                return singleMetricResult.copy(d, d2, d3, d4, list);
            }

            @NotNull
            public String toString() {
                return "SingleMetricResult(minimum=" + this.minimum + ", maximum=" + this.maximum + ", median=" + this.median + ", coefficientOfVariation=" + this.coefficientOfVariation + ", runs=" + this.runs + ')';
            }

            public int hashCode() {
                int result = Double.hashCode(this.minimum);
                result = result * 31 + Double.hashCode(this.maximum);
                result = result * 31 + Double.hashCode(this.median);
                result = result * 31 + Double.hashCode(this.coefficientOfVariation);
                result = result * 31 + ((Object)this.runs).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SingleMetricResult)) {
                    return false;
                }
                SingleMetricResult singleMetricResult = (SingleMetricResult)other;
                if (Double.compare(this.minimum, singleMetricResult.minimum) != 0) {
                    return false;
                }
                if (Double.compare(this.maximum, singleMetricResult.maximum) != 0) {
                    return false;
                }
                if (Double.compare(this.median, singleMetricResult.median) != 0) {
                    return false;
                }
                if (Double.compare(this.coefficientOfVariation, singleMetricResult.coefficientOfVariation) != 0) {
                    return false;
                }
                return Intrinsics.areEqual(this.runs, singleMetricResult.runs);
            }
        }
    }
}

