/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import android.os.Build;
import androidx.annotation.CheckResult;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellFile;
import androidx.benchmark.UserFile;
import androidx.benchmark.UserInfo;
import androidx.benchmark.VirtualFile;
import androidx.benchmark.perfetto.PerfettoCapture;
import androidx.benchmark.perfetto.PerfettoConfig;
import androidx.benchmark.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.tracing.perfetto.handshake.PerfettoSdkHandshake;
import androidx.tracing.perfetto.handshake.protocol.Response;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J,\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture;", "", "unbundled", "", "(Z)V", "helper", "Landroidx/benchmark/perfetto/PerfettoHelper;", "binaryMissingResponseString", "", "requiredVersion", "message", "constructLibrarySource", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "enableAndroidxTracingPerfetto", "Lkotlin/Pair;", "", "config", "Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig;", "targetPackage", "provideBinariesIfMissing", "isColdStartupTracing", "isRunning", "start", "", "Landroidx/benchmark/perfetto/PerfettoConfig;", "stop", "destinationPath", "PerfettoSdkConfig", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=23)
@SourceDebugExtension(value={"SMAP\nPerfettoCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoCapture.kt\nandroidx/benchmark/perfetto/PerfettoCapture\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,260:1\n186#2,3:261\n186#2,6:264\n186#2,6:270\n190#2,2:276\n186#2,6:278\n*S KotlinDebug\n*F\n+ 1 PerfettoCapture.kt\nandroidx/benchmark/perfetto/PerfettoCapture\n*L\n60#1:261,3\n71#1:264,6\n72#1:270,6\n60#1:276,2\n87#1:278,6\n*E\n"})
public final class PerfettoCapture {
    @NotNull
    private final PerfettoHelper helper;

    public PerfettoCapture(boolean unbundled) {
        this.helper = new PerfettoHelper(unbundled);
    }

    public /* synthetic */ PerfettoCapture(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = Build.VERSION.SDK_INT <= 29;
        }
        this(bl);
    }

    public final boolean isRunning() {
        return this.helper.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull PerfettoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String label$iv = "start perfetto";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, null, null, 14, null);
        try {
            boolean bl = false;
            VirtualFile configProtoFile = UserInfo.INSTANCE.getCurrentUserId() > 0 && Build.VERSION.SDK_INT >= 31 ? (VirtualFile)ShellFile.Companion.inTempDir("trace_config.pb") : (VirtualFile)UserFile.Companion.inOutputsDir("trace_config.pb");
            try {
                Unit unit;
                String label$iv2 = "write config";
                boolean $i$f$inMemoryTrace2 = false;
                InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv2, 0L, null, null, 14, null);
                try {
                    boolean bl2 = false;
                    config.writeTo$benchmark_common_release(configProtoFile);
                    unit = Unit.INSTANCE;
                }
                finally {
                    InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
                }
                label$iv2 = "start perfetto process";
                $i$f$inMemoryTrace2 = false;
                InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv2, 0L, null, null, 14, null);
                try {
                    boolean bl3 = false;
                    this.helper.startCollecting(configProtoFile.getAbsolutePath(), config.isTextProto$benchmark_common_release());
                    unit = Unit.INSTANCE;
                }
                finally {
                    InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
                }
            }
            finally {
                configProtoFile.delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull String destinationPath) {
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        String label$iv = "stop perfetto";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default(InMemoryTracing.INSTANCE, label$iv, 0L, null, null, 14, null);
        try {
            boolean bl = false;
            this.helper.stopCollecting(destinationPath);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default(InMemoryTracing.INSTANCE, 0L, 1, null);
        }
    }

    @RequiresApi(value=30)
    @CheckResult
    @NotNull
    public final Pair<Integer, String> enableAndroidxTracingPerfetto(@NotNull PerfettoSdkConfig config) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getTargetPackage();
        boolean bl2 = config.getProvideBinariesIfMissing();
        switch (WhenMappings.$EnumSwitchMapping$0[config.getProcessState().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = Shell.INSTANCE.isPackageAlive(config.getTargetPackage());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.enableAndroidxTracingPerfetto(string, bl2, bl);
    }

    @RequiresApi(value=30)
    @CheckResult
    private final Pair<Integer, String> enableAndroidxTracingPerfetto(String targetPackage, boolean provideBinariesIfMissing, boolean isColdStartupTracing) {
        String string;
        Response response;
        Response responseNoSideloading;
        if (!PerfettoHelper.Companion.isAbiSupported()) {
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
            throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])Build.SUPPORTED_ABIS, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
        }
        PerfettoSdkHandshake handshake2 = new PerfettoSdkHandshake(targetPackage, (Function1)enableAndroidxTracingPerfetto.handshake.1.INSTANCE, (Function1)enableAndroidxTracingPerfetto.handshake.2.INSTANCE);
        Response response2 = responseNoSideloading = isColdStartupTracing ? PerfettoSdkHandshake.enableTracingColdStart$default((PerfettoSdkHandshake)handshake2, (boolean)false, null, (int)3, null) : PerfettoSdkHandshake.enableTracingImmediate$default((PerfettoSdkHandshake)handshake2, null, (int)1, null);
        if (responseNoSideloading.getResultCode() == 11 && provideBinariesIfMissing) {
            PerfettoSdkHandshake.LibrarySource librarySource = this.constructLibrarySource();
            response = isColdStartupTracing ? handshake2.enableTracingColdStart(false, librarySource) : handshake2.enableTracingImmediate(librarySource);
        } else {
            response = responseNoSideloading;
        }
        Response response3 = response;
        switch (response3.getResultCode()) {
            case 0: {
                string = "The broadcast to enable tracing was not received. This most likely means that the app does not contain the `androidx.tracing.tracing-perfetto` library as its dependency.";
                break;
            }
            case 1: {
                string = "Success";
                break;
            }
            case 2: {
                string = "Perfetto SDK already enabled.";
                break;
            }
            case 11: {
                string = this.binaryMissingResponseString(response3.getRequiredVersion(), response3.getMessage());
                break;
            }
            case 12: {
                string = "Perfetto SDK binary mismatch. Required version: " + response3.getRequiredVersion() + ". Error: " + response3.getMessage() + '.';
                break;
            }
            case 13: {
                string = "Perfetto SDK binary verification failed. Required version: " + response3.getRequiredVersion() + ". Error: " + response3.getMessage() + ". If working with an unreleased snapshot, ensure all modules are built against the same snapshot (e.g. clear caches and rebuild).";
                break;
            }
            case 99: {
                if (responseNoSideloading.getResultCode() == 11) {
                    string = this.binaryMissingResponseString(responseNoSideloading.getRequiredVersion(), response3.getMessage());
                    break;
                }
                string = "Error: " + response3.getMessage() + '.';
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized result code: " + response3.getResultCode() + '.');
            }
        }
        String message = string;
        return TuplesKt.to((Object)response3.getResultCode(), (Object)message);
    }

    private final String binaryMissingResponseString(String requiredVersion, String message) {
        return "Perfetto SDK binary dependencies missing. Required version: " + requiredVersion + ". Error: " + message + ".\nTo fix, declare the following dependency in your *benchmark* project (i.e. not the app under benchmark): \nandroidTestImplementation(\"androidx.tracing:tracing-perfetto-binary:" + requiredVersion + "\")";
    }

    private final PerfettoSdkHandshake.LibrarySource constructLibrarySource() {
        String string = InstrumentationRegistry.getInstrumentation().getContext().getApplicationInfo().publicSourceDir;
        Intrinsics.checkNotNull((Object)string);
        File baseApk = new File(string);
        Function2 mvTmpFileDstFile2 = constructLibrarySource.mvTmpFileDstFile.1.INSTANCE;
        return PerfettoSdkHandshake.LibrarySource.Companion.apkLibrarySource(baseApk, Outputs.INSTANCE.getDirUsableByAppAndShell(), mvTmpFileDstFile2);
    }

    public PerfettoCapture() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig;", "", "targetPackage", "", "processState", "Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig$InitialProcessState;", "provideBinariesIfMissing", "", "(Ljava/lang/String;Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig$InitialProcessState;Z)V", "getProcessState", "()Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig$InitialProcessState;", "getProvideBinariesIfMissing", "()Z", "getTargetPackage", "()Ljava/lang/String;", "InitialProcessState", "benchmark-common_release"})
    public static final class PerfettoSdkConfig {
        @NotNull
        private final String targetPackage;
        @NotNull
        private final InitialProcessState processState;
        private final boolean provideBinariesIfMissing;

        public PerfettoSdkConfig(@NotNull String targetPackage, @NotNull InitialProcessState processState, boolean provideBinariesIfMissing) {
            Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
            Intrinsics.checkNotNullParameter((Object)((Object)processState), (String)"processState");
            this.targetPackage = targetPackage;
            this.processState = processState;
            this.provideBinariesIfMissing = provideBinariesIfMissing;
        }

        public /* synthetic */ PerfettoSdkConfig(String string, InitialProcessState initialProcessState, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(string, initialProcessState, bl);
        }

        @NotNull
        public final String getTargetPackage() {
            return this.targetPackage;
        }

        @NotNull
        public final InitialProcessState getProcessState() {
            return this.processState;
        }

        public final boolean getProvideBinariesIfMissing() {
            return this.provideBinariesIfMissing;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/benchmark/perfetto/PerfettoCapture$PerfettoSdkConfig$InitialProcessState;", "", "(Ljava/lang/String;I)V", "NotAlive", "Alive", "Unknown", "benchmark-common_release"})
        public static final class InitialProcessState
        extends Enum<InitialProcessState> {
            public static final /* enum */ InitialProcessState NotAlive = new InitialProcessState();
            public static final /* enum */ InitialProcessState Alive = new InitialProcessState();
            public static final /* enum */ InitialProcessState Unknown = new InitialProcessState();
            private static final /* synthetic */ InitialProcessState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static InitialProcessState[] values() {
                return (InitialProcessState[])$VALUES.clone();
            }

            public static InitialProcessState valueOf(String value) {
                return Enum.valueOf(InitialProcessState.class, value);
            }

            @NotNull
            public static EnumEntries<InitialProcessState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = initialProcessStateArray = new InitialProcessState[]{InitialProcessState.NotAlive, InitialProcessState.Alive, InitialProcessState.Unknown};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PerfettoSdkConfig.InitialProcessState.values().length];
            try {
                nArray[PerfettoSdkConfig.InitialProcessState.Alive.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PerfettoSdkConfig.InitialProcessState.NotAlive.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PerfettoSdkConfig.InitialProcessState.Unknown.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

