/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.vmtrace;

import android.os.Process;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.vmtrace.MethodInfo;
import androidx.benchmark.vmtrace.TraceAction;
import androidx.benchmark.vmtrace.VmTraceHandler;
import androidx.benchmark.vmtrace.VmTraceParser;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.EventName;
import perfetto.protos.InternedData;
import perfetto.protos.ThreadDescriptor;
import perfetto.protos.Trace;
import perfetto.protos.TracePacket;
import perfetto.protos.TracePacketDefaults;
import perfetto.protos.TrackDescriptor;
import perfetto.protos.TrackEvent;
import perfetto.protos.TrackEventDefaults;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/vmtrace/ArtTrace;", "", "artTrace", "Ljava/io/File;", "uuidProvider", "Lkotlin/Function0;", "", "Landroidx/benchmark/vmtrace/UuidProvider;", "pid", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;I)V", "convertToPerfetto", "", "flushEvents", "Lkotlin/Function1;", "", "Lperfetto/protos/TracePacket;", "toPerfettoTrace", "Lperfetto/protos/Trace;", "writeAsPerfettoTrace", "output", "Ljava/io/OutputStream;", "Companion", "PerfettoVmTraceParser", "benchmark-common_release"})
public final class ArtTrace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File artTrace;
    @NotNull
    private final Function0<Long> uuidProvider;
    private final int pid;
    private static final int clockId = 3;
    private static final int trustedPacketSequenceId = 1234565432;
    private static final int eventsBetweenFlush = 10000;
    private static final int SequenceDataInitial = TracePacket.SequenceFlags.SEQ_INCREMENTAL_STATE_CLEARED.getValue() | TracePacket.SequenceFlags.SEQ_NEEDS_INCREMENTAL_STATE.getValue();
    private static final int SequenceDataSubsequent = TracePacket.SequenceFlags.SEQ_NEEDS_INCREMENTAL_STATE.getValue();

    public ArtTrace(@NotNull File artTrace, @NotNull Function0<Long> uuidProvider, int pid) {
        Intrinsics.checkNotNullParameter((Object)artTrace, (String)"artTrace");
        Intrinsics.checkNotNullParameter(uuidProvider, (String)"uuidProvider");
        this.artTrace = artTrace;
        this.uuidProvider = uuidProvider;
        this.pid = pid;
    }

    public /* synthetic */ ArtTrace(File file, Function0 function0, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            n = Process.myPid();
        }
        this(file, (Function0<Long>)function0, n);
    }

    private final void convertToPerfetto(Function1<? super List<TracePacket>, Unit> flushEvents) {
        PerfettoVmTraceParser parser = new PerfettoVmTraceParser(3, this.uuidProvider, this.pid, flushEvents);
        new VmTraceParser(this.artTrace, parser).parse();
        parser.flushEndEvents();
    }

    public final void writeAsPerfettoTrace(@NotNull OutputStream output2) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        this.convertToPerfetto((Function1<? super List<TracePacket>, Unit>)((Function1)new Function1<List<? extends TracePacket>, Unit>(output2){
            final /* synthetic */ OutputStream $output;
            {
                this.$output = $output;
                super(1);
            }

            public final void invoke(List<TracePacket> eventsToFlush) {
                Intrinsics.checkNotNullParameter(eventsToFlush, (String)"eventsToFlush");
                new Trace(eventsToFlush, null, 2, null).encode(this.$output);
            }
        }));
    }

    @VisibleForTesting
    @NotNull
    public final Trace toPerfettoTrace() {
        List events = new ArrayList();
        this.convertToPerfetto((Function1<? super List<TracePacket>, Unit>)((Function1)new Function1<List<? extends TracePacket>, Unit>((List<TracePacket>)events){
            final /* synthetic */ List<TracePacket> $events;
            {
                this.$events = $events;
                super(1);
            }

            public final void invoke(List<TracePacket> eventsToFlush) {
                Intrinsics.checkNotNullParameter(eventsToFlush, (String)"eventsToFlush");
                this.$events.addAll((Collection<TracePacket>)eventsToFlush);
            }
        }));
        return new Trace(events, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/benchmark/vmtrace/ArtTrace$Companion;", "", "()V", "SequenceDataInitial", "", "SequenceDataSubsequent", "clockId", "eventsBetweenFlush", "trustedPacketSequenceId", "benchmark-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001:\u00019BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J0\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020\rJ\b\u00101\u001a\u00020\rH\u0002J\b\u00102\u001a\u0004\u0018\u000103J\u0018\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020/H\u0016J\u0010\u00107\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0010\u00108\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/benchmark/vmtrace/ArtTrace$PerfettoVmTraceParser;", "Landroidx/benchmark/vmtrace/VmTraceHandler;", "clockId", "", "uuidProvider", "Lkotlin/Function0;", "", "Landroidx/benchmark/vmtrace/UuidProvider;", "pid", "flushEvents", "Lkotlin/Function1;", "", "Lperfetto/protos/TracePacket;", "", "(ILkotlin/jvm/functions/Function0;ILkotlin/jvm/functions/Function1;)V", "eventNames", "", "Lperfetto/protos/EventName;", "events", "hasEmittedInternedData", "", "getHasEmittedInternedData", "()Z", "setHasEmittedInternedData", "(Z)V", "internOffset", "getInternOffset", "()I", "maxTimeNs", "startTimeUs", "threads", "", "Landroidx/benchmark/vmtrace/ArtTrace$PerfettoVmTraceParser$ThreadTrack;", "version", "addMethod", "id", "info", "Landroidx/benchmark/vmtrace/MethodInfo;", "addMethodAction", "threadId", "methodId", "methodAction", "Landroidx/benchmark/vmtrace/TraceAction;", "threadTime", "globalTime", "addThread", "name", "", "flushEndEvents", "flushEventsInternal", "getInternedData", "Lperfetto/protos/InternedData;", "setProperty", "key", "value", "setStartTimeUs", "setVersion", "ThreadTrack", "benchmark-common_release"})
    @SourceDebugExtension(value={"SMAP\nArtTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtTrace.kt\nandroidx/benchmark/vmtrace/ArtTrace$PerfettoVmTraceParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1855#2,2:256\n*S KotlinDebug\n*F\n+ 1 ArtTrace.kt\nandroidx/benchmark/vmtrace/ArtTrace$PerfettoVmTraceParser\n*L\n218#1:256,2\n*E\n"})
    private static final class PerfettoVmTraceParser
    implements VmTraceHandler {
        private final int clockId;
        @NotNull
        private final Function0<Long> uuidProvider;
        private final int pid;
        @NotNull
        private final Function1<List<TracePacket>, Unit> flushEvents;
        @NotNull
        private final List<TracePacket> events;
        @NotNull
        private final Map<Integer, ThreadTrack> threads;
        @NotNull
        private final List<EventName> eventNames;
        private int version;
        private long startTimeUs;
        private long maxTimeNs;
        private final int internOffset;
        private boolean hasEmittedInternedData;

        public PerfettoVmTraceParser(int clockId, @NotNull Function0<Long> uuidProvider, int pid, @NotNull Function1<? super List<TracePacket>, Unit> flushEvents) {
            Intrinsics.checkNotNullParameter(uuidProvider, (String)"uuidProvider");
            Intrinsics.checkNotNullParameter(flushEvents, (String)"flushEvents");
            this.clockId = clockId;
            this.uuidProvider = uuidProvider;
            this.pid = pid;
            this.flushEvents = flushEvents;
            this.events = new ArrayList();
            this.threads = new LinkedHashMap();
            this.eventNames = new ArrayList();
            this.version = -1;
            this.internOffset = 100;
        }

        public final int getInternOffset() {
            return this.internOffset;
        }

        public final boolean getHasEmittedInternedData() {
            return this.hasEmittedInternedData;
        }

        public final void setHasEmittedInternedData(boolean bl) {
            this.hasEmittedInternedData = bl;
        }

        @Nullable
        public final InternedData getInternedData() {
            InternedData internedData;
            if (this.hasEmittedInternedData) {
                internedData = null;
            } else {
                InternedData internedData2;
                this.hasEmittedInternedData = true;
                InternedData it = internedData2 = new InternedData(CollectionsKt.toList((Iterable)this.eventNames), null, 2, null);
                boolean bl = false;
                this.eventNames.clear();
                internedData = internedData2;
            }
            return internedData;
        }

        @Override
        public void setVersion(int version) {
            this.version = version;
        }

        @Override
        public void setProperty(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        }

        @Override
        public void addMethod(long id2, @NotNull MethodInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.eventNames.add(new EventName(id2 + (long)this.internOffset, info.getFullName(), null, 4, null));
        }

        @Override
        public void setStartTimeUs(long startTimeUs) {
            this.startTimeUs = startTimeUs;
        }

        @Override
        public void addThread(int id2, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Integer n = id2;
            if (this.threads.containsKey(n)) {
                return;
            }
            n = id2;
            this.threads.put(n, new ThreadTrack(((Number)this.uuidProvider.invoke()).longValue(), name, false, 0, false, 24, null));
        }

        @Override
        public void addMethodAction(int threadId, long methodId, @NotNull TraceAction methodAction, int threadTime, int globalTime) {
            boolean isBegin;
            Intrinsics.checkNotNullParameter((Object)((Object)methodAction), (String)"methodAction");
            ThreadTrack threadTrack = this.threads.get(threadId);
            Intrinsics.checkNotNull((Object)threadTrack);
            ThreadTrack threadTrack2 = threadTrack;
            if (!threadTrack2.getCreated()) {
                this.events.add(new TracePacket(this.startTimeUs * (long)1000, this.clockId, null, new TrackDescriptor(threadTrack2.getUuid(), null, threadTrack2.getName() + " (Method Trace)", new ThreadDescriptor(this.pid, threadId, null, 4, null), null, true, null, 82, null), null, null, null, null, null, null, null, null, 4084, null));
                threadTrack2.setCreated(true);
            }
            long timestampNs = (this.startTimeUs + (long)globalTime) * 1000L;
            this.maxTimeNs = RangesKt.coerceAtLeast((long)this.maxTimeNs, (long)timestampNs);
            boolean bl = isBegin = methodAction == TraceAction.METHOD_ENTER;
            if (isBegin || threadTrack2.getDepth() > 0) {
                TrackEvent.Type type;
                InternedData internedData = this.getInternedData();
                if (internedData != null) {
                    threadTrack2.setDefault(true);
                }
                if (isBegin) {
                    int n = threadTrack2.getDepth();
                    threadTrack2.setDepth(n + 1);
                    type = TrackEvent.Type.TYPE_SLICE_BEGIN;
                } else {
                    threadTrack2.setDepth(RangesKt.coerceAtLeast((int)(threadTrack2.getDepth() - 1), (int)0));
                    type = TrackEvent.Type.TYPE_SLICE_END;
                }
                TrackEvent.Type type2 = type;
                Object object = threadTrack2.isDefault() ? null : Long.valueOf(threadTrack2.getUuid());
                Long l = isBegin ? Long.valueOf(methodId + (long)this.internOffset) : null;
                TrackEvent trackEvent = new TrackEvent(null, l, null, type2, (Long)object, null, null, null, null, null, null, null, 4069, null);
                int n = internedData != null ? SequenceDataInitial : SequenceDataSubsequent;
                object = internedData != null ? new TracePacketDefaults(this.clockId, new TrackEventDefaults(threadTrack2.getUuid(), null, 2, null), null, 4, null) : null;
                this.events.add(new TracePacket(timestampNs, null, trackEvent, null, null, null, 1234565432, internedData, n, null, (TracePacketDefaults)((Object)object), null, 2618, null));
                if (internedData != null || this.events.size() > 10000) {
                    this.flushEventsInternal();
                }
            }
        }

        public final void flushEndEvents() {
            Iterable $this$forEach$iv = this.threads.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThreadTrack threadTrack = (ThreadTrack)element$iv;
                boolean bl = false;
                int n = threadTrack.getDepth();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl2 = false;
                    long l = this.maxTimeNs;
                    TrackEvent trackEvent = new TrackEvent(null, null, null, TrackEvent.Type.TYPE_SLICE_END, threadTrack.getUuid(), null, null, null, null, null, null, null, 4071, null);
                    this.events.add(new TracePacket(l, null, trackEvent, null, null, null, 1234565432, null, null, null, null, null, 4026, null));
                }
            }
            this.flushEventsInternal();
        }

        private final void flushEventsInternal() {
            this.flushEvents.invoke(this.events);
            this.events.clear();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\tH\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\r\"\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Landroidx/benchmark/vmtrace/ArtTrace$PerfettoVmTraceParser$ThreadTrack;", "", "uuid", "", "name", "", "created", "", "depth", "", "isDefault", "(JLjava/lang/String;ZIZ)V", "getCreated", "()Z", "setCreated", "(Z)V", "getDepth", "()I", "setDepth", "(I)V", "setDefault", "getName", "()Ljava/lang/String;", "getUuid", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "benchmark-common_release"})
        private static final class ThreadTrack {
            private final long uuid;
            @NotNull
            private final String name;
            private boolean created;
            private int depth;
            private boolean isDefault;

            public ThreadTrack(long uuid, @NotNull String name, boolean created, int depth, boolean isDefault) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.uuid = uuid;
                this.name = name;
                this.created = created;
                this.depth = depth;
                this.isDefault = isDefault;
            }

            public /* synthetic */ ThreadTrack(long l, String string, boolean bl, int n, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 8) != 0) {
                    n = 0;
                }
                if ((n2 & 0x10) != 0) {
                    bl2 = false;
                }
                this(l, string, bl, n, bl2);
            }

            public final long getUuid() {
                return this.uuid;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean getCreated() {
                return this.created;
            }

            public final void setCreated(boolean bl) {
                this.created = bl;
            }

            public final int getDepth() {
                return this.depth;
            }

            public final void setDepth(int n) {
                this.depth = n;
            }

            public final boolean isDefault() {
                return this.isDefault;
            }

            public final void setDefault(boolean bl) {
                this.isDefault = bl;
            }

            public final long component1() {
                return this.uuid;
            }

            @NotNull
            public final String component2() {
                return this.name;
            }

            public final boolean component3() {
                return this.created;
            }

            public final int component4() {
                return this.depth;
            }

            public final boolean component5() {
                return this.isDefault;
            }

            @NotNull
            public final ThreadTrack copy(long uuid, @NotNull String name, boolean created, int depth, boolean isDefault) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new ThreadTrack(uuid, name, created, depth, isDefault);
            }

            public static /* synthetic */ ThreadTrack copy$default(ThreadTrack threadTrack, long l, String string, boolean bl, int n, boolean bl2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    l = threadTrack.uuid;
                }
                if ((n2 & 2) != 0) {
                    string = threadTrack.name;
                }
                if ((n2 & 4) != 0) {
                    bl = threadTrack.created;
                }
                if ((n2 & 8) != 0) {
                    n = threadTrack.depth;
                }
                if ((n2 & 0x10) != 0) {
                    bl2 = threadTrack.isDefault;
                }
                return threadTrack.copy(l, string, bl, n, bl2);
            }

            @NotNull
            public String toString() {
                return "ThreadTrack(uuid=" + this.uuid + ", name=" + this.name + ", created=" + this.created + ", depth=" + this.depth + ", isDefault=" + this.isDefault + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.uuid);
                result = result * 31 + this.name.hashCode();
                result = result * 31 + Boolean.hashCode(this.created);
                result = result * 31 + Integer.hashCode(this.depth);
                result = result * 31 + Boolean.hashCode(this.isDefault);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ThreadTrack)) {
                    return false;
                }
                ThreadTrack threadTrack = (ThreadTrack)other;
                if (this.uuid != threadTrack.uuid) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.name, (Object)threadTrack.name)) {
                    return false;
                }
                if (this.created != threadTrack.created) {
                    return false;
                }
                if (this.depth != threadTrack.depth) {
                    return false;
                }
                return this.isDefault == threadTrack.isDefault;
            }
        }
    }
}

