/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.app.Instrumentation;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.macro.CompilationMode;
import androidx.benchmark.macro.DeviceInfo;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.AssumptionViolatedException;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\"\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0002H\u0007\u00a8\u0006\r"}, d2={"assumeSupportedWithVmSettings", "", "Landroidx/benchmark/macro/CompilationMode;", "compile", "packageName", "", "block", "Lkotlin/Function0;", "device", "Landroidx/test/uiautomator/UiDevice;", "Landroid/app/Instrumentation;", "isSupportedWithVmSettings", "", "benchmark-macro_release"})
public final class CompilationModeKt {
    public static final void compile(@NotNull CompilationMode $this$compile, @NotNull String packageName, @NotNull Function0<Unit> block) {
        String response;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"instrumentation");
        UiDevice device = CompilationModeKt.device(instrumentation);
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Clearing profiles for ", (Object)packageName));
        device.executeShellCommand(Intrinsics.stringPlus((String)"cmd package compile --reset ", (Object)packageName));
        if (Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.None.INSTANCE) || Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.Interpreted.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.BaselineProfile.INSTANCE)) {
            boolean bl;
            boolean bl2;
            String action = "androidx.profileinstaller.action.INSTALL_PROFILE";
            Object object = device.executeShellCommand("am broadcast -a " + action + " -p " + packageName);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"device.executeShellCommand(\"am broadcast -a $action -p $packageName\")");
            object = StringsKt.substringAfter$default((String)object, (String)"Broadcast completed: result=", null, (int)2, null);
            n = 0;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            Integer result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
            object = result;
            if (object == null) {
                bl2 = true;
            } else {
                n = 0;
                bl2 = (Integer)object == 0;
            }
            if (bl2) {
                throw new RuntimeException("The baseline profile install broadcast was not received. This most likely means that the profileinstaller library is not in the target APK. It must be in order to use CompilationMode.BaselineProfile.");
            }
            Object object2 = object;
            n = 1;
            if (object2 != null && (Integer)object2 == n) {
                bl = true;
            } else {
                Object object3 = object;
                n = 2;
                bl = object3 != null && (Integer)object3 == n;
            }
            if (!bl) {
                boolean bl3;
                boolean bl4;
                boolean bl5;
                Object object4 = object;
                n = 3;
                if (object4 != null && (Integer)object4 == n) {
                    throw new RuntimeException("Baseline profiles aren't supported on this device version");
                }
                Object object5 = object;
                n = 6;
                if (object5 != null && (Integer)object5 == n) {
                    throw new RuntimeException("No baseline profile was found in the target apk.");
                }
                Object object6 = object;
                n = 4;
                if (object6 != null && (Integer)object6 == n) {
                    bl5 = true;
                } else {
                    Object object7 = object;
                    n = 5;
                    bl5 = object7 != null && (Integer)object7 == n;
                }
                if (bl5) {
                    bl4 = true;
                } else {
                    Object object8 = object;
                    n = 7;
                    bl4 = object8 != null && (Integer)object8 == n;
                }
                if (bl4) {
                    bl3 = true;
                } else {
                    Object object9 = object;
                    n = 8;
                    bl3 = object9 != null && (Integer)object9 == n;
                }
                if (bl3) {
                    throw new RuntimeException("Baseline Profile wasn't successfully installed");
                }
                throw new RuntimeException(Intrinsics.stringPlus((String)"unrecognized ProfileInstaller result code: ", (Object)result));
            }
        }
        if ($this$compile instanceof CompilationMode.SpeedProfile) {
            int action = ((CompilationMode.SpeedProfile)$this$compile).getWarmupIterations();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            n = action;
            while (n2 < n) {
                int it = n2++;
                boolean bl6 = false;
                block.invoke();
            }
            Thread.sleep(5000L);
            response = device.executeShellCommand(Intrinsics.stringPlus((String)"killall -s SIGUSR1 ", (Object)packageName));
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            CharSequence charSequence = response;
            n2 = 0;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Received dump profile response ", (Object)response));
                throw new RuntimeException("Failed to dump profile for " + packageName + " (" + response + ')');
            }
            Thread.sleep(5000L);
        }
        Log.d((String)"Benchmark", (String)("Compiling " + packageName + " (" + $this$compile + ')'));
        response = device.executeShellCommand("cmd package compile -f -m " + $this$compile.compileArgument$benchmark_macro_release() + ' ' + packageName);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        if (!StringsKt.contains$default((CharSequence)response, (CharSequence)"Success", (boolean)false, (int)2, null)) {
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Received compile cmd response: ", (Object)response));
            throw new RuntimeException("Failed to compile " + packageName + " (" + response + ')');
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final boolean isSupportedWithVmSettings(@NotNull CompilationMode $this$isSupportedWithVmSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedWithVmSettings, (String)"<this>");
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"getInstrumentation()");
        UiDevice device = CompilationModeKt.device(instrumentation);
        String getProp = device.executeShellCommand("getprop dalvik.vm.extra-opts");
        Intrinsics.checkNotNullExpressionValue((Object)getProp, (String)"getProp");
        boolean vmRunningInterpretedOnly = StringsKt.contains$default((CharSequence)getProp, (CharSequence)"-Xusejit:false", (boolean)false, (int)2, null);
        boolean interpreted = Intrinsics.areEqual((Object)$this$isSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE);
        return vmRunningInterpretedOnly == interpreted;
    }

    public static final void assumeSupportedWithVmSettings(@NotNull CompilationMode $this$assumeSupportedWithVmSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$assumeSupportedWithVmSettings, (String)"<this>");
        if (!CompilationModeKt.isSupportedWithVmSettings($this$assumeSupportedWithVmSettings)) {
            throw new AssumptionViolatedException(DeviceInfo.INSTANCE.isRooted() && Intrinsics.areEqual((Object)$this$assumeSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE) ? StringsKt.trimIndent((String)("\n                        To run benchmarks with CompilationMode " + $this$assumeSupportedWithVmSettings + ",\n                        you must disable jit on your device with the following command:\n                        `adb shell setprop dalvik.vm.extra-opts -Xusejit:false; adb shell stop; adb shell start`                         \n                    ")) : (DeviceInfo.INSTANCE.isRooted() && !Intrinsics.areEqual((Object)$this$assumeSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE) ? StringsKt.trimIndent((String)("\n                        To run benchmarks with CompilationMode " + $this$assumeSupportedWithVmSettings + ",\n                        you must enable jit on your device with the following command:\n                        `adb shell setprop dalvik.vm.extra-opts \\\"\\\"; adb shell stop; adb shell start` \n                    ")) : "You must toggle usejit on the VM to use CompilationMode " + $this$assumeSupportedWithVmSettings + ", this requiresrooting your device."));
        }
    }

    @NotNull
    public static final UiDevice device(@NotNull Instrumentation $this$device) {
        Intrinsics.checkNotNullParameter((Object)$this$device, (String)"<this>");
        UiDevice uiDevice = UiDevice.getInstance((Instrumentation)$this$device);
        Intrinsics.checkNotNullExpressionValue((Object)uiDevice, (String)"getInstance(this)");
        return uiDevice;
    }
}

