/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.perfetto.ShellUtilsKt;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.By;
import androidx.test.uiautomator.BySelector;
import androidx.test.uiautomator.UiDevice;
import androidx.test.uiautomator.Until;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0017J\u0017\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001bR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/macro/MacrobenchmarkScope;", "", "packageName", "", "launchWithClearTask", "", "(Ljava/lang/String;Z)V", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "device", "Landroidx/test/uiautomator/UiDevice;", "instrumentation", "Landroid/app/Instrumentation;", "dropKernelPageCache", "", "killProcess", "pressHome", "delayDurationMs", "", "startActivityAndWait", "block", "Lkotlin/Function1;", "Landroid/content/Intent;", "intent", "waitOnPackageLaunch", "timeoutInSeconds", "waitOnPackageLaunch$benchmark_macro_release", "benchmark-macro_release"})
public final class MacrobenchmarkScope {
    @NotNull
    private final String packageName;
    private final boolean launchWithClearTask;
    private final Instrumentation instrumentation;
    private final Context context;
    private final UiDevice device;

    public MacrobenchmarkScope(@NotNull String packageName, boolean launchWithClearTask) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        this.launchWithClearTask = launchWithClearTask;
        this.instrumentation = InstrumentationRegistry.getInstrumentation();
        this.context = this.instrumentation.getContext();
        this.device = UiDevice.getInstance((Instrumentation)this.instrumentation);
    }

    public final void startActivityAndWait(@NotNull Function1<? super Intent, Unit> block) {
        Intent intent;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intent intent2 = this.context.getPackageManager().getLaunchIntentForPackage(this.packageName);
        if (intent2 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unable to acquire intent for package ", (Object)this.packageName));
        }
        Intent intent3 = intent = intent2;
        block.invoke((Object)intent3);
        this.startActivityAndWait(intent3);
    }

    public static /* synthetic */ void startActivityAndWait$default(MacrobenchmarkScope macrobenchmarkScope, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = startActivityAndWait.1.INSTANCE;
        }
        macrobenchmarkScope.startActivityAndWait((Function1<? super Intent, Unit>)function1);
    }

    public final void startActivityAndWait(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        intent.addFlags(0x10000000);
        if (this.launchWithClearTask) {
            intent.addFlags(32768);
        }
        try {
            this.context.startActivity(intent);
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Unable to launch Activity due to Security Exception. To launch an activity from a benchmark, you may need to set android:exported=true for the Activity in your application's manifest", securityException);
        }
        MacrobenchmarkScope.waitOnPackageLaunch$benchmark_macro_release$default(this, 0L, 1, null);
    }

    public final void waitOnPackageLaunch$benchmark_macro_release(long timeoutInSeconds) {
        long timeoutInMilliseconds = TimeUnit.SECONDS.toMillis(timeoutInSeconds);
        Boolean packageIsDisplayed = (Boolean)this.device.wait(Until.hasObject((BySelector)By.pkg((String)this.packageName).depth(0)), timeoutInMilliseconds);
        if (!packageIsDisplayed.booleanValue()) {
            throw new IllegalStateException("Unable to detect Activity of package " + this.packageName + " after " + timeoutInSeconds + " second timeout. Did it fail to launch?");
        }
    }

    public static /* synthetic */ void waitOnPackageLaunch$benchmark_macro_release$default(MacrobenchmarkScope macrobenchmarkScope, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 30L;
        }
        macrobenchmarkScope.waitOnPackageLaunch$benchmark_macro_release(l);
    }

    public final void pressHome(long delayDurationMs) {
        this.device.pressHome();
        Thread.sleep(delayDurationMs);
    }

    public static /* synthetic */ void pressHome$default(MacrobenchmarkScope macrobenchmarkScope, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 300L;
        }
        macrobenchmarkScope.pressHome(l);
    }

    public final void killProcess() {
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Killing process ", (Object)this.packageName));
        this.device.executeShellCommand(Intrinsics.stringPlus((String)"am force-stop ", (Object)this.packageName));
    }

    public final void dropKernelPageCache() {
        Object object = this.device;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"device");
        object = ShellUtilsKt.executeShellScript$default(object, "echo 3 > /proc/sys/vm/drop_caches && echo Success || echo Failure", null, 2, null);
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String result = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
        if (!Intrinsics.areEqual((Object)result, (Object)"Success")) {
            Log.w((String)"Benchmark", (String)("Failed to drop kernel page cache, result: '" + result + '\''));
        }
    }
}

