/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Outputs;
import androidx.benchmark.macro.R;
import androidx.benchmark.macro.perfetto.PerfettoHelper;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoCapture;", "", "unbundled", "", "(Z)V", "helper", "Landroidx/benchmark/macro/perfetto/PerfettoHelper;", "cancel", "", "start", "stop", "destinationPath", "", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PerfettoCapture {
    private final boolean unbundled;
    @NotNull
    private final PerfettoHelper helper;

    public PerfettoCapture(boolean unbundled) {
        this.unbundled = unbundled;
        this.helper = new PerfettoHelper(this.unbundled);
    }

    public /* synthetic */ PerfettoCapture(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int n2 = Build.VERSION.SDK_INT;
            bl = 21 <= n2 ? n2 <= 28 : false;
        }
        this(bl);
    }

    public final void cancel() {
        if (this.helper.isPerfettoRunning()) {
            this.helper.stopPerfetto();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Context context = InstrumentationRegistry.getInstrumentation().getContext();
        InputStream inputStream = context.getResources().openRawResource(R.raw.trace_config);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.resources.openRawResource(R.raw.trace_config)");
        byte[] configBytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        File textProtoFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_config.textproto");
        try {
            FilesKt.writeBytes((File)textProtoFile, (byte[])configBytes);
            String string = textProtoFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textProtoFile.absolutePath");
            this.helper.startCollecting(string, true);
        }
        finally {
            textProtoFile.delete();
        }
    }

    public final void stop(@NotNull String destinationPath) {
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        if (!this.helper.stopCollecting(400L, destinationPath)) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unable to store perfetto trace in ", (Object)destinationPath));
        }
    }

    public PerfettoCapture() {
        this(false, 1, null);
    }
}

