/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.app.Instrumentation;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Outputs;
import androidx.benchmark.macro.CompilationModeKt;
import androidx.benchmark.macro.perfetto.PerfettoCapture;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0003J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoCaptureWrapper;", "", "()V", "TRACE_ENABLE_PROP", "", "capture", "Landroidx/benchmark/macro/perfetto/PerfettoCapture;", "record", "benchmarkName", "iteration", "", "block", "Lkotlin/Function0;", "", "start", "", "stop", "benchmark-macro_release"})
public final class PerfettoCaptureWrapper {
    @Nullable
    private PerfettoCapture capture;
    @NotNull
    private final String TRACE_ENABLE_PROP;

    public PerfettoCaptureWrapper() {
        this.TRACE_ENABLE_PROP = "persist.traced.enable";
        if (Build.VERSION.SDK_INT >= 21) {
            this.capture = new PerfettoCapture(false, 1, null);
        }
    }

    @RequiresApi(value=21)
    private final boolean start() {
        if (Build.VERSION.SDK_INT >= 21) {
            Log.d((String)"PerfettoCapture", (String)"Recording perfetto trace");
            PerfettoCapture perfettoCapture = this.capture;
            if (perfettoCapture != null) {
                perfettoCapture.start();
            }
        }
        return true;
    }

    @RequiresApi(value=21)
    private final String stop(String benchmarkName, int iteration) {
        String iterString = StringsKt.padStart((String)String.valueOf(iteration), (int)3, (char)'0');
        String traceName = StringsKt.replace$default((String)(benchmarkName + "_iter" + iterString + '_' + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".trace"), (String)" ", (String)"", (boolean)false, (int)4, null);
        return Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)traceName, (String)Intrinsics.stringPlus((String)"perfetto_trace_", (Object)iterString), (boolean)false, (Function1)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ PerfettoCaptureWrapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = PerfettoCaptureWrapper.access$getCapture$p(this.this$0);
                Intrinsics.checkNotNull((Object)object);
                PerfettoCapture perfettoCapture = object;
                object = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.absolutePath");
                perfettoCapture.stop((String)object);
            }
        }), (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String record(@NotNull String benchmarkName, int iteration, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)benchmarkName, (String)"benchmarkName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (Build.VERSION.SDK_INT < 29) {
            return null;
        }
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"getInstrumentation()");
        UiDevice device = CompilationModeKt.device(instrumentation);
        String resetTracedEnabledString = null;
        try {
            String currentPropVal;
            if (Build.VERSION.SDK_INT <= 29 && !Intrinsics.areEqual((Object)(currentPropVal = device.executeShellCommand(Intrinsics.stringPlus((String)"getprop ", (Object)this.TRACE_ENABLE_PROP))), (Object)"1")) {
                Log.d((String)"PerfettoCapture", (String)("set " + this.TRACE_ENABLE_PROP + " to 1 (was " + currentPropVal));
                device.executeShellCommand("setprop " + this.TRACE_ENABLE_PROP + " 1");
                resetTracedEnabledString = currentPropVal;
            }
            this.start();
            block.invoke();
            String string = this.stop(benchmarkName, iteration);
            return string;
        }
        finally {
            if (resetTracedEnabledString != null) {
                Log.d((String)"PerfettoCapture", (String)("resetting " + this.TRACE_ENABLE_PROP + " to " + resetTracedEnabledString));
                device.executeShellCommand(Intrinsics.stringPlus((String)"setprop persist.traced.enable ", resetTracedEnabledString));
            }
        }
    }

    public static final /* synthetic */ PerfettoCapture access$getCapture$p(PerfettoCaptureWrapper $this) {
        return $this.capture;
    }
}

