/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.app.Instrumentation;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.macro.CompilationModeKt;
import androidx.benchmark.macro.DeviceInfo;
import androidx.benchmark.macro.perfetto.PerfettoHelper;
import androidx.benchmark.macro.perfetto.ShellUtilsKt;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0003J\u0012\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J$\u0010\u0016\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\f2\u000e\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010#\u001a\u00020\u0003J\u0012\u0010$\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoHelper;", "", "unbundled", "", "(Z)V", "device", "Landroidx/test/uiautomator/UiDevice;", "instrumentation", "Landroid/app/Instrumentation;", "kotlin.jvm.PlatformType", "copyFileOutput", "destinationFile", "", "getPerfettoTmpOutputFilePath", "getProcessId", "processName", "isPerfettoRunning", "isProcessRunning", "pid", "perfettoCommand", "configFilePath", "isTextProtoConfig", "perfettoStartupException", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "label", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setupTracedAndProbes", "", "startCollecting", "stopCollecting", "waitTimeInMsecs", "", "stopPerfetto", "stopProcess", "Companion", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=21)
public final class PerfettoHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean unbundled;
    private final Instrumentation instrumentation;
    @NotNull
    private final UiDevice device;
    @NotNull
    public static final String LOG_TAG = "PerfettoCapture";
    @NotNull
    private static final String PERFETTO_TMP_OUTPUT_FILE = "/data/misc/perfetto-traces/trace_output.pb";
    @NotNull
    private static final String PERFETTO_TXT_PROTO_ARG = " --txt";
    private static final int PERFETTO_KILL_WAIT_COUNT = 12;
    private static final long PERFETTO_KILL_WAIT_TIME = 5000L;
    @NotNull
    private static final String UNBUNDLED_PERFETTO_ROOT_DIR = "/data/local/tmp";
    @NotNull
    private static final String UNBUNDLED_TEMP_OUTPUT_FILE = "/data/local/tmp/trace_output.pb";
    @NotNull
    private static final String UNBUNDLED_ENV_PREFIX = "PERFETTO_PRODUCER_SOCK_NAME=@macrobenchmark_producer PERFETTO_CONSUMER_SOCK_NAME=@macrobenchmark_consumer";
    @NotNull
    private static final Set<String> SUPPORTED_64_ABIS;
    @NotNull
    private static final Set<String> SUPPORTED_32_ABIS;
    @NotNull
    private static final String PERFETTO = "perfetto";
    @NotNull
    private static final String TRACED = "traced";
    @NotNull
    private static final String TRACED_PROBES = "traced_probes";
    @NotNull
    private static final Lazy<String> tracedProbesShellPath$delegate;
    @NotNull
    private static final Lazy<String> tracedShellPath$delegate;
    @NotNull
    private static final Lazy<String> perfettoShellPath$delegate;

    public PerfettoHelper(boolean unbundled) {
        this.unbundled = unbundled;
        Instrumentation instrumentation = this.instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"instrumentation");
        this.device = CompilationModeKt.device(instrumentation);
    }

    public /* synthetic */ PerfettoHelper(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            int n2 = Build.VERSION.SDK_INT;
            bl = 21 <= n2 ? n2 <= 28 : false;
        }
        this(bl);
    }

    private final IllegalStateException perfettoStartupException(String label, Exception cause) {
        return new IllegalStateException(StringsKt.trimIndent((String)("\n            " + label + "\n            Please report a bug, and include a logcat capture of the test run and failure.\n            " + DeviceInfo.INSTANCE.getDeviceSummaryString() + "\n            ")), cause);
    }

    public final void startCollecting(@NotNull String configFilePath, boolean isTextProtoConfig) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        CharSequence charSequence = configFilePath;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0;
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Perfetto config cannot be empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        try {
            String string;
            Log.i((String)LOG_TAG, (String)"Cleanup perfetto before starting.");
            if (this.isPerfettoRunning()) {
                Log.i((String)LOG_TAG, (String)"Perfetto tracing is already running. Stopping perfetto.");
                if (!this.stopPerfetto()) {
                    throw this.perfettoStartupException("Unable to stop Perfetto trace capture", null);
                }
            }
            if (this.unbundled) {
                String path = "/data/local/tmp/config.pb";
                this.device.executeShellCommand(Intrinsics.stringPlus((String)"rm ", (Object)path));
                this.device.executeShellCommand("mv " + configFilePath + ' ' + path);
                string = path;
            } else {
                string = configFilePath;
            }
            String actualConfigPath = string;
            String outputPath = this.getPerfettoTmpOutputFilePath();
            String output = this.device.executeShellCommand(Intrinsics.stringPlus((String)"rm ", (Object)outputPath));
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Perfetto output file cleanup - ", (Object)output));
            this.setupTracedAndProbes();
            String perfettoCmd = this.perfettoCommand(actualConfigPath, isTextProtoConfig);
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Starting perfetto tracing with cmd: ", (Object)perfettoCmd));
            String perfettoCmdOutput = ShellUtilsKt.executeShellScript$default(this.device, perfettoCmd, null, 2, null);
            Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Perfetto pid - ", (Object)perfettoCmdOutput));
        }
        catch (IOException ioe) {
            throw this.perfettoStartupException("Unable to start perfetto tracing", ioe);
        }
        if (!this.isPerfettoRunning()) {
            throw this.perfettoStartupException("Perfetto tracing failed to start. ", null);
        }
        Log.i((String)LOG_TAG, (String)"Perfetto tracing started successfully.");
    }

    public final boolean stopCollecting(long waitTimeInMsecs, @NotNull String destinationFile) {
        Intrinsics.checkNotNullParameter((Object)destinationFile, (String)"destinationFile");
        Log.i((String)LOG_TAG, (String)("Waiting for " + waitTimeInMsecs + " millis before stopping perfetto."));
        SystemClock.sleep((long)waitTimeInMsecs);
        Log.i((String)LOG_TAG, (String)"Stopping perfetto.");
        try {
            boolean stopped = this.stopPerfetto();
            if (this.unbundled) {
                Log.i((String)LOG_TAG, (String)"Stopping `traced` and `traced_probes`.");
                stopped |= this.stopProcess(this.getProcessId(TRACED));
                stopped |= this.stopProcess(this.getProcessId(TRACED_PROBES));
            }
            if (!stopped) {
                Log.e((String)LOG_TAG, (String)"Perfetto failed to stop.");
                return false;
            }
            Log.i((String)LOG_TAG, (String)("Writing to " + destinationFile + '.'));
            if (!this.copyFileOutput(destinationFile)) {
                return false;
            }
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Unable to stop the perfetto tracing due to ", (Object)ioe.getMessage()), (Throwable)ioe);
            return false;
        }
        return true;
    }

    public final boolean stopPerfetto() throws IOException {
        return this.stopProcess(this.getProcessId(PERFETTO));
    }

    public final boolean isPerfettoRunning() {
        String pid = this.getProcessId(PERFETTO);
        CharSequence charSequence = pid;
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final void setupTracedAndProbes() {
        if (!this.unbundled) {
            return;
        }
        String tracedCmd = "PERFETTO_PRODUCER_SOCK_NAME=@macrobenchmark_producer PERFETTO_CONSUMER_SOCK_NAME=@macrobenchmark_consumer " + Companion.getTracedShellPath() + " --background";
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Starting traced cmd: ", (Object)tracedCmd));
        ShellUtilsKt.executeShellScript$default(this.device, tracedCmd, null, 2, null);
        String tracedProbesCmd = "PERFETTO_PRODUCER_SOCK_NAME=@macrobenchmark_producer PERFETTO_CONSUMER_SOCK_NAME=@macrobenchmark_consumer " + Companion.getTracedProbesShellPath() + " --background";
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Starting traced_probes cmd: ", (Object)tracedProbesCmd));
        ShellUtilsKt.executeShellScript$default(this.device, tracedProbesCmd, null, 2, null);
    }

    private final String perfettoCommand(String configFilePath, boolean isTextProtoConfig) {
        String command;
        String outputPath = this.getPerfettoTmpOutputFilePath();
        String string = command = !this.unbundled ? "cat " + configFilePath + " | perfetto --background -c - -o " + outputPath : "PERFETTO_PRODUCER_SOCK_NAME=@macrobenchmark_producer PERFETTO_CONSUMER_SOCK_NAME=@macrobenchmark_consumer " + Companion.getPerfettoShellPath() + " --background -c " + configFilePath + " -o " + outputPath;
        if (isTextProtoConfig) {
            command = Intrinsics.stringPlus((String)command, (Object)PERFETTO_TXT_PROTO_ARG);
        }
        return command;
    }

    private final String getPerfettoTmpOutputFilePath() {
        return this.unbundled ? UNBUNDLED_TEMP_OUTPUT_FILE : PERFETTO_TMP_OUTPUT_FILE;
    }

    private final String getProcessId(String processName) {
        String string;
        try {
            String string2;
            String processId = this.device.executeShellCommand(Intrinsics.stringPlus((String)"pidof ", (Object)processName));
            Intrinsics.checkNotNullExpressionValue((Object)processId, (String)"processId");
            Object object = new String[]{" "};
            String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)processId, (String[])object, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) {
                string2 = null;
            } else {
                object = string3;
                boolean bl = false;
                string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
            }
            String pid = string2;
            Log.d((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Process id is ", pid));
            string = pid;
        }
        catch (IOException ioe) {
            Log.i((String)LOG_TAG, (String)("Unable to check process status due to " + ioe + '.'), (Throwable)ioe);
            string = null;
        }
        return string;
    }

    private final boolean stopProcess(String pid) {
        String stopOutput = this.device.executeShellCommand(Intrinsics.stringPlus((String)"kill -TERM ", (Object)pid));
        Log.i((String)LOG_TAG, (String)Intrinsics.stringPlus((String)"Stop command output - ", (Object)stopOutput));
        int waitCount = 0;
        while (this.isProcessRunning(pid)) {
            Log.d((String)LOG_TAG, (String)("Process (" + pid + ") is running"));
            if (waitCount < 12) {
                SystemClock.sleep((long)5000L);
                int n = waitCount;
                waitCount = n + 1;
                continue;
            }
            return false;
        }
        Log.i((String)LOG_TAG, (String)"Process stopped successfully.");
        return true;
    }

    private final boolean isProcessRunning(String pid) throws IOException {
        CharSequence charSequence = pid;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Log.d((String)LOG_TAG, (String)("Checking if " + pid + " is running"));
        String output = this.device.executeShellCommand(Intrinsics.stringPlus((String)"ps -A ", (Object)pid));
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        return StringsKt.contains$default((CharSequence)output, (CharSequence)pid, (boolean)false, (int)2, null);
    }

    private final boolean copyFileOutput(String destinationFile) {
        boolean success;
        File directory;
        String sourceFile = this.getPerfettoTmpOutputFilePath();
        File filePath = new File(destinationFile);
        String destDirectory = filePath.getParent();
        if (destDirectory != null && !(directory = new File(destDirectory)).exists() && !(success = directory.mkdirs())) {
            Log.e((String)LOG_TAG, (String)("Result output directory " + destDirectory + " not created successfully."));
            return false;
        }
        try {
            String moveResult = this.device.executeShellCommand("mv " + sourceFile + ' ' + destinationFile);
            Intrinsics.checkNotNullExpressionValue((Object)moveResult, (String)"moveResult");
            CharSequence charSequence = moveResult;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Log.e((String)LOG_TAG, (String)StringsKt.trimIndent((String)("\n                        Unable to move perfetto output file from " + sourceFile + "\n                        to " + destinationFile + " due to " + moveResult + ".\n                    ")));
                return false;
            }
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)"Unable to move the perfetto trace file to destination file.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    public PerfettoHelper() {
        this(false, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"arm64-v8a", "x86_64"};
        SUPPORTED_64_ABIS = SetsKt.setOf((Object[])objectArray);
        SUPPORTED_32_ABIS = SetsKt.setOf((Object)"armeabi");
        tracedProbesShellPath$delegate = LazyKt.lazy((Function0)Companion.tracedProbesShellPath.2.INSTANCE);
        tracedShellPath$delegate = LazyKt.lazy((Function0)Companion.tracedShellPath.2.INSTANCE);
        perfettoShellPath$delegate = LazyKt.lazy((Function0)Companion.perfettoShellPath.2.INSTANCE);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b!J\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0019\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001a\u0010\u0016R\u001b\u0010\u001c\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0018\u001a\u0004\b\u001d\u0010\u0016\u00a8\u0006$"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoHelper$Companion;", "", "()V", "LOG_TAG", "", "PERFETTO", "PERFETTO_KILL_WAIT_COUNT", "", "PERFETTO_KILL_WAIT_TIME", "", "PERFETTO_TMP_OUTPUT_FILE", "PERFETTO_TXT_PROTO_ARG", "SUPPORTED_32_ABIS", "", "SUPPORTED_64_ABIS", "TRACED", "TRACED_PROBES", "UNBUNDLED_ENV_PREFIX", "UNBUNDLED_PERFETTO_ROOT_DIR", "UNBUNDLED_TEMP_OUTPUT_FILE", "perfettoShellPath", "getPerfettoShellPath", "()Ljava/lang/String;", "perfettoShellPath$delegate", "Lkotlin/Lazy;", "tracedProbesShellPath", "getTracedProbesShellPath", "tracedProbesShellPath$delegate", "tracedShellPath", "getTracedShellPath", "tracedShellPath$delegate", "createExecutable", "tool", "createExecutable$benchmark_macro_release", "isAbiSupported", "", "benchmark-macro_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAbiSupported() {
            String it;
            String[] stringArray = Build.SUPPORTED_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_ABIS");
            Log.d((String)PerfettoHelper.LOG_TAG, (String)Intrinsics.stringPlus((String)"Supported ABIs: ", (Object)ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null)));
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Cuttlefish", (boolean)false, (int)2, null)) return false;
            String[] stringArray2 = Build.SUPPORTED_64_BIT_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"SUPPORTED_64_BIT_ABIS");
            Object[] objectArray = stringArray2;
            boolean $i$f$any = false;
            for (Object element$iv : objectArray) {
                it = (String)element$iv;
                boolean bl = false;
                if (!SUPPORTED_64_ABIS.contains(it)) continue;
                return true;
            }
            boolean bl = false;
            if (bl) return true;
            String[] stringArray3 = Build.SUPPORTED_32_BIT_ABIS;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"SUPPORTED_32_BIT_ABIS");
            Object[] objectArray2 = stringArray3;
            $i$f$any = false;
            Object[] objectArray3 = objectArray2;
            int n = objectArray3.length;
            int n2 = 0;
            while (n2 < n) {
                Object element$iv;
                element$iv = objectArray3[n2];
                it = (String)element$iv;
                boolean bl2 = false;
                if (SUPPORTED_32_ABIS.contains(it)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @NotNull
        public final String getTracedProbesShellPath() {
            Lazy lazy = tracedProbesShellPath$delegate;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTracedShellPath() {
            Lazy lazy = tracedShellPath$delegate;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getPerfettoShellPath() {
            Lazy lazy = perfettoShellPath$delegate;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String createExecutable$benchmark_macro_release(@NotNull String tool) {
            Serializable serializable;
            boolean bl;
            String it;
            boolean $i$f$any;
            Object[] $this$any$iv;
            block10: {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                if (!this.isAbiSupported()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                    String[] stringArray = Build.SUPPORTED_ABIS;
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_ABIS");
                    throw new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])stringArray, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                }
                String[] stringArray = Build.SUPPORTED_64_BIT_ABIS;
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"SUPPORTED_64_BIT_ABIS");
                $this$any$iv = stringArray;
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!StringsKt.startsWith$default((String)it, (String)"x86_64", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                serializable = (Serializable)((Object)"x86_64");
            } else {
                boolean bl2;
                block11: {
                    $this$any$iv = Build.SUPPORTED_64_BIT_ABIS;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_64_BIT_ABIS");
                    $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.startsWith$default((String)it, (String)"arm64", (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    serializable = (Serializable)((Object)"aarch64");
                } else {
                    boolean bl3;
                    block12: {
                        $this$any$iv = Build.SUPPORTED_32_BIT_ABIS;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_32_BIT_ABIS");
                        $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl6 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"armeabi", (boolean)false, (int)2, null)) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        serializable = (Serializable)((Object)"arm");
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append("Unsupported ABI (");
                        $this$any$iv = Build.SUPPORTED_ABIS;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"SUPPORTED_ABIS");
                        serializable = new IllegalStateException(stringBuilder.append(ArraysKt.joinToString$default((Object[])$this$any$iv, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
                    }
                }
            }
            Serializable suffix = serializable;
            Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
            InputStream inputStream = instrumentation.getContext().getAssets().open(tool + '_' + suffix);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"instrumentation.context.assets.open(\"${tool}_$suffix\")");
            InputStream inputStream2 = inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"instrumentation");
            UiDevice uiDevice = CompilationModeKt.device(instrumentation);
            return ShellUtilsKt.createRunnableExecutable(uiDevice, tool, inputStream2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "tracedProbesShellPath", "getTracedProbesShellPath()Ljava/lang/String;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "tracedShellPath", "getTracedShellPath()Ljava/lang/String;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "perfettoShellPath", "getPerfettoShellPath()Ljava/lang/String;")))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

