/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.app.Instrumentation;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.benchmark.macro.CompilationModeKt;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "", "()V", "TAG", "", "shellPath", "getShellPath", "()Ljava/lang/String;", "shellPath$delegate", "Lkotlin/Lazy;", "getJsonMetrics", "absoluteTracePath", "metric", "benchmark-macro_release"})
@RequiresApi(value=29)
public final class PerfettoTraceProcessor {
    @NotNull
    public static final PerfettoTraceProcessor INSTANCE = new PerfettoTraceProcessor();
    @NotNull
    private static final String TAG = "PerfettoTraceProcessor";
    @NotNull
    private static final Lazy shellPath$delegate = LazyKt.lazy((Function0)shellPath.2.INSTANCE);

    private PerfettoTraceProcessor() {
    }

    @NotNull
    public final String getShellPath() {
        Lazy lazy = shellPath$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getJsonMetrics(@NotNull String absoluteTracePath, @NotNull String metric) {
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        boolean bl = !StringsKt.contains$default((CharSequence)absoluteTracePath, (CharSequence)" ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Trace path must not contain spaces: ", (Object)absoluteTracePath);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !StringsKt.contains$default((CharSequence)metric, (CharSequence)" ", (boolean)false, (int)2, null);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = Intrinsics.stringPlus((String)"Metric must not contain spaces: ", (Object)metric);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkNotNullExpressionValue((Object)instrumentation, (String)"instrumentation");
        UiDevice device = CompilationModeKt.device(instrumentation);
        String command = this.getShellPath() + " --run-metric " + metric + ' ' + absoluteTracePath + " --metrics-output=json";
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Executing command ", (Object)command));
        CharSequence charSequence = device.executeShellCommand(command);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"device.executeShellCommand(command)");
        boolean bl6 = false;
        String json = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Trace Processor result: \n\n ", (Object)json));
        charSequence = json;
        bl6 = false;
        if (charSequence.length() == 0) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Empty json result from Trace Processor - possibly malformed command? Command: ", (Object)command));
        }
        return json;
    }
}

