/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.CompilationMode;
import androidx.profileinstaller.ProfileInstallReceiver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.AssumptionViolatedException;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\"\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0007\u00a8\u0006\u000b"}, d2={"assumeSupportedWithVmSettings", "", "Landroidx/benchmark/macro/CompilationMode;", "compile", "packageName", "", "block", "Lkotlin/Function0;", "compilePackage", "isSupportedWithVmSettings", "", "benchmark-macro_release"})
public final class CompilationModeKt {
    public static final void compile(@NotNull CompilationMode $this$compile, @NotNull String packageName, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$compile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Clearing profiles for ", (Object)packageName));
        Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"cmd package compile --reset ", (Object)packageName));
        Thread.sleep(1000L);
        if (Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.None.INSTANCE) || Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.Interpreted.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)$this$compile, (Object)CompilationMode.BaselineProfile.INSTANCE)) {
            boolean bl;
            String action = "androidx.profileinstaller.action.INSTALL_PROFILE";
            String name = ProfileInstallReceiver.class.getName();
            Object object = StringsKt.substringAfter$default((String)Shell.INSTANCE.executeCommand("am broadcast -a " + action + ' ' + packageName + '/' + name), (String)"Broadcast completed: result=", null, (int)2, null);
            int n = 0;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            Integer result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
            object = result;
            if (object == null) {
                bl = true;
            } else {
                n = 0;
                bl = (Integer)object == 0;
            }
            if (bl) {
                throw new RuntimeException("The baseline profile install broadcast was not received. This most likely means that the profileinstaller library is not in the target APK. It must be in order to use CompilationMode.BaselineProfile.");
            }
            Object object2 = object;
            n = 1;
            if (object2 == null || (Integer)object2 != n) {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                Object object3 = object;
                n = 2;
                if (object3 != null && (Integer)object3 == n) {
                    throw new RuntimeException("Unable to install baseline profiles. This most likely means that the latest version of the profileinstaller library is not being used. Please use the latest profileinstaller library version.");
                }
                Object object4 = object;
                n = 3;
                if (object4 != null && (Integer)object4 == n) {
                    throw new RuntimeException("Baseline profiles aren't supported on this device version");
                }
                Object object5 = object;
                n = 6;
                if (object5 != null && (Integer)object5 == n) {
                    throw new RuntimeException("No baseline profile was found in the target apk.");
                }
                Object object6 = object;
                n = 4;
                if (object6 != null && (Integer)object6 == n) {
                    bl4 = true;
                } else {
                    Object object7 = object;
                    n = 5;
                    bl4 = object7 != null && (Integer)object7 == n;
                }
                if (bl4) {
                    bl3 = true;
                } else {
                    Object object8 = object;
                    n = 7;
                    bl3 = object8 != null && (Integer)object8 == n;
                }
                if (bl3) {
                    bl2 = true;
                } else {
                    Object object9 = object;
                    n = 8;
                    bl2 = object9 != null && (Integer)object9 == n;
                }
                if (bl2) {
                    throw new RuntimeException("Baseline Profile wasn't successfully installed");
                }
                throw new RuntimeException(Intrinsics.stringPlus((String)"unrecognized ProfileInstaller result code: ", (Object)result));
            }
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Killing process ", (Object)packageName));
            Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"am force-stop ", (Object)packageName));
            CompilationModeKt.compilePackage($this$compile, packageName);
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)packageName, (Object)" is compiled."));
        } else if ($this$compile instanceof CompilationMode.SpeedProfile) {
            int action = ((CompilationMode.SpeedProfile)$this$compile).getWarmupIterations();
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = action;
            while (n < n2) {
                int it = n++;
                boolean bl5 = false;
                block.invoke();
            }
            Thread.sleep(5000L);
            String response = Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"killall -s SIGUSR1 ", (Object)packageName));
            CharSequence charSequence = response;
            n = 0;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Received dump profile response ", (Object)response));
                throw new RuntimeException("Failed to dump profile for " + packageName + " (" + response + ')');
            }
            CompilationModeKt.compilePackage($this$compile, packageName);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final boolean isSupportedWithVmSettings(@NotNull CompilationMode $this$isSupportedWithVmSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupportedWithVmSettings, (String)"<this>");
        String getProp = Shell.INSTANCE.executeCommand("getprop dalvik.vm.extra-opts");
        boolean vmRunningInterpretedOnly = StringsKt.contains$default((CharSequence)getProp, (CharSequence)"-Xusejit:false", (boolean)false, (int)2, null);
        boolean interpreted = Intrinsics.areEqual((Object)$this$isSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE);
        return vmRunningInterpretedOnly == interpreted;
    }

    public static final void assumeSupportedWithVmSettings(@NotNull CompilationMode $this$assumeSupportedWithVmSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$assumeSupportedWithVmSettings, (String)"<this>");
        if (!CompilationModeKt.isSupportedWithVmSettings($this$assumeSupportedWithVmSettings)) {
            throw new AssumptionViolatedException(DeviceInfo.INSTANCE.isRooted() && Intrinsics.areEqual((Object)$this$assumeSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE) ? StringsKt.trimIndent((String)("\n                        To run benchmarks with CompilationMode " + $this$assumeSupportedWithVmSettings + ",\n                        you must disable jit on your device with the following command:\n                        `adb shell setprop dalvik.vm.extra-opts -Xusejit:false; adb shell stop; adb shell start`                         \n                    ")) : (DeviceInfo.INSTANCE.isRooted() && !Intrinsics.areEqual((Object)$this$assumeSupportedWithVmSettings, (Object)CompilationMode.Interpreted.INSTANCE) ? StringsKt.trimIndent((String)("\n                        To run benchmarks with CompilationMode " + $this$assumeSupportedWithVmSettings + ",\n                        you must enable jit on your device with the following command:\n                        `adb shell setprop dalvik.vm.extra-opts \\\"\\\"; adb shell stop; adb shell start` \n                    ")) : "You must toggle usejit on the VM to use CompilationMode " + $this$assumeSupportedWithVmSettings + ", this requiresrooting your device."));
        }
    }

    public static final void compilePackage(@NotNull CompilationMode $this$compilePackage, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$compilePackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)("Compiling " + packageName + " (" + $this$compilePackage + ')'));
        String response = Shell.INSTANCE.executeCommand("cmd package compile -f -m " + $this$compilePackage.compileArgument$benchmark_macro_release() + ' ' + packageName);
        if (!StringsKt.contains$default((CharSequence)response, (CharSequence)"Success", (boolean)false, (int)2, null)) {
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Received compile cmd response: ", (Object)response));
            throw new RuntimeException("Failed to compile " + packageName + " (" + response + ')');
        }
        Thread.sleep(5000L);
    }
}

