/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.util.Log;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J-\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0011\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\f\u0010\u0017\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "", "()V", "TAG", "", "shellPath", "getShellPath", "()Ljava/lang/String;", "shellPath$delegate", "Lkotlin/Lazy;", "getJsonMetrics", "absoluteTracePath", "metric", "querySlices", "", "Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor$Slice;", "sliceNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "rawQuery", "query", "validateTracePath", "", "unquote", "Slice", "benchmark-macro_release"})
public final class PerfettoTraceProcessor {
    @NotNull
    public static final PerfettoTraceProcessor INSTANCE = new PerfettoTraceProcessor();
    @NotNull
    private static final String TAG = "PerfettoTraceProcessor";
    @NotNull
    private static final Lazy shellPath$delegate = LazyKt.lazy((Function0)shellPath.2.INSTANCE);

    private PerfettoTraceProcessor() {
    }

    @NotNull
    public final String getShellPath() {
        Lazy lazy = shellPath$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final void validateTracePath(String absoluteTracePath) {
        boolean bl = !StringsKt.contains$default((CharSequence)absoluteTracePath, (CharSequence)" ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Trace path must not contain spaces: ", (Object)absoluteTracePath);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getJsonMetrics(@NotNull String absoluteTracePath, @NotNull String metric) {
        String string;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.validateTracePath(absoluteTracePath);
        boolean bl = !StringsKt.contains$default((CharSequence)metric, (CharSequence)" ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus((String)"Metric must not contain spaces: ", (Object)metric);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String command = this.getShellPath() + " --run-metric " + metric + ' ' + absoluteTracePath + " --metrics-output=json";
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Executing command ", (Object)command));
        String label$iv = "trace_processor_shell";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl5 = false;
            String string3 = Shell.INSTANCE.executeCommand(command);
            boolean bl6 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
        String json = string;
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Trace Processor result: \n\n ", (Object)json));
        CharSequence charSequence = json;
        boolean bl7 = false;
        if (charSequence.length() == 0) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Empty json result from Trace Processor - possibly malformed command? Command: ", (Object)command));
        }
        return json;
    }

    private final String unquote(String $this$unquote) {
        boolean bl = StringsKt.first((CharSequence)$this$unquote) == '\"' && StringsKt.last((CharSequence)$this$unquote) == '\"';
        int n = 0;
        int n2 = 0;
        n2 = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = $this$unquote;
        n = 1;
        n2 = $this$unquote.length() - 1;
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Slice> querySlices(@NotNull String absoluteTracePath, String ... sliceNames) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)sliceNames, (String)"sliceNames");
        String whereClause2 = ArraysKt.joinToString$default((Object[])sliceNames, (CharSequence)" OR ", null, null, (int)0, null, (Function1)querySlices.whereClause.1.INSTANCE, (int)30, null);
        String queryResult = this.rawQuery(absoluteTracePath, StringsKt.trimMargin$default((String)("\n                SELECT slice.name,ts,dur\n                FROM slice\n                JOIN thread_track ON thread_track.id = slice.track_id\n                WHERE " + whereClause2 + "\n            "), null, (int)1, null));
        Object object2 = new String[]{"\n"};
        List resultLines = StringsKt.split$default((CharSequence)queryResult, (String[])object2, (boolean)false, (int)0, (int)6, null);
        if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)resultLines), (Object)"\"name\",\"ts\",\"dur\"")) {
            throw new IllegalStateException("query failed!");
        }
        object2 = resultLines;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            object = (String[])it;
            boolean bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)object);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            object = new String[]{","};
            List columns = StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = (String)columns.get(1);
            boolean bl4 = false;
            long l = Long.parseLong((String)object);
            object = (String)columns.get(2);
            bl4 = false;
            Slice slice = new Slice(INSTANCE.unquote((String)columns.get(0)), l, Long.parseLong((String)object));
            collection.add(slice);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String rawQuery(String absoluteTracePath, String query) {
        this.validateTracePath(absoluteTracePath);
        File queryFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_processor_query.sql");
        try {
            String string;
            FilesKt.writeText$default((File)queryFile, (String)query, null, (int)2, null);
            String command = this.getShellPath() + " --query-file " + queryFile.getAbsolutePath() + ' ' + absoluteTracePath;
            String label$iv = "trace_processor_shell";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.INSTANCE.startSection(label$iv);
            try {
                boolean bl = false;
                string = Shell.INSTANCE.executeCommand(command);
            }
            finally {
                UserspaceTracing.INSTANCE.endSection();
            }
            String string2 = string;
            return string2;
        }
        finally {
            queryFile.delete();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor$Slice;", "", "name", "", "ts", "", "dur", "(Ljava/lang/String;JJ)V", "getDur", "()J", "getName", "()Ljava/lang/String;", "getTs", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-macro_release"})
    public static final class Slice {
        @NotNull
        private final String name;
        private final long ts;
        private final long dur;

        public Slice(@NotNull String name, long ts, long dur) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.ts = ts;
            this.dur = dur;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getTs() {
            return this.ts;
        }

        public final long getDur() {
            return this.dur;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.ts;
        }

        public final long component3() {
            return this.dur;
        }

        @NotNull
        public final Slice copy(@NotNull String name, long ts, long dur) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Slice(name, ts, dur);
        }

        public static /* synthetic */ Slice copy$default(Slice slice, String string, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = slice.name;
            }
            if ((n & 2) != 0) {
                l = slice.ts;
            }
            if ((n & 4) != 0) {
                l2 = slice.dur;
            }
            return slice.copy(string, l, l2);
        }

        @NotNull
        public String toString() {
            return "Slice(name=" + this.name + ", ts=" + this.ts + ", dur=" + this.dur + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Long.hashCode(this.ts);
            result = result * 31 + Long.hashCode(this.dur);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Slice)) {
                return false;
            }
            Slice slice = (Slice)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)slice.name)) {
                return false;
            }
            if (this.ts != slice.ts) {
                return false;
            }
            return this.dur == slice.dur;
        }
    }
}

