/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.util.Log;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.Slice;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J-\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0011\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "", "()V", "TAG", "", "shellPath", "getShellPath", "()Ljava/lang/String;", "shellPath$delegate", "Lkotlin/Lazy;", "getJsonMetrics", "absoluteTracePath", "metric", "querySlices", "", "Landroidx/benchmark/macro/perfetto/Slice;", "sliceNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "rawQuery", "query", "rawQuery$benchmark_macro_release", "validateTracePath", "", "benchmark-macro_release"})
public final class PerfettoTraceProcessor {
    @NotNull
    public static final PerfettoTraceProcessor INSTANCE = new PerfettoTraceProcessor();
    @NotNull
    private static final String TAG = "PerfettoTraceProcessor";
    @NotNull
    private static final Lazy shellPath$delegate = LazyKt.lazy((Function0)shellPath.2.INSTANCE);

    private PerfettoTraceProcessor() {
    }

    @NotNull
    public final String getShellPath() {
        Lazy lazy = shellPath$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final void validateTracePath(String absoluteTracePath) {
        boolean bl = !StringsKt.contains$default((CharSequence)absoluteTracePath, (CharSequence)" ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Trace path must not contain spaces: ", (Object)absoluteTracePath);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getJsonMetrics(@NotNull String absoluteTracePath, @NotNull String metric) {
        String string;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.validateTracePath(absoluteTracePath);
        boolean bl = !StringsKt.contains$default((CharSequence)metric, (CharSequence)" ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus((String)"Metric must not contain spaces: ", (Object)metric);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String command = this.getShellPath() + " --run-metric " + metric + ' ' + absoluteTracePath + " --metrics-output=json";
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Executing command ", (Object)command));
        String label$iv = "trace_processor_shell";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.INSTANCE.startSection(label$iv);
        try {
            boolean bl5 = false;
            String string3 = Shell.INSTANCE.executeCommand(command);
            boolean bl6 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        finally {
            UserspaceTracing.INSTANCE.endSection();
        }
        String json = string;
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"Trace Processor result: \n\n ", (Object)json));
        CharSequence charSequence = json;
        boolean bl7 = false;
        if (charSequence.length() == 0) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Empty json result from Trace Processor - possibly malformed command? Command: ", (Object)command));
        }
        return json;
    }

    @NotNull
    public final List<Slice> querySlices(@NotNull String absoluteTracePath, String ... sliceNames) {
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)sliceNames, (String)"sliceNames");
        String whereClause2 = ArraysKt.joinToString$default((Object[])sliceNames, (CharSequence)" OR ", null, null, (int)0, null, (Function1)querySlices.whereClause.1.INSTANCE, (int)30, null);
        return Slice.Companion.parseListFromQueryResult(this.rawQuery$benchmark_macro_release(absoluteTracePath, StringsKt.trimMargin$default((String)("\n                SELECT slice.name,ts,dur\n                FROM slice\n                JOIN thread_track ON thread_track.id = slice.track_id\n                WHERE " + whereClause2 + "\n            "), null, (int)1, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String rawQuery$benchmark_macro_release(@NotNull String absoluteTracePath, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.validateTracePath(absoluteTracePath);
        File queryFile = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), "trace_processor_query.sql");
        try {
            String string;
            FilesKt.writeText$default((File)queryFile, (String)query, null, (int)2, null);
            String command = this.getShellPath() + " --query-file " + queryFile.getAbsolutePath() + ' ' + absoluteTracePath;
            String label$iv = "trace_processor_shell";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.INSTANCE.startSection(label$iv);
            try {
                boolean bl = false;
                string = Shell.INSTANCE.executeCommand(command);
            }
            finally {
                UserspaceTracing.INSTANCE.endSection();
            }
            String string2 = string;
            return string2;
        }
        finally {
            queryFile.delete();
        }
    }
}

