/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.benchmark.macro.CompilationMode;
import androidx.benchmark.macro.MacrobenchmarkScope;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u001a1\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\b\bH\u0007\u001a\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002\u001a \u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"collectBaselineProfile", "", "uniqueName", "", "packageName", "profileBlock", "Lkotlin/Function1;", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "Lkotlin/ExtensionFunctionType;", "profile", "apkPath", "pathOptions", "", "summaryRecord", "totalRunTime", "", "absolutePath", "tsAbsolutePath", "benchmark-macro_release"})
public final class BaselineProfilesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=28)
    public static final void collectBaselineProfile(@NotNull String uniqueName, @NotNull String packageName, @NotNull Function1<? super MacrobenchmarkScope, Unit> profileBlock) {
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(profileBlock, (String)"profileBlock");
        if (!(Build.VERSION.SDK_INT >= 28)) {
            boolean $i$a$-require-BaselineProfilesKt$collectBaselineProfile$32 = false;
            String $i$a$-require-BaselineProfilesKt$collectBaselineProfile$32 = "Baseline Profile Collection requires API 28 or higher.";
            throw new IllegalArgumentException($i$a$-require-BaselineProfilesKt$collectBaselineProfile$32.toString());
        }
        if (!Shell.INSTANCE.isSessionRooted()) {
            boolean bl = false;
            String string = "Baseline Profile Collection requires a rooted device, and a rooted adb session. Use `adb root`.";
            throw new IllegalArgumentException(string.toString());
        }
        long startTime = System.nanoTime();
        MacrobenchmarkScope scope = new MacrobenchmarkScope(packageName, true);
        CompilationMode.Partial compilationMode = new CompilationMode.Partial(BaselineProfileMode.Disable, 3);
        scope.killProcess();
        try {
            String label$iv = Intrinsics.stringPlus((String)"compile ", (Object)packageName);
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                boolean bl = false;
                compilationMode.resetAndCompile$benchmark_macro_release(packageName, (Function0<Unit>)((Function0)new Function0<Unit>(profileBlock, scope){
                    final /* synthetic */ Function1<MacrobenchmarkScope, Unit> $profileBlock;
                    final /* synthetic */ MacrobenchmarkScope $scope;
                    {
                        this.$profileBlock = $profileBlock;
                        this.$scope = $scope;
                        super(0);
                    }

                    public final void invoke() {
                        this.$profileBlock.invoke((Object)this.$scope);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
            }
            String referenceProfile = "/data/misc/profiles/ref/" + packageName + "/primary.prof";
            String currentProfile = "/data/misc/profiles/cur/0/" + packageName + "/primary.prof";
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Reference profile location: ", (Object)referenceProfile));
            String pathResult = Shell.executeScript$default((Shell)Shell.INSTANCE, (String)Intrinsics.stringPlus((String)"pm path ", (Object)packageName), null, (int)2, null);
            String apkPath = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)pathResult, (String)"package:", null, (int)2, null))).toString();
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"APK Path: ", (Object)apkPath));
            Log.d((String)"Benchmark", (String)"Converting to human readable profile format");
            Object[] objectArray = new String[]{referenceProfile, currentProfile};
            String profile = BaselineProfilesKt.profile(apkPath, CollectionsKt.listOf((Object[])objectArray));
            InstrumentationResults.INSTANCE.instrumentationReport((Function1)new Function1<InstrumentationResultScope, Unit>(uniqueName, startTime, profile){
                final /* synthetic */ String $uniqueName;
                final /* synthetic */ long $startTime;
                final /* synthetic */ String $profile;
                {
                    this.$uniqueName = $uniqueName;
                    this.$startTime = $startTime;
                    this.$profile = $profile;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    String fileName = Intrinsics.stringPlus((String)this.$uniqueName, (Object)"-baseline-prof.txt");
                    String absolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)fileName, (String)"baseline-profile", (boolean)false, (Function1)((Function1)new Function1<File, Unit>(this.$profile){
                        final /* synthetic */ String $profile;
                        {
                            this.$profile = $profile;
                            super(1);
                        }

                        public final void invoke(@NotNull File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            FilesKt.writeText$default((File)it, (String)this.$profile, null, (int)2, null);
                        }
                    }), (int)4, null);
                    String tsFileName = this.$uniqueName + "-baseline-prof-" + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".txt";
                    String tsAbsolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)tsFileName, (String)"baseline-profile-ts", (boolean)false, (Function1)((Function1)new Function1<File, Unit>(this.$profile){
                        final /* synthetic */ String $profile;
                        {
                            this.$profile = $profile;
                            super(1);
                        }

                        public final void invoke(@NotNull File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Log.d((String)"Benchmark", (String)("Pull Baseline Profile with: `adb pull \"" + it.getAbsolutePath() + "\" .`"));
                            FilesKt.writeText$default((File)it, (String)this.$profile, null, (int)2, null);
                        }
                    }), (int)4, null);
                    long totalRunTime = System.nanoTime() - this.$startTime;
                    String summary = BaselineProfilesKt.access$summaryRecord(totalRunTime, absolutePath2, tsAbsolutePath2);
                    $this$instrumentationReport.ideSummaryRecord(summary, summary);
                    Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Total Run Time Ns: ", (Object)totalRunTime));
                }
            });
        }
        finally {
            scope.killProcess();
        }
    }

    private static final String profile(String apkPath, List<String> pathOptions) {
        for (String currentPath : pathOptions) {
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Using profile location: ", (Object)currentPath));
            String profile = Shell.executeScript$default((Shell)Shell.INSTANCE, (String)("profman --dump-classes-and-methods --profile-file=" + currentPath + " --apk=" + apkPath), null, (int)2, null);
            if (!(!StringsKt.isBlank((CharSequence)profile))) continue;
            return profile;
        }
        throw new IllegalStateException("The profile is empty.");
    }

    private static final String summaryRecord(long totalRunTime, String absolutePath2, String tsAbsolutePath2) {
        String relativePath = StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor(absolutePath2), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null);
        return StringsKt.trimIndent((String)("\n        Total run time Ns: " + totalRunTime + ".\n        Baseline profile [results](file://" + relativePath + ")\n\n        To copy the profile use:\n        `adb pull \"" + tsAbsolutePath2 + "\" .`\n    "));
    }

    public static final /* synthetic */ String access$summaryRecord(long totalRunTime, String absolutePath2, String tsAbsolutePath2) {
        return BaselineProfilesKt.summaryRecord(totalRunTime, absolutePath2, tsAbsolutePath2);
    }
}

