/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.profileinstaller.ProfileInstallReceiver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0005\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\bJ#\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH!\u00a2\u0006\u0002\b\fJ#\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0000\u00a2\u0006\u0002\b\u000e\u0082\u0001\u0004\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/macro/CompilationMode;", "", "()V", "cmdPackageCompile", "", "packageName", "", "compileArgument", "cmdPackageCompile$benchmark_macro_release", "compileImpl", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "resetAndCompile", "resetAndCompile$benchmark_macro_release", "Companion", "Full", "Interpreted", "None", "Partial", "Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode$Partial;", "Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode$Interpreted;", "benchmark-macro_release"})
public abstract class CompilationMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompilationMode noop = Build.VERSION.SDK_INT >= 24 ? (CompilationMode)new None() : (CompilationMode)new Full();
    @JvmField
    @NotNull
    public static final CompilationMode DEFAULT = Build.VERSION.SDK_INT >= 24 ? (CompilationMode)new Partial(BaselineProfileMode.UseIfAvailable, 0) : (CompilationMode)new Full();

    private CompilationMode() {
    }

    public final void resetAndCompile$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> warmupBlock) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        if (Build.VERSION.SDK_INT >= 24) {
            Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Clearing profiles for ", (Object)packageName));
            Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"cmd package compile --reset ", (Object)packageName));
            this.compileImpl$benchmark_macro_release(packageName, warmupBlock);
        }
    }

    @RequiresApi(value=24)
    public final void cmdPackageCompile$benchmark_macro_release(@NotNull String packageName, @NotNull String compileArgument) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)compileArgument, (String)"compileArgument");
        Shell.INSTANCE.executeCommand("cmd package compile -f -m " + compileArgument + ' ' + packageName);
    }

    @RequiresApi(value=24)
    public abstract void compileImpl$benchmark_macro_release(@NotNull String var1, @NotNull Function0<Unit> var2);

    public /* synthetic */ CompilationMode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RequiresApi(value=24)
    public static final class None
    extends CompilationMode {
        public None() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "None";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0010\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/macro/CompilationMode$Partial;", "Landroidx/benchmark/macro/CompilationMode;", "baselineProfileMode", "Landroidx/benchmark/macro/BaselineProfileMode;", "warmupIterations", "", "(Landroidx/benchmark/macro/BaselineProfileMode;I)V", "getBaselineProfileMode", "()Landroidx/benchmark/macro/BaselineProfileMode;", "getWarmupIterations", "()I", "broadcastBaselineProfileInstall", "", "packageName", "compileImpl", "", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RequiresApi(value=24)
    public static final class Partial
    extends CompilationMode {
        @NotNull
        private final BaselineProfileMode baselineProfileMode;
        private final int warmupIterations;

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode, @IntRange(from=0L) int warmupIterations) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            super(null);
            this.baselineProfileMode = baselineProfileMode;
            this.warmupIterations = warmupIterations;
            if (!(this.warmupIterations >= 0)) {
                boolean $i$a$-require-CompilationMode$Partial$32 = false;
                String $i$a$-require-CompilationMode$Partial$32 = Intrinsics.stringPlus((String)"warmupIterations must be non-negative, was ", (Object)this.getWarmupIterations());
                throw new IllegalArgumentException($i$a$-require-CompilationMode$Partial$32.toString());
            }
            if (!(this.baselineProfileMode != BaselineProfileMode.Disable || this.warmupIterations > 0)) {
                boolean bl = false;
                String string = "Must set baselineProfileMode != Ignore, or warmup iterations > 0 to define which portion of the app to pre-compile.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Partial(BaselineProfileMode baselineProfileMode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                baselineProfileMode = BaselineProfileMode.Require;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(baselineProfileMode, n);
        }

        @NotNull
        public final BaselineProfileMode getBaselineProfileMode() {
            return this.baselineProfileMode;
        }

        public final int getWarmupIterations() {
            return this.warmupIterations;
        }

        @NotNull
        public String toString() {
            return this.baselineProfileMode == BaselineProfileMode.Require && this.warmupIterations == 0 ? "BaselineProfile" : (this.baselineProfileMode == BaselineProfileMode.Disable && this.warmupIterations > 0 ? "WarmupProfile(iterations=" + this.warmupIterations + ')' : "Partial(baselineProfile=" + (Object)((Object)this.baselineProfileMode) + ",iterations=" + this.warmupIterations + ')');
        }

        private final String broadcastBaselineProfileInstall(String packageName) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            boolean bl4;
            String action = "androidx.profileinstaller.action.INSTALL_PROFILE";
            String name = ProfileInstallReceiver.class.getName();
            Integer result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)Shell.INSTANCE.executeCommand("am broadcast -a " + action + ' ' + packageName + '/' + name), (String)"Broadcast completed: result=", null, (int)2, null))).toString());
            Integer n2 = result;
            if (n2 == null) {
                bl4 = true;
            } else {
                n = 0;
                bl4 = n2 == 0;
            }
            if (bl4) {
                return "The baseline profile install broadcast was not received. This most likely means that the profileinstaller library is missing from the target apk.";
            }
            Integer n3 = n2;
            n = 1;
            if (n3 != null && n3 == n) {
                return null;
            }
            Integer n4 = n2;
            n = 2;
            if (n4 != null && n4 == n) {
                throw new RuntimeException("Unable to install baseline profile. This most likely means that the latest version of the profileinstaller library is not being used. Please use the latest profileinstaller library version in the target app.");
            }
            Integer n5 = n2;
            n = 3;
            if (n5 != null && n5 == n) {
                throw new RuntimeException("Baseline profiles aren't supported on this device version");
            }
            Integer n6 = n2;
            n = 6;
            if (n6 != null && n6 == n) {
                return "No baseline profile was found in the target apk.";
            }
            Integer n7 = n2;
            n = 4;
            if (n7 != null && n7 == n) {
                bl3 = true;
            } else {
                Integer n8 = n2;
                n = 5;
                bl3 = n8 != null && n8 == n;
            }
            if (bl3) {
                bl2 = true;
            } else {
                Integer n9 = n2;
                n = 7;
                bl2 = n9 != null && n9 == n;
            }
            if (bl2) {
                bl = true;
            } else {
                Integer n10 = n2;
                n = 8;
                bl = n10 != null && n10 == n;
            }
            if (bl) {
                throw new RuntimeException("Baseline Profile wasn't successfully installed");
            }
            throw new RuntimeException(Intrinsics.stringPlus((String)"unrecognized ProfileInstaller result code: ", (Object)result));
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            if (this.baselineProfileMode != BaselineProfileMode.Disable) {
                String installErrorString = this.broadcastBaselineProfileInstall(packageName);
                if (installErrorString == null) {
                    Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Killing process ", (Object)packageName));
                    Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"am force-stop ", (Object)packageName));
                    this.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
                } else {
                    if (this.baselineProfileMode == BaselineProfileMode.Require) {
                        throw new RuntimeException(installErrorString);
                    }
                    Log.d((String)"Benchmark", (String)installErrorString);
                }
            }
            if (this.warmupIterations > 0) {
                int installErrorString = this.warmupIterations;
                int n = 0;
                while (n < installErrorString) {
                    int n2;
                    int it = n2 = n++;
                    boolean bl = false;
                    warmupBlock.invoke();
                }
                Thread.sleep(5000L);
                String response = Shell.INSTANCE.executeCommand(Intrinsics.stringPlus((String)"killall -s SIGUSR1 ", (Object)packageName));
                if (!StringsKt.isBlank((CharSequence)response)) {
                    Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Received dump profile response ", (Object)response));
                    throw new RuntimeException("Failed to dump profile for " + packageName + " (" + response + ')');
                }
                this.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
            }
        }

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            this(baselineProfileMode, 0, 2, null);
        }

        @JvmOverloads
        public Partial() {
            this(null, 0, 3, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "toString", "benchmark-macro_release"})
    public static final class Full
    extends CompilationMode {
        public Full() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Full";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            if (Build.VERSION.SDK_INT >= 24) {
                this.cmdPackageCompile$benchmark_macro_release(packageName, "speed");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/macro/CompilationMode$Interpreted;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Interpreted
    extends CompilationMode {
        @NotNull
        public static final Interpreted INSTANCE = new Interpreted();

        private Interpreted() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Interpreted";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/benchmark/macro/CompilationMode$Companion;", "", "()V", "DEFAULT", "Landroidx/benchmark/macro/CompilationMode;", "noop", "getNoop$benchmark_macro_release", "()Landroidx/benchmark/macro/CompilationMode;", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilationMode getNoop$benchmark_macro_release() {
            return noop;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

