/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00100\u00062\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery;", "", "()V", "getFrameSubMetrics", "", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "", "", "absoluteTracePath", "", "captureApiLevel", "", "packageName", "getFullQuery", "processName", "binarySearchFrameId", "Landroidx/benchmark/macro/perfetto/Slice;", "frameId", "FrameData", "FrameSliceType", "SubMetric", "benchmark-macro_release"})
public final class FrameTimingQuery {
    @NotNull
    public static final FrameTimingQuery INSTANCE = new FrameTimingQuery();

    private FrameTimingQuery() {
    }

    private final String getFullQuery(String processName) {
        return StringsKt.trimIndent((String)("\n        ------ Select all frame-relevant slices from slice table\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN thread_track on slice.track_id = thread_track.id\n            INNER JOIN thread USING(utid)\n            INNER JOIN process USING(upid)\n        WHERE (\n            ( slice.name LIKE \"Choreographer#doFrame%\" AND process.pid LIKE thread.tid ) OR\n            ( slice.name LIKE \"DrawFrame%\" AND thread.name like \"RenderThread\" )\n        ) AND (process.name LIKE \"" + processName + "\")\n        ------ Add in actual frame slices (prepended with \"actual \" to differentiate)\n        UNION\n        SELECT\n            \"actual \" || actual_frame_timeline_slice.name as name,\n            actual_frame_timeline_slice.ts as ts,\n            actual_frame_timeline_slice.dur as dur\n        FROM actual_frame_timeline_slice\n            INNER JOIN process USING(upid)\n        WHERE\n            process.name LIKE \"" + processName + "\"\n        ------ Add in expected time slices (prepended with \"expected \" to differentiate)\n        UNION\n        SELECT\n            \"expected \" || expected_frame_timeline_slice.name as name,\n            expected_frame_timeline_slice.ts as ts,\n            expected_frame_timeline_slice.dur as dur\n        FROM expected_frame_timeline_slice\n            INNER JOIN process USING(upid)\n        WHERE\n            process.name LIKE \"" + processName + "\"\n        ORDER BY ts ASC\n    "));
    }

    private final Slice binarySearchFrameId(List<Slice> $this$binarySearchFrameId, int frameId) {
        int targetIndex2 = CollectionsKt.binarySearch$default($this$binarySearchFrameId, (int)0, (int)0, (Function1)((Function1)new Function1<Slice, Integer>(frameId){
            final /* synthetic */ int $frameId;
            {
                this.$frameId = $frameId;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Slice potentialTarget) {
                Intrinsics.checkNotNullParameter((Object)potentialTarget, (String)"potentialTarget");
                Integer n = potentialTarget.getFrameId();
                Intrinsics.checkNotNull((Object)n);
                return n - this.$frameId;
            }
        }), (int)3, null);
        return targetIndex2 >= 0 ? $this$binarySearchFrameId.get(targetIndex2) : (Slice)null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<SubMetric, List<Long>> getFrameSubMetrics(@NotNull String absoluteTracePath, int captureApiLevel, @NotNull String packageName) {
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        FrameData it$iv$iv;
        Object rtSlice;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        int $i$f$forEach;
        SubMetric[] $this$forEach$iv$iv$iv;
        SubMetric[] $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        boolean $i$f$mapNotNull;
        SubMetric[] $this$mapNotNull$iv;
        Slice it;
        boolean $i$f$none2;
        Iterable $this$none$iv;
        Iterator answer$iv$iv$iv2;
        Object $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Slice it2;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String queryResult = PerfettoTraceProcessor.INSTANCE.rawQuery$benchmark_macro_release(absoluteTracePath, this.getFullQuery(packageName));
        Iterable<Slice> list2 = Slice.Companion.parseListFromQueryResult(queryResult);
        boolean bl2 = false;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterator destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Slice slice = (Slice)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(Slice.copy$default((Slice)it3, null, it3.getTs() - ((Slice)CollectionsKt.first(list2)).getTs(), 0L, 5, null));
        }
        List slices = (List)((Object)destination$iv$iv2);
        list2 = slices;
        boolean $i$f$filter = false;
        $this$map$iv = $this$filter$iv2;
        Object destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            it2 = (Slice)element$iv$iv2;
            boolean bl4 = false;
            if (!(it2.getDur() > 0L)) continue;
            destination$iv$iv3.add(element$iv$iv2);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$groupBy22 = false;
        $this$filterTo$iv$iv2 = $this$groupBy$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        destination$iv$iv2 = $this$groupByTo$iv$iv.iterator();
        while (destination$iv$iv2.hasNext()) {
            Object object;
            FrameSliceType frameSliceType;
            Object element$iv$iv3 = destination$iv$iv2.next();
            it2 = (Slice)element$iv$iv3;
            boolean bl5 = false;
            if (StringsKt.startsWith$default((String)it2.getName(), (String)"Choreographer#doFrame", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.UiThread;
            } else if (StringsKt.startsWith$default((String)it2.getName(), (String)"DrawFrame", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.RenderThread;
            } else if (StringsKt.startsWith$default((String)it2.getName(), (String)"actual ", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.Actual;
            } else if (StringsKt.startsWith$default((String)it2.getName(), (String)"expected ", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.Expected;
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected slice ", (Object)it2));
            }
            FrameSliceType key$iv$iv = frameSliceType;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                answer$iv$iv$iv2 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv2);
                object = answer$iv$iv$iv2;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        Object groupedData = destination$iv$iv3;
        Object $i$f$groupBy22 = groupedData;
        $this$groupByTo$iv$iv = FrameSliceType.UiThread;
        Object object = $i$f$groupBy22.get($this$groupByTo$iv$iv);
        if (object == null) {
            boolean bl7 = false;
            object = CollectionsKt.emptyList();
        }
        List uiSlices = (List)object;
        $this$groupByTo$iv$iv = groupedData;
        destination$iv$iv3 = FrameSliceType.RenderThread;
        Object object2 = $this$groupByTo$iv$iv.get(destination$iv$iv3);
        if (object2 == null) {
            boolean bl8 = false;
            object2 = CollectionsKt.emptyList();
        }
        List rtSlices = (List)object2;
        destination$iv$iv3 = groupedData;
        Object bl7 = FrameSliceType.Actual;
        Object object3 = destination$iv$iv3.get(bl7);
        if (object3 == null) {
            boolean bl9 = false;
            object3 = CollectionsKt.emptyList();
        }
        List actualSlices = (List)object3;
        bl7 = groupedData;
        FrameSliceType bl8 = FrameSliceType.Expected;
        Object object4 = bl7.get((Object)bl8);
        if (object4 == null) {
            boolean bl10 = false;
            object4 = CollectionsKt.emptyList();
        }
        List expectedSlices = (List)object4;
        if (uiSlices.isEmpty()) {
            return MapsKt.emptyMap();
        }
        boolean newSlicesShouldBeEmpty = captureApiLevel < 31;
        if (!(actualSlices.isEmpty() == newSlicesShouldBeEmpty)) {
            String bl9 = "Failed requirement.";
            throw new IllegalArgumentException(bl9.toString());
        }
        if (!(expectedSlices.isEmpty() == newSlicesShouldBeEmpty)) {
            String bl9 = "Failed requirement.";
            throw new IllegalArgumentException(bl9.toString());
        }
        if (captureApiLevel >= 31) {
            boolean bl11;
            block36: {
                $this$none$iv = slices;
                $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl11 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Slice)element$iv;
                        boolean bl12 = false;
                        if (!(it.getFrameId() == null)) continue;
                        bl11 = false;
                        break block36;
                    }
                    bl11 = true;
                }
            }
            if (!bl11) {
                String $i$f$none2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$none2.toString());
            }
            $this$mapNotNull$iv = (SubMetric[])rtSlices;
            $i$f$mapNotNull = false;
            SubMetric[] bl5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = 0;
            answer$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (answer$iv$iv$iv2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = answer$iv$iv$iv2.next();
                bl = false;
                rtSlice = (Slice)element$iv$iv;
                boolean bl13 = false;
                Integer n = ((Slice)rtSlice).getFrameId();
                Intrinsics.checkNotNull((Object)n);
                int frameId = n;
                if (FrameData.Companion.tryCreate31(INSTANCE.binarySearchFrameId(uiSlices, frameId), (Slice)rtSlice, INSTANCE.binarySearchFrameId(expectedSlices, frameId), INSTANCE.binarySearchFrameId(actualSlices, frameId)) == null) continue;
                boolean bl14 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl15;
            block37: {
                $this$none$iv = slices;
                $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl15 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Slice)element$iv;
                        boolean bl16 = false;
                        if (!(it.getFrameId() != null)) continue;
                        bl15 = false;
                        break block37;
                    }
                    bl15 = true;
                }
            }
            if (!bl15) {
                String $i$f$none3 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$none3.toString());
            }
            $this$mapNotNull$iv = rtSlices;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = 0;
            answer$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (answer$iv$iv$iv2.hasNext()) {
                FrameData it$iv$iv2;
                Object v10;
                FrameData.Companion companion;
                block38: {
                    void $this$firstOrNull$iv;
                    element$iv$iv = element$iv$iv$iv = answer$iv$iv$iv2.next();
                    bl = false;
                    rtSlice = (Slice)element$iv$iv;
                    boolean bl17 = false;
                    Iterable frameId = uiSlices;
                    companion = FrameData.Companion;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Slice it4 = (Slice)element$iv;
                        boolean bl18 = false;
                        if (!it4.contains(((Slice)rtSlice).getTs())) continue;
                        v10 = element$iv;
                        break block38;
                    }
                    v10 = null;
                }
                if (companion.tryCreateBasic(v10, (Slice)rtSlice) == null) continue;
                boolean bl19 = false;
                destination$iv$iv.add(it$iv$iv2);
            }
            list = (List)destination$iv$iv;
        }
        List frameData = list;
        $this$mapNotNull$iv = SubMetric.values();
        boolean $i$f$filter2 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (void element$iv$iv4 : $this$filterTo$iv$iv) {
            void it5 = element$iv$iv4;
            boolean bl20 = false;
            if (!it5.supportedOnApiLevel(captureApiLevel)) continue;
            destination$iv$iv.add(element$iv$iv4);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv5 : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            SubMetric answer$iv$iv$iv2 = (SubMetric)((Object)element$iv$iv5);
            Object t = element$iv$iv5;
            Map map = result$iv;
            boolean bl21 = false;
            Iterable $this$map$iv2 = frameData;
            boolean $i$f$map2 = false;
            rtSlice = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void subMetric;
                void frame;
                it$iv$iv = (FrameData)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl22 = false;
                collection.add(frame.get((SubMetric)subMetric));
            }
            List list3 = (List)destination$iv$iv4;
            map.put(t, list3);
        }
        return result$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "", "(Ljava/lang/String;I)V", "supportedOnApiLevel", "", "apiLevel", "", "FrameDurationCpuNs", "FrameDurationUiNs", "FrameOverrunNs", "benchmark-macro_release"})
    public static final class SubMetric
    extends Enum<SubMetric> {
        public static final /* enum */ SubMetric FrameDurationCpuNs = new SubMetric();
        public static final /* enum */ SubMetric FrameDurationUiNs = new SubMetric();
        public static final /* enum */ SubMetric FrameOverrunNs = new SubMetric();
        private static final /* synthetic */ SubMetric[] $VALUES;

        public final boolean supportedOnApiLevel(int apiLevel) {
            return apiLevel >= 31 || this != FrameOverrunNs;
        }

        public static SubMetric[] values() {
            return (SubMetric[])$VALUES.clone();
        }

        public static SubMetric valueOf(String value) {
            return Enum.valueOf(SubMetric.class, value);
        }

        static {
            $VALUES = subMetricArray = new SubMetric[]{SubMetric.FrameDurationCpuNs, SubMetric.FrameDurationUiNs, SubMetric.FrameOverrunNs};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameSliceType;", "", "(Ljava/lang/String;I)V", "Expected", "Actual", "UiThread", "RenderThread", "benchmark-macro_release"})
    public static final class FrameSliceType
    extends Enum<FrameSliceType> {
        public static final /* enum */ FrameSliceType Expected = new FrameSliceType();
        public static final /* enum */ FrameSliceType Actual = new FrameSliceType();
        public static final /* enum */ FrameSliceType UiThread = new FrameSliceType();
        public static final /* enum */ FrameSliceType RenderThread = new FrameSliceType();
        private static final /* synthetic */ FrameSliceType[] $VALUES;

        public static FrameSliceType[] values() {
            return (FrameSliceType[])$VALUES.clone();
        }

        public static FrameSliceType valueOf(String value) {
            return Enum.valueOf(FrameSliceType.class, value);
        }

        static {
            $VALUES = frameSliceTypeArray = new FrameSliceType[]{FrameSliceType.Expected, FrameSliceType.Actual, FrameSliceType.UiThread, FrameSliceType.RenderThread};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData;", "", "uiSlice", "Landroidx/benchmark/macro/perfetto/Slice;", "rtSlice", "expectedSlice", "actualSlice", "(Landroidx/benchmark/macro/perfetto/Slice;Landroidx/benchmark/macro/perfetto/Slice;Landroidx/benchmark/macro/perfetto/Slice;Landroidx/benchmark/macro/perfetto/Slice;)V", "getActualSlice", "()Landroidx/benchmark/macro/perfetto/Slice;", "getExpectedSlice", "getRtSlice", "getUiSlice", "get", "", "subMetric", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "Companion", "benchmark-macro_release"})
    private static final class FrameData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Slice uiSlice;
        @NotNull
        private final Slice rtSlice;
        @Nullable
        private final Slice expectedSlice;
        @Nullable
        private final Slice actualSlice;

        public FrameData(@NotNull Slice uiSlice, @NotNull Slice rtSlice, @Nullable Slice expectedSlice, @Nullable Slice actualSlice) {
            Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
            Intrinsics.checkNotNullParameter((Object)rtSlice, (String)"rtSlice");
            this.uiSlice = uiSlice;
            this.rtSlice = rtSlice;
            this.expectedSlice = expectedSlice;
            this.actualSlice = actualSlice;
        }

        @NotNull
        public final Slice getUiSlice() {
            return this.uiSlice;
        }

        @NotNull
        public final Slice getRtSlice() {
            return this.rtSlice;
        }

        @Nullable
        public final Slice getExpectedSlice() {
            return this.expectedSlice;
        }

        @Nullable
        public final Slice getActualSlice() {
            return this.actualSlice;
        }

        public final long get(@NotNull SubMetric subMetric) {
            long l;
            Intrinsics.checkNotNullParameter((Object)((Object)subMetric), (String)"subMetric");
            switch (WhenMappings.$EnumSwitchMapping$0[subMetric.ordinal()]) {
                case 1: {
                    l = this.rtSlice.getEndTs() - this.uiSlice.getTs();
                    break;
                }
                case 2: {
                    l = this.uiSlice.getDur();
                    break;
                }
                case 3: {
                    Slice slice = this.actualSlice;
                    Intrinsics.checkNotNull((Object)slice);
                    long l2 = slice.getEndTs();
                    Slice slice2 = this.expectedSlice;
                    Intrinsics.checkNotNull((Object)slice2);
                    l = l2 - slice2.getEndTs();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData$Companion;", "", "()V", "tryCreate31", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData;", "uiSlice", "Landroidx/benchmark/macro/perfetto/Slice;", "rtSlice", "expectedSlice", "actualSlice", "tryCreateBasic", "benchmark-macro_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final FrameData tryCreateBasic(@Nullable Slice uiSlice, @Nullable Slice rtSlice) {
                FrameData frameData;
                Slice slice = uiSlice;
                if (slice == null) {
                    frameData = null;
                } else {
                    Slice it = slice;
                    boolean bl = false;
                    Slice slice2 = rtSlice;
                    if (slice2 == null) {
                        frameData = null;
                    } else {
                        Slice it2 = slice2;
                        boolean bl2 = false;
                        frameData = new FrameData(uiSlice, rtSlice, null, null);
                    }
                }
                return frameData;
            }

            @Nullable
            public final FrameData tryCreate31(@Nullable Slice uiSlice, @Nullable Slice rtSlice, @Nullable Slice expectedSlice, @Nullable Slice actualSlice) {
                return uiSlice != null && rtSlice != null && expectedSlice != null && actualSlice != null ? new FrameData(uiSlice, rtSlice, expectedSlice, actualSlice) : (FrameData)null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SubMetric.values().length];
                nArray[SubMetric.FrameDurationCpuNs.ordinal()] = 1;
                nArray[SubMetric.FrameDurationUiNs.ordinal()] = 2;
                nArray[SubMetric.FrameOverrunNs.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

