/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.StartupMode;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.Slice;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nH\u0002J0\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\u00a8\u0006\u001b"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery;", "", "()V", "findEndRenderTimeForUiFrame", "", "uiSlices", "", "Landroidx/benchmark/macro/perfetto/Slice;", "rtSlices", "predicate", "Lkotlin/Function1;", "", "getFrameSubMetrics", "Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "absoluteTracePath", "", "captureApiLevel", "", "targetPackageName", "testPackageName", "startupMode", "Landroidx/benchmark/macro/StartupMode;", "getFullQuery", "testProcessName", "targetProcessName", "StartupSliceType", "SubMetrics", "benchmark-macro_release"})
public final class StartupTimingQuery {
    @NotNull
    public static final StartupTimingQuery INSTANCE = new StartupTimingQuery();

    private StartupTimingQuery() {
    }

    private final String getFullQuery(String testProcessName, String targetProcessName) {
        return StringsKt.trimIndent((String)("\n        ------ Select all startup-relevant slices from slice table\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN thread_track on slice.track_id = thread_track.id\n            INNER JOIN thread USING(utid)\n            INNER JOIN process USING(upid)\n        WHERE (\n            (process.name LIKE \"" + testProcessName + "\" AND slice.name LIKE \"startActivityAndWait\") OR\n            (\n                process.name LIKE \"" + targetProcessName + "\" AND (\n                    (slice.name LIKE \"activityResume\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"Choreographer#doFrame%\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"reportFullyDrawn() for %\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"DrawFrame%\" AND thread.name LIKE \"RenderThread\")\n                )\n            ) OR\n            (\n                -- Signals beginning of launch event, only present in API 29+\n                process.name LIKE \"system_server\" AND\n                slice.name LIKE \"MetricsLogger:launchObserverNotifyIntentStarted\"\n            )\n        )\n        ------ Add in async slices\n        UNION\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN process_track on slice.track_id = process_track.id\n            INNER JOIN process USING(upid)\n        WHERE (\n            -- API 23+:   \"launching: <target>\"\n            -- API 19-22: \"launching\"\n            slice.name LIKE \"launching%\" AND process.name LIKE \"system_server\"\n        )\n        ORDER BY ts ASC\n    "));
    }

    private final long findEndRenderTimeForUiFrame(List<Slice> uiSlices, List<Slice> rtSlices, Function1<? super Slice, Boolean> predicate) {
        Object element$iv3;
        block3: {
            Object element$iv22;
            block2: {
                Iterable $this$first$iv = uiSlices;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    if (!((Boolean)predicate.invoke(element$iv22)).booleanValue()) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Slice uiSlice = (Slice)element$iv22;
            Iterable $this$first$iv = rtSlices;
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                Slice rtSlice = (Slice)element$iv3;
                boolean bl = false;
                if (!(rtSlice.getTs() > uiSlice.getTs())) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Slice rtSlice = (Slice)element$iv3;
        return rtSlice.getEndTs();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SubMetrics getFrameSubMetrics(@NotNull String absoluteTracePath, int captureApiLevel, @NotNull String targetPackageName, @NotNull String testPackageName, @NotNull StartupMode startupMode) {
        Long l;
        Slice reportFullyDrawnSlice;
        Long launchingSlice;
        Object $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Slice it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        Intrinsics.checkNotNullParameter((Object)testPackageName, (String)"testPackageName");
        Intrinsics.checkNotNullParameter((Object)((Object)startupMode), (String)"startupMode");
        String queryResult = PerfettoTraceProcessor.INSTANCE.rawQuery$benchmark_macro_release(absoluteTracePath, this.getFullQuery(testPackageName, targetPackageName));
        List<Slice> slices = Slice.Companion.parseListFromQueryResult(queryResult);
        Iterable iterable = slices;
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Slice)element$iv$iv;
            boolean bl = false;
            if (!(it.getDur() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            StartupSliceType startupSliceType;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (Slice)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it.getName(), (String)"Choreographer#doFrame", (boolean)false, (int)2, null)) {
                startupSliceType = StartupSliceType.FrameUiThread;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"DrawFrame", (boolean)false, (int)2, null)) {
                startupSliceType = StartupSliceType.FrameRenderThread;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"launching", (boolean)false, (int)2, null)) {
                startupSliceType = StartupSliceType.Launching;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"reportFullyDrawn", (boolean)false, (int)2, null)) {
                startupSliceType = StartupSliceType.ReportFullyDrawn;
            } else if (Intrinsics.areEqual((Object)it.getName(), (Object)"MetricsLogger:launchObserverNotifyIntentStarted")) {
                startupSliceType = StartupSliceType.NotifyStarted;
            } else if (Intrinsics.areEqual((Object)it.getName(), (Object)"activityResume")) {
                startupSliceType = StartupSliceType.ActivityResume;
            } else if (Intrinsics.areEqual((Object)it.getName(), (Object)"startActivityAndWait")) {
                startupSliceType = StartupSliceType.StartActivityAndWait;
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected slice ", (Object)it));
            }
            StartupSliceType key$iv$iv = startupSliceType;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object groupedData = destination$iv$iv;
        List list = (List)groupedData.get((Object)StartupSliceType.StartActivityAndWait);
        Slice slice = $i$f$groupBy = list == null ? null : (Slice)CollectionsKt.first((List)list);
        if ($i$f$groupBy == null) {
            return null;
        }
        Slice startActivityAndWaitSlice = $i$f$groupBy;
        $this$groupByTo$iv$iv = groupedData;
        destination$iv$iv = StartupSliceType.FrameUiThread;
        Object object = $this$groupByTo$iv$iv.get(destination$iv$iv);
        if (object == null) {
            boolean bl = false;
            object = CollectionsKt.emptyList();
        }
        List uiSlices = (List)object;
        destination$iv$iv = groupedData;
        StartupSliceType startupSliceType = StartupSliceType.FrameRenderThread;
        Object object2 = destination$iv$iv.get((Object)startupSliceType);
        if (object2 == null) {
            boolean bl = false;
            object2 = CollectionsKt.emptyList();
        }
        List rtSlices = (List)object2;
        long startTs = 0L;
        long initialDisplayTs = 0L;
        if (captureApiLevel >= 29 || startupMode != StartupMode.HOT) {
            long l2;
            Long bl;
            Object object3;
            List list2 = (List)groupedData.get((Object)StartupSliceType.Launching);
            if (list2 == null) {
                object3 = null;
            } else {
                Object v9;
                block38: {
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Slice it2 = (Slice)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = startActivityAndWaitSlice.contains(it2.getTs()) && (captureApiLevel < 23 || Intrinsics.areEqual((Object)it2.getName(), (Object)Intrinsics.stringPlus((String)"launching: ", (Object)targetPackageName)));
                        if (!bl4) continue;
                        v9 = element$iv;
                        break block38;
                    }
                    v9 = null;
                }
                object3 = bl = (Slice)v9;
            }
            if (bl == null) {
                return null;
            }
            launchingSlice = bl;
            if (captureApiLevel >= 29) {
                Slice slice2;
                Slice slice3;
                List list3 = (List)groupedData.get((Object)StartupSliceType.NotifyStarted);
                if (list3 == null) {
                    slice3 = null;
                } else {
                    Object v12;
                    block39: {
                        List $this$lastOrNull$iv = list3;
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            Object element$iv = iterator$iv.previous();
                            Slice it3 = (Slice)element$iv;
                            boolean bl5 = false;
                            if (!(it3.getTs() < ((Slice)((Object)launchingSlice)).getTs())) continue;
                            v12 = element$iv;
                            break block39;
                        }
                        v12 = null;
                    }
                    slice3 = slice2 = (Slice)v12;
                }
                if (slice2 == null) {
                    return null;
                }
                Slice notifyStartedSlice = slice2;
                l2 = notifyStartedSlice.getTs();
            } else {
                l2 = ((Slice)((Object)launchingSlice)).getTs();
            }
            startTs = l2;
            initialDisplayTs = this.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>((Slice)((Object)launchingSlice)){
                final /* synthetic */ Slice $launchingSlice;
                {
                    this.$launchingSlice = $launchingSlice;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Slice uiSlice) {
                    Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                    return uiSlice.getTs() > this.$launchingSlice.getTs();
                }
            }));
        } else {
            Long l3;
            List list4 = (List)groupedData.get((Object)StartupSliceType.ActivityResume);
            if (list4 == null) {
                l3 = null;
            } else {
                Slice slice4 = (Slice)CollectionsKt.first((List)list4);
                l3 = launchingSlice = slice4 == null ? null : Long.valueOf(slice4.getTs());
            }
            if (launchingSlice == null) {
                return null;
            }
            startTs = launchingSlice;
            initialDisplayTs = this.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>(startTs){
                final /* synthetic */ long $startTs;
                {
                    this.$startTs = $startTs;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Slice uiSlice) {
                    Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                    return uiSlice.getTs() > this.$startTs;
                }
            }));
        }
        List list5 = (List)groupedData.get((Object)StartupSliceType.ReportFullyDrawn);
        Slice slice5 = reportFullyDrawnSlice = list5 == null ? null : (Slice)CollectionsKt.firstOrNull((List)list5);
        if (slice5 == null) {
            l = null;
        } else {
            Slice it4 = slice5;
            boolean bl = false;
            l = INSTANCE.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>(reportFullyDrawnSlice){
                final /* synthetic */ Slice $reportFullyDrawnSlice;
                {
                    this.$reportFullyDrawnSlice = $reportFullyDrawnSlice;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Slice uiSlice) {
                    Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                    return uiSlice.getEndTs() > this.$reportFullyDrawnSlice.getTs();
                }
            }));
        }
        Long reportFullyDrawnEndTs2 = l;
        return new SubMetrics(startTs, initialDisplayTs, reportFullyDrawnEndTs2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery$StartupSliceType;", "", "(Ljava/lang/String;I)V", "StartActivityAndWait", "NotifyStarted", "Launching", "ReportFullyDrawn", "FrameUiThread", "FrameRenderThread", "ActivityResume", "benchmark-macro_release"})
    public static final class StartupSliceType
    extends Enum<StartupSliceType> {
        public static final /* enum */ StartupSliceType StartActivityAndWait = new StartupSliceType();
        public static final /* enum */ StartupSliceType NotifyStarted = new StartupSliceType();
        public static final /* enum */ StartupSliceType Launching = new StartupSliceType();
        public static final /* enum */ StartupSliceType ReportFullyDrawn = new StartupSliceType();
        public static final /* enum */ StartupSliceType FrameUiThread = new StartupSliceType();
        public static final /* enum */ StartupSliceType FrameRenderThread = new StartupSliceType();
        public static final /* enum */ StartupSliceType ActivityResume = new StartupSliceType();
        private static final /* synthetic */ StartupSliceType[] $VALUES;

        public static StartupSliceType[] values() {
            return (StartupSliceType[])$VALUES.clone();
        }

        public static StartupSliceType valueOf(String value) {
            return Enum.valueOf(StartupSliceType.class, value);
        }

        static {
            $VALUES = startupSliceTypeArray = new StartupSliceType[]{StartupSliceType.StartActivityAndWait, StartupSliceType.NotifyStarted, StartupSliceType.Launching, StartupSliceType.ReportFullyDrawn, StartupSliceType.FrameUiThread, StartupSliceType.FrameRenderThread, StartupSliceType.ActivityResume};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J.\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "", "startTs", "", "initialDisplayTs", "fullDisplayTs", "(JJLjava/lang/Long;)V", "timeToInitialDisplayNs", "timeToFullDisplayNs", "timelineRangeNs", "Lkotlin/ranges/LongRange;", "(JLjava/lang/Long;Lkotlin/ranges/LongRange;)V", "getTimeToFullDisplayNs", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getTimeToInitialDisplayNs", "()J", "getTimelineRangeNs", "()Lkotlin/ranges/LongRange;", "component1", "component2", "component3", "copy", "(JLjava/lang/Long;Lkotlin/ranges/LongRange;)Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "equals", "", "other", "hashCode", "", "toString", "", "benchmark-macro_release"})
    public static final class SubMetrics {
        private final long timeToInitialDisplayNs;
        @Nullable
        private final Long timeToFullDisplayNs;
        @NotNull
        private final LongRange timelineRangeNs;

        public SubMetrics(long timeToInitialDisplayNs, @Nullable Long timeToFullDisplayNs, @NotNull LongRange timelineRangeNs) {
            Intrinsics.checkNotNullParameter((Object)timelineRangeNs, (String)"timelineRangeNs");
            this.timeToInitialDisplayNs = timeToInitialDisplayNs;
            this.timeToFullDisplayNs = timeToFullDisplayNs;
            this.timelineRangeNs = timelineRangeNs;
        }

        public final long getTimeToInitialDisplayNs() {
            return this.timeToInitialDisplayNs;
        }

        @Nullable
        public final Long getTimeToFullDisplayNs() {
            return this.timeToFullDisplayNs;
        }

        @NotNull
        public final LongRange getTimelineRangeNs() {
            return this.timelineRangeNs;
        }

        /*
         * WARNING - void declaration
         */
        public SubMetrics(long startTs, long initialDisplayTs, @Nullable Long fullDisplayTs) {
            Long l;
            SubMetrics subMetrics = this;
            long l2 = initialDisplayTs - startTs;
            Long l3 = fullDisplayTs;
            if (l3 == null) {
                l = null;
            } else {
                void it;
                long l4 = ((Number)l3).longValue();
                long l5 = l2;
                SubMetrics subMetrics2 = subMetrics;
                boolean bl = false;
                Long l6 = (long)(it - startTs);
                subMetrics = subMetrics2;
                l2 = l5;
                l = l6;
            }
            Long l7 = fullDisplayTs;
            subMetrics(l2, l, new LongRange(startTs, l7 == null ? initialDisplayTs : l7));
        }

        public final long component1() {
            return this.timeToInitialDisplayNs;
        }

        @Nullable
        public final Long component2() {
            return this.timeToFullDisplayNs;
        }

        @NotNull
        public final LongRange component3() {
            return this.timelineRangeNs;
        }

        @NotNull
        public final SubMetrics copy(long timeToInitialDisplayNs, @Nullable Long timeToFullDisplayNs, @NotNull LongRange timelineRangeNs) {
            Intrinsics.checkNotNullParameter((Object)timelineRangeNs, (String)"timelineRangeNs");
            return new SubMetrics(timeToInitialDisplayNs, timeToFullDisplayNs, timelineRangeNs);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, long l, Long l2, LongRange longRange, int n, Object object) {
            if ((n & 1) != 0) {
                l = subMetrics.timeToInitialDisplayNs;
            }
            if ((n & 2) != 0) {
                l2 = subMetrics.timeToFullDisplayNs;
            }
            if ((n & 4) != 0) {
                longRange = subMetrics.timelineRangeNs;
            }
            return subMetrics.copy(l, l2, longRange);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(timeToInitialDisplayNs=" + this.timeToInitialDisplayNs + ", timeToFullDisplayNs=" + this.timeToFullDisplayNs + ", timelineRangeNs=" + this.timelineRangeNs + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.timeToInitialDisplayNs);
            result = result * 31 + (this.timeToFullDisplayNs == null ? 0 : ((Object)this.timeToFullDisplayNs).hashCode());
            result = result * 31 + this.timelineRangeNs.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (this.timeToInitialDisplayNs != subMetrics.timeToInitialDisplayNs) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeToFullDisplayNs, (Object)subMetrics.timeToFullDisplayNs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timelineRangeNs, (Object)subMetrics.timelineRangeNs);
        }
    }
}

