/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.perfetto.ForceTracing;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import androidx.tracing.Trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0012\u0010\u001e\u001a\u00020\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010!\u001a\u00020\u001b2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001b0#H\u0007J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020$J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0003H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118F@@X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Landroidx/benchmark/macro/MacrobenchmarkScope;", "", "packageName", "", "launchWithClearTask", "", "(Ljava/lang/String;Z)V", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "device", "Landroidx/test/uiautomator/UiDevice;", "getDevice", "()Landroidx/test/uiautomator/UiDevice;", "instrumentation", "Landroid/app/Instrumentation;", "<set-?>", "", "iteration", "getIteration", "()Ljava/lang/Integer;", "setIteration$benchmark_macro_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getPackageName", "()Ljava/lang/String;", "dropKernelPageCache", "", "dropKernelPageCacheSetProp", "killProcess", "pressHome", "delayDurationMs", "", "startActivityAndWait", "block", "Lkotlin/Function1;", "Landroid/content/Intent;", "intent", "startActivityImpl", "uri", "benchmark-macro_release"})
public final class MacrobenchmarkScope {
    @NotNull
    private final String packageName;
    private final boolean launchWithClearTask;
    private final Instrumentation instrumentation;
    private final Context context;
    @Nullable
    private Integer iteration;
    @NotNull
    private final UiDevice device;

    public MacrobenchmarkScope(@NotNull String packageName, boolean launchWithClearTask) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        this.launchWithClearTask = launchWithClearTask;
        this.instrumentation = InstrumentationRegistry.getInstrumentation();
        this.context = this.instrumentation.getContext();
        UiDevice uiDevice = UiDevice.getInstance((Instrumentation)this.instrumentation);
        Intrinsics.checkNotNullExpressionValue((Object)uiDevice, (String)"getInstance(instrumentation)");
        this.device = uiDevice;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final Integer getIteration() {
        return this.iteration;
    }

    public final void setIteration$benchmark_macro_release(@Nullable Integer n) {
        this.iteration = n;
    }

    @NotNull
    public final UiDevice getDevice() {
        return this.device;
    }

    @JvmOverloads
    public final void startActivityAndWait(@NotNull Function1<? super Intent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intent intent = this.context.getPackageManager().getLaunchIntentForPackage(this.packageName);
        if (intent == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unable to acquire intent for package ", (Object)this.packageName));
        }
        Intent intent2 = intent;
        block.invoke((Object)intent2);
        this.startActivityAndWait(intent2);
    }

    public static /* synthetic */ void startActivityAndWait$default(MacrobenchmarkScope macrobenchmarkScope, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = startActivityAndWait.1.INSTANCE;
        }
        macrobenchmarkScope.startActivityAndWait((Function1<? super Intent, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startActivityAndWait(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String label$iv = "startActivityAndWait";
        boolean $i$f$forceTrace = false;
        ForceTracing.INSTANCE.begin(label$iv);
        try {
            boolean bl = false;
            intent.addFlags(0x10000000);
            if (this.launchWithClearTask) {
                intent.addFlags(32768);
            }
            String string = intent.toUri(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intent.toUri(Intent.URI_INTENT_SCHEME)");
            this.startActivityImpl(string);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            ForceTracing.INSTANCE.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void startActivityImpl(String uri) {
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String cmd = "am start -W \"" + uri + '\"';
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Starting activity with command: ", (Object)cmd));
        Shell.Output result = Shell.executeScriptWithStderr$default((Shell)Shell.INSTANCE, (String)cmd, null, (int)2, null);
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)result.getStdout(), (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"Error:", (boolean)false, (int)2, null)) continue;
            throw new IllegalStateException(it);
        }
        if (StringsKt.contains$default((CharSequence)result.getStderr(), (CharSequence)"java.lang.SecurityException", (boolean)false, (int)2, null)) {
            throw new SecurityException(result.getStderr());
        }
        if (((CharSequence)result.getStderr()).length() > 0) {
            throw new IllegalStateException(result.getStderr());
        }
        if (Build.VERSION.SDK_INT < 29) {
            String label$iv = "sleeping to ensure am start completed";
            boolean $i$f$trace = false;
            try {
                Trace.beginSection((String)label$iv);
                boolean bl = false;
                Thread.sleep(250L);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Trace.endSection();
            }
        }
    }

    @JvmOverloads
    public final void pressHome(long delayDurationMs) {
        this.device.pressHome();
        Thread.sleep(delayDurationMs);
    }

    public static /* synthetic */ void pressHome$default(MacrobenchmarkScope macrobenchmarkScope, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 300L;
        }
        macrobenchmarkScope.pressHome(l);
    }

    public final void killProcess() {
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Killing process ", (Object)this.packageName));
        this.device.executeShellCommand(Intrinsics.stringPlus((String)"am force-stop ", (Object)this.packageName));
    }

    @RequiresApi(value=31)
    private final void dropKernelPageCacheSetProp() {
        Shell.Output result = Shell.executeScriptWithStderr$default((Shell)Shell.INSTANCE, (String)"setprop perf.drop_caches 3", null, (int)2, null);
        if (!(((CharSequence)result.getStdout()).length() == 0 && ((CharSequence)result.getStderr()).length() == 0)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Failed to trigger drop cache via setprop: ", (Object)result);
            throw new IllegalStateException(string.toString());
        }
        int n = 50;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            Thread.sleep(50L);
            String getPropResult = ((Object)StringsKt.trim((CharSequence)Shell.INSTANCE.executeCommand("getprop perf.drop_caches"))).toString();
            if (Intrinsics.areEqual((Object)getPropResult, (Object)"0")) {
                return;
            }
            if (Intrinsics.areEqual((Object)getPropResult, (Object)"3")) continue;
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unable to drop caches: Failed to read drop cache via getprop: ", (Object)getPropResult));
        }
        throw new IllegalStateException("Unable to drop caches: Did not observe perf.drop_caches reset automatically");
    }

    public final void dropKernelPageCache() {
        if (Build.VERSION.SDK_INT >= 31) {
            this.dropKernelPageCacheSetProp();
        } else {
            String result = ((Object)StringsKt.trim((CharSequence)Shell.executeScript$default((Shell)Shell.INSTANCE, (String)"echo 3 > /proc/sys/vm/drop_caches && echo Success || echo Failure", null, (int)2, null))).toString();
            if (!Intrinsics.areEqual((Object)result, (Object)"Success")) {
                if (DeviceInfo.INSTANCE.isRooted() && !Shell.INSTANCE.isSessionRooted()) {
                    throw new IllegalStateException("Failed to drop caches - run `adb root`");
                }
                Log.w((String)"Benchmark", (String)("Failed to drop kernel page cache, result: '" + result + '\''));
            }
        }
    }

    @JvmOverloads
    public final void startActivityAndWait() {
        MacrobenchmarkScope.startActivityAndWait$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void pressHome() {
        MacrobenchmarkScope.pressHome$default(this, 0L, 1, null);
    }
}

