/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery;", "", "()V", "VAL_MAX", "", "VAL_NAME", "VAL_TS", "VAL_VALUE", "getFullQuery", "", "getSubMetrics", "Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery$SubMetrics;", "absoluteTracePath", "SubMetrics", "benchmark-macro_release"})
public final class AudioUnderrunQuery {
    @NotNull
    public static final AudioUnderrunQuery INSTANCE = new AudioUnderrunQuery();
    private static final int VAL_NAME = 0;
    private static final int VAL_VALUE = 1;
    private static final int VAL_TS = 2;
    private static final int VAL_MAX = 3;

    private AudioUnderrunQuery() {
    }

    private final String getFullQuery() {
        return "SELECT track.name, counter.value, counter.ts\nFROM track\nJOIN counter ON track.id = counter.track_id\nWHERE track.type = 'process_counter_track' AND track.name LIKE 'nRdy%'";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SubMetrics getSubMetrics(@NotNull String absoluteTracePath) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        String queryResult = PerfettoTraceProcessor.INSTANCE.rawQuery$benchmark_macro_release(absoluteTracePath, this.getFullQuery());
        String[] stringArray = new String[]{"\n"};
        List resultLines = StringsKt.split$default((CharSequence)queryResult, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!Intrinsics.areEqual((Object)CollectionsKt.first((List)resultLines), (Object)"\"name\",\"value\",\"ts\"")) {
            throw new IllegalStateException("query failed!");
        }
        if (resultLines.size() <= 3) {
            throw new RuntimeException("No playing audio detected");
        }
        Object trackName = null;
        Long lastTs = null;
        long totalNs = 0L;
        long zeroNs = 0L;
        Iterable iterable = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)resultLines, (int)1), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{","};
            List lineVals = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (lineVals.size() != 3) {
                throw new IllegalStateException("query failed");
            }
            if (trackName == null) {
                trackName = lineVals.get(0);
            } else if (!StringsKt.equals$default((String)trackName, (String)((String)lineVals.get(0)), (boolean)false, (int)2, null)) {
                throw new RuntimeException("There could be only one AudioTrack per measure");
            }
            if (lastTs == null) {
                lastTs = Long.parseLong((String)lineVals.get(2));
                continue;
            }
            long frameNs = Long.parseLong((String)lineVals.get(2)) - ((Number)lastTs).longValue();
            lastTs = Long.parseLong((String)lineVals.get(2));
            totalNs += frameNs;
            int frameCounter = (int)Double.parseDouble((String)lineVals.get(1));
            if (frameCounter != 0) continue;
            zeroNs += frameNs;
        }
        return new SubMetrics((int)(totalNs / (long)1000000), (int)(zeroNs / (long)1000000));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery$SubMetrics;", "", "totalMs", "", "zeroMs", "(II)V", "getTotalMs", "()I", "getZeroMs", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "benchmark-macro_release"})
    public static final class SubMetrics {
        private final int totalMs;
        private final int zeroMs;

        public SubMetrics(int totalMs, int zeroMs) {
            this.totalMs = totalMs;
            this.zeroMs = zeroMs;
        }

        public final int getTotalMs() {
            return this.totalMs;
        }

        public final int getZeroMs() {
            return this.zeroMs;
        }

        public final int component1() {
            return this.totalMs;
        }

        public final int component2() {
            return this.zeroMs;
        }

        @NotNull
        public final SubMetrics copy(int totalMs, int zeroMs) {
            return new SubMetrics(totalMs, zeroMs);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = subMetrics.totalMs;
            }
            if ((n3 & 2) != 0) {
                n2 = subMetrics.zeroMs;
            }
            return subMetrics.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(totalMs=" + this.totalMs + ", zeroMs=" + this.zeroMs + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.totalMs);
            result = result * 31 + Integer.hashCode(this.zeroMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (this.totalMs != subMetrics.totalMs) {
                return false;
            }
            return this.zeroMs == subMetrics.zeroMs;
        }
    }
}

