/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.benchmark.macro.BaselineProfilesKt;
import androidx.benchmark.macro.CompilationMode;
import androidx.benchmark.macro.MacrobenchmarkKt;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.StartupProfilesKt;
import androidx.benchmark.macro.Summary;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0002\u001aK\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\u0002\b\u0013H\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0003\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0001\u001a\u001e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001d"}, d2={"deviceSpecifier", "", "getDeviceSpecifier", "()Ljava/lang/String;", "deviceSpecifier$delegate", "Lkotlin/Lazy;", "applyPackageFilters", "profile", "packageFilters", "", "collectBaselineProfile", "", "uniqueName", "packageName", "iterations", "", "profileBlock", "Lkotlin/Function1;", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "Lkotlin/ExtensionFunctionType;", "extractProfile", "extractProfileRooted", "filterProfileRulesToTargetP", "profmanGetProfileRules", "apkPath", "pathOptions", "summaryRecord", "record", "Landroidx/benchmark/macro/Summary;", "benchmark-macro_release"})
public final class BaselineProfilesKt {
    @NotNull
    private static final Lazy deviceSpecifier$delegate = LazyKt.lazy((Function0)deviceSpecifier.2.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=28)
    @JvmOverloads
    public static final void collectBaselineProfile(@NotNull String uniqueName, @NotNull String packageName, int iterations, @NotNull List<String> packageFilters, @NotNull Function1<? super MacrobenchmarkScope, Unit> profileBlock) {
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(packageFilters, (String)"packageFilters");
        Intrinsics.checkNotNullParameter(profileBlock, (String)"profileBlock");
        if (!(Build.VERSION.SDK_INT >= 33 || Build.VERSION.SDK_INT >= 28 && Shell.INSTANCE.isSessionRooted())) {
            boolean bl = false;
            String string = "Baseline Profile collection requires API 33+, or a rooted device running API 28 or higher and rooted adb session (via `adb root`).";
            throw new IllegalArgumentException(string.toString());
        }
        MacrobenchmarkKt.getInstalledPackageInfo(packageName);
        long startTime = System.nanoTime();
        MacrobenchmarkScope scope = new MacrobenchmarkScope(packageName, true);
        Function0 killProcessBlock2 = (Function0)new Function0<Unit>(scope){
            final /* synthetic */ MacrobenchmarkScope $scope;
            {
                this.$scope = $scope;
                super(0);
            }

            public final void invoke() {
                this.$scope.killProcess(Shell.INSTANCE.isSessionRooted());
                Thread.sleep(Arguments.INSTANCE.getKillProcessDelayMillis());
            }
        };
        killProcessBlock2.invoke();
        try {
            String label$iv = "generate profile for " + packageName;
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                boolean bl = false;
                Ref.IntRef iteration = new Ref.IntRef();
                new CompilationMode.Partial(BaselineProfileMode.Disable, iterations).resetAndCompile$benchmark_macro_release(packageName, (Function0<Unit>)killProcessBlock2, (Function0<Unit>)((Function0)new Function0<Unit>(scope, iteration, profileBlock){
                    final /* synthetic */ MacrobenchmarkScope $scope;
                    final /* synthetic */ Ref.IntRef $iteration;
                    final /* synthetic */ Function1<MacrobenchmarkScope, Unit> $profileBlock;
                    {
                        this.$scope = $scope;
                        this.$iteration = $iteration;
                        this.$profileBlock = $profileBlock;
                        super(0);
                    }

                    public final void invoke() {
                        int n = this.$iteration.element;
                        this.$iteration.element = n + 1;
                        this.$scope.setIteration$benchmark_macro_release(n);
                        this.$profileBlock.invoke((Object)this.$scope);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
            }
            String unfilteredProfile = Build.VERSION.SDK_INT >= 33 ? BaselineProfilesKt.extractProfile(packageName) : BaselineProfilesKt.extractProfileRooted(packageName);
            if (!(!StringsKt.isBlank((CharSequence)unfilteredProfile))) {
                boolean $i$a$-check-BaselineProfilesKt$collectBaselineProfile$42 = false;
                String $i$a$-check-BaselineProfilesKt$collectBaselineProfile$42 = "Generated Profile is empty, before filtering. Ensure your profileBlock invokes the target app, and runs a non-trivial amount of code";
                throw new IllegalStateException($i$a$-check-BaselineProfilesKt$collectBaselineProfile$42.toString());
            }
            String profile = BaselineProfilesKt.filterProfileRulesToTargetP(unfilteredProfile);
            Ref.ObjectRef startupProfile = new Ref.ObjectRef();
            if (Arguments.INSTANCE.getEnableStartupProfiles()) {
                startupProfile.element = StartupProfilesKt.startupProfile(profile, Arguments.INSTANCE.getStrictStartupProfiles());
            }
            String filteredProfile = BaselineProfilesKt.applyPackageFilters(profile, packageFilters);
            String fileName = uniqueName + "-baseline-prof.txt";
            String absolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)fileName, (String)"baseline-profile", (boolean)false, (Function1)((Function1)new Function1<File, Unit>(filteredProfile){
                final /* synthetic */ String $filteredProfile;
                {
                    this.$filteredProfile = $filteredProfile;
                    super(1);
                }

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    FilesKt.writeText$default((File)it, (String)this.$filteredProfile, null, (int)2, null);
                }
            }), (int)4, null);
            String startupProfilePath = null;
            if (startupProfile.element != null) {
                String startupProfileFileName = uniqueName + "-startup-prof.txt";
                startupProfilePath = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)startupProfileFileName, (String)"startup-profile", (boolean)false, (Function1)((Function1)new Function1<File, Unit>((Ref.ObjectRef<String>)startupProfile){
                    final /* synthetic */ Ref.ObjectRef<String> $startupProfile;
                    {
                        this.$startupProfile = $startupProfile;
                        super(1);
                    }

                    public final void invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FilesKt.writeText$default((File)it, (String)((String)this.$startupProfile.element), null, (int)2, null);
                    }
                }), (int)4, null);
            }
            String tsFileName = uniqueName + "-baseline-prof-" + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".txt";
            String tsAbsolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)tsFileName, (String)"baseline-profile-ts", (boolean)false, (Function1)((Function1)new Function1<File, Unit>(filteredProfile){
                final /* synthetic */ String $filteredProfile;
                {
                    this.$filteredProfile = $filteredProfile;
                    super(1);
                }

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Log.d((String)"Benchmark", (String)("Pull Baseline Profile with: `adb pull \"" + it.getAbsolutePath() + "\" .`"));
                    FilesKt.writeText$default((File)it, (String)this.$filteredProfile, null, (int)2, null);
                }
            }), (int)4, null);
            String tsStartupAbsolutePath = null;
            if (startupProfile.element != null) {
                String tsStartupFileName = uniqueName + "-startup-prof-" + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".txt";
                tsStartupAbsolutePath = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)tsStartupFileName, (String)"startup-profile-ts", (boolean)false, (Function1)((Function1)new Function1<File, Unit>((Ref.ObjectRef<String>)startupProfile){
                    final /* synthetic */ Ref.ObjectRef<String> $startupProfile;
                    {
                        this.$startupProfile = $startupProfile;
                        super(1);
                    }

                    public final void invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Log.d((String)"Benchmark", (String)("Pull Startup Profile with: `adb pull \"" + it.getAbsolutePath() + "\" .`"));
                        FilesKt.writeText$default((File)it, (String)((String)this.$startupProfile.element), null, (int)2, null);
                    }
                }), (int)4, null);
            }
            long totalRunTime = System.nanoTime() - startTime;
            Summary results = new Summary(totalRunTime, absolutePath2, tsAbsolutePath2, startupProfilePath, tsStartupAbsolutePath);
            InstrumentationResults.INSTANCE.instrumentationReport((Function1)new Function1<InstrumentationResultScope, Unit>(results, totalRunTime){
                final /* synthetic */ Summary $results;
                final /* synthetic */ long $totalRunTime;
                {
                    this.$results = $results;
                    this.$totalRunTime = $totalRunTime;
                    super(1);
                }

                public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                    Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                    String summary = BaselineProfilesKt.access$summaryRecord(this.$results);
                    $this$instrumentationReport.ideSummaryRecord(summary, summary);
                    Log.d((String)"Benchmark", (String)("Total Run Time Ns: " + this.$totalRunTime));
                }
            });
        }
        finally {
            killProcessBlock2.invoke();
        }
    }

    public static /* synthetic */ void collectBaselineProfile$default(String string, String string2, int n, List list, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        BaselineProfilesKt.collectBaselineProfile(string, string2, n, list, (Function1<? super MacrobenchmarkScope, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=33)
    private static final String extractProfile(String packageName) {
        Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("pm dump-profiles --dump-classes-and-methods " + packageName), null, (int)2, null);
        String fileName = packageName + "-primary.prof.txt";
        Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("mv /data/misc/profman/" + fileName + ' ' + Outputs.INSTANCE.getDirUsableByAppAndShell() + '/'), null, (int)2, null);
        File rawRuleOutput = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), fileName);
        try {
            String string = FilesKt.readText$default((File)rawRuleOutput, null, (int)1, null);
            return string;
        }
        finally {
            rawRuleOutput.delete();
        }
    }

    private static final String extractProfileRooted(String packageName) {
        String referenceProfile = "/data/misc/profiles/ref/" + packageName + "/primary.prof";
        String currentProfile = "/data/misc/profiles/cur/0/" + packageName + "/primary.prof";
        Log.d((String)"Benchmark", (String)("Reference profile location: " + referenceProfile));
        String pathResult = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("pm path " + packageName), null, (int)2, null);
        String apkPath = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)pathResult, (String)"package:", null, (int)2, null))).toString();
        Log.d((String)"Benchmark", (String)("APK Path: " + apkPath));
        Log.d((String)"Benchmark", (String)"Converting to human readable profile format");
        Object[] objectArray = new String[]{referenceProfile, currentProfile};
        return BaselineProfilesKt.profmanGetProfileRules(apkPath, CollectionsKt.listOf((Object[])objectArray));
    }

    private static final String profmanGetProfileRules(String apkPath, List<String> pathOptions) {
        for (String currentPath : pathOptions) {
            Log.d((String)"Benchmark", (String)("Using profile location: " + currentPath));
            String profile = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("profman --dump-classes-and-methods --profile-file=" + currentPath + " --apk=" + apkPath), null, (int)2, null);
            if (!(!StringsKt.isBlank((CharSequence)profile))) continue;
            return profile;
        }
        throw new IllegalStateException("The profile is empty.");
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final String filterProfileRulesToTargetP(@NotNull String profile) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        List rules = StringsKt.lines((CharSequence)profile);
        Iterable $this$filterNot$iv = rules;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String rule = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)rule, (String)"[", (boolean)false, (int)2, null) ? true : StringsKt.contains$default((CharSequence)rule, (CharSequence)"+", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredRules = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)filteredRules, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String applyPackageFilters(String profile, List<String> packageFilters) {
        String string;
        if (packageFilters.isEmpty()) {
            string = profile;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = packageFilters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.replace$default((String)it, (String)".", (String)"/", (boolean)false, (int)4, null) + (StringsKt.endsWith$default((String)it, (String)".", (boolean)false, (int)2, null) ? "" : "/"));
            }
            List fixedPackageFilters = (List)destination$iv$iv;
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)profile);
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block7: {
                    String line = (String)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = fixedPackageFilters;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            String string3 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator()");
            string = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    private static final String summaryRecord(Summary record) {
        StringBuilder summary = new StringBuilder();
        String relativePath = StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor(record.getProfileTsPath()), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null);
        summary.append(StringsKt.trimIndent((String)("\n            Total run time Ns: " + record.getTotalRunTime() + ".\n            Baseline profile [results](file://" + relativePath + ")\n        ")));
        String startupTsProfilePath = record.getStartupTsProfilePath();
        CharSequence charSequence = startupTsProfilePath;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String startupRelativePath = StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor(startupTsProfilePath), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null);
            summary.append("\n").append(StringsKt.trimIndent((String)("\n                Startup profile [results](file://" + startupRelativePath + ")\n            ")));
        }
        summary.append("\n").append("\n").append(StringsKt.trimIndent((String)("\n                To copy the profile use:\n                adb pull " + BaselineProfilesKt.getDeviceSpecifier() + '\"' + record.getProfilePath() + "\" .\n            ")));
        String startupProfilePath = record.getStartupProfilePath();
        CharSequence charSequence2 = startupProfilePath;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            summary.append("\n").append("\n").append(StringsKt.trimIndent((String)("\n                    To copy the startup profile use:\n                    adb pull " + BaselineProfilesKt.getDeviceSpecifier() + '\"' + record.getStartupProfilePath() + "\" .\n                ")));
        }
        String string = summary.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"summary.toString()");
        return string;
    }

    @NotNull
    public static final String getDeviceSpecifier() {
        Lazy lazy = deviceSpecifier$delegate;
        return (String)lazy.getValue();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=28)
    @JvmOverloads
    public static final void collectBaselineProfile(@NotNull String uniqueName, @NotNull String packageName, int iterations, @NotNull Function1<? super MacrobenchmarkScope, Unit> profileBlock) {
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(profileBlock, (String)"profileBlock");
        BaselineProfilesKt.collectBaselineProfile$default(uniqueName, packageName, iterations, null, profileBlock, 8, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=28)
    @JvmOverloads
    public static final void collectBaselineProfile(@NotNull String uniqueName, @NotNull String packageName, @NotNull Function1<? super MacrobenchmarkScope, Unit> profileBlock) {
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(profileBlock, (String)"profileBlock");
        BaselineProfilesKt.collectBaselineProfile$default(uniqueName, packageName, 0, null, profileBlock, 12, null);
    }

    public static final /* synthetic */ String access$summaryRecord(Summary record) {
        return BaselineProfilesKt.summaryRecord(record);
    }
}

