/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.benchmark.Shell;
import androidx.profileinstaller.ProfileInstallReceiver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/benchmark/macro/ProfileInstallBroadcast;", "", "()V", "receiverName", "", "kotlin.jvm.PlatformType", "benchmarkOperation", "packageName", "operation", "dropShaderCache", "installProfile", "saveProfile", "skipFileOperation", "benchmark-macro_release"})
public final class ProfileInstallBroadcast {
    @NotNull
    public static final ProfileInstallBroadcast INSTANCE = new ProfileInstallBroadcast();
    private static final String receiverName = ProfileInstallReceiver.class.getName();

    private ProfileInstallBroadcast() {
    }

    @Nullable
    public final String installProfile(@NotNull String packageName) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Integer result;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)"Profile Installer - Install profile");
        String action = "androidx.profileinstaller.action.INSTALL_PROFILE";
        Integer n = result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("am broadcast -a " + action + ' ' + packageName + '/' + receiverName), null, (int)2, null), (String)"Broadcast completed: result=", null, (int)2, null))).toString());
        if (n == null ? true : n == 0) {
            return "The baseline profile install broadcast was not received. This most likely means that the profileinstaller library is missing from the target apk.";
        }
        Integer n2 = n;
        int n3 = 1;
        if (n2 != null && n2 == n3) {
            return null;
        }
        Integer n4 = n;
        n3 = 2;
        if (n4 != null && n4 == n3) {
            throw new RuntimeException("Unable to install baseline profile. This most likely means that the latest version of the profileinstaller library is not being used. Please use the latest profileinstaller library version in the target app.");
        }
        Integer n5 = n;
        n3 = 3;
        if (n5 != null && n5 == n3) {
            throw new RuntimeException("Baseline profiles aren't supported on this device version");
        }
        Integer n6 = n;
        n3 = 6;
        if (n6 != null && n6 == n3) {
            return "No baseline profile was found in the target apk.";
        }
        Integer n7 = n;
        n3 = 4;
        if (n7 != null && n7 == n3) {
            bl3 = true;
        } else {
            Integer n8 = n;
            n3 = 5;
            bl3 = n8 != null && n8 == n3;
        }
        if (bl3) {
            bl2 = true;
        } else {
            Integer n9 = n;
            n3 = 7;
            bl2 = n9 != null && n9 == n3;
        }
        if (bl2) {
            bl = true;
        } else {
            Integer n10 = n;
            n3 = 8;
            bl = n10 != null && n10 == n3;
        }
        if (bl) {
            throw new RuntimeException("Baseline Profile wasn't successfully installed");
        }
        throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String skipFileOperation(@NotNull String packageName, @NotNull String operation) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Log.d((String)"Benchmark", (String)("Profile Installer - Skip File Operation: " + operation));
        String action = "androidx.profileinstaller.action.SKIP_FILE";
        String operationKey = "EXTRA_SKIP_FILE_OPERATION";
        String extras = operationKey + ' ' + operation;
        Integer result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("am broadcast -a " + action + " -e " + extras + ' ' + packageName + '/' + receiverName), null, (int)2, null), (String)"Broadcast completed: result=", null, (int)2, null))).toString());
        if (result == null) return "The baseline profile skip file broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.2.0-alpha03` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        if (result == 0) {
            return "The baseline profile skip file broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.2.0-alpha03` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"WRITE_SKIP_FILE")) {
            n = 10;
            if (result == n) {
                string = null;
                return string;
            }
        }
        if (!Intrinsics.areEqual((Object)operation, (Object)"DELETE_SKIP_FILE")) throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
        n = 11;
        if (result != n) throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
        string = null;
        return string;
    }

    @RequiresApi(value=24)
    @Nullable
    public final String saveProfile(@NotNull String packageName) {
        String string;
        Integer result;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)"Profile Installer - Save Profile");
        String action = "androidx.profileinstaller.action.SAVE_PROFILE";
        Integer n2 = n = (result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("am broadcast -a " + action + ' ' + packageName + '/' + receiverName), null, (int)2, null), (String)"Broadcast completed: result=", null, (int)2, null))).toString()));
        if (n2 == null ? true : n2 == 0) {
            string = "The save profile broadcast event was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.3.0-alpha01` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        } else {
            Integer n3 = n;
            int n4 = 12;
            if (n3 != null && n3 == n4) {
                Thread.sleep(500L);
                string = null;
            } else {
                throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
            }
        }
        return string;
    }

    private final String benchmarkOperation(String packageName, String operation) {
        String string;
        int n;
        boolean bl;
        Integer result;
        Integer n2;
        Log.d((String)"Benchmark", (String)("Profile Installer - Benchmark Operation: " + operation));
        String action = "androidx.profileinstaller.action.BENCHMARK_OPERATION";
        String operationKey = "EXTRA_BENCHMARK_OPERATION";
        String extras = operationKey + ' ' + operation;
        Integer n3 = n2 = (result = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("am broadcast -a " + action + " -e " + extras + ' ' + packageName + '/' + receiverName), null, (int)2, null), (String)"Broadcast completed: result=", null, (int)2, null))).toString()));
        if (n3 == null ? true : n3 == 0) {
            bl = true;
        } else {
            Integer n4 = n2;
            n = 16;
            bl = n4 != null && n4 == n;
        }
        if (bl) {
            string = "The " + operation + " broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.3.0-alpha02` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        } else {
            Integer n5 = n2;
            n = 15;
            if (n5 != null && n5 == n) {
                string = "The " + operation + " broadcast failed.";
            } else {
                Integer n6 = n2;
                n = 14;
                if (n6 != null && n6 == n) {
                    string = null;
                } else {
                    throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
                }
            }
        }
        return string;
    }

    @Nullable
    public final String dropShaderCache(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.benchmarkOperation(packageName, "DROP_SHADER_CACHE");
    }
}

