/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.macro.IterationResult;
import androidx.benchmark.macro.Metric;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.AndroidStartupMetric;
import perfetto.protos.TraceMetrics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/macro/StartupTimingLegacyMetric;", "Landroidx/benchmark/macro/Metric;", "()V", "configure", "", "packageName", "", "configure$benchmark_macro_release", "getMetrics", "Landroidx/benchmark/macro/IterationResult;", "captureInfo", "Landroidx/benchmark/macro/Metric$CaptureInfo;", "perfettoTraceProcessor", "Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "getMetrics$benchmark_macro_release", "start", "start$benchmark_macro_release", "stop", "stop$benchmark_macro_release", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@RequiresApi(value=29)
public final class StartupTimingLegacyMetric
extends Metric {
    public StartupTimingLegacyMetric() {
        super(null);
    }

    @Override
    public void configure$benchmark_macro_release(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
    }

    @Override
    public void start$benchmark_macro_release() {
    }

    @Override
    public void stop$benchmark_macro_release() {
    }

    @Override
    @NotNull
    public IterationResult getMetrics$benchmark_macro_release(@NotNull Metric.CaptureInfo captureInfo, @NotNull PerfettoTraceProcessor perfettoTraceProcessor) {
        Double fullyDrawnMs;
        Double durMs;
        Object element$iv2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
            Intrinsics.checkNotNullParameter((Object)perfettoTraceProcessor, (String)"perfettoTraceProcessor");
            TraceMetrics traceMetrics = perfettoTraceProcessor.getTraceMetrics("android_startup");
            AndroidStartupMetric androidStartupMetric = traceMetrics.getAndroid_startup();
            if (androidStartupMetric == null) {
                throw new IllegalStateException("No android_startup metric found.");
            }
            AndroidStartupMetric androidStartup = androidStartupMetric;
            Iterable $this$first$iv = androidStartup.getStartup();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                AndroidStartupMetric.Startup it = (AndroidStartupMetric.Startup)((Object)element$iv2);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPackage_name(), (Object)captureInfo.getTargetPackageName())) continue;
                break block4;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        AndroidStartupMetric.Startup appStartup = (AndroidStartupMetric.Startup)((Object)element$iv2);
        Map metricMap = new LinkedHashMap();
        AndroidStartupMetric.ToFirstFrame toFirstFrame = appStartup.getTo_first_frame();
        Double d = durMs = toFirstFrame != null ? toFirstFrame.getDur_ms() : null;
        if (durMs != null) {
            metricMap.put("startupMs", durMs);
        }
        AndroidStartupMetric.Slice slice = appStartup.getReport_fully_drawn();
        Double d2 = fullyDrawnMs = slice != null ? slice.getDur_ms() : null;
        if (fullyDrawnMs != null) {
            metricMap.put("fullyDrawnMs", fullyDrawnMs);
        }
        AndroidStartupMetric.EventTimestamps eventTimestamps = appStartup.getEvent_timestamps();
        Long timelineStart = eventTimestamps != null ? eventTimestamps.getIntent_received() : null;
        AndroidStartupMetric.EventTimestamps eventTimestamps2 = appStartup.getEvent_timestamps();
        Long timelineEnd = eventTimestamps2 != null ? eventTimestamps2.getFirst_frame() : null;
        return new IterationResult(metricMap, MapsKt.emptyMap(), timelineStart != null && timelineEnd != null ? new LongRange(timelineStart.longValue(), timelineEnd.longValue()) : (LongRange)null);
    }
}

