/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.Slice;
import androidx.benchmark.macro.perfetto.server.QueryResultIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Landroidx/benchmark/macro/perfetto/BatteryDischargeQuery;", "", "()V", "getBatteryDischargeMetrics", "", "Landroidx/benchmark/macro/perfetto/BatteryDischargeQuery$BatteryDischargeMeasurement;", "perfettoTraceProcessor", "Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "slice", "Landroidx/benchmark/macro/perfetto/Slice;", "getFullQuery", "", "BatteryDischargeMeasurement", "benchmark-macro_release"})
public final class BatteryDischargeQuery {
    @NotNull
    public static final BatteryDischargeQuery INSTANCE = new BatteryDischargeQuery();

    private BatteryDischargeQuery() {
    }

    private final String getFullQuery(Slice slice) {
        return StringsKt.trimIndent((String)("\n        SELECT\n            max(c.value)/1000 AS startMah,\n            min(c.value)/1000 AS endMah,\n            max(c.value)/1000 - min(c.value)/1000 AS diffMah\n        FROM counter c\n        JOIN counter_track t ON c.track_id = t.id\n        WHERE t.name = 'batt.charge_uah'\n        AND c.ts >= " + slice.getTs() + " AND c.ts <= " + slice.getEndTs() + "\n    "));
    }

    @NotNull
    public final List<BatteryDischargeMeasurement> getBatteryDischargeMetrics(@NotNull PerfettoTraceProcessor perfettoTraceProcessor, @NotNull Slice slice) {
        Intrinsics.checkNotNullParameter((Object)perfettoTraceProcessor, (String)"perfettoTraceProcessor");
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        QueryResultIterator queryResult = perfettoTraceProcessor.rawQuery(this.getFullQuery(slice));
        if (queryResult.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (queryResult.size() != 1) {
            throw new IllegalStateException("Unexpected query result size for battery discharge.");
        }
        Object row = queryResult.next();
        Object[] objectArray = new BatteryDischargeMeasurement[3];
        Object v = row.get("startMah");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Double");
        objectArray[0] = new BatteryDischargeMeasurement("Start", (Double)v);
        Object v2 = row.get("endMah");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Double");
        objectArray[1] = new BatteryDischargeMeasurement("End", (Double)v2);
        Object v3 = row.get("diffMah");
        Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Double");
        objectArray[2] = new BatteryDischargeMeasurement("Diff", (Double)v3);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/macro/perfetto/BatteryDischargeQuery$BatteryDischargeMeasurement;", "", "name", "", "chargeMah", "", "(Ljava/lang/String;D)V", "getChargeMah", "()D", "setChargeMah", "(D)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "benchmark-macro_release"})
    public static final class BatteryDischargeMeasurement {
        @NotNull
        private String name;
        private double chargeMah;

        public BatteryDischargeMeasurement(@NotNull String name, double chargeMah) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.chargeMah = chargeMah;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final double getChargeMah() {
            return this.chargeMah;
        }

        public final void setChargeMah(double d) {
            this.chargeMah = d;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final double component2() {
            return this.chargeMah;
        }

        @NotNull
        public final BatteryDischargeMeasurement copy(@NotNull String name, double chargeMah) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BatteryDischargeMeasurement(name, chargeMah);
        }

        public static /* synthetic */ BatteryDischargeMeasurement copy$default(BatteryDischargeMeasurement batteryDischargeMeasurement, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = batteryDischargeMeasurement.name;
            }
            if ((n & 2) != 0) {
                d = batteryDischargeMeasurement.chargeMah;
            }
            return batteryDischargeMeasurement.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "BatteryDischargeMeasurement(name=" + this.name + ", chargeMah=" + this.chargeMah + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Double.hashCode(this.chargeMah);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BatteryDischargeMeasurement)) {
                return false;
            }
            BatteryDischargeMeasurement batteryDischargeMeasurement = (BatteryDischargeMeasurement)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)batteryDischargeMeasurement.name)) {
                return false;
            }
            return Double.compare(this.chargeMah, batteryDischargeMeasurement.chargeMah) == 0;
        }
    }
}

