/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.annotation.RestrictTo;
import androidx.benchmark.UserspaceTracing;
import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.Slice;
import androidx.benchmark.macro.perfetto.SliceKt;
import androidx.benchmark.macro.perfetto.server.PerfettoHttpServer;
import androidx.benchmark.macro.perfetto.server.QueryResultIterator;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.AppendTraceDataResult;
import perfetto.protos.ComputeMetricResult;
import perfetto.protos.TraceMetrics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0013\"\u00020\fH\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0000H\u0002J\b\u0010\u001a\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "", "()V", "perfettoHttpServer", "Landroidx/benchmark/macro/perfetto/server/PerfettoHttpServer;", "traceLoaded", "", "clearTrace", "", "getTraceMetrics", "Lperfetto/protos/TraceMetrics;", "metric", "", "loadTrace", "absoluteTracePath", "querySlices", "", "Landroidx/benchmark/macro/perfetto/Slice;", "sliceNames", "", "querySlices$benchmark_macro_release", "([Ljava/lang/String;)Ljava/util/List;", "rawQuery", "Landroidx/benchmark/macro/perfetto/server/QueryResultIterator;", "query", "startServer", "stopServer", "Companion", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PerfettoTraceProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PerfettoHttpServer perfettoHttpServer = new PerfettoHttpServer();
    private boolean traceLoaded;
    public static final int PORT = 9001;
    @NotNull
    private static final Lazy<String> shellPath$delegate = LazyKt.lazy((Function0)Companion.shellPath.2.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PerfettoTraceProcessor startServer() {
        PerfettoTraceProcessor perfettoTraceProcessor;
        String label$iv = "PerfettoTraceProcessor#startServer";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            this.perfettoHttpServer.startServer();
            perfettoTraceProcessor = this;
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
        return perfettoTraceProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopServer() {
        String label$iv = "PerfettoTraceProcessor#stopServer";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            this.perfettoHttpServer.stopServer();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadTrace(@NotNull String absoluteTracePath) {
        Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
        String label$iv = "PerfettoTraceProcessor#loadTrace";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)absoluteTracePath, (CharSequence)" ", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-PerfettoTraceProcessor$loadTrace$1$32 = false;
                String $i$a$-require-PerfettoTraceProcessor$loadTrace$1$32 = "Trace path must not contain spaces: " + absoluteTracePath;
                throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$loadTrace$1$32.toString());
            }
            File traceFile = new File(absoluteTracePath);
            if (!(traceFile.exists() && traceFile.isFile())) {
                boolean bl2 = false;
                String string = "Trace path must exist and not be a directory: " + absoluteTracePath;
                throw new IllegalArgumentException(string.toString());
            }
            if (this.traceLoaded) {
                this.clearTrace();
            }
            this.traceLoaded = false;
            AppendTraceDataResult parseResult = this.perfettoHttpServer.parse(FilesKt.readBytes((File)traceFile));
            if (parseResult.getError() != null) {
                throw new IllegalStateException(parseResult.getError());
            }
            this.perfettoHttpServer.notifyEof();
            this.traceLoaded = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearTrace() {
        String label$iv = "PerfettoTraceProcessor#clearTrace";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            this.perfettoHttpServer.restoreInitialTables();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TraceMetrics getTraceMetrics(@NotNull String metric) {
        TraceMetrics traceMetrics;
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        String label$iv = "PerfettoTraceProcessor#getTraceMetrics " + metric;
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)metric, (CharSequence)" ", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-PerfettoTraceProcessor$getTraceMetrics$1$32 = false;
                String $i$a$-require-PerfettoTraceProcessor$getTraceMetrics$1$32 = "Metric must not contain spaces: " + metric;
                throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$getTraceMetrics$1$32.toString());
            }
            if (!this.perfettoHttpServer.isRunning()) {
                boolean bl2 = false;
                String string = "Perfetto trace_shell_process is not running.";
                throw new IllegalArgumentException(string.toString());
            }
            ComputeMetricResult computeResult = this.perfettoHttpServer.computeMetric(CollectionsKt.listOf((Object)metric));
            if (computeResult.getError() != null) {
                throw new IllegalStateException(computeResult.getError());
            }
            ByteString byteString = computeResult.getMetrics();
            Intrinsics.checkNotNull((Object)byteString);
            traceMetrics = (TraceMetrics)((Object)TraceMetrics.ADAPTER.decode(byteString));
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
        return traceMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final QueryResultIterator rawQuery(@NotNull String query2) {
        QueryResultIterator queryResultIterator;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        String label$iv = StringsKt.take((String)("PerfettoTraceProcessor#rawQuery " + query2), (int)127);
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (!this.perfettoHttpServer.isRunning()) {
                boolean bl2 = false;
                String string = "Perfetto trace_shell_process is not running.";
                throw new IllegalArgumentException(string.toString());
            }
            queryResultIterator = this.perfettoHttpServer.query(query2);
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
        return queryResultIterator;
    }

    @NotNull
    public final List<Slice> querySlices$benchmark_macro_release(String ... sliceNames) {
        Intrinsics.checkNotNullParameter((Object)sliceNames, (String)"sliceNames");
        if (!this.perfettoHttpServer.isRunning()) {
            boolean $i$a$-require-PerfettoTraceProcessor$querySlices$22 = false;
            String $i$a$-require-PerfettoTraceProcessor$querySlices$22 = "Perfetto trace_shell_process is not running.";
            throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$querySlices$22.toString());
        }
        String whereClause2 = ArraysKt.joinToString$default((Object[])sliceNames, (CharSequence)" OR ", null, null, (int)0, null, (Function1)querySlices.whereClause.1.INSTANCE, (int)30, null);
        QueryResultIterator queryResultIterator = this.rawQuery(StringsKt.trimMargin$default((String)("\n                SELECT slice.name,ts,dur\n                FROM slice\n                WHERE " + whereClause2 + "\n            "), null, (int)1, null));
        return SliceKt.toSlices(queryResultIterator);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor$Companion;", "", "()V", "PORT", "", "shellPath", "", "getShellPath", "()Ljava/lang/String;", "shellPath$delegate", "Lkotlin/Lazy;", "runServer", "T", "absoluteTracePath", "block", "Lkotlin/Function1;", "Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShellPath() {
            Lazy lazy = shellPath$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runServer(@Nullable String absoluteTracePath, @NotNull Function1<? super PerfettoTraceProcessor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            String label$iv = "PerfettoTraceProcessor#runServer";
            boolean $i$f$userspaceTrace = false;
            UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                PerfettoTraceProcessor perfettoTraceProcessor;
                Object object2;
                boolean bl = false;
                PerfettoTraceProcessor perfettoTraceProcessor2 = null;
                try {
                    Object object3;
                    perfettoTraceProcessor2 = new PerfettoTraceProcessor().startServer();
                    if (absoluteTracePath != null) {
                        perfettoTraceProcessor2.loadTrace(absoluteTracePath);
                    }
                    String label$iv2 = "PerfettoTraceProcessor#runServer#block";
                    boolean $i$f$userspaceTrace2 = false;
                    UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv2, (long)0L, (int)2, null);
                    try {
                        boolean bl2 = false;
                        object3 = block.invoke((Object)perfettoTraceProcessor2);
                    }
                    finally {
                        UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
                    }
                    object2 = object3;
                    perfettoTraceProcessor = perfettoTraceProcessor2;
                }
                catch (Throwable throwable) {
                    PerfettoTraceProcessor perfettoTraceProcessor3 = perfettoTraceProcessor2;
                    if (perfettoTraceProcessor3 != null) {
                        perfettoTraceProcessor3.stopServer();
                    }
                    throw throwable;
                }
                if (perfettoTraceProcessor != null) {
                    perfettoTraceProcessor.stopServer();
                }
                object = object2;
            }
            finally {
                UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
            }
            return (T)object;
        }

        public static /* synthetic */ Object runServer$default(Companion companion, String string, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.runServer(string, function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

