/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto.server;

import androidx.annotation.RestrictTo;
import androidx.benchmark.macro.perfetto.server.QueryResultIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.QueryResult;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000*\u0001\u0012\b\u0007\u0018\u00002\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\u0006\u0010\u0016\u001a\u00020\u0015J\u0017\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002H\u0096\u0002J\u0006\u0010\u0018\u001a\u00020\fJ4\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000e\"\u0004\b\u0000\u0010\u001a2 \u0010\u001b\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002\u0012\u0004\u0012\u0002H\u001a0\u001cR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001d"}, d2={"Landroidx/benchmark/macro/perfetto/server/QueryResultIterator;", "", "", "", "", "queryResult", "Lperfetto/protos/QueryResult;", "(Lperfetto/protos/QueryResult;)V", "cells", "", "Lperfetto/protos/QueryResult$CellsBatch$CellType;", "columnCount", "", "columnNames", "", "count", "currentIndex", "dataLists", "androidx/benchmark/macro/perfetto/server/QueryResultIterator$dataLists$1", "Landroidx/benchmark/macro/perfetto/server/QueryResultIterator$dataLists$1;", "hasNext", "", "isEmpty", "next", "size", "toList", "T", "mapFunc", "Lkotlin/Function1;", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class QueryResultIterator
implements Iterator<Map<String, ? extends Object>>,
KMappedMarker {
    @NotNull
    private final dataLists.1 dataLists;
    @NotNull
    private final List<QueryResult.CellsBatch.CellType> cells;
    @NotNull
    private final List<String> columnNames;
    private final int columnCount;
    private final int count;
    private int currentIndex;

    public QueryResultIterator(@NotNull QueryResult queryResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)queryResult), (String)"queryResult");
        this.dataLists = new Object(){
            @NotNull
            private final List<String> stringBatches;
            @NotNull
            private final List<Long> varIntBatches;
            @NotNull
            private final List<Double> float64Batches;
            @NotNull
            private final List<ByteString> blobBatches;
            private int stringIndex;
            private int varIntIndex;
            private int float64Index;
            private int blobIndex;
            {
                this.stringBatches = new ArrayList<E>();
                this.varIntBatches = new ArrayList<E>();
                this.float64Batches = new ArrayList<E>();
                this.blobBatches = new ArrayList<E>();
            }

            @NotNull
            public final List<String> getStringBatches() {
                return this.stringBatches;
            }

            @NotNull
            public final List<Long> getVarIntBatches() {
                return this.varIntBatches;
            }

            @NotNull
            public final List<Double> getFloat64Batches() {
                return this.float64Batches;
            }

            @NotNull
            public final List<ByteString> getBlobBatches() {
                return this.blobBatches;
            }

            public final int getStringIndex() {
                return this.stringIndex;
            }

            public final void setStringIndex(int n) {
                this.stringIndex = n;
            }

            public final int getVarIntIndex() {
                return this.varIntIndex;
            }

            public final void setVarIntIndex(int n) {
                this.varIntIndex = n;
            }

            public final int getFloat64Index() {
                return this.float64Index;
            }

            public final void setFloat64Index(int n) {
                this.float64Index = n;
            }

            public final int getBlobIndex() {
                return this.blobIndex;
            }

            public final void setBlobIndex(int n) {
                this.blobIndex = n;
            }
        };
        this.cells = new ArrayList();
        this.columnNames = queryResult.getColumn_names();
        for (QueryResult.CellsBatch batch : queryResult.getBatch()) {
            String string = batch.getString_cells();
            Intrinsics.checkNotNull((Object)string);
            char[] cArray = new char[]{'\u0000'};
            List stringsBatch = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1);
            this.dataLists.getStringBatches().addAll(stringsBatch);
            this.dataLists.getVarIntBatches().addAll((Collection<Long>)batch.getVarint_cells());
            this.dataLists.getFloat64Batches().addAll((Collection<Double>)batch.getFloat64_cells());
            this.dataLists.getBlobBatches().addAll((Collection<ByteString>)batch.getBlob_cells());
            this.cells.addAll((Collection<QueryResult.CellsBatch.CellType>)batch.getCells());
        }
        this.columnCount = this.columnNames.size();
        this.count = this.columnCount > 0 ? this.cells.size() / this.columnCount : 0;
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.count;
    }

    @Override
    @NotNull
    public Map<String, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map row = new LinkedHashMap();
        int baseCellIndex = this.currentIndex * this.columnCount;
        Iterator<String> iterator = this.columnNames.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object;
            int num = n++;
            String columnName = iterator.next();
            QueryResult.CellsBatch.CellType colType = this.cells.get(baseCellIndex + num);
            int colIndex = 0;
            Map map = row;
            switch (WhenMappings.$EnumSwitchMapping$0[colType.ordinal()]) {
                case 1: {
                    colIndex = this.dataLists.getStringIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setStringIndex(var11_11.getStringIndex() + 1);
                    object = this.dataLists.getStringBatches().get(colIndex);
                    break;
                }
                case 2: {
                    colIndex = this.dataLists.getVarIntIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setVarIntIndex(var11_11.getVarIntIndex() + 1);
                    object = this.dataLists.getVarIntBatches().get(colIndex);
                    break;
                }
                case 3: {
                    colIndex = this.dataLists.getFloat64Index();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setFloat64Index(var11_11.getFloat64Index() + 1);
                    object = this.dataLists.getFloat64Batches().get(colIndex);
                    break;
                }
                case 4: {
                    colIndex = this.dataLists.getBlobIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setBlobIndex(var11_11.getBlobIndex() + 1);
                    object = this.dataLists.getBlobBatches().get(colIndex);
                    break;
                }
                case 5: {
                    throw new IllegalArgumentException("Invalid cell type");
                }
                case 6: {
                    object = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string = object;
            map.put(columnName, string);
        }
        ++this.currentIndex;
        return row;
    }

    @NotNull
    public final <T> List<T> toList(@NotNull Function1<? super Map<String, ? extends Object>, ? extends T> mapFunc) {
        Intrinsics.checkNotNullParameter(mapFunc, (String)"mapFunc");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)this), mapFunc));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QueryResult.CellsBatch.CellType.values().length];
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_VARINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_FLOAT64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_BLOB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_INVALID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

