/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.macro.perfetto.server.QueryResultIterator;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery;", "", "()V", "EXPECTED_COLUMN_COUNT", "", "VAL_NAME", "", "VAL_TS", "VAL_VALUE", "getFullQuery", "getSubMetrics", "Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery$SubMetrics;", "perfettoTraceProcessor", "Landroidx/benchmark/macro/perfetto/PerfettoTraceProcessor;", "SubMetrics", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nAudioUnderrunQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioUnderrunQuery.kt\nandroidx/benchmark/macro/perfetto/AudioUnderrunQuery\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,77:1\n1295#2,2:78\n*S KotlinDebug\n*F\n+ 1 AudioUnderrunQuery.kt\nandroidx/benchmark/macro/perfetto/AudioUnderrunQuery\n*L\n44#1:78,2\n*E\n"})
public final class AudioUnderrunQuery {
    @NotNull
    public static final AudioUnderrunQuery INSTANCE = new AudioUnderrunQuery();
    @NotNull
    private static final String VAL_NAME = "name";
    @NotNull
    private static final String VAL_VALUE = "value";
    @NotNull
    private static final String VAL_TS = "ts";
    private static final int EXPECTED_COLUMN_COUNT = 3;

    private AudioUnderrunQuery() {
    }

    private final String getFullQuery() {
        return "SELECT track.name, counter.value, counter.ts\nFROM track\nJOIN counter ON track.id = counter.track_id\nWHERE track.type = 'process_counter_track' AND track.name LIKE 'nRdy%'";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SubMetrics getSubMetrics(@NotNull PerfettoTraceProcessor perfettoTraceProcessor) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)perfettoTraceProcessor, (String)"perfettoTraceProcessor");
        QueryResultIterator queryResult = perfettoTraceProcessor.rawQuery(this.getFullQuery());
        String trackName = null;
        Long lastTs = null;
        long totalNs = 0L;
        long zeroNs = 0L;
        Sequence sequence = SequencesKt.asSequence((Iterator)queryResult);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map lineVals = (Map)element$iv;
            boolean bl = false;
            if (lineVals.size() != 3) {
                throw new IllegalStateException("query failed");
            }
            if (trackName == null) {
                trackName = (String)lineVals.get(VAL_NAME);
            } else if (!Intrinsics.areEqual((Object)trackName, lineVals.get(VAL_NAME))) {
                throw new RuntimeException("There could be only one AudioTrack per measure");
            }
            if (lastTs == null) {
                Object v = lineVals.get(VAL_TS);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
                lastTs = (Long)v;
                continue;
            }
            Object v = lineVals.get(VAL_TS);
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Long");
            long frameNs = (Long)v - ((Number)lastTs).longValue();
            Object v2 = lineVals.get(VAL_TS);
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Long");
            lastTs = (Long)v2;
            totalNs += frameNs;
            Object v3 = lineVals.get(VAL_VALUE);
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Double");
            int frameCounter = (int)((Double)v3).doubleValue();
            if (frameCounter != 0) continue;
            zeroNs += frameNs;
        }
        return new SubMetrics((int)(totalNs / (long)1000000), (int)(zeroNs / (long)1000000));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/AudioUnderrunQuery$SubMetrics;", "", "totalMs", "", "zeroMs", "(II)V", "getTotalMs", "()I", "getZeroMs", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "benchmark-macro_release"})
    public static final class SubMetrics {
        private final int totalMs;
        private final int zeroMs;

        public SubMetrics(int totalMs, int zeroMs) {
            this.totalMs = totalMs;
            this.zeroMs = zeroMs;
        }

        public final int getTotalMs() {
            return this.totalMs;
        }

        public final int getZeroMs() {
            return this.zeroMs;
        }

        public final int component1() {
            return this.totalMs;
        }

        public final int component2() {
            return this.zeroMs;
        }

        @NotNull
        public final SubMetrics copy(int totalMs, int zeroMs) {
            return new SubMetrics(totalMs, zeroMs);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = subMetrics.totalMs;
            }
            if ((n3 & 2) != 0) {
                n2 = subMetrics.zeroMs;
            }
            return subMetrics.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(totalMs=" + this.totalMs + ", zeroMs=" + this.zeroMs + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.totalMs);
            result = result * 31 + Integer.hashCode(this.zeroMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (this.totalMs != subMetrics.totalMs) {
                return false;
            }
            return this.zeroMs == subMetrics.zeroMs;
        }
    }
}

