/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.util.Log;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.PerfettoTraceProcessorKt;
import androidx.benchmark.perfetto.Row;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/MemoryCountersQuery;", "", "()V", "MAJOR_PAGE_FAULTS_COUNT", "", "MEMORY_COMPACTION_EVENTS_COUNT", "MEMORY_RECLAIM_EVENTS_COUNT", "MINOR_PAGE_FAULTS_COUNT", "PAGE_FAULTS_BACKED_BY_READ_IO_COUNT", "PAGE_FAULTS_BACKED_BY_SWAP_CACHE_COUNT", "getFullQuery", "targetPackageName", "getFullQuery$benchmark_macro_release", "getMemoryCounters", "Landroidx/benchmark/macro/perfetto/MemoryCountersQuery$SubMetrics;", "session", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "SubMetrics", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nMemoryCountersQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCountersQuery.kt\nandroidx/benchmark/macro/perfetto/MemoryCountersQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1855#2,2:126\n*S KotlinDebug\n*F\n+ 1 MemoryCountersQuery.kt\nandroidx/benchmark/macro/perfetto/MemoryCountersQuery\n*L\n83#1:126,2\n*E\n"})
public final class MemoryCountersQuery {
    @NotNull
    public static final MemoryCountersQuery INSTANCE = new MemoryCountersQuery();
    @NotNull
    private static final String MINOR_PAGE_FAULTS_COUNT = "mem.mm.min_flt.count";
    @NotNull
    private static final String MAJOR_PAGE_FAULTS_COUNT = "mem.mm.maj_flt.count";
    @NotNull
    private static final String PAGE_FAULTS_BACKED_BY_SWAP_CACHE_COUNT = "mem.mm.swp_flt.count";
    @NotNull
    private static final String PAGE_FAULTS_BACKED_BY_READ_IO_COUNT = "mem.mm.read_io.count";
    @NotNull
    private static final String MEMORY_COMPACTION_EVENTS_COUNT = "mem.mm.compaction.count";
    @NotNull
    private static final String MEMORY_RECLAIM_EVENTS_COUNT = "mem.mm.reclaim.count";

    private MemoryCountersQuery() {
    }

    @Language(value="sql")
    @NotNull
    public final String getFullQuery$benchmark_macro_release(@NotNull String targetPackageName) {
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        return StringsKt.trimIndent((String)("\n        SELECT\n            track.name as counter_name,\n            process.name as process_name,\n            ts,\n            value\n        FROM counter\n            LEFT JOIN process_counter_track as track on counter.track_id = track.id\n            LEFT JOIN process using (upid)\n        WHERE\n            " + PerfettoTraceProcessorKt.processNameLikePkg(targetPackageName) + " AND\n            track.name LIKE 'mem.%.count'\n    "));
    }

    @Nullable
    public final SubMetrics getMemoryCounters(@NotNull PerfettoTraceProcessor.Session session, @NotNull String targetPackageName) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        Sequence<Row> queryResultIterator = session.query(this.getFullQuery$benchmark_macro_release(targetPackageName));
        double minorPageFaults = 0.0;
        double majorPageFaults = 0.0;
        double faultsBackedBySwapCache = 0.0;
        double faultsBackedByReadIO = 0.0;
        double memoryCompactionEvents = 0.0;
        double memoryReclaimEvents = 0.0;
        List rows = SequencesKt.toList(queryResultIterator);
        if (rows.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Row row = (Row)element$iv;
            boolean bl = false;
            switch (row.string("counter_name")) {
                case "mem.mm.min_flt.count": {
                    minorPageFaults += row.double("value");
                    break;
                }
                case "mem.mm.maj_flt.count": {
                    majorPageFaults += row.double("value");
                    break;
                }
                case "mem.mm.swp_flt.count": {
                    faultsBackedBySwapCache += row.double("value");
                    break;
                }
                case "mem.mm.read_io.count": {
                    faultsBackedByReadIO += row.double("value");
                    break;
                }
                case "mem.mm.compaction.count": {
                    memoryCompactionEvents += row.double("value");
                    break;
                }
                case "mem.mm.reclaim.count": {
                    memoryReclaimEvents += row.double("value");
                    break;
                }
                default: {
                    Log.d((String)"Benchmark", (String)("Unknown counter: " + row));
                }
            }
        }
        return new SubMetrics(minorPageFaults, majorPageFaults, faultsBackedBySwapCache, faultsBackedByReadIO, memoryCompactionEvents, memoryReclaimEvents);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/macro/perfetto/MemoryCountersQuery$SubMetrics;", "", "minorPageFaults", "", "majorPageFaults", "pageFaultsBackedBySwapCache", "pageFaultsBackedByReadIO", "memoryCompactionEvents", "memoryReclaimEvents", "(DDDDDD)V", "getMajorPageFaults", "()D", "getMemoryCompactionEvents", "getMemoryReclaimEvents", "getMinorPageFaults", "getPageFaultsBackedByReadIO", "getPageFaultsBackedBySwapCache", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "benchmark-macro_release"})
    public static final class SubMetrics {
        private final double minorPageFaults;
        private final double majorPageFaults;
        private final double pageFaultsBackedBySwapCache;
        private final double pageFaultsBackedByReadIO;
        private final double memoryCompactionEvents;
        private final double memoryReclaimEvents;

        public SubMetrics(double minorPageFaults, double majorPageFaults, double pageFaultsBackedBySwapCache, double pageFaultsBackedByReadIO, double memoryCompactionEvents, double memoryReclaimEvents) {
            this.minorPageFaults = minorPageFaults;
            this.majorPageFaults = majorPageFaults;
            this.pageFaultsBackedBySwapCache = pageFaultsBackedBySwapCache;
            this.pageFaultsBackedByReadIO = pageFaultsBackedByReadIO;
            this.memoryCompactionEvents = memoryCompactionEvents;
            this.memoryReclaimEvents = memoryReclaimEvents;
        }

        public final double getMinorPageFaults() {
            return this.minorPageFaults;
        }

        public final double getMajorPageFaults() {
            return this.majorPageFaults;
        }

        public final double getPageFaultsBackedBySwapCache() {
            return this.pageFaultsBackedBySwapCache;
        }

        public final double getPageFaultsBackedByReadIO() {
            return this.pageFaultsBackedByReadIO;
        }

        public final double getMemoryCompactionEvents() {
            return this.memoryCompactionEvents;
        }

        public final double getMemoryReclaimEvents() {
            return this.memoryReclaimEvents;
        }

        public final double component1() {
            return this.minorPageFaults;
        }

        public final double component2() {
            return this.majorPageFaults;
        }

        public final double component3() {
            return this.pageFaultsBackedBySwapCache;
        }

        public final double component4() {
            return this.pageFaultsBackedByReadIO;
        }

        public final double component5() {
            return this.memoryCompactionEvents;
        }

        public final double component6() {
            return this.memoryReclaimEvents;
        }

        @NotNull
        public final SubMetrics copy(double minorPageFaults, double majorPageFaults, double pageFaultsBackedBySwapCache, double pageFaultsBackedByReadIO, double memoryCompactionEvents, double memoryReclaimEvents) {
            return new SubMetrics(minorPageFaults, majorPageFaults, pageFaultsBackedBySwapCache, pageFaultsBackedByReadIO, memoryCompactionEvents, memoryReclaimEvents);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
            if ((n & 1) != 0) {
                d = subMetrics.minorPageFaults;
            }
            if ((n & 2) != 0) {
                d2 = subMetrics.majorPageFaults;
            }
            if ((n & 4) != 0) {
                d3 = subMetrics.pageFaultsBackedBySwapCache;
            }
            if ((n & 8) != 0) {
                d4 = subMetrics.pageFaultsBackedByReadIO;
            }
            if ((n & 0x10) != 0) {
                d5 = subMetrics.memoryCompactionEvents;
            }
            if ((n & 0x20) != 0) {
                d6 = subMetrics.memoryReclaimEvents;
            }
            return subMetrics.copy(d, d2, d3, d4, d5, d6);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(minorPageFaults=" + this.minorPageFaults + ", majorPageFaults=" + this.majorPageFaults + ", pageFaultsBackedBySwapCache=" + this.pageFaultsBackedBySwapCache + ", pageFaultsBackedByReadIO=" + this.pageFaultsBackedByReadIO + ", memoryCompactionEvents=" + this.memoryCompactionEvents + ", memoryReclaimEvents=" + this.memoryReclaimEvents + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.minorPageFaults);
            result = result * 31 + Double.hashCode(this.majorPageFaults);
            result = result * 31 + Double.hashCode(this.pageFaultsBackedBySwapCache);
            result = result * 31 + Double.hashCode(this.pageFaultsBackedByReadIO);
            result = result * 31 + Double.hashCode(this.memoryCompactionEvents);
            result = result * 31 + Double.hashCode(this.memoryReclaimEvents);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (Double.compare(this.minorPageFaults, subMetrics.minorPageFaults) != 0) {
                return false;
            }
            if (Double.compare(this.majorPageFaults, subMetrics.majorPageFaults) != 0) {
                return false;
            }
            if (Double.compare(this.pageFaultsBackedBySwapCache, subMetrics.pageFaultsBackedBySwapCache) != 0) {
                return false;
            }
            if (Double.compare(this.pageFaultsBackedByReadIO, subMetrics.pageFaultsBackedByReadIO) != 0) {
                return false;
            }
            if (Double.compare(this.memoryCompactionEvents, subMetrics.memoryCompactionEvents) != 0) {
                return false;
            }
            return Double.compare(this.memoryReclaimEvents, subMetrics.memoryReclaimEvents) == 0;
        }
    }
}

