/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/perfetto/Slice;", "", "name", "", "ts", "", "dur", "(Ljava/lang/String;JJ)V", "getDur", "()J", "endTs", "getEndTs", "frameId", "", "getFrameId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getName", "()Ljava/lang/String;", "getTs", "component1", "component2", "component3", "contains", "", "targetTs", "copy", "equals", "other", "hashCode", "toString", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Slice {
    @NotNull
    private final String name;
    private final long ts;
    private final long dur;
    private final long endTs;
    @Nullable
    private final Integer frameId;

    public Slice(@NotNull String name, long ts, long dur) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.ts = ts;
        this.dur = dur;
        this.endTs = this.ts + this.dur;
        this.frameId = StringsKt.toIntOrNull((String)StringsKt.substringAfterLast$default((String)this.name, (String)" ", null, (int)2, null));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getTs() {
        return this.ts;
    }

    public final long getDur() {
        return this.dur;
    }

    public final long getEndTs() {
        return this.endTs;
    }

    @Nullable
    public final Integer getFrameId() {
        return this.frameId;
    }

    public final boolean contains(long targetTs) {
        return targetTs >= this.ts && targetTs <= this.ts + this.dur;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final long component2() {
        return this.ts;
    }

    public final long component3() {
        return this.dur;
    }

    @NotNull
    public final Slice copy(@NotNull String name, long ts, long dur) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Slice(name, ts, dur);
    }

    public static /* synthetic */ Slice copy$default(Slice slice, String string, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = slice.name;
        }
        if ((n & 2) != 0) {
            l = slice.ts;
        }
        if ((n & 4) != 0) {
            l2 = slice.dur;
        }
        return slice.copy(string, l, l2);
    }

    @NotNull
    public String toString() {
        return "Slice(name=" + this.name + ", ts=" + this.ts + ", dur=" + this.dur + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Long.hashCode(this.ts);
        result = result * 31 + Long.hashCode(this.dur);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)slice.name)) {
            return false;
        }
        if (this.ts != slice.ts) {
            return false;
        }
        return this.dur == slice.dur;
    }
}

