/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.FrameStatsResult;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.ProfileInstallBroadcast;
import androidx.benchmark.macro.perfetto.ForceTracing;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import androidx.tracing.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0003J\u0006\u0010\u001d\u001a\u00020\u001bJ\r\u0010\u001e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001fJ\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b#J\u0012\u0010$\u001a\u00020\u001b2\b\b\u0002\u0010%\u001a\u00020\u0005H\u0007J\u0012\u0010&\u001a\u00020\u001b2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\u001e\u0010)\u001a\u00020\u001b2\u0014\b\u0002\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001b0+H\u0007J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020,J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0003H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118F@@X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Landroidx/benchmark/macro/MacrobenchmarkScope;", "", "packageName", "", "launchWithClearTask", "", "(Ljava/lang/String;Z)V", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "device", "Landroidx/test/uiautomator/UiDevice;", "getDevice", "()Landroidx/test/uiautomator/UiDevice;", "instrumentation", "Landroid/app/Instrumentation;", "<set-?>", "", "iteration", "getIteration", "()Ljava/lang/Integer;", "setIteration$benchmark_macro_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getPackageName", "()Ljava/lang/String;", "dropKernelPageCache", "", "dropKernelPageCacheSetProp", "dropShaderCache", "dropShaderCacheRoot", "dropShaderCacheRoot$benchmark_macro_release", "getFrameStats", "", "Landroidx/benchmark/macro/FrameStatsResult;", "getFrameStats$benchmark_macro_release", "killProcess", "useKillAll", "pressHome", "delayDurationMs", "", "startActivityAndWait", "block", "Lkotlin/Function1;", "Landroid/content/Intent;", "intent", "startActivityImpl", "uri", "Companion", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nMacrobenchmarkScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacrobenchmarkScope.kt\nandroidx/benchmark/macro/MacrobenchmarkScope\n+ 2 ForceTracing.kt\nandroidx/benchmark/macro/perfetto/ForceTracingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Trace.kt\nandroidx/tracing/TraceKt\n*L\n1#1,348:1\n68#2,6:349\n1549#3:355\n1620#3,3:356\n1549#3:359\n1620#3,3:360\n1855#3,2:363\n1747#3,3:365\n1747#3,3:368\n1360#3:376\n1446#3,2:377\n1448#3,3:384\n27#4,5:371\n27#4,5:379\n*S KotlinDebug\n*F\n+ 1 MacrobenchmarkScope.kt\nandroidx/benchmark/macro/MacrobenchmarkScope\n*L\n103#1:349,6\n120#1:355\n120#1:356,3\n132#1:359\n132#1:360,3\n135#1:363,2\n150#1:365,3\n164#1:368,3\n189#1:376\n189#1:377,2\n189#1:384,3\n172#1:371,5\n190#1:379,5\n*E\n"})
public final class MacrobenchmarkScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    private final boolean launchWithClearTask;
    private final Instrumentation instrumentation;
    private final Context context;
    @Nullable
    private Integer iteration;
    @NotNull
    private final UiDevice device;

    public MacrobenchmarkScope(@NotNull String packageName, boolean launchWithClearTask) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
        this.launchWithClearTask = launchWithClearTask;
        this.instrumentation = InstrumentationRegistry.getInstrumentation();
        this.context = this.instrumentation.getContext();
        UiDevice uiDevice = UiDevice.getInstance((Instrumentation)this.instrumentation);
        Intrinsics.checkNotNullExpressionValue((Object)uiDevice, (String)"getInstance(instrumentation)");
        this.device = uiDevice;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @Nullable
    public final Integer getIteration() {
        return this.iteration;
    }

    public final void setIteration$benchmark_macro_release(@Nullable Integer n) {
        this.iteration = n;
    }

    @NotNull
    public final UiDevice getDevice() {
        return this.device;
    }

    @JvmOverloads
    public final void startActivityAndWait(@NotNull Function1<? super Intent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intent intent = this.context.getPackageManager().getLaunchIntentForPackage(this.packageName);
        if (intent == null && (intent = this.context.getPackageManager().getLeanbackLaunchIntentForPackage(this.packageName)) == null) {
            throw new IllegalStateException("Unable to acquire intent for package " + this.packageName);
        }
        Intent intent2 = intent;
        block.invoke((Object)intent2);
        this.startActivityAndWait(intent2);
    }

    public static /* synthetic */ void startActivityAndWait$default(MacrobenchmarkScope macrobenchmarkScope, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = startActivityAndWait.1.INSTANCE;
        }
        macrobenchmarkScope.startActivityAndWait((Function1<? super Intent, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startActivityAndWait(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String label$iv = "startActivityAndWait";
        boolean $i$f$forceTrace = false;
        ForceTracing.INSTANCE.begin(label$iv);
        try {
            boolean bl = false;
            intent.addFlags(0x10000000);
            if (this.launchWithClearTask) {
                intent.addFlags(32768);
            }
            String string = intent.toUri(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"intent.toUri(Intent.URI_INTENT_SCHEME)");
            this.startActivityImpl(string);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            ForceTracing.INSTANCE.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void startActivityImpl(String uri) {
        boolean bl;
        String string;
        long preLaunchTimestampNs;
        List ignoredUniqueNames;
        block19: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void it;
            Collection collection;
            List list;
            if (!this.launchWithClearTask) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = this.getFrameStats$benchmark_macro_release();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Iterator iterator = (FrameStatsResult)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getUniqueName());
                }
                list = (List)destination$iv$iv;
            }
            ignoredUniqueNames = list;
            preLaunchTimestampNs = System.nanoTime();
            String cmd = "am start -W \"" + uri + '\"';
            Log.d((String)"Benchmark", (String)("Starting activity with command: " + cmd));
            Shell.Output result = Shell.executeScriptCaptureStdoutStderr$default((Shell)Shell.INSTANCE, (String)cmd, null, (int)2, null);
            Object object = new String[]{"\n"};
            object = StringsKt.split$default((CharSequence)result.getStdout(), (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it2;
                string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)it2)))).toString());
            }
            List outputLines = (List)destination$iv$iv;
            Iterable $this$forEach$iv = outputLines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it3 = (String)element$iv;
                boolean bl4 = false;
                if (!StringsKt.startsWith$default((String)it3, (String)"Error:", (boolean)false, (int)2, null)) continue;
                throw new IllegalStateException(it3);
            }
            if (StringsKt.contains$default((CharSequence)result.getStderr(), (CharSequence)"java.lang.SecurityException", (boolean)false, (int)2, null)) {
                throw new SecurityException(result.getStderr());
            }
            if (((CharSequence)result.getStderr()).length() > 0) {
                throw new IllegalStateException(result.getStderr());
            }
            Log.d((String)"Benchmark", (String)("Result: " + result.getStdout()));
            Iterable $this$any$iv = outputLines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it4 = (String)element$iv;
                    boolean bl5 = false;
                    if (!StringsKt.startsWith$default((String)it4, (String)"Warning: Activity not started", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            Log.d((String)"Benchmark", (String)"Unable to safely detect Activity launch, waiting 2s");
            Thread.sleep(2000L);
            return;
        }
        List<FrameStatsResult> lastFrameStats = null;
        lastFrameStats = CollectionsKt.emptyList();
        int n = 100;
        for (int i = 0; i < n; ++i) {
            boolean bl6;
            block20: {
                int it = i;
                boolean bl7 = false;
                lastFrameStats = this.getFrameStats$benchmark_macro_release();
                Iterable $this$any$iv = lastFrameStats;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FrameStatsResult it5 = (FrameStatsResult)element$iv;
                        boolean bl8 = false;
                        boolean bl9 = !ignoredUniqueNames.contains(it5.getUniqueName()) && it5.getLastFrameNs() != null && it5.getLastFrameNs() > preLaunchTimestampNs;
                        if (!bl9) continue;
                        bl6 = true;
                        break block20;
                    }
                    bl6 = false;
                }
            }
            if (bl6) {
                return;
            }
            String label$iv = "wait for " + this.packageName + " to draw";
            boolean $i$f$trace = false;
            try {
                Trace.beginSection((String)label$iv);
                boolean bl10 = false;
                Thread.sleep(100L);
                string = Unit.INSTANCE;
                continue;
            }
            finally {
                Trace.endSection();
            }
        }
        throw new IllegalStateException("Unable to confirm activity launch completion " + lastFrameStats + " Please report a bug with the output of `adb shell dumpsys gfxinfo " + this.packageName + " framestats`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<FrameStatsResult> getFrameStats$benchmark_macro_release() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = Shell.INSTANCE.getRunningProcessesForPackage(this.packageName);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String string;
            String processName = (String)element$iv$iv;
            boolean bl = false;
            String label$iv = "dumpsys gfxinfo framestats";
            boolean $i$f$trace = false;
            try {
                Trace.beginSection((String)label$iv);
                boolean bl2 = false;
                string = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("dumpsys gfxinfo " + processName + " framestats"), null, (int)2, null);
            }
            finally {
                Trace.endSection();
            }
            String frameStatsOutput = string;
            Iterable list$iv$iv = FrameStatsResult.Companion.parse(frameStatsOutput);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    public final void pressHome(long delayDurationMs) {
        this.device.pressHome();
        Thread.sleep(delayDurationMs);
    }

    public static /* synthetic */ void pressHome$default(MacrobenchmarkScope macrobenchmarkScope, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        macrobenchmarkScope.pressHome(l);
    }

    @JvmOverloads
    public final void killProcess(boolean useKillAll) {
        Log.d((String)"Benchmark", (String)("Killing process " + this.packageName));
        if (useKillAll) {
            this.device.executeShellCommand("killall " + this.packageName);
        } else {
            this.device.executeShellCommand("am force-stop " + this.packageName);
        }
    }

    public static /* synthetic */ void killProcess$default(MacrobenchmarkScope macrobenchmarkScope, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        macrobenchmarkScope.killProcess(bl);
    }

    public final void dropShaderCache() {
        Log.d((String)"Benchmark", (String)("Dropping shader cache for " + this.packageName));
        String dropError = ProfileInstallBroadcast.INSTANCE.dropShaderCache(this.packageName);
        if (dropError != null && !DeviceInfo.INSTANCE.isEmulator() && !this.dropShaderCacheRoot$benchmark_macro_release()) {
            throw new IllegalStateException(dropError);
        }
    }

    public final boolean dropShaderCacheRoot$benchmark_macro_release() {
        if (Shell.INSTANCE.isSessionRooted()) {
            String path = Companion.getShaderCachePath(this.packageName);
            Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("find " + path + " -type f | xargs rm -f"), null, (int)2, null);
            return true;
        }
        return false;
    }

    @RequiresApi(value=31)
    private final void dropKernelPageCacheSetProp() {
        Shell.Output result = Shell.executeScriptCaptureStdoutStderr$default((Shell)Shell.INSTANCE, (String)"setprop perf.drop_caches 3", null, (int)2, null);
        if (!(((CharSequence)result.getStdout()).length() == 0 && ((CharSequence)result.getStderr()).length() == 0)) {
            boolean bl = false;
            String string = "Failed to trigger drop cache via setprop: " + result;
            throw new IllegalStateException(string.toString());
        }
        int n = 50;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Thread.sleep(50L);
            String getPropResult = Shell.INSTANCE.getprop("perf.drop_caches");
            if (Intrinsics.areEqual((Object)getPropResult, (Object)"0")) {
                return;
            }
            if (Intrinsics.areEqual((Object)getPropResult, (Object)"3")) continue;
            throw new IllegalStateException("Unable to drop caches: Failed to read drop cache via getprop: " + getPropResult);
        }
        throw new IllegalStateException("Unable to drop caches: Did not observe perf.drop_caches reset automatically");
    }

    public final void dropKernelPageCache() {
        if (Build.VERSION.SDK_INT >= 31) {
            this.dropKernelPageCacheSetProp();
        } else {
            Shell.Output result = Shell.executeScriptCaptureStdoutStderr$default((Shell)Shell.INSTANCE, (String)"echo 3 > /proc/sys/vm/drop_caches && echo Success || echo Failure", null, (int)2, null);
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)result.getStdout())).toString(), (Object)"Success")) {
                if (DeviceInfo.INSTANCE.isRooted() && !Shell.INSTANCE.isSessionRooted()) {
                    throw new IllegalStateException("Failed to drop caches - run `adb root`");
                }
                Log.w((String)"Benchmark", (String)("Failed to drop kernel page cache, result: '" + result + '\''));
            }
        }
    }

    @JvmOverloads
    public final void startActivityAndWait() {
        MacrobenchmarkScope.startActivityAndWait$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void pressHome() {
        MacrobenchmarkScope.pressHome$default(this, 0L, 1, null);
    }

    @JvmOverloads
    public final void killProcess() {
        MacrobenchmarkScope.killProcess$default(this, false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Landroidx/benchmark/macro/MacrobenchmarkScope$Companion;", "", "()V", "getShaderCachePath", "", "packageName", "Api24ContextHelper", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShaderCachePath(@NotNull String packageName) {
            File file;
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Context context = InstrumentationRegistry.getInstrumentation().getContext();
            if (Build.VERSION.SDK_INT >= 34) {
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                file = Api24ContextHelper.INSTANCE.createDeviceProtectedStorageContextCompat(context).getCacheDir();
            } else if (Build.VERSION.SDK_INT >= 24) {
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                file = Api24ContextHelper.INSTANCE.createDeviceProtectedStorageContextCompat(context).getCodeCacheDir();
            } else {
                file = context.getCodeCacheDir();
            }
            File shaderDirectory = file;
            String string = shaderDirectory.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shaderDirectory.absolutePath");
            String string2 = context.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.packageName");
            return StringsKt.replace$default((String)string, (String)string2, (String)packageName, (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/benchmark/macro/MacrobenchmarkScope$Companion$Api24ContextHelper;", "", "()V", "createDeviceProtectedStorageContextCompat", "Landroid/content/Context;", "benchmark-macro_release"})
        @RequiresApi(value=24)
        public static final class Api24ContextHelper {
            @NotNull
            public static final Api24ContextHelper INSTANCE = new Api24ContextHelper();

            private Api24ContextHelper() {
            }

            @NotNull
            public final Context createDeviceProtectedStorageContextCompat(@NotNull Context $this$createDeviceProtectedStorageContextCompat) {
                Intrinsics.checkNotNullParameter((Object)$this$createDeviceProtectedStorageContextCompat, (String)"<this>");
                Context context = $this$createDeviceProtectedStorageContextCompat.createDeviceProtectedStorageContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"createDeviceProtectedStorageContext()");
                return context;
            }
        }
    }
}

