/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Api21Kt;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserspaceTracing;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/macro/MethodTracing;", "", "()V", "context", "Landroid/content/Context;", "broadcast", "", "targetPackageName", "", "extras", "fileName", "uniqueName", "startTracing", "packageName", "options", "stopTracing", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@SourceDebugExtension(value={"SMAP\nMethodTracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodTracing.kt\nandroidx/benchmark/macro/MethodTracing\n+ 2 UserspaceTracing.kt\nandroidx/benchmark/UserspaceTracingKt\n*L\n1#1,90:1\n131#2,6:91\n*S KotlinDebug\n*F\n+ 1 MethodTracing.kt\nandroidx/benchmark/macro/MethodTracing\n*L\n76#1:91,6\n*E\n"})
public final class MethodTracing {
    @NotNull
    public static final MethodTracing INSTANCE = new MethodTracing();
    @NotNull
    private static final Context context;

    private MethodTracing() {
    }

    public final void startTracing(@NotNull String packageName, @NotNull String uniqueName, @NotNull String options) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String fileName = this.fileName(uniqueName);
        String extras = Intrinsics.areEqual((Object)options, (Object)"Sampled") ? "-e ACTION METHOD_TRACE_START_SAMPLED -e UNIQUE_NAME " + fileName : "-e ACTION METHOD_TRACE_START -e UNIQUE_NAME " + fileName;
        this.broadcast(packageName, extras);
    }

    public final void stopTracing(@NotNull String packageName, @NotNull String uniqueName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        String fileName = this.fileName(uniqueName);
        String extras = "-e ACTION ACTION_METHOD_TRACE_END";
        this.broadcast(packageName, extras);
        File file = Api21Kt.getFirstMountedMediaDir((Context)context);
        File mediaDirParent = file != null ? file.getParentFile() : null;
        String sourcePath = mediaDirParent + '/' + packageName + '/' + fileName;
        String stagingPath = Outputs.INSTANCE.getDirUsableByAppAndShell() + "/_" + fileName;
        Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("cp '" + sourcePath + "' '" + stagingPath + '\''), null, (int)2, null);
        Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)fileName, (String)fileName, (boolean)false, (Function1)((Function1)new Function1<File, Unit>(stagingPath){
            final /* synthetic */ String $stagingPath;
            {
                this.$stagingPath = $stagingPath;
                super(1);
            }

            public final void invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                File staging = new File(this.$stagingPath);
                FilesKt.copyTo$default((File)staging, (File)it, (boolean)true, (int)0, (int)4, null);
            }
        }), (int)4, null);
    }

    private final String fileName(String uniqueName) {
        return uniqueName + "_method.trace";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void broadcast(String targetPackageName, String extras) {
        String label$iv = "methodTracingBroadcast";
        boolean $i$f$userspaceTrace = false;
        UserspaceTracing.beginSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            String action = "androidx.benchmark.experiments.ACTION_METHOD_TRACE";
            Integer n = Shell.INSTANCE.amBroadcast("-a " + action + ' ' + extras + ' ' + targetPackageName + "/androidx.benchmark.internal.MethodTracingReceiver");
            int result = n != null ? n : 0;
            if (!(result > 0)) {
                boolean bl2 = false;
                String string = StringsKt.trimIndent((String)("\n                    Operation with " + extras + " failed (result code " + result + ").\n                    Make sure you add a dependency on:\n                    `project(\":benchmark:benchmark-internal\")`\n                "));
                throw new IllegalArgumentException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            UserspaceTracing.endSection$default((UserspaceTracing)UserspaceTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    static {
        Context context = InstrumentationRegistry.getInstrumentation().getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getInstrumentation().context");
        MethodTracing.context = context;
    }
}

