/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Arguments;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.benchmark.macro.ExperimentalMacrobenchmarkApi;
import androidx.benchmark.macro.ProfileInstallBroadcast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0006\u0013\u0014\u0015\u0016\u0017\u0018B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH!\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J;\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u000eH!\u00a2\u0006\u0002\b\u0011J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u0082\u0001\u0005\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Landroidx/benchmark/macro/CompilationMode;", "", "()V", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "reinstallPackage", "resetAndCompile", "allowCompilationSkipping", "", "resetAndCompile$benchmark_macro_release", "shouldReset", "shouldReset$benchmark_macro_release", "writeProfileInstallerSkipFile", "Companion", "Full", "Ignore", "Interpreted", "None", "Partial", "Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode$Ignore;", "Landroidx/benchmark/macro/CompilationMode$Interpreted;", "Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode$Partial;", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nCompilationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationMode.kt\nandroidx/benchmark/macro/CompilationMode\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n141#2,3:501\n145#2,2:509\n1559#3:504\n1590#3,4:505\n*S KotlinDebug\n*F\n+ 1 CompilationMode.kt\nandroidx/benchmark/macro/CompilationMode\n*L\n126#1:501,3\n126#1:509,2\n131#1:504\n131#1:505,4\n*E\n"})
public abstract class CompilationMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final CompilationMode DEFAULT = Build.VERSION.SDK_INT >= 24 ? (CompilationMode)new Partial(BaselineProfileMode.UseIfAvailable, 0) : (CompilationMode)new Full();

    private CompilationMode() {
    }

    public final void resetAndCompile$benchmark_macro_release(@NotNull String packageName, boolean allowCompilationSkipping, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
        Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        if (Build.VERSION.SDK_INT >= 24) {
            if (Arguments.INSTANCE.getEnableCompilation() || !allowCompilationSkipping) {
                Log.d((String)"Benchmark", (String)("Resetting " + packageName));
                if (this.shouldReset$benchmark_macro_release()) {
                    if (Build.VERSION.SDK_INT >= 34 || Shell.INSTANCE.isSessionRooted()) {
                        Log.d((String)"Benchmark", (String)("Re-compiling " + packageName));
                        String output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("cmd package compile --reset " + packageName), null, (int)2, null);
                        if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)output, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
                            boolean bl = false;
                            String string = Companion.compileResetErrorString(packageName, output, DeviceInfo.INSTANCE.isEmulator());
                            throw new IllegalStateException(string.toString());
                        }
                    } else {
                        Log.d((String)"Benchmark", (String)("Reinstalling " + packageName));
                        this.reinstallPackage(packageName);
                    }
                }
                this.writeProfileInstallerSkipFile(packageName, killProcessBlock2);
                this.compileImpl$benchmark_macro_release(packageName, killProcessBlock2, warmupBlock);
            } else {
                Log.d((String)"Benchmark", (String)("Compilation is disabled, skipping compilation of " + packageName));
            }
        }
    }

    public static /* synthetic */ void resetAndCompile$benchmark_macro_release$default(CompilationMode compilationMode, String string, boolean bl, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resetAndCompile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        compilationMode.resetAndCompile$benchmark_macro_release(string, bl, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void reinstallPackage(String packageName) {
        String label$iv = "reinstallPackage";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            void $this$mapIndexedTo$iv$iv;
            boolean bl = false;
            List apkPaths = Shell.INSTANCE.pmPath(packageName);
            Iterable $this$mapIndexed$iv = apkPaths;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void apkPath;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String tempApkPath = "/data/local/tmp/" + packageName + '-' + (int)index + '-' + System.currentTimeMillis() + ".apk";
                Log.d((String)"Benchmark", (String)("Copying APK " + (String)apkPath + " to " + tempApkPath));
                Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("cp " + (String)apkPath + ' ' + tempApkPath), null, (int)2, null);
                collection.add(tempApkPath);
            }
            List tempApkPaths = (List)destination$iv$iv;
            String tempApkPathsString = CollectionsKt.joinToString$default((Iterable)tempApkPaths, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            try {
                Log.d((String)"Benchmark", (String)("Uninstalling " + packageName));
                String output = null;
                output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("pm uninstall " + packageName), null, (int)2, null);
                if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success")) {
                    boolean $i$a$-check-CompilationMode$reinstallPackage$1$32 = false;
                    String $i$a$-check-CompilationMode$reinstallPackage$1$32 = "Unable to uninstall " + packageName + " (" + output + ')';
                    throw new IllegalStateException($i$a$-check-CompilationMode$reinstallPackage$1$32.toString());
                }
                Log.d((String)"Benchmark", (String)("Installing " + packageName));
                output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("pm install -t " + tempApkPathsString), null, (int)2, null);
                if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)output, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
                    boolean bl3 = false;
                    String string = "Unable to install " + packageName + " (out=" + output + ')';
                    throw new IllegalStateException(string.toString());
                }
            }
            finally {
                Log.d((String)"Benchmark", (String)("Deleting " + tempApkPathsString));
                Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("rm " + tempApkPathsString), null, (int)2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    private final void writeProfileInstallerSkipFile(String packageName, Function0<Unit> killProcessBlock2) {
        String result = ProfileInstallBroadcast.INSTANCE.skipFileOperation(packageName, "WRITE_SKIP_FILE");
        if (result != null) {
            Log.w((String)"Benchmark", (String)StringsKt.trimIndent((String)("\n                    " + packageName + " should use the latest version of `androidx.profileinstaller`\n                    for stable benchmarks. (" + result + ")\"\n                ")));
        }
        Log.d((String)"Benchmark", (String)("Killing process " + packageName));
        killProcessBlock2.invoke();
    }

    @RequiresApi(value=24)
    public abstract void compileImpl$benchmark_macro_release(@NotNull String var1, @NotNull Function0<Unit> var2, @NotNull Function0<Unit> var3);

    @RequiresApi(value=24)
    public abstract boolean shouldReset$benchmark_macro_release();

    public /* synthetic */ CompilationMode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Companion;", "", "()V", "DEFAULT", "Landroidx/benchmark/macro/CompilationMode;", "cmdPackageCompile", "", "packageName", "", "compileArgument", "cmdPackageCompile$benchmark_macro_release", "compileResetErrorString", "output", "isEmulator", "", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresApi(value=24)
        public final void cmdPackageCompile$benchmark_macro_release(@NotNull String packageName, @NotNull String compileArgument) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)compileArgument, (String)"compileArgument");
            String stdout = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("cmd package compile -f -m " + compileArgument + ' ' + packageName), null, (int)2, null);
            if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)stdout)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)stdout, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string = "Failed to compile (out=" + stdout + ')';
                throw new IllegalStateException(string.toString());
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String compileResetErrorString(@NotNull String packageName, @NotNull String output, boolean isEmulator) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return "Unable to reset compilation of " + packageName + " (out=" + output + ")." + (StringsKt.contains$default((CharSequence)output, (CharSequence)"could not be compiled", (boolean)false, (int)2, null) && isEmulator ? " Try updating your emulator - see https://issuetracker.google.com/issue?id=251540646" : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "benchmark-macro_release"})
    public static final class Full
    extends CompilationMode {
        public Full() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Full";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            if (Build.VERSION.SDK_INT >= 24) {
                Companion.cmdPackageCompile$benchmark_macro_release(packageName, "speed");
            }
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Ignore;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @ExperimentalMacrobenchmarkApi
    public static final class Ignore
    extends CompilationMode {
        public Ignore() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Ignore";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Interpreted;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Interpreted
    extends CompilationMode {
        @NotNull
        public static final Interpreted INSTANCE = new Interpreted();

        private Interpreted() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Interpreted";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\nJ\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RequiresApi(value=24)
    public static final class None
    extends CompilationMode {
        public None() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "None";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0010\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/macro/CompilationMode$Partial;", "Landroidx/benchmark/macro/CompilationMode;", "baselineProfileMode", "Landroidx/benchmark/macro/BaselineProfileMode;", "warmupIterations", "", "(Landroidx/benchmark/macro/BaselineProfileMode;I)V", "getBaselineProfileMode", "()Landroidx/benchmark/macro/BaselineProfileMode;", "getWarmupIterations", "()I", "compileImpl", "", "packageName", "", "killProcessBlock", "Lkotlin/Function0;", "warmupBlock", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "benchmark-macro_release"})
    @RequiresApi(value=24)
    public static final class Partial
    extends CompilationMode {
        @NotNull
        private final BaselineProfileMode baselineProfileMode;
        private final int warmupIterations;

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode, @IntRange(from=0L) int warmupIterations) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            super(null);
            this.baselineProfileMode = baselineProfileMode;
            this.warmupIterations = warmupIterations;
            if (!(this.warmupIterations >= 0)) {
                boolean $i$a$-require-CompilationMode$Partial$32 = false;
                String $i$a$-require-CompilationMode$Partial$32 = "warmupIterations must be non-negative, was " + this.warmupIterations;
                throw new IllegalArgumentException($i$a$-require-CompilationMode$Partial$32.toString());
            }
            if (!(this.baselineProfileMode != BaselineProfileMode.Disable || this.warmupIterations > 0)) {
                boolean bl = false;
                String string = "Must set baselineProfileMode != Ignore, or warmup iterations > 0 to define which portion of the app to pre-compile.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Partial(BaselineProfileMode baselineProfileMode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                baselineProfileMode = BaselineProfileMode.Require;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(baselineProfileMode, n);
        }

        @NotNull
        public final BaselineProfileMode getBaselineProfileMode() {
            return this.baselineProfileMode;
        }

        public final int getWarmupIterations() {
            return this.warmupIterations;
        }

        @NotNull
        public String toString() {
            return this.baselineProfileMode == BaselineProfileMode.Require && this.warmupIterations == 0 ? "BaselineProfile" : (this.baselineProfileMode == BaselineProfileMode.Disable && this.warmupIterations > 0 ? "WarmupProfile(iterations=" + this.warmupIterations + ')' : "Partial(baselineProfile=" + (Object)((Object)this.baselineProfileMode) + ",iterations=" + this.warmupIterations + ')');
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull String packageName, @NotNull Function0<Unit> killProcessBlock2, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter(killProcessBlock2, (String)"killProcessBlock");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            if (this.baselineProfileMode != BaselineProfileMode.Disable) {
                String installErrorString = ProfileInstallBroadcast.INSTANCE.installProfile(packageName);
                if (installErrorString == null) {
                    Log.d((String)"Benchmark", (String)("Killing process " + packageName));
                    killProcessBlock2.invoke();
                    Companion.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
                } else {
                    if (this.baselineProfileMode == BaselineProfileMode.Require) {
                        throw new RuntimeException(installErrorString);
                    }
                    Log.d((String)"Benchmark", (String)installErrorString);
                }
            }
            if (this.warmupIterations > 0) {
                int installErrorString = this.warmupIterations;
                int n = 0;
                while (n < installErrorString) {
                    int it = n++;
                    boolean bl = false;
                    warmupBlock.invoke();
                }
                Thread.sleep(5000L);
                String saveResult = ProfileInstallBroadcast.INSTANCE.saveProfile(packageName);
                if (saveResult == null) {
                    killProcessBlock2.invoke();
                } else if (Shell.INSTANCE.isSessionRooted()) {
                    Log.d((String)"Benchmark", (String)("Unable to saveProfile with profileinstaller (" + saveResult + "), trying kill"));
                    Shell.Output response = Shell.executeScriptCaptureStdoutStderr$default((Shell)Shell.INSTANCE, (String)("killall -s SIGUSR1 " + packageName), null, (int)2, null);
                    if (!response.isBlank()) {
                        boolean bl = false;
                        String string = "Failed to dump profile for " + packageName + " (" + response + "),\n and failed to save profile with broadcast: " + saveResult;
                        throw new IllegalStateException(string.toString());
                    }
                } else {
                    throw new RuntimeException(saveResult);
                }
                Companion.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
            }
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            this(baselineProfileMode, 0, 2, null);
        }

        @JvmOverloads
        public Partial() {
            this(null, 0, 3, null);
        }
    }
}

