/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import androidx.benchmark.macro.ExperimentalMetricApi;
import androidx.benchmark.macro.Metric;
import androidx.benchmark.macro.TraceMetric;
import androidx.benchmark.macro.perfetto.MemoryUsageQuery;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/macro/MemoryUsageMetric;", "Landroidx/benchmark/macro/TraceMetric;", "mode", "Landroidx/benchmark/macro/MemoryUsageMetric$Mode;", "subMetrics", "", "Landroidx/benchmark/macro/MemoryUsageMetric$SubMetric;", "(Landroidx/benchmark/macro/MemoryUsageMetric$Mode;Ljava/util/List;)V", "getResult", "Landroidx/benchmark/macro/Metric$Measurement;", "captureInfo", "Landroidx/benchmark/macro/Metric$CaptureInfo;", "traceSession", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "Mode", "SubMetric", "benchmark-macro_release"})
@ExperimentalMetricApi
@SourceDebugExtension(value={"SMAP\nMetric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metric.kt\nandroidx/benchmark/macro/MemoryUsageMetric\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,799:1\n135#2,9:800\n215#2:809\n216#2:811\n144#2:812\n1#3:810\n*S KotlinDebug\n*F\n+ 1 Metric.kt\nandroidx/benchmark/macro/MemoryUsageMetric\n*L\n765#1:800,9\n765#1:809\n765#1:811\n765#1:812\n765#1:810\n*E\n"})
public final class MemoryUsageMetric
extends TraceMetric {
    @NotNull
    private final Mode mode;
    @NotNull
    private final List<SubMetric> subMetrics;

    public MemoryUsageMetric(@NotNull Mode mode, @NotNull List<? extends SubMetric> subMetrics) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(subMetrics, (String)"subMetrics");
        this.mode = mode;
        this.subMetrics = subMetrics;
    }

    public /* synthetic */ MemoryUsageMetric(Mode mode, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            SubMetric[] subMetricArray = new SubMetric[]{SubMetric.HeapSize, SubMetric.RssAnon, SubMetric.RssFile, SubMetric.Gpu};
            list = CollectionsKt.listOf((Object[])subMetricArray);
        }
        this(mode, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Metric.Measurement> getResult(@NotNull Metric.CaptureInfo captureInfo, @NotNull PerfettoTraceProcessor.Session traceSession) {
        List list;
        Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
        Intrinsics.checkNotNullParameter((Object)traceSession, (String)"traceSession");
        String suffix = this.mode.toString();
        Map<SubMetric, Integer> map = MemoryUsageQuery.INSTANCE.getMemoryUsageKb(traceSession, captureInfo.getTargetPackageName(), this.mode);
        if (map != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Map<SubMetric, Integer> map2 = map;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Metric.Measurement it$iv$iv;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry it = element$iv$iv;
                boolean bl2 = false;
                if ((this.subMetrics.contains(it.getKey()) ? new Metric.Measurement("memory" + it.getKey() + suffix + "Kb", ((Number)it.getValue()).intValue()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/benchmark/macro/MemoryUsageMetric$Mode;", "", "(Ljava/lang/String;I)V", "Last", "Max", "benchmark-macro_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Last = new Mode();
        public static final /* enum */ Mode Max = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Last, Mode.Max};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/macro/MemoryUsageMetric$SubMetric;", "", "counterName", "", "alreadyInKb", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getAlreadyInKb$benchmark_macro_release", "()Z", "getCounterName$benchmark_macro_release", "()Ljava/lang/String;", "HeapSize", "RssAnon", "RssFile", "RssShmem", "Gpu", "benchmark-macro_release"})
    public static final class SubMetric
    extends Enum<SubMetric> {
        @NotNull
        private final String counterName;
        private final boolean alreadyInKb;
        public static final /* enum */ SubMetric HeapSize = new SubMetric("Heap size (KB)", true);
        public static final /* enum */ SubMetric RssAnon = new SubMetric("mem.rss.anon", false);
        public static final /* enum */ SubMetric RssFile = new SubMetric("mem.rss.file", false);
        public static final /* enum */ SubMetric RssShmem = new SubMetric("mem.rss.shmem", false);
        public static final /* enum */ SubMetric Gpu = new SubMetric("GPU Memory", false);
        private static final /* synthetic */ SubMetric[] $VALUES;

        private SubMetric(String counterName, boolean alreadyInKb) {
            this.counterName = counterName;
            this.alreadyInKb = alreadyInKb;
        }

        @NotNull
        public final String getCounterName$benchmark_macro_release() {
            return this.counterName;
        }

        public final boolean getAlreadyInKb$benchmark_macro_release() {
            return this.alreadyInKb;
        }

        public static SubMetric[] values() {
            return (SubMetric[])$VALUES.clone();
        }

        public static SubMetric valueOf(String value) {
            return Enum.valueOf(SubMetric.class, value);
        }

        static {
            $VALUES = subMetricArray = new SubMetric[]{SubMetric.HeapSize, SubMetric.RssAnon, SubMetric.RssFile, SubMetric.RssShmem, SubMetric.Gpu};
        }
    }
}

