/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.PerfettoTraceProcessorKt;
import androidx.benchmark.perfetto.Row;
import androidx.benchmark.perfetto.Slice;
import androidx.benchmark.perfetto.SliceKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\tH\u0002J*\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00040\u0012*\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery;", "", "()V", "getFrameData", "", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData;", "session", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "captureApiLevel", "", "packageName", "", "getFrameData$benchmark_macro_release", "getFullQuery", "binarySearchFrameId", "Landroidx/benchmark/perfetto/Slice;", "frameId", "getFrameSubMetrics", "", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "", "FrameData", "FrameSliceType", "SubMetric", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nFrameTimingQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameTimingQuery.kt\nandroidx/benchmark/macro/perfetto/FrameTimingQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,242:1\n1549#2:243\n1620#2,3:244\n766#2:247\n857#2,2:248\n1477#2:250\n1502#2,3:251\n1505#2,3:261\n2624#2,3:265\n1603#2,9:268\n1855#2:277\n533#2,6:278\n1856#2:285\n1612#2:286\n2624#2,3:287\n1603#2,9:290\n1855#2:299\n288#2,2:300\n1856#2:303\n1612#2:304\n1271#2,2:308\n1285#2,2:310\n1549#2:312\n1620#2,3:313\n1288#2:316\n361#3,7:254\n1#4:264\n1#4:284\n1#4:302\n3792#5:305\n4307#5,2:306\n*S KotlinDebug\n*F\n+ 1 FrameTimingQuery.kt\nandroidx/benchmark/macro/perfetto/FrameTimingQuery\n*L\n157#1:243\n157#1:244,3\n161#1:247\n161#1:248,2\n162#1:250\n162#1:251,3\n162#1:261,3\n190#1:265,3\n193#1:268,9\n193#1:277\n208#1:278,6\n193#1:285\n193#1:286\n224#1:287,3\n225#1:290,9\n225#1:299\n227#1:300,2\n225#1:303\n225#1:304\n237#1:308,2\n237#1:310,2\n238#1:312\n238#1:313,3\n237#1:316\n162#1:254,7\n193#1:284\n225#1:302\n236#1:305\n236#1:306,2\n*E\n"})
public final class FrameTimingQuery {
    @NotNull
    public static final FrameTimingQuery INSTANCE = new FrameTimingQuery();

    private FrameTimingQuery() {
    }

    @Language(value="sql")
    private final String getFullQuery(String packageName) {
        return StringsKt.trimIndent((String)("\n        ------ Select all frame-relevant slices from slice table\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN thread_track on slice.track_id = thread_track.id\n            INNER JOIN thread USING(utid)\n            INNER JOIN process USING(upid)\n        WHERE (\n            ---- parent_stack_id = 0 to filter to top of trace stack\n            ( slice.name LIKE \"Choreographer#doFrame%\" AND process.pid LIKE thread.tid AND slice.parent_stack_id = 0) OR\n            ( slice.name LIKE \"DrawFrame%\" AND thread.name like \"RenderThread\" )\n        ) AND " + PerfettoTraceProcessorKt.processNameLikePkg(packageName) + "\n        ------ Add in actual frame slices (prepended with \"actual \" to differentiate)\n        UNION\n        SELECT\n            \"actual \" || actual_frame_timeline_slice.name as name,\n            actual_frame_timeline_slice.ts as ts,\n            actual_frame_timeline_slice.dur as dur\n        FROM actual_frame_timeline_slice\n            INNER JOIN process USING(upid)\n        WHERE\n            " + PerfettoTraceProcessorKt.processNameLikePkg(packageName) + "\n        ------ Add in expected time slices (prepended with \"expected \" to differentiate)\n        UNION\n        SELECT\n            \"expected \" || expected_frame_timeline_slice.name as name,\n            expected_frame_timeline_slice.ts as ts,\n            expected_frame_timeline_slice.dur as dur\n        FROM expected_frame_timeline_slice\n            INNER JOIN process USING(upid)\n        WHERE\n            " + PerfettoTraceProcessorKt.processNameLikePkg(packageName) + "\n        ORDER BY ts ASC\n    "));
    }

    private final Slice binarySearchFrameId(List<Slice> $this$binarySearchFrameId, int frameId) {
        int targetIndex2 = CollectionsKt.binarySearch$default($this$binarySearchFrameId, (int)0, (int)0, (Function1)((Function1)new Function1<Slice, Integer>(frameId){
            final /* synthetic */ int $frameId;
            {
                this.$frameId = $frameId;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Slice potentialTarget) {
                Intrinsics.checkNotNullParameter((Object)potentialTarget, (String)"potentialTarget");
                Integer n = potentialTarget.getFrameId();
                Intrinsics.checkNotNull((Object)n);
                return n - this.$frameId;
            }
        }), (int)3, null);
        return targetIndex2 >= 0 ? $this$binarySearchFrameId.get(targetIndex2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FrameData> getFrameData$benchmark_macro_release(@NotNull PerfettoTraceProcessor.Session session, int captureApiLevel, @NotNull String packageName) {
        List list;
        boolean $i$f$none2;
        Object answer$iv$iv$iv;
        Object $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Slice it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Slice it2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Sequence<Row> queryResultIterator = session.query(this.getFullQuery(packageName));
        Iterable<Slice> list2 = SliceKt.toSlices(queryResultIterator);
        boolean bl = false;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Slice slice = (Slice)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Slice.copy$default(it2, null, it2.getTs() - ((Slice)CollectionsKt.first(list2)).getTs(), 0L, 5, null));
        }
        List slices = (List)((Object)destination$iv$iv);
        list2 = slices;
        boolean $i$f$filter = false;
        $this$map$iv = $this$filter$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Slice)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getDur() > 0L)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy22 = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        destination$iv$iv = $this$groupByTo$iv$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            Object object;
            FrameSliceType frameSliceType;
            Object element$iv$iv = destination$iv$iv.next();
            it = (Slice)element$iv$iv;
            boolean bl4 = false;
            if (StringsKt.startsWith$default((String)it.getName(), (String)"Choreographer#doFrame", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.UiThread;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"DrawFrame", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.RenderThread;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"actual ", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.Actual;
            } else if (StringsKt.startsWith$default((String)it.getName(), (String)"expected ", (boolean)false, (int)2, null)) {
                frameSliceType = FrameSliceType.Expected;
            } else {
                throw new IllegalStateException("Unexpected slice " + it);
            }
            FrameSliceType key$iv$iv = frameSliceType;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object groupedData = destination$iv$iv2;
        Object $i$f$groupBy22 = groupedData;
        Object object = $i$f$groupBy22.get((Object)FrameSliceType.UiThread);
        if (object == null) {
            boolean bl6 = false;
            object = CollectionsKt.emptyList();
        }
        List uiSlices = (List)object;
        $this$groupByTo$iv$iv = groupedData;
        Object object2 = $this$groupByTo$iv$iv.get((Object)FrameSliceType.RenderThread);
        if (object2 == null) {
            boolean bl7 = false;
            object2 = CollectionsKt.emptyList();
        }
        List rtSlices = (List)object2;
        Object bl6 = groupedData;
        Object object3 = bl6.get((Object)FrameSliceType.Actual);
        if (object3 == null) {
            boolean bl8 = false;
            object3 = CollectionsKt.emptyList();
        }
        List actualSlices = (List)object3;
        Object bl7 = groupedData;
        Object object4 = bl7.get((Object)FrameSliceType.Expected);
        if (object4 == null) {
            boolean bl9 = false;
            object4 = CollectionsKt.emptyList();
        }
        List expectedSlices = (List)object4;
        if (uiSlices.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean newSlicesShouldBeEmpty = captureApiLevel < 31;
        if (!(actualSlices.isEmpty() == newSlicesShouldBeEmpty)) {
            String bl9 = "Failed requirement.";
            throw new IllegalArgumentException(bl9.toString());
        }
        if (!(expectedSlices.isEmpty() == newSlicesShouldBeEmpty)) {
            String bl9 = "Failed requirement.";
            throw new IllegalArgumentException(bl9.toString());
        }
        if (captureApiLevel >= 31) {
            void $this$mapNotNullTo$iv$iv;
            boolean bl10;
            block38: {
                Iterable $this$none$iv = slices;
                $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl10 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it2 = (Slice)element$iv;
                        boolean bl11 = false;
                        if (!(it2.getFrameId() == null)) continue;
                        bl10 = false;
                        break block38;
                    }
                    bl10 = true;
                }
            }
            if (!bl10) {
                String $i$f$none2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$none2.toString());
            }
            List actualSlicesPool = CollectionsKt.toMutableList((Collection)actualSlices);
            Iterable $this$mapNotNull$iv = rtSlices;
            boolean $i$f$mapNotNull2 = false;
            Iterable element$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            answer$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                FrameData frameData;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = answer$iv$iv$iv.next();
                boolean bl12 = false;
                Slice rtSlice = (Slice)element$iv$iv;
                boolean bl13 = false;
                Integer n = rtSlice.getFrameId();
                Intrinsics.checkNotNull((Object)n);
                int frameId = n;
                Slice uiSlice = INSTANCE.binarySearchFrameId(uiSlices, frameId);
                if (uiSlice != null) {
                    Slice slice;
                    Object v8;
                    block39: {
                        List $this$lastOrNull$iv = actualSlicesPool;
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            Object element$iv2 = iterator$iv.previous();
                            Slice it3 = (Slice)element$iv2;
                            boolean bl14 = false;
                            if (!(it3.getTs() < uiSlice.getTs() + (long)50000)) continue;
                            v8 = element$iv2;
                            break block39;
                        }
                        v8 = null;
                    }
                    Slice actualSlice = v8;
                    TypeIntrinsics.asMutableCollection((Object)actualSlicesPool).remove(actualSlice);
                    Object object5 = actualSlice;
                    if (object5 != null && (object5 = ((Slice)object5).getFrameId()) != null) {
                        int $this$getFrameData_u24lambda_u2411_u24lambda_u2410 = ((Number)object5).intValue();
                        boolean bl15 = false;
                        slice = INSTANCE.binarySearchFrameId(expectedSlices, $this$getFrameData_u24lambda_u2411_u24lambda_u2410);
                    } else {
                        slice = null;
                    }
                    Slice expectedSlice = slice;
                    frameData = FrameData.Companion.tryCreate31(uiSlice, rtSlice, expectedSlice, actualSlice);
                } else {
                    frameData = null;
                }
                if (frameData == null) continue;
                FrameData it$iv$iv = frameData;
                boolean bl16 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            list = (List)destination$iv$iv3;
        } else {
            void $this$mapNotNullTo$iv$iv;
            boolean bl17;
            block40: {
                Iterable $this$none$iv = slices;
                $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl17 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it2 = (Slice)element$iv;
                        boolean bl18 = false;
                        if (!(it2.getFrameId() != null)) continue;
                        bl17 = false;
                        break block40;
                    }
                    bl17 = true;
                }
            }
            if (!bl17) {
                String $i$f$none3 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$none3.toString());
            }
            Iterable $this$mapNotNull$iv = rtSlices;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapNotNull2 = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                FrameData it$iv$iv;
                Object v14;
                FrameData.Companion companion;
                Slice rtSlice;
                block41: {
                    void $this$firstOrNull$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl19 = false;
                    rtSlice = (Slice)element$iv$iv;
                    boolean bl20 = false;
                    Iterable bl13 = uiSlices;
                    companion = FrameData.Companion;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Slice it4 = (Slice)element$iv;
                        boolean bl21 = false;
                        if (!it4.contains(rtSlice.getTs())) continue;
                        v14 = element$iv;
                        break block41;
                    }
                    v14 = null;
                }
                if (companion.tryCreateBasic(v14, rtSlice) == null) continue;
                boolean bl22 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            list = (List)destination$iv$iv4;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<SubMetric, List<Long>> getFrameSubMetrics(@NotNull List<FrameData> $this$getFrameSubMetrics, int captureApiLevel) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getFrameSubMetrics, (String)"<this>");
        SubMetric[] $this$filter$iv = SubMetric.values();
        boolean $i$f$filter = false;
        SubMetric[] subMetricArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (SubMetric element$iv$iv2 : $this$filterTo$iv$iv) {
            void it = element$iv$iv2;
            boolean bl = false;
            if (!it.supportedOnApiLevel(captureApiLevel)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            SubMetric element$iv$iv2;
            element$iv$iv2 = (SubMetric)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$map$iv = $this$getFrameSubMetrics;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void subMetric;
                void frame;
                FrameData frameData = (FrameData)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(frame.get((SubMetric)subMetric));
            }
            List list = (List)destination$iv$iv2;
            map.put(t, list);
        }
        return result$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData;", "", "uiSlice", "Landroidx/benchmark/perfetto/Slice;", "rtSlice", "expectedSlice", "actualSlice", "(Landroidx/benchmark/perfetto/Slice;Landroidx/benchmark/perfetto/Slice;Landroidx/benchmark/perfetto/Slice;Landroidx/benchmark/perfetto/Slice;)V", "getActualSlice", "()Landroidx/benchmark/perfetto/Slice;", "getExpectedSlice", "getRtSlice", "getUiSlice", "get", "", "subMetric", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "Companion", "benchmark-macro_release"})
    public static final class FrameData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Slice uiSlice;
        @NotNull
        private final Slice rtSlice;
        @Nullable
        private final Slice expectedSlice;
        @Nullable
        private final Slice actualSlice;

        public FrameData(@NotNull Slice uiSlice, @NotNull Slice rtSlice, @Nullable Slice expectedSlice, @Nullable Slice actualSlice) {
            Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
            Intrinsics.checkNotNullParameter((Object)rtSlice, (String)"rtSlice");
            this.uiSlice = uiSlice;
            this.rtSlice = rtSlice;
            this.expectedSlice = expectedSlice;
            this.actualSlice = actualSlice;
        }

        @NotNull
        public final Slice getUiSlice() {
            return this.uiSlice;
        }

        @NotNull
        public final Slice getRtSlice() {
            return this.rtSlice;
        }

        @Nullable
        public final Slice getExpectedSlice() {
            return this.expectedSlice;
        }

        @Nullable
        public final Slice getActualSlice() {
            return this.actualSlice;
        }

        public final long get(@NotNull SubMetric subMetric) {
            long l;
            Intrinsics.checkNotNullParameter((Object)((Object)subMetric), (String)"subMetric");
            switch (WhenMappings.$EnumSwitchMapping$0[subMetric.ordinal()]) {
                case 1: {
                    l = this.rtSlice.getEndTs() - this.uiSlice.getTs();
                    break;
                }
                case 2: {
                    l = this.uiSlice.getDur();
                    break;
                }
                case 3: {
                    Slice slice = this.actualSlice;
                    Intrinsics.checkNotNull((Object)slice);
                    long l2 = Math.max(slice.getEndTs(), this.rtSlice.getEndTs());
                    Slice slice2 = this.expectedSlice;
                    Intrinsics.checkNotNull((Object)slice2);
                    l = l2 - slice2.getEndTs();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData$Companion;", "", "()V", "tryCreate31", "Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameData;", "uiSlice", "Landroidx/benchmark/perfetto/Slice;", "rtSlice", "expectedSlice", "actualSlice", "tryCreateBasic", "benchmark-macro_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final FrameData tryCreateBasic(@Nullable Slice uiSlice, @Nullable Slice rtSlice) {
                FrameData frameData;
                Slice slice = uiSlice;
                if (slice != null) {
                    Slice it = slice;
                    boolean bl = false;
                    Slice slice2 = rtSlice;
                    if (slice2 != null) {
                        Slice it2 = slice2;
                        boolean bl2 = false;
                        frameData = new FrameData(uiSlice, rtSlice, null, null);
                    } else {
                        frameData = null;
                    }
                } else {
                    frameData = null;
                }
                return frameData;
            }

            @Nullable
            public final FrameData tryCreate31(@Nullable Slice uiSlice, @Nullable Slice rtSlice, @Nullable Slice expectedSlice, @Nullable Slice actualSlice) {
                return uiSlice != null && rtSlice != null && expectedSlice != null && actualSlice != null ? new FrameData(uiSlice, rtSlice, expectedSlice, actualSlice) : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SubMetric.values().length];
                try {
                    nArray[SubMetric.FrameDurationCpuNs.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SubMetric.FrameDurationUiNs.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SubMetric.FrameOverrunNs.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$FrameSliceType;", "", "(Ljava/lang/String;I)V", "Expected", "Actual", "UiThread", "RenderThread", "benchmark-macro_release"})
    public static final class FrameSliceType
    extends Enum<FrameSliceType> {
        public static final /* enum */ FrameSliceType Expected = new FrameSliceType();
        public static final /* enum */ FrameSliceType Actual = new FrameSliceType();
        public static final /* enum */ FrameSliceType UiThread = new FrameSliceType();
        public static final /* enum */ FrameSliceType RenderThread = new FrameSliceType();
        private static final /* synthetic */ FrameSliceType[] $VALUES;

        public static FrameSliceType[] values() {
            return (FrameSliceType[])$VALUES.clone();
        }

        public static FrameSliceType valueOf(String value) {
            return Enum.valueOf(FrameSliceType.class, value);
        }

        static {
            $VALUES = frameSliceTypeArray = new FrameSliceType[]{FrameSliceType.Expected, FrameSliceType.Actual, FrameSliceType.UiThread, FrameSliceType.RenderThread};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/benchmark/macro/perfetto/FrameTimingQuery$SubMetric;", "", "(Ljava/lang/String;I)V", "supportedOnApiLevel", "", "apiLevel", "", "FrameDurationCpuNs", "FrameDurationUiNs", "FrameOverrunNs", "benchmark-macro_release"})
    public static final class SubMetric
    extends Enum<SubMetric> {
        public static final /* enum */ SubMetric FrameDurationCpuNs = new SubMetric();
        public static final /* enum */ SubMetric FrameDurationUiNs = new SubMetric();
        public static final /* enum */ SubMetric FrameOverrunNs = new SubMetric();
        private static final /* synthetic */ SubMetric[] $VALUES;

        public final boolean supportedOnApiLevel(int apiLevel) {
            return apiLevel >= 31 || this != FrameOverrunNs;
        }

        public static SubMetric[] values() {
            return (SubMetric[])$VALUES.clone();
        }

        public static SubMetric valueOf(String value) {
            return Enum.valueOf(SubMetric.class, value);
        }

        static {
            $VALUES = subMetricArray = new SubMetric[]{SubMetric.FrameDurationCpuNs, SubMetric.FrameDurationUiNs, SubMetric.FrameOverrunNs};
        }
    }
}

