/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.macro.PowerCategory;
import androidx.benchmark.macro.PowerMetric;
import androidx.benchmark.macro.perfetto.PowerQuery;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0003J\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/benchmark/macro/perfetto/PowerQuery;", "", "()V", "categoryToSubsystem", "", "Landroidx/benchmark/macro/PowerCategory;", "", "", "filterRails", "", "subsystems", "railName", "getFullQuery", "slice", "Landroidx/benchmark/perfetto/Slice;", "getPowerMetrics", "Landroidx/benchmark/macro/perfetto/PowerQuery$CategoryMeasurement;", "session", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "getRailMetrics", "Landroidx/benchmark/macro/perfetto/PowerQuery$ComponentMeasurement;", "railInCategory", "category", "sortComponentsByCategories", "railMetrics", "CategoryMeasurement", "ComponentMeasurement", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nPowerQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerQuery.kt\nandroidx/benchmark/macro/perfetto/PowerQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,199:1\n1#2:200\n9496#3,2:201\n9646#3,2:203\n9649#3:211\n766#4:205\n857#4,2:206\n1789#4,3:208\n515#5:212\n500#5,6:213\n*S KotlinDebug\n*F\n+ 1 PowerQuery.kt\nandroidx/benchmark/macro/perfetto/PowerQuery\n*L\n116#1:201,2\n116#1:203,2\n116#1:211\n118#1:205\n118#1:206,2\n123#1:208,3\n136#1:212\n136#1:213,6\n*E\n"})
public final class PowerQuery {
    @NotNull
    public static final PowerQuery INSTANCE = new PowerQuery();
    @NotNull
    private static final Map<PowerCategory, List<String>> categoryToSubsystem;

    private PowerQuery() {
    }

    @Language(value="sql")
    private final String getFullQuery(Slice slice) {
        return StringsKt.trimIndent((String)("\n        SELECT\n            t.name,\n            max(c.value) - min(c.value) AS energyUws,\n            (max(c.value) - min(c.value))/((max(c.ts) - min(c.ts)) / 1000000) AS powerUs\n        FROM counter c\n        JOIN counter_track t ON c.track_id = t.id\n        WHERE t.name GLOB 'power.*'\n        AND c.ts >= " + slice.getTs() + " AND c.ts <= " + slice.getEndTs() + "\n        GROUP BY t.name\n    "));
    }

    @NotNull
    public final Map<PowerCategory, CategoryMeasurement> getPowerMetrics(@NotNull PerfettoTraceProcessor.Session session, @NotNull Slice slice) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        List<ComponentMeasurement> railMetrics = this.getRailMetrics(session, slice);
        Collection collection = railMetrics;
        if (collection.isEmpty()) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        return this.sortComponentsByCategories(railMetrics);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PowerCategory, CategoryMeasurement> sortComponentsByCategories(List<ComponentMeasurement> railMetrics) {
        void $this$filterTo$iv$iv;
        PowerCategory[] $this$associateWith$iv = PowerCategory.values();
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        PowerCategory[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$fold$iv;
            void initial$iv;
            void $this$filterTo$iv$iv2;
            PowerCategory element$iv$iv;
            PowerCategory powerCategory = element$iv$iv = $this$associateWithTo$iv$iv[i];
            PowerCategory powerCategory2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = railMetrics;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                void category;
                ComponentMeasurement rail = (ComponentMeasurement)element$iv$iv2;
                boolean bl2 = false;
                if (!INSTANCE.railInCategory((PowerCategory)category, rail.getName())) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List rails = (List)destination$iv$iv;
            $this$filter$iv = rails;
            CategoryMeasurement $i$f$filter22 = new CategoryMeasurement(0.0, 0.0, rails);
            boolean $i$f$fold = false;
            CategoryMeasurement accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                Object element$iv$iv2;
                element$iv$iv2 = (ComponentMeasurement)element$iv;
                void total = accumulator$iv;
                boolean bl3 = false;
                accumulator$iv = new CategoryMeasurement(total.getEnergyUws() + next.getEnergyUws(), total.getPowerUw() + next.getPowerUw(), total.getComponents());
            }
            void var24_31 = accumulator$iv;
            map.put(powerCategory2, var24_31);
        }
        Map $this$filter$iv = result$iv;
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            CategoryMeasurement measurement = (CategoryMeasurement)entry.getValue();
            boolean bl4 = !((Collection)measurement.getComponents()).isEmpty();
            if (!bl4) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private final List<ComponentMeasurement> getRailMetrics(PerfettoTraceProcessor.Session session, Slice slice) {
        String query2 = this.getFullQuery(slice);
        return SequencesKt.toList((Sequence)SequencesKt.map(session.query(query2), (Function1)getRailMetrics.1.INSTANCE));
    }

    private final boolean railInCategory(PowerCategory category, String railName) {
        if (category == PowerCategory.UNCATEGORIZED) {
            return !this.filterRails(CollectionsKt.flatten((Iterable)categoryToSubsystem.values()), railName);
        }
        List list = categoryToSubsystem.get((Object)category);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return this.filterRails(list, railName);
    }

    private final boolean filterRails(List<String> subsystems, String railName) {
        for (String subsystem : subsystems) {
            if (!StringsKt.contains$default((CharSequence)railName, (CharSequence)subsystem, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    static {
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)((Object)PowerCategory.CPU), (Object)CollectionsKt.listOf((Object)"Cpu"));
        pairArray[1] = TuplesKt.to((Object)((Object)PowerCategory.DISPLAY), (Object)CollectionsKt.listOf((Object)"Display"));
        pairArray[2] = TuplesKt.to((Object)((Object)PowerCategory.GPU), (Object)CollectionsKt.listOf((Object)"Gpu"));
        pairArray[3] = TuplesKt.to((Object)((Object)PowerCategory.GPS), (Object)CollectionsKt.listOf((Object)"Gps"));
        Object[] objectArray = new String[]{"Ddr", "MemoryInterface"};
        pairArray[4] = TuplesKt.to((Object)((Object)PowerCategory.MEMORY), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[5] = TuplesKt.to((Object)((Object)PowerCategory.MACHINE_LEARNING), (Object)CollectionsKt.listOf((Object)"Tpu"));
        objectArray = new String[]{"Aoc", "Radio", "VsysPwrMmwave", "Wifi", "Modem"};
        pairArray[6] = TuplesKt.to((Object)((Object)PowerCategory.NETWORK), (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[7] = TuplesKt.to((Object)((Object)PowerCategory.UNCATEGORIZED), (Object)CollectionsKt.emptyList());
        categoryToSubsystem = MapsKt.mapOf((Pair[])pairArray);
        if (!(categoryToSubsystem.keySet().size() == PowerCategory.values().length)) {
            boolean bl = false;
            String string = "Missing power categories in categoryToSubsystem";
            throw new IllegalStateException(string.toString());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006!"}, d2={"Landroidx/benchmark/macro/perfetto/PowerQuery$CategoryMeasurement;", "", "energyUws", "", "powerUw", "components", "", "Landroidx/benchmark/macro/perfetto/PowerQuery$ComponentMeasurement;", "(DDLjava/util/List;)V", "getComponents", "()Ljava/util/List;", "setComponents", "(Ljava/util/List;)V", "getEnergyUws", "()D", "setEnergyUws", "(D)V", "getPowerUw", "setPowerUw", "component1", "component2", "component3", "copy", "equals", "", "other", "getValue", "type", "Landroidx/benchmark/macro/PowerMetric$Type;", "hashCode", "", "toString", "", "benchmark-macro_release"})
    public static final class CategoryMeasurement {
        private double energyUws;
        private double powerUw;
        @NotNull
        private List<ComponentMeasurement> components;

        public CategoryMeasurement(double energyUws, double powerUw, @NotNull List<ComponentMeasurement> components) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            this.energyUws = energyUws;
            this.powerUw = powerUw;
            this.components = components;
        }

        public final double getEnergyUws() {
            return this.energyUws;
        }

        public final void setEnergyUws(double d) {
            this.energyUws = d;
        }

        public final double getPowerUw() {
            return this.powerUw;
        }

        public final void setPowerUw(double d) {
            this.powerUw = d;
        }

        @NotNull
        public final List<ComponentMeasurement> getComponents() {
            return this.components;
        }

        public final void setComponents(@NotNull List<ComponentMeasurement> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.components = list;
        }

        public final double getValue(@NotNull PowerMetric.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return type instanceof PowerMetric.Type.Power ? this.powerUw : this.energyUws;
        }

        public final double component1() {
            return this.energyUws;
        }

        public final double component2() {
            return this.powerUw;
        }

        @NotNull
        public final List<ComponentMeasurement> component3() {
            return this.components;
        }

        @NotNull
        public final CategoryMeasurement copy(double energyUws, double powerUw, @NotNull List<ComponentMeasurement> components) {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            return new CategoryMeasurement(energyUws, powerUw, components);
        }

        public static /* synthetic */ CategoryMeasurement copy$default(CategoryMeasurement categoryMeasurement, double d, double d2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                d = categoryMeasurement.energyUws;
            }
            if ((n & 2) != 0) {
                d2 = categoryMeasurement.powerUw;
            }
            if ((n & 4) != 0) {
                list = categoryMeasurement.components;
            }
            return categoryMeasurement.copy(d, d2, list);
        }

        @NotNull
        public String toString() {
            return "CategoryMeasurement(energyUws=" + this.energyUws + ", powerUw=" + this.powerUw + ", components=" + this.components + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.energyUws);
            result = result * 31 + Double.hashCode(this.powerUw);
            result = result * 31 + ((Object)this.components).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CategoryMeasurement)) {
                return false;
            }
            CategoryMeasurement categoryMeasurement = (CategoryMeasurement)other;
            if (Double.compare(this.energyUws, categoryMeasurement.energyUws) != 0) {
                return false;
            }
            if (Double.compare(this.powerUw, categoryMeasurement.powerUw) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.components, categoryMeasurement.components);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/macro/perfetto/PowerQuery$ComponentMeasurement;", "", "name", "", "energyUws", "", "powerUw", "(Ljava/lang/String;DD)V", "getEnergyUws", "()D", "setEnergyUws", "(D)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPowerUw", "setPowerUw", "component1", "component2", "component3", "copy", "equals", "", "other", "getValue", "type", "Landroidx/benchmark/macro/PowerMetric$Type;", "hashCode", "", "toString", "benchmark-macro_release"})
    public static final class ComponentMeasurement {
        @NotNull
        private String name;
        private double energyUws;
        private double powerUw;

        public ComponentMeasurement(@NotNull String name, double energyUws, double powerUw) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.energyUws = energyUws;
            this.powerUw = powerUw;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final double getEnergyUws() {
            return this.energyUws;
        }

        public final void setEnergyUws(double d) {
            this.energyUws = d;
        }

        public final double getPowerUw() {
            return this.powerUw;
        }

        public final void setPowerUw(double d) {
            this.powerUw = d;
        }

        public final double getValue(@NotNull PowerMetric.Type type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return type instanceof PowerMetric.Type.Power ? this.powerUw : this.energyUws;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final double component2() {
            return this.energyUws;
        }

        public final double component3() {
            return this.powerUw;
        }

        @NotNull
        public final ComponentMeasurement copy(@NotNull String name, double energyUws, double powerUw) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ComponentMeasurement(name, energyUws, powerUw);
        }

        public static /* synthetic */ ComponentMeasurement copy$default(ComponentMeasurement componentMeasurement, String string, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                string = componentMeasurement.name;
            }
            if ((n & 2) != 0) {
                d = componentMeasurement.energyUws;
            }
            if ((n & 4) != 0) {
                d2 = componentMeasurement.powerUw;
            }
            return componentMeasurement.copy(string, d, d2);
        }

        @NotNull
        public String toString() {
            return "ComponentMeasurement(name=" + this.name + ", energyUws=" + this.energyUws + ", powerUw=" + this.powerUw + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Double.hashCode(this.energyUws);
            result = result * 31 + Double.hashCode(this.powerUw);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentMeasurement)) {
                return false;
            }
            ComponentMeasurement componentMeasurement = (ComponentMeasurement)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)componentMeasurement.name)) {
                return false;
            }
            if (Double.compare(this.energyUws, componentMeasurement.energyUws) != 0) {
                return false;
            }
            return Double.compare(this.powerUw, componentMeasurement.powerUw) == 0;
        }
    }
}

